/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "nlchoix.h"

/*--------------- GLOBAL --------------------------*/
int pload, psiload, invload;
/* pload=0 si programme de calcul du modele non charge, 1 sinon */
/* psiload=0 si programme de calcul des fonctions non charge, 1 sinon */
/* invload=0 si programme de calcul de l'inverse de f non charge, 1 sinon */


/*--------------- Identification fonction ----------
| Nom de la fonction    : initloadnls2            |
| Role                  : mettre dans la variable  |
|  globale pload la valeur de l'argument           |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: loadnls2                      |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/

void initloadnls2(TFuncInt *modelploadval, TFuncInt *psiloadval, TFuncInt *invloadval)

/*--------------- Fin identification fonction ----*/

{
pload=*modelploadval;
psiload=*psiloadval;
invload=*invloadval;

return;
}

/* ------------- fin initloadnls2 ----------------------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : ploadnls2            |
| Role                  : renvoyer la variable  |
|  globale pload 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: nls2, calcfnls2                  |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/

void ploadnls2(ploadval)


/* arguments de sortie */
TFuncInt *ploadval;
/*--------------- Fin identification fonction ----*/

{
*ploadval= pload;
return;
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : psiloadnls2            |
| Role                  : renvoyer la variable  |
|  globale psiload 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: calcpsinls2, bootstrap           |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/

void psiloadnls2(psiloadval)


/* arguments de sortie */
TFuncInt *psiloadval;
/*--------------- Fin identification fonction ----*/

{
*psiloadval= psiload;
return;
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : invloadnls2            |
| Role                  : renvoyer la variable  |
|  globale invload 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: calcinvnls2, calib           |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/

void invloadnls2(invloadval)


/* arguments de sortie */
TFuncInt *invloadval;
/*--------------- Fin identification fonction ----*/

{
*invloadval= invload;
return;
}

/* -----------------------------------------
premiernom:
extrait le 1ier mot de la chaine 'textein' et lui ote les 2
derniers car. supposs tre le suffixe .c, .f ou .o
--------------------------------------------- */
void premiernom(char ** textein, char ** resultout, TFuncInt *code)
{
char *texte, *result;
int i, longueur;

*code=0;
texte = *textein; 
result = *resultout;

/* Se positionner sur la 1iere lettre */
longueur = strlen(texte) ;
i=0;
while ( (i<longueur) && isspace(texte[i++]) )
  {
    ;
  }

/* Pas de caractre alpha trouv */
if (i == longueur)
  {
    *code=1; return;
  }

texte = texte+i-1;
/* On revient d'une position en arrire car on a fait i++
dans la boucle ci-dessus: ici, texte pointe
sur le 1ier car. non blanc */

/* On cherche le 1ier 'space' qui suit: */
longueur = strlen(texte);
i = 0;
while ( (i<longueur) && !isspace(texte[i++]) )
  {
    ;
  }

if (i < longueur)
  {
    /* plusieurs mots dans la chaine ou un 'space' final */
    longueur = i-3;
  }
else
  {
    longueur = i - 2;
  }

strncpy(result, texte, longueur);
result[longueur] ='\0';
return;
}
 
/* ------------------------------------------
coller la valeur du 'pwd' devant les mots de 'textein'
- Si le mot commence par '-', on suppose que c'est 
'-lmot', -Lmot', '-Imot' et on dcale de 2 positions
avant de rajouter le pwd
- Si le mot commence par '/', on suppose que c'est 
un chemin absolu et on ne rajoute rien
- Si le mot commence par '~', on remplace le '~',
par le chemin du home-dir
-------------------------------------------- */
void collePwd(char ** textein, char ** pwd, char ** resultout)
{
char *texte, *result, *chemin, *home, shome[300];
int longueur;
int i,j,l ;

i=j=l=0;
home = shome;
texte = *textein; 
chemin = *pwd;
result = *resultout;
longueur = strlen(texte);

while (i < longueur)
  {
    switch (texte[i])
      {
      case '-' :
	result[j] = texte[i]; i++; j++;
	result[j] = texte[i]; i++; j++;
	break;
      case ' ' :
	result[j] = texte[i]; i++; j++;
	break;
      case '/' :
	while ( (texte[i] != ' ') && (i < longueur))
	  {
	   result[j] = texte[i];  i++; j++;
	  }
	break;
      case '~' :
	strcpy(home , (char *)getenv("HOME"));
	for (l=0; l< strlen(home); l++)
	  {
	   result[j] = home[l];
	   j++;
	  }
	i++;
	break;
    default:
        for (l=0; l< strlen(chemin); l++)
	  {
	    result[j] = chemin[l];
	    j++;
	  }
	result[j] = '/'; j++;
	while ( (texte[i] != ' ') && (i < longueur))
	  {
	   result[j] = texte[i];  i++; j++;
	  }
	break;
      } /* fin du switch */
  } /* fin while */
result[j] = '\0';
} /* fin collePwd */


