/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : nlfonc.h                  |
| Date                 : 14 janv. 1992             |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : piege les erreurs dans les|
|      parametres d'entree a une fontion de math.h |
|  Attention: ne pas faire:                        |
|     return(mysignaling_nan(n));                    |
| mais:                                            | 
|      r=mysignaling_nan(n);                         |
|      return(r);                                  |
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <math.h>
#include <float.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "nlmacros.h"
#include "errcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
extern TDouble pow(double x, double y);
extern TDouble log(double x); 
extern TDouble exp(double x);
TShortInt GerMessage( );

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

double mylog(double x)
{
  double r;
  long n=0;
  char Mess1[30];

  if (x<=0)
    {
      /* erreur on retourne NaN ou on s'arrete*/
       sprintf(Mess1,"%g", x);
      NLWARNING((WARNUM,3,"log10",Mess1," ", WNUMER));
      /* 
     fprintf(GNLControle.SortWE," mylog: argument errone %g\
 On retourne NaN ou on s'arrete \n",  x);
     */
      r=mysignaling_nan(n);
      return(r);
    }
  else
    {
      return(log(x)/log((double)10));
    }
}

double myln(double x)
{
  double r;
  long n=0;
  char Mess1[30];

  if (x<=0)
    {
      /* erreur on retourne NaN ou on s'arrete */
       sprintf(Mess1,"%g", x);
      NLWARNING((WARNUM,3,"neperien log",Mess1," ", WNUMER));
      /* 
     fprintf(GNLControle.SortWE," myln: argument errone %g\
 On retourne NaN ou on s'arrete \n",  x);
     */
      r=mysignaling_nan(n);
      return(r);
    }
  else
    {
      return(log(x));
    }
}

double mypow(double x,double y)
{
  long n=0;
  double r;
  char Mess1[30], Mess2[30];

  if ((x==0 && y<=0) || (x<0 && (int)y!=y))
    {
      /* erreur on retourne NaN ou on s'arrete */
       sprintf(Mess1,"%g", x);
       sprintf(Mess2,"%g", y);
      NLWARNING((WARNUM,3,"power",Mess1,Mess2, WNUMER));
      r=mysignaling_nan(n);
      return(r);
    }
  else
    {
      return(pow(x,y));
    }
}

double mydiv(double x, double y)
{
  long n=0;
  double r;
  char Mess1[30];
  char Mess2[30];

  if (y==(double)0)
    {
      /* erreur on retourne NaN ou on s'arrete */
       sprintf(Mess1,"%g", x);
       sprintf(Mess2,"%g", y);
      NLWARNING((WARNUM,3,"division",Mess1,Mess2, WNUMER));
      r=mysignaling_nan(n);
      return(r);
    }
  else
    {
      return(x/y);
    }
}

double myexp( double x)
{
  long n=0;
  double r;
  char Mess1[30];

   if (x<(double)-745)
    {
      /* x petit: on retourne 0 */
      r=(double)0.0;
      return(r);
    }
  else
    {
    if (x>(double)709)
      {
      /* erreur on retourne NaN ou on s'arrete */
       sprintf(Mess1,"%g", x);
      NLWARNING ((WARNUM,3,"exp",Mess1," ", WNUMER)); 
      r=mysignaling_nan(n); 
      return(r);
      }
    else
      { 
      r=(double)exp(x);
      return(r);
      }
    }
}

