#ifndef CHOIXH
#define CHOIXH


 /*--------------- COPYRIGHT ------------------------
 | INRA - Laboratoire de Biometrie de Jouy en Josas |
 --------------------------------------------------*/

 /*--------------- IDENTIFICATION PRODUIT -----------
 | Produit              : nlchoix.sh/ES0/e1/i10     |
 | Date                 : 17Sep91 / 13:49:41        |
 | Derniere mise a jour : 28Jun91 / 17:16:23        |
 | Concepteur           : A. Bouvier                |
 | Role                 : les choix pour les valeurs|
 |                        par defaut, bornes, etc   |
 | Reference conception :                           |
 | Lecteur              :                           |
 --------------------------------------------------*/

 /*--------------- FIN IDENTIFICATION PRODUIT -----*/

 /* ........................................................................ */
 /* ........ DEFINITIONS DES CHOIX NUMERIQUES ............................ */
 /* ........................................................................ */
/* ......... MINSG: valeur minimale dans l'inversion de matrice : ............
             utilise par ProgMath.MatInv                                           */

#define MINSG 1e-30 

/* ....... pour la fonction SysLin: plus petit pivot acceptable .........  */
#define EPSILON 1.0e-30

 /* ........................................................................ */
 /* ........ DEFINITIONS DES CHOIX STATISTIQUES ............................ */
 /* ........................................................................ */

/* VALEURS PAR DEFAUT DANS CTXPUSS */
/* ------------------- */
#define DEFALGO GM
#define DEFDIRECC 0.5
#define DEFLAMBDA0 5
#define DEFLAMBDAC1 0.1
#define DEFLAMBDAC2 100
#define DEFCRITA 10e-8
#define DEFMAXERR 5
#define DEFMAXDEB 5
#define DEFMAXLAMBDA 10e-6
#define DEFNBETAP 1
#define DEFOMEGA 0.01
#define DEFFAMILLE GAUSS
#define DEFMU MUGAUSS
#define DEFMAXITER 10 /* le defaut est en pratique:
                         DEFMAXITER * Nombre de parametres */


/* VALEURS MINIMALES ET MAXIMALES */
/* ----------------------------- */
/* ........  MAXETAP: nombre maximal d'etapes ........................... */
/* = dimension des tableaux contenant les structures relatives a chaque etape */
#define MAXETAP 3

 /* ........ MINREP: nombre de repetitions en chaque point ................... 
	     a partir duquel on considere que l'estimateur                  
	     MCPVI(theta) est valide. 
	     Entre MINREP et MAXREP, on emet un warning.
	     Utilises par le module  EstTheta                                 */
#define MINREP 2
#define MAXREP 4

 /* ........ MINREPMU: nombre de repetitions en chaque point ................... 
	     a partir duquel on considere que TypeMu= MURESREPET
	     (calcul des mu3 et mu4 a partir des residus sur les repetitions 
	     Si inf a  MINREP , on emet un warning. */
#define MINREPMU 2

/*  ... nombre maximum d'iterations dont on peut garder les resultats  */
#define MAXSVIT 100

/* ............  DEFY: nom par defaut de la variable y ................... */
#define DEFY "y"
             
 /* ........................................................................ */
 /* ........ DEFINITIONS DES VALEURS PAR DEFAUT DU GNLCtxInteg................... */
 /* ........................................................................ */

 /* ........ Controle de la tolerance pour LSODA ........................ */
#define DEFITOL 1      /* valeur par defaut de itol */
#define DEFATOL 1.e-7  /* valeur par defaut de atol */
#define DEFRTOL 1.e-5  /*  valeur par defaut de rtol */

 /* ........ Methode par defaut du calcul du jacobien ................... */
#define DEFJT 1




 /* ........................................................................ */
/* ..... VALEURS PAR DEFAUT POUR LA GESTION DES IMPRESSIONS ET ERREURS ..... */
 /* ........................................................................ */
#define DEFFINTRAIT  RETURN  /* sortie en cas d'erreur */
#define DEFFREQIP  -1 /* ip initiale et finale */

#define DEFLGTRACE 15      /* longueur de la trace */
#define DEFWANALY 30       /* nombre maximum de warnings de l'analyseur autorises */
#define DEFWINTEG 30       /* nombre maximum de warnings de l'integrateur autorises */
#define DEFWMETHO 30       /* nombre maximum de warnings methodologiques autorises */
#define DEFWNUMER 30       /* nombre maximum de warnings numeriques autorises */
#define DEFWTOTAL 30       /* nombre maximum de warnings totaux autorises */

#define DEFSORTIMP  stdout /* unite d'impression des impressions intermediaires */
#define DEFSORTTRACE stdout  /* unite d'impression de la trace */
#define DEFSORTWE  stderr  /* unite d'impression des warnings et erreurs */
#define DEFLGMESS  COURT   /* longueur des warnings et erreurs */


/* ...... VALEURS MAXIMALES ................................................... */ 
/* longueur maxi du nom du fichier des messages */
#define MAXLGFIC 255

/* nombre maximum de caracteres des messages, apres substitution
des parametres: attention si ceux-ci sont des pathnames */
/* #define MAXLGMESS  255 */
#define MAXLGMESS 655
/* longueur maxi d'un texte dans le fichier des messages */
/* #define MAXLGBRUT 200  */
#define MAXLGBRUT 600

/* longueur maxi d'une chaine contenant un parametre d'un message */
#define MAXLGCHP 50 

#define MAXLGTRACE 200     /* longueur maximale de la trace */

/* longueur maximale des chaines de caracteres, elements des vecteurs TVectStr */
#define MAXCH 15


/* ......... POUR l'INTEGRATEUR ............................................... */
#define BSUPFICT  200 /* nombre maxi d'equations */
#endif
