#ifndef MACROSH
#define MACROSH
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : nlmacros.sh/ES0/e1/i29    |
| Date                 :  7Nov91 / 16:57:09        |
| Derniere mise a jour : 24Sep91 / 15:36:39        |
| Concepteur           : A. Bouvier                |
| Role                 : macros de base            |
| Reference conception : Normes de Programmation   |
|                         (Annexe)                 |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
/* On n'utilise pas les fonctions S: S-alloc et S_realloc
car ca obligerait a modifier tous les appels aux macros de creation:
il faut connaitre l'ancienne taille dans les reallocations */
#include <stdlib.h>
/*
extern char *calloc();
extern char *realloc();
extern int free();
*/

#include <stdio.h>
/*
extern int fprintf(FILE *fp, const char *s, ...);
extern int fscanf(FILE *fp, const char *s, ...);
*/
#include <string.h>
/*
extern char *strcpy(char *s1, const char *s2);
*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/* ........ DEFINITIONS DE MACROS.......................................... */

/* .........DECLARATION D'UN NOM DE FICHIER ............................... */
/* a utiliser ainsi: DCL_FIC(NomFic); */
#define DCL_FIC(nom) TChar nom[15]

/* ......... LECTURE ASSOCIEE A CHAQUE TYPE DE BASE .....................   */
#define LEC_LOG(Pfic,val) fscanf (Pfic, "%hd", &val) /* TLogic */
#define LEC_BIN(Pfic,val) fscanf (Pfic, "%lu", &val) /* TBin   */
#define LEC_SIN(Pfic,val) fscanf (Pfic, "%hd", &val) /* TShortInt */
#define LEC_LIN(Pfic,val) fscanf (Pfic, "%ld", &val) /* TLongInt */
#define LEC_FLO(Pfic,val) fscanf (Pfic, "%f", &val)  /* TFloat */
#define LEC_DOU(Pfic,val) fscanf (Pfic, "%lf", &val) /* TDouble */
#define LEC_FIC(Pfic,val) fscanf (Pfic, "%14s", val) /* TFic    */
#define LEC_CHN(Pfic,val) fscanf (Pfic, "%s", val)   /* TChaine */


/* ......... ECRITURE ASSOCIEE A CHAQUE TYPE DE BASE .....................   */
#define ECR_LOG(Pfic,val) fprintf (Pfic, "%hd", val)
#define ECR_BIN(Pfic,val) fprintf (Pfic, "%10lu", val)
#define ECR_SIN(Pfic,val) fprintf (Pfic, "%hd", val)
#define ECR_LIN(Pfic,val) fprintf (Pfic, "%ld", val)
#define ECR_FLO(Pfic,val) fprintf (Pfic, "%15.8g", val)
#define ECR_DOU(Pfic,val) fprintf (Pfic, "%23.16lg", val)
#define ECR_CHN(Pfic,val) fprintf (Pfic, "%s", val)  /* chaine de car */


/* ......... GESTION MEMOIRE .............................................  */

/*           Le compteur d'emplacements memoire, la variable globale
             GNLMEM,
             sert a visualiser le nombre d'octets alloues dynamiquement    */

/* .......... Incrementation/Decrementation de ce compteur
              de `n0' emplacements de type `type'
              (Incorporer les `printf' pour visualiser l'occupation memoire:
              - soit on les met dans la macro, et alors l'impression
              apparaitra a chaque allocation, desallocation,
              - soit on les met dans son programme aux endroits sensibles)   */ 


#define MEM_INCR(n0,type) \
GNLMEM += (unsigned) (n0) * sizeof (type) ,/* printf ("%u\n", GNLMEM) , */
#define MEM_DECR(n0,type) \
GNLMEM -= (unsigned) (n0) * sizeof (type) ,/* printf ("%u\n", GNLMEM) ,*/

/* .......... Allocation de `n0' emplacements de type `type' ............. */
/*            Pour les vecteurs, on met un `*' dans l'instruction
              `type', pour les matrices on en met 2, etc            */  
/*            Si le pointeur retourne est NULL, c'est que ca a pas marche:
              on imprime un message et on sort  */
/* on ne met pas unsigned devant les nombres d'octets a allouer
   au cas ou la macro aurait ete appelee avec un nombre negatif:
   il faut que ca plante dans ce cas et non pas que ca convertisse
   en non-signe */

#define CREER_T1(vect,n0,type)  \
  { \
  /* MEM_INCR(n0,type *) */ \
  vect = (type *) calloc (n0, sizeof (type)); \
  if (vect == NULL) \
    { \
    fprintf(stdout, "CREER_T1: Memory allocation problem\n"); \
    exit(ERRALLOC); \
    } \
  }

#define CREER_T2(mat,n0,type) \
  { \
  /* MEM_INCR(n0,type *) */ \
  mat = (type **) calloc (n0, sizeof (type *)); \
  if (mat == NULL) \
    { \
    fprintf(stdout, "CREER_T2: Memory allocation problem\n"); \
    exit(ERRALLOC); \
    } \
  }


#define RECREER_T1(vect,n0,type)   \
  { \
  vect = (type *) realloc ((char *)vect,  n0*sizeof(type)); \
  if (vect == NULL) \
    { \
    fprintf(stdout, "RECREER_T1: Memory allocation problem\n"); \
    exit(ERRALLOC); \
    } \
  }


#define RECREER_T2(mat,n0,type)  \
  { \
  mat = (type **) realloc ((char *)mat,  n0*sizeof(type)); \
  if (mat == NULL) \
    { \
    fprintf(stdout, "RECREER_T2: Memory allocation problem\n"); \
    exit(ERRALLOC); \
    } \
  }

/* .......... Desallocation de `n0' emplacements de type `type' ........   */
/*           le char * dans le free evite message de lint   */
#define DETRU_T1(vect,n0,type) ( /* MEM_DECR(n0,(type)) */ \
free ((char *) vect))
#define DETRU_T2(mat,n0,type) ( /* MEM_DECR(n0,(type *)) */ \
free ((char *) mat))

/* ............ Appel de fonction ..................................... */
/* exemple de syntaxe : APPEL( Mafonc(arg1,arg2)); */
#define APPEL(NLFonc)       \
  { \
  TShortInt ErrCode; \
  ErrCode=NLFonc ;   \
  if(ErrCode!=OK) return(ErrCode);  \
  }


/* ............ Appel de Warning ..................................... */
/* Remarquez le double parenthesage: c'est fait expres                 */
/* exemple de syntaxe : NLWARNING((Code,1,"+",WANALY));              */
#define NLWARNING(ARGU)   APPEL(GerMessage ARGU)


/* ............ Appel de NLErreur ..................................... */
/* Remarquez le double parenthesage: c'est fait expres                  */
/* exemple de syntaxe : NLERREUR((Code,2,"fichier","directory",ERR));   */
#define NLERREUR(ARGU)   return(GerMessage ARGU)


/* ............. Mettre son nom dans la trace                           */
/* exemple de syntaxe : ECRTRACE("ModSedo"); */

#define ECRTRACE(Routine) \
  { \
  extern TTrace *GNLCourant; \
  extern TLongInt GNLNbAppel; \
  strcpy(GNLCourant->Nom,Routine); \
  GNLCourant=GNLCourant->Suivant;GNLNbAppel++; \
  }


/* ............ Fonctions MIN, MAX  ........................*/
#define MIN(a,b) ( (a)<(b) ? (a) : (b))
#define MAX(a,b) ( (a)>(b) ? (a) : (b))

/* ............ Fonctions signaling_nan , isnan .............*/
/* DBL_MAX est defini dans float.h */
#define mysignaling_nan(n) DBL_MAX
#define myisnan(r) ( (r)==DBL_MAX ? 1 : 0)
#endif

