

/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"
#include "nlglobal.h"

/* pour les structures de analder */
#include "dftypes.h"


/*--------------- VARIABLES STATIQUES ------------*/
static int NbBoucles;



/*--------------- VARIABLES EXTERNES -------------*/
#include "nldcl.h"     /* les arguments de NL */
/*  contraintes sur les parametres differents. */
TContr CThetaE[MAXETAP], CBetaE[MAXETAP];
/* les sorties de analDer */
 TRetModele RetModele;

/*----------------FONCTIONS EXTERNES ------------*/
TShortInt CreerMat( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerMatC( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerVect( TShortInt nbele, TVect *pvect);
TShortInt CreerVectShort(TShortInt nbele, TVectShort *pvect);
TShortInt CreerVectStr( TShortInt nbele, TVectStr *pvect);
TShortInt CStatDon(TVectLong *NbRepet, TVect *ValY, TVect *PoidsT, 
		   TStatDon *StatDon) ;


TShortInt NLEtape(TShortInt Etape, TDonnees *Donnees, TModele *Modele, 
		  TCtxPuss *CtxPuss, TCtxNum *CtxNum,
                  TVect *ThetaPred1, TVect *ThetaPred2, 
		  TVect *BetaPred1, TVect *BetaPred2,
                  TVect *Valf1,TMat * DValf1,
                  TParam  *Theta, TParam  *Beta, 
		  TContr *CTheta, TContr *CBeta, TContr *CThetaE, TContr *CBetaE,
		  TResNum *ResNum, TResStat *ResStat,
                  TShortInt *NbItSv, TResNum *ItNum, TResStat *ItStat,
		  TVect *ItTheta, TVect *ItBeta, TVect *ItDirec, TDouble *ItOmega);


TShortInt NLAutres(TDonnees * Donnees, TCtxPuss *CtxPuss, TCtxNum CtxNum[], 
		   TParam Theta[], TParam Beta[],
		   TContr CTheta[], TContr CBeta[],  
		   TContr CThetaE[],  TContr CBetaE[],
                   TResNum ResNum[], TResStat ResStat[]);

/*--------------- Identification fonction ----------
| Nom de la fonction    : initrenls2               |
| Role                  :                          |
|  reinitialisation des structures de NL avant     |
|  les calculs effectifs par renls2                |
| Parametres d'entree   :                          |
|  ValY: nouvelles valeurs de la reponse           |
|  ThetaInit, BetaInit: nouvelles valeurs initiales|
|       des parametres                             |
| Parametres de sortie  :                          |
|   NbObsLu:n+nombre de poids nuls                 |
|   la suite: cf notice NL                         |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: renls2                           |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void initrenls2(
         ValY, ThetaInit, BetaInit,
         LgValY, NbObsLu, k,n,
         NbTheta, NbBeta, NbGamF,NbGamV, pmult, qmult,
         NbEq, NbJ, NbDF, LgDSedo)

/* vecteurs en entree*/
double *ValY, *ThetaInit, *BetaInit;
/* scalaire en entree */
TFuncInt *LgValY;

/* scalaires  en sortie */
TFuncInt *NbObsLu,*k, *n, *NbTheta, *NbBeta, * NbGamF, *NbGamV, *pmult,*qmult;
TFuncInt   *NbEq,*NbJ,*NbDF, *LgDSedo;

{
/*--------------- Fin identification fonction ----*/
int i,j;


/* reinitialisation des compteurs de warnings */
 GNLControle.CWarAna=0 ;  /* nbre de warnings pour l'analyseur-derivateur */
 GNLControle.CWarInt=0 ;  /* nbre de warnings pour l'integrateur */
 GNLControle.CWarMet=0 ;  /* nbre de warnings de type methodologique */
 GNLControle.CWarNum=0 ;  /* nbre de warnings de type numerique */
 GNLControle.CWarTot=0 ;  /* nbre de warnings tous types */

/* Reinitialisation des valeurs de Y */
*NbObsLu=(TFuncInt)Donnees.ValY.nbele;
if (*LgValY != *NbObsLu)
  {
/* cas ou l'utilisateur n'a pas donne de valeurs pour la reponse
   on a pris les valeurs ajustees (dim=k) , on les a replique pour tenir des repetitions
   mais, la longueur n'est pas toujours celles des XObsT:
   ca veut dire qu'il y a des poids nuls
   On met un element bidon dans les reponses correspondant a des poids nuls */
  j=0;
  for (i=0; i<*NbObsLu; i++)
    {
    if (Donnees.PoidsT.donnees[i] != 0 )
      {
      Donnees.ValY.donnees[i]=ValY[j];
      j=j+1;
      }
    else
      Donnees.ValY.donnees[i]=0;
    }
  }
else
  {
  for (i=0; i<*NbObsLu; i++)
    {
    Donnees.ValY.donnees[i]=ValY[i];
    }
  }


/* Reinitialisation des parametres */
*pmult=(TFuncInt)CtxPuss.Theta0.nbele;
for (i=0; i<*pmult; i++)
  {
  CtxPuss.Theta0.donnees[i]=ThetaInit[i];
  }

*qmult=(TFuncInt)CtxPuss.Beta0.nbele;
for (i=0; i<*qmult; i++)
  {
  CtxPuss.Beta0.donnees[i]=BetaInit[i];
  }

/* Reinitialisation du compteur d'appel a renls2 */
NbBoucles=0;

/*retour des dimensions */
*k= (TFuncInt)Donnees.NbObs;
*n=(TFuncInt)Donnees.NbObsT;

*NbTheta=(TFuncInt)Modele.NomTheta.nbele;
*NbBeta=(TFuncInt)Modele.NomBeta.nbele;
*NbGamF=(TFuncInt)Modele.NomGamF.nbele;
*NbGamV=(TFuncInt)Modele.NomGamV.nbele;
if (Modele.CasSedo ==1)
  {
  *NbJ= GNLCtxInteg.NbJ;
  *NbEq= GNLCtxInteg.NbEq;
  *NbDF=(TFuncInt)RetModele.NomLesDF.nbele;
  *LgDSedo= GNLCtxInteg.LongSys -  GNLCtxInteg.NbEq;
  }
else
  {
  *NbJ=0;
  *NbEq=0;
  *NbDF=0;
  *LgDSedo=0;
  }
return;

}
/* -------------- Fin fonction initrenls2 ----------------- */



/*--------------- Identification fonction ----------
| Nom de la fonction    : calcStatrenls2             | 
| Role                  :                          |
|  calcul des statistiques elementaires            |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
|   Code: code de retour de  CStatDon              |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|  Le programme de NL:CStatDon                     |
| Fonctions appelantes :                           |
|  la fonction S: renls2                           |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void calcStatrenls2(
         Code)

/* scalaire */
TFuncInt   *Code;

{
/*--------------- Fin identification fonction ----*/

*Code=OK;

/* Calcul des statistiques elementaires */
*Code = CStatDon( &(Donnees.NbRepet), &(Donnees.ValY), &(Donnees.PoidsT),
           &(Donnees.StatDon));
if (*Code != OK)
  {
  fprintf(stderr,"\nError  %d in the calculation of the data statistics, program 'calcStatrenls2' \n",
      *Code);
  }

return;

}
/* -------------- Fin fonction calcStatrenls2 ----------------- */





/*--------------- Identification fonction ----------
| Nom de la fonction    : steprenls2               |
| Role                  :                          |
|  gerer les calculs de toutes les etapes          |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
|  pact, qact, nh: voir notice NL                  |
|  Code: code de retour des programmes de NL       |
|         appeles                                  |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|  les programmes de NL: CreerVect, NLEtapes       |
| Fonctions appelantes :                           |
|  la fonction S: renls2                           |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void steprenls2(
           NbEtapes, vouluit, nbitsv,
           pact, qact, nh,
           NomTheta, NomBeta, NomGamF, NomGamV,
           NomValInt, NomLesF, NomLesDF,
           Code)

TFuncInt *NbEtapes;
/* vecteurs */
TFuncInt *vouluit, *nbitsv, *pact, *qact, *nh;
/* vecteurs char */
char ***NomTheta, ***NomBeta, ***NomGamF, ***NomGamV;
char ***NomValInt, ***NomLesF, ***NomLesDF;

/* scalaire */
TFuncInt    *Code;

{
/*--------------- Fin identification fonction ----*/
TShortInt  i, Etape, IndEtap;
TVect ThetaPred1, ThetaPred2, BetaPred1, BetaPred2;

TShortInt NbCodesErr=11;
TShortInt CodesErr[11];

/* CodesErr: les codes de retour de NL pour lesquels les sorties sont non valides */
/* erreur fatale dans ces cas */
CodesErr[0]=NONFAIT;
CodesErr[1]=ERRTYPES;
CodesErr[2]=ERRTRACE;
CodesErr[3]=ERRVINIT;
CodesErr[4]=ERWT;
CodesErr[5]=ERWM;
CodesErr[6]=ERWI;
CodesErr[7]=ERWN;
CodesErr[8]=ERRCMU;
CodesErr[9]=EPBALLOC;
CodesErr[10]=ERRALLOC;

*Code=OK;
NbBoucles= NbBoucles+1;

/* INITIALISATIONS */
/* on cree des vecteurs bidon pour pouvoir faire l'appel a NL
avec les memes arguments, qu'il y ait des valeurs precedemment estimees
ou non */
CreerVect((TShortInt)0, &ThetaPred1);
CreerVect((TShortInt)0, &ThetaPred2);
CreerVect((TShortInt)0, &BetaPred1);
CreerVect((TShortInt)0, &BetaPred2);


/* APPEL  DE NLEtape */
  for(Etape=1; Etape<=CtxPuss.NbEtapes; Etape++)
    {
    IndEtap = Etape - 1; /* indice dans les structures */

    switch(Etape)
      {
      case 1:
        *Code=NLEtape(Etape, &Donnees, &Modele, &CtxPuss, &(CtxNum[IndEtap]),
              &ThetaPred1, &ThetaPred2, &BetaPred1, &BetaPred2,
              &(ResStat[IndEtap].Ajustes.Valf),
              &(ResStat[IndEtap].FctSensib.DValf),
              &(Theta[IndEtap]), &(Beta[IndEtap]), 
              &(CTheta[IndEtap]), &(CBeta[IndEtap]),
              &(CThetaE[IndEtap]), &(CBetaE[IndEtap]),
              &(ResNum[IndEtap]), &(ResStat[IndEtap]),
              &(NbItSv[IndEtap]),
              ItNum[IndEtap], ItStat[IndEtap],
              ItTheta[IndEtap], ItBeta[IndEtap],
              ItDirec[IndEtap], ItOmega[IndEtap]);

         break;
      case 2:
         *Code=NLEtape(Etape, &Donnees, &Modele, &CtxPuss, &(CtxNum[IndEtap]),
              &(Theta[IndEtap-1].Estim), &ThetaPred2, 
              &(Beta[IndEtap-1].Estim), &BetaPred2,
              &(ResStat[IndEtap].Ajustes.Valf),
              &(ResStat[IndEtap].FctSensib.DValf),
              &(Theta[IndEtap]), &(Beta[IndEtap]), 
              &(CTheta[IndEtap]), &(CBeta[IndEtap]),
              &(CThetaE[IndEtap]), &(CBetaE[IndEtap]),
              &(ResNum[IndEtap]), &(ResStat[IndEtap]),
              &(NbItSv[IndEtap]),
              ItNum[IndEtap], ItStat[IndEtap],
              ItTheta[IndEtap], ItBeta[IndEtap],
              ItDirec[IndEtap], ItOmega[IndEtap]);

         break;
      default:
        *Code=NLEtape(Etape, &Donnees, &Modele, &CtxPuss, &(CtxNum[IndEtap]),
               &(Theta[IndEtap-1].Estim), &(Theta[IndEtap-2].Estim),
               &(Beta[IndEtap-1].Estim), &(Beta[IndEtap-2].Estim),
              &(ResStat[IndEtap-1].Ajustes.Valf),
              &(ResStat[IndEtap-1].FctSensib.DValf),
              &(Theta[IndEtap]), &(Beta[IndEtap]), 
              &(CTheta[IndEtap]), &(CBeta[IndEtap]),
              &(CThetaE[IndEtap]), &(CBetaE[IndEtap]),
              &(ResNum[IndEtap]), &(ResStat[IndEtap]),
              &(NbItSv[IndEtap]),
              ItNum[IndEtap], ItStat[IndEtap],
              ItTheta[IndEtap], ItBeta[IndEtap],
              ItDirec[IndEtap], ItOmega[IndEtap]);

        break;

      } /* fin du switch */
    if (*Code !=OK)
      {
      /* Impression en cas d'erreur lors de l'estimation bootstrap b */
      /* ----------------------------------------------------------- */
      fprintf(stderr, "\n Error %d at the %d estimation\n",
            *Code, NbBoucles);
      for (i=0; i<NbCodesErr; i++)
        {
        if (*Code == CodesErr[i])
          {
          return;
          }
        }
      /* erreur qui n'engendre pas un stop */
      *Code=OK;
      }


    /* On retourne les dimensions utiles */
    pact[IndEtap]= Theta[IndEtap].Act.nbele;
    qact[IndEtap]= Beta[IndEtap].Act.nbele;
    nh[IndEtap]= ResStat[IndEtap].EquN.ValEta.nbele;
    nbitsv[IndEtap]=NbItSv[IndEtap];
    } /* fin boucle sur Etape */

/* on retourne vouluit */

vouluit[0]=GNLControle.VouluIt.Ajustes;
vouluit[1]=GNLControle.VouluIt.EquN;
vouluit[2]=GNLControle.VouluIt.Estim;
vouluit[3]=GNLControle.VouluIt.FctSensib;
vouluit[4]=GNLControle.VouluIt.NbIter;
vouluit[5]=GNLControle.VouluIt.ResNum;
vouluit[6]=GNLControle.VouluIt.Sedo;

/* on retourne NbEtapes qui a pu avoir change */
*NbEtapes=(TFuncInt)CtxPuss.NbEtapes;


/* on retourne les noms utiles */
for(i=0;i<RetModele.NomTheta.nbele;i++)
  {
  strcpy(NomTheta[i], RetModele.NomTheta.donnees[i]);
  }

for(i=0;i<RetModele.NomBeta.nbele;i++)
  {
  strcpy(NomBeta[i], RetModele.NomBeta.donnees[i]);
  }

for(i=0;i<RetModele.NomGamF.nbele;i++)
  {
  strcpy(NomGamF[i], RetModele.NomGamF.donnees[i]);
  }

for(i=0;i<RetModele.NomGamV.nbele;i++)
  {
  strcpy(NomGamV[i], RetModele.NomGamV.donnees[i]);
  }

if (RetModele.CasSedo)
  {
  for(i=0;i<RetModele.NomValInt.nbele;i++)
    {
    strcpy(NomValInt[i], RetModele.NomValInt.donnees[i]);
    }
  for(i=0;i<RetModele.NomLesF.nbele;i++)
    {
    strcpy(NomLesF[i], RetModele.NomLesF.donnees[i]);
    }
  for(i=0;i<RetModele.NomLesDF.nbele;i++)
    {
    strcpy(NomLesDF[i], RetModele.NomLesDF.donnees[i]);
    }
  } /* fin cas sedo */


return;

}
/* -------------- Fin fonction steprenls2 ----------------- */




/*--------------- Identification fonction ----------
| Nom de la fonction    : otherrenls2               |
| Role                  :                          |
|  gerer l'appel aux calculs supplementaires       |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
|  Code: code de retour des programmes de NL       |
|         appeles                                  |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|   le programme de NL: NLAutres                   |
| Fonctions appelantes :                           |
|  la fonction S: renls2                           |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void otherrenls2( Code)

/* scalaire */
TFuncInt    *Code;

{
/*--------------- Fin identification fonction ----*/

*Code=OK;

  /* Calcul des autres sorties */
  *Code= NLAutres(&Donnees, &CtxPuss, CtxNum, 
                  Theta, Beta, CTheta, CBeta, CThetaE, CBetaE,
                  ResNum, ResStat);

  if (*Code !=OK)
    {
    /* Impression en cas d'erreur lors de l'estimation bootstrap b */
    /* ----------------------------------------------------------- */
    fprintf(stderr, "\n Error %d at the %d estimation, program 'otherrenls2'\n",
            *Code, NbBoucles);
    }
return;

}
/* -------------- Fin fonction otherrenls2 ----------------- */
