/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
/*----------------ROLE-----------------------------
  LES UTILITAIRES DE CREATION/DESTRUCTION DE STRUCTURES NL   
 -------------------------------------------------*/


/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <math.h>
#include <float.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"
#include "nlglobal.h"



/*--------------- VARIABLES EXTERNES -------------*/
#include "nldcl.h"     /* les arguments de NL */

/*----------------FONCTIONS EXTERNES ------------*/
TShortInt CreerMat( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerMatC( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerVect( TShortInt nbele, TVect *pvect);
TShortInt CreerVectLong(TShortInt nbele, TVectLong *pvect);
TShortInt CreerVectShort(TShortInt nbele, TVectShort *pvect);
TShortInt CreerVectStr( TShortInt nbele, TVectStr *pvect);
TShortInt NLVTrace();

/* --------- FONCTIONS appeles avant leur definition ----- */
void create_vect_int(TFuncInt *val, TFuncInt nbele, TVectShort *Struct);
void create_vect(double *val, TFuncInt nbele, TVect *Struct);
void create_vect_str();
/* 5/7/2001: je ne declare pas les arguments
car warning: argument #1 is incompatible with prototype:
si on le fait et ca ne marche pas si on essaie d'etre compatible.
Les argu sont dans utilnls2.c:
 char **val, TFuncInt nbele, TVectStr *Struct);
*/




/*--------------- Identification fonction ----------
| Nom de la fonction    : crintnls2
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crintnls2(char **Nom, TFuncInt *Val)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{

while(VRAI)
  {
  if (strcmp(*Nom, "Vari") == 0)
    {
    Modele.Vari= (TShortInt)*Val;
    break;
    }

  if (strcmp(*Nom, "NbEtapes") == 0)
    {
    CtxPuss.NbEtapes=(TShortInt)*Val;
    break;
    }
  if (strcmp(*Nom, "MaxDeb") == 0)
    {
    CtxPuss.MaxDeb=(TLongInt)*Val;
    break;
    }
  if (strcmp(*Nom, "MaxErr") == 0)
    {
    CtxPuss.MaxErr=(TLongInt)*Val;
    break;
    }
  if (strcmp(*Nom, "MaxIter") == 0)
    {
    CtxPuss.MaxIter=(TLongInt)*Val;
    break;
    }
  if (strcmp(*Nom, "Algo") == 0)
    {
    CtxPuss.Algo=(TShortInt)*Val;
    break;
    }
  if (strcmp(*Nom, "TypeMu") == 0)
    {
    CtxPuss.TypeMu=(TShortInt)*Val;
    break;
    }
  if (strcmp(*Nom, "Famille") == 0)
    {
    CtxPuss.Famille=(TShortInt)*Val;
    break;
    }
  if (strcmp(*Nom, "IndiceN") == 0)
    {
    Donnees.IndiceN=(TShortInt)*Val;
    break;
    }
  if (strcmp(*Nom, "TypeSigma") == 0)
    {
    CtxPuss.TypeSigma=(TShortInt)*Val;
    break;
    }

  if (strcmp(*Nom, "LgTrace") == 0)
    {
    GNLControle.LgTrace=(TShortInt)*Val;
    break;
    }

  if (strcmp(*Nom, "FreqIp") == 0)
    {
    GNLControle.FreqIp=(TLongInt)*Val;
    break;
    }

  if (strcmp(*Nom, "NbWAnaly") == 0)
    {
    GNLControle.NbWAnaly=(TShortInt)*Val;
    break;
    }

  if (strcmp(*Nom, "NbWInteg") == 0)
    {
    GNLControle.NbWInteg=(TShortInt)*Val;
    break;
    }

  if (strcmp(*Nom, "NbWMethe") == 0)
    {
    GNLControle.NbWMethe=(TShortInt)*Val;
    break;
    }

  if (strcmp(*Nom, "NbWNumer") == 0)
    {
    GNLControle.NbWNumer=(TShortInt)*Val;
    break;
    }

  if (strcmp(*Nom, "NbWTotal") == 0)
    {
    GNLControle.NbWTotal=(TShortInt)*Val;
    break;
    }

  if (strcmp(*Nom, "IpAjustes") == 0)
    {
    GNLControle.VouluIp.Ajustes=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "IpEquN") == 0)
    {
    GNLControle.VouluIp.EquN=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "IpEstim") == 0)
    {
    GNLControle.VouluIp.Estim=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "IpFctSensib") == 0)
    {
    GNLControle.VouluIp.FctSensib=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "IpNbIter") == 0)
    {
    GNLControle.VouluIp.NbIter=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "IpResNum") == 0)
    {
    GNLControle.VouluIp.ResNum=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "IpSedo") == 0)
    {
    GNLControle.VouluIp.Sedo=(TLogic)*Val;
    break;
    }



  if (strcmp(*Nom, "ItAjustes") == 0)
    {
    GNLControle.VouluIt.Ajustes=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "ItEquN") == 0)
    {
    GNLControle.VouluIt.EquN=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "ItEstim") == 0)
    {
    GNLControle.VouluIt.Estim=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "ItFctSensib") == 0)
    {
    GNLControle.VouluIt.FctSensib=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "ItNbIter") == 0)
    {
    GNLControle.VouluIt.NbIter=(TLogic)*Val;
    break;
    }

  if (strcmp(*Nom, "ItResNum") == 0)
    {
    GNLControle.VouluIt.ResNum=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "ItSedo") == 0)
    {
    GNLControle.VouluIt.Sedo=(TLogic)*Val;
    break;
    }


  if (strcmp(*Nom, "VeuxAjustes") == 0)
    {
    GNLControle.Voulu.Ajustes=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "VeuxAsVar") == 0)
    {
    GNLControle.Voulu.AsVar=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "VeuxBVarZBP") == 0)
    {
    GNLControle.Voulu.BVarZBP=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "VeuxCorr") == 0)
    {
    GNLControle.Voulu.Corr=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "VeuxData") == 0)
    {
    GNLControle.Voulu.Data=(TLogic)*Val;
    break;
    }

  if (strcmp(*Nom, "VeuxEquN") == 0)
    {
    GNLControle.Voulu.EquN=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "VeuxEstim") == 0)
    {
    GNLControle.Voulu.Estim=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "VeuxFctSensib") == 0)
    {
    GNLControle.Voulu.FctSensib=(TLogic)*Val;
    break;
    }

  if (strcmp(*Nom, "VeuxMu") == 0)
    {
    GNLControle.Voulu.Mu=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "VeuxResNum") == 0)
    {
    GNLControle.Voulu.ResNum=(TLogic)*Val;
    break;
    }

  if (strcmp(*Nom, "VeuxResidus") == 0)
    {
    GNLControle.Voulu.Residus=(TLogic)*Val;
    break;
    }

  if (strcmp(*Nom, "VeuxSedo") == 0)
    {
    GNLControle.Voulu.Sedo=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "VeuxValW") == 0)
    {
    GNLControle.Voulu.ValW=(TLogic)*Val;
    break;
    }
  if (strcmp(*Nom, "VeuxZ") == 0)
    {
    GNLControle.Voulu.Z=(TLogic)*Val;
    break;
    }

    fprintf(stderr,"\n Error in the execution of the program 'crintnls2'\n");
    fprintf(stderr,"Type %s Value %d\n", *Nom, *Val);
  } /* fin du while */

return;
}
/* -------------- Fin fonction crintnls2 ----------------- */



/*--------------- Identification fonction ----------
| Nom de la fonction    : crdblenls2
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crdblenls2(char **Nom, double *Val)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{

while(VRAI)
  {
  if (strcmp(*Nom, "DirecC") == 0)
    {
    CtxPuss.DirecC= (TDouble)*Val;
    break;
    }

  if (strcmp(*Nom, "Lambda0") == 0)
    {
    CtxPuss.Lambda0= (TDouble)*Val;
    break;
    }

  if (strcmp(*Nom, "LambdaC1") == 0)
    {
    CtxPuss.LambdaC1= (TDouble)*Val;
    break;
    }

  if (strcmp(*Nom, "LambdaC2") == 0)
    {
    CtxPuss.LambdaC2= (TDouble)*Val;
    break;
    }

  if (strcmp(*Nom, "MaxCritArret") == 0)
    {
    CtxPuss.MaxCritArret= (TDouble)*Val;
    break;
    }

  if (strcmp(*Nom, "MaxLambda") == 0)
    {
    CtxPuss.MaxLambda= (TDouble)*Val;
    break;
    }

  if (strcmp(*Nom, "OmegaPas") == 0)
    {
    CtxPuss.OmegaPas= (TDouble)*Val;
    break;
    }

  if (strcmp(*Nom, "Sigma2") == 0)
    {
    CtxPuss.Sigma= (TDouble)*Val;
    break;
    }

    fprintf(stderr,"\n Error in the execution of the program 'crdblenls2'\n");
  } /* fin du while */
return;
}
/* -------------- Fin fonction crdblenls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : crvectnls2
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crvectnls2(char **Nom, double *Val, TFuncInt *n)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{

while(VRAI)
  {

   /* Les Donnees */
   /* ---------- */
  if (strcmp(*Nom, "PoidsT") == 0)
    {
    create_vect(Val, *n,     &(Donnees.PoidsT));
    break;
    }
   /* Le modele */
   /* --------- */
  if (strcmp(*Nom, "GamF") == 0)
    {
    create_vect(Val, *n,     &(Modele.GamF));
    break;
    }
  if (strcmp(*Nom, "GamV") == 0)
    {
    create_vect(Val, *n,     &(Modele.GamV));
    break;
    }
  if (strcmp(*Nom, "EquNTheta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CTheta0.EgalN));
    break;
    }
  if (strcmp(*Nom, "InfTheta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CTheta0.BInf));
    break;
    }
  if (strcmp(*Nom, "SupTheta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CTheta0.BSup));
    break;
    }
  if (strcmp(*Nom, "EquNBeta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CBeta0.EgalN));
    break;
    }
  if (strcmp(*Nom, "InfBeta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CBeta0.BInf));
    break;
    }
  if (strcmp(*Nom, "SupBeta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CBeta0.BSup));
    break;
    }



  /* Le ctxpuss */
  /* ---------  */
  if (strcmp(*Nom, "Theta0") == 0)
    {
    create_vect(Val, *n,     &(CtxPuss.Theta0));
    break;
    }
  if (strcmp(*Nom, "Beta0") == 0)
    {
    create_vect(Val, *n,     &(CtxPuss.Beta0));
    break;
    }
  if (strcmp(*Nom, "Mu3") == 0)
    {
    create_vect(Val, *n,     &(CtxPuss.Mu3));
    break;
    }
  if (strcmp(*Nom, "Mu4") == 0)
    {
      create_vect(Val, *n,     &(CtxPuss.Mu4));
    break;
    }

    fprintf(stderr,"\n Error in the execution of the program 'crvectnls2'\n");
  } /* fin du while */
return;
}
/* -------------- Fin fonction crvectnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : crvectNAnls2
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crvectNAnls2(char **Nom, double *Val, int *indNA, TFuncInt *n)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{
int i;

/* Remplacement des valeurs manquantes */
for (i=0; i<*n; i++)
  {
  if (indNA[i]==1)
        Val[i] =mysignaling_nan(nn);
  }


while(VRAI)
  {
   /* Le modele */
   /* --------- */
  if (strcmp(*Nom, "EquNTheta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CTheta0.EgalN));
    break;
    }
  if (strcmp(*Nom, "InfTheta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CTheta0.BInf));
    break;
    }
  if (strcmp(*Nom, "SupTheta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CTheta0.BSup));
    break;
    }
  if (strcmp(*Nom, "EquNBeta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CBeta0.EgalN));
    break;
    }
  if (strcmp(*Nom, "InfBeta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CBeta0.BInf));
    break;
    }
  if (strcmp(*Nom, "SupBeta") == 0)
    {
    create_vect(Val, *n,     &(Modele.CBeta0.BSup));
    break;
    }

    fprintf(stderr,"\n Error in the execution of the program 'crvectNAnls2'\n");
  } /* fin du while */
return;
}
/* -------------- Fin fonction crvectNAnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : crvectintnls2
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crvectintnls2(char **Nom, TFuncInt *Val, TFuncInt *n)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{

while(VRAI)
  {
   /* Le modele */
   /* --------- */
  if (strcmp(*Nom, "EquPTheta") == 0)
    {
    create_vect_int(Val, *n,     &(Modele.CTheta0.EgalP));
    break;
    }
  if (strcmp(*Nom, "EquPBeta") == 0)
    {
    create_vect_int(Val, *n,     &(Modele.CBeta0.EgalP));
    break;
    }

    fprintf(stderr,"\n Error in the execution of the program 'crvectintnls2'\n");
  } /* fin du while */
return;
}
/* -------------- Fin fonction crvectintnls2 ----------------- */



/*--------------- Identification fonction ----------
| Nom de la fonction    : crvectstrnls2
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void crvectstrnls2(char **Nom, char ***Val,TFuncInt  *n)

/* arguments d'entree */

/*--------------- Fin identification fonction ----*/
{

while(VRAI)
  {
  if (strcmp(*Nom, "NomCT") == 0)
    {
    create_vect_str(Val, *n,     &(Donnees.NomCT));
    break;
    }
  if (strcmp(*Nom, "NomObsT") == 0)
    {
    create_vect_str(Val, *n,     &(Donnees.NomObsT));
    break;
    }

    fprintf(stderr,"\n Error in the execution of the program 'crvectstrnls2'\n");
  } /* fin du while */
return;
}
/* -------------- Fin fonction crvectstrnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : crTracenls2              |
| Role                  :                          |
|    Creer la trace
--------------------------------------------------*/
void crTracenls2()
{
 /* creation de la trace */
  GNLControle.LgTrace=DEFLGTRACE;
  NLVTrace();
  return;
}
/* ---------------- end of crTracenls2 -----------------*/

/* -----------------------------------------------------------
generxnls2: generation des points du reseau
pour contours
 ------------------------------------------------------------- */
void generxnls2(double theta, double se, 
		double extends0, double extends1, 
		double bounds0, double bounds1, 
		TFuncInt nbpoints0, TFuncInt nbpoints1,double *x)
/* arguments d'entree 
double theta, se, extends0, extends1, bounds0, bounds1;
TFuncInt  nbpoints0, nbpoints1;
 argu de sortie 
double *x;
*/
{
int i,l;
double depart, delta;

/* generation a gauche */
if (bounds0==bounds1)
  {
  depart= theta - (extends0 * se);
  delta= (extends0 * se) / (double)nbpoints0;
  }
else
  {
  depart=bounds0;
  delta= (theta-bounds0)/ (double)nbpoints0;
  }

for (i=0; i<nbpoints0; i++)
  {
  x[i]= depart + ( (double)i * delta);
  }

/* generation a droite */
if (bounds0==bounds1)
  delta= (extends1 * se) /(double)nbpoints1;
else
  delta= (bounds1-theta)/(double)nbpoints1;

depart= theta + delta;
l=nbpoints0;
for (i=0; i<nbpoints1; i++)
  {
  x[l]= depart + ( (double)i * delta);
  l=l+1;
  }
return;
}

/* -----------------------------------------------------------
initialisation de ce qui est necessaire dans GNLControle
pour ecrire des messages
 ------------------------------------------------------------- */
void initcrolenls2(TFuncInt *check, TFuncInt *warn)
{

GNLControle.FinTrait = DEFFINTRAIT;
GNLControle.LgTrace = DEFLGTRACE;
GNLControle.NbWAnaly = DEFWANALY;
GNLControle.NbWInteg = DEFWINTEG;
GNLControle.NbWMethe = DEFWMETHO;
GNLControle.NbWNumer = DEFWNUMER;
GNLControle.NbWTotal = DEFWTOTAL;
GNLControle.SortImp = DEFSORTIMP;
GNLControle.SortTrace = DEFSORTTRACE;
GNLControle.SortWE = DEFSORTWE;
GNLControle.TypeLgMess = DEFLGMESS;

/* Messages longs si l'option check=T */
if (*check == 1)
  GNLControle.TypeLgMess = LONG;

/* actions selon la valeur de l'option warn */
if (*warn == 1)
  {
  /* Ip des warnings quand ils apparaissent */
  GNLControle.SortWE = GNLControle.SortImp;
  }
if (*warn == 2)
  {
  /* un warning = une erreur */
  GNLControle.NbWTotal =2; /* c'est le minimum possible */
  }
if (*warn <0)
  {
  /* pas d'impression */
  GNLControle.SortWE=NULL;
  }

return;
}
/* -------------- Fin fonction initcrolenls2 ----------------- */




/*--------------- Identification fonction ----------
| Nom de la fonction    : create_mat
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void create_mat(double *val, TFuncInt nblig, TFuncInt nbcol, TMat *Struct)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{
int i,j;
int l=0;


/* allocation: */
CreerMat((TShortInt)nblig, (TShortInt)nbcol, Struct);

/* affectation */
for (j=0;j<nbcol;j++)
  {
  for(i=0;i<nblig;i++)
    {
    Struct->donnees[i][j]=val[l];
    l=l+1;
    }
  }

return;

}
/* -------------- Fin fonction create_mat ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : create_vect
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void create_vect(double *val, TFuncInt nbele, TVect *Struct)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{
int i;

/* allocation: */
CreerVect((TShortInt)nbele, Struct);

/* affectation */
for(i=0;i<nbele;i++)
  {
  Struct->donnees[i]=val[i];
  }
return;
}
/* -------------- Fin fonction create_vect ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : create_vect_int
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void create_vect_int(TFuncInt *val, TFuncInt nbele, TVectShort *Struct)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{
int i;

/* allocation: */
CreerVectShort((TShortInt)nbele, Struct);

/* affectation */
for(i=0;i<nbele;i++)
  {
  Struct->donnees[i]=(TShortInt)val[i];
  }
return;
}
/* -------------- Fin fonction create_vect_int ----------------- */



/*--------------- Identification fonction ----------
| Nom de la fonction    : create_vect_long
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void create_vect_long(TFuncInt *val, TFuncInt nbele, TVectLong *Struct)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{
int i;

/* allocation: */
CreerVectLong((TShortInt)nbele, Struct);

/* affectation */
for(i=0;i<nbele;i++)
  {
  Struct->donnees[i]=(TLongInt)val[i];
  }
return;
}
/* -------------- Fin fonction create_vect_long ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : create_vect_str
| Role                  : 
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes :  
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void create_vect_str(char **val, TFuncInt  nbele, TVectStr *Struct)

/* arguments d'entree */
/*--------------- Fin identification fonction ----*/

{
int i;


/* allocation: */
CreerVectStr((TShortInt)nbele, Struct);

/* affectation */
for(i=0;i<nbele;i++)
  {
  strcpy(Struct->donnees[i], val[i]);
  }
return;
}
/* -------------- Fin fonction create_vect_str ----------------- */
