/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : analyse.c                 |
| Date                 : 12 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : prepare et gere l'appel des analyseurs
| Reference conception : DCP modules 2 et 3        |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdlib.h>
#include <string.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;

/*--------------- FONCTIONS EXTERNES -------------*/

extern TArbre* constBin();
extern TArbre* constUn();
extern TShortInt gereIden();
extern TDouble decoCons();
extern void *malloc(size_t size);

/*--------------- OTHER INCLUDES ---------------------*/
#include "analSynt.h"
#include "analLex.h"

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : analSerr                 |
| Role                  : filtre les messages de yacc
| Parametres d'entree   : libelle                  |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 15            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

int analSerr(libelle)
     char * libelle;

/*--------------- Fin identification fonction ----*/

{
  if (strcmp(libelle, SYNTERR)==0)
    {
      erreAnal(EYSYNT, monyytext);
    }
  else if (strcmp(libelle, OUTMEM)==0)
    {
      erreAnal(EYMEM, monyytext);
    }
  else if (strcmp(libelle, STACKOWF)==0)
    {
      erreAnal(EYSTACK, monyytext);
    }
  else if (strcmp(libelle, CANTBACK)==0)
    {
      erreAnal(EYBACK, monyytext);
    }
  else 
    {
      erreAnal(EYAUTRE, monyytext);
    }
return 1;
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : initOuv                  |
| Role                  : ouvre le fichier de description, initialise
| Parametres d'entree   : NomDescr                 |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 3             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : analyse                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt initOuv(NomDescr)
     TChaine NomDescr;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  if (NomDescr==NULL)
    {
      erreAnal(ENOMFICH, NULL);
      return(FAUX);
    }
  monyyin=fopen(NomDescr, "r");
  if (monyyin==NULL)
    {
      erreAnal(EFICH, NomDescr);
      return(FAUX);
    }
  /* initialisation de ModSpecif */
  GModSpecif.IdeX.nbele=0;
  GModSpecif.IdeTheta.nbele=0;
  GModSpecif.IdeBeta.nbele=0;
  GModSpecif.IdeGamF.nbele=0;
  GModSpecif.IdeGamV.nbele=0;
  GModSpecif.IdeLesDF.nbele=0;
  GModSpecif.IdeLesF.nbele=0;
  GModSpecif.IdeValInt.nbele=0;
  GModSpecif.IdeCondInit.nbele=0;
  GModSpecif.Auxiliaire.nbele=0;
  GModSpecif.Constantes.nbele=0;
  GModSpecif.IndicTj.nbele=0;
  GModSpecif.Unique=OUI;
  for (i=0; i<16; i++)
    {
      GModSpecif.typeUsed[i]=FAUX;
    }
  GModSpecif.yaerr=NON;
  GModSpecif.Resp=NON;
  GModSpecif.Vari=NON;
  GModSpecif.Subroutine=NON;
  GModSpecif.CasSedo=NON;
  GModSpecif.IdeF.arbre=NULL;
  GModSpecif.IdeV.arbre=NULL;

  /* stocke NomDescr au debut de la table des identificateurs PPident[0] */
  GModSpecif.NomFich=0;
  GModSpecif.PPident.nbele=1;

  GModSpecif.PPident.ident=(Tident *)malloc(sizeof(Tident));
  if (GModSpecif.PPident.ident==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }

  GModSpecif.PPident.ident[0].libelle=(TChaine)malloc(strlen(NomDescr)
						      *sizeof(TChar));
  if (GModSpecif.PPident.ident[0].libelle==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }
  strcpy(GModSpecif.PPident.ident[0].libelle, NomDescr);

  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : analyse                  |
| Role                  : gere l'appel des analyseurs
| Parametres d'entree   : NomDescr                 |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 2             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : initOuv analyseurs        |
| Fonctions appelantes : analDer                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt analyse(NomDescr)
     TChaine NomDescr;

/*--------------- Fin identification fonction ----*/

{
  if (initOuv(NomDescr)==VRAI)
    {
      analSynt();
      fclose(monyyin);
    }
return(OK);


}
