/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : attaArb.c                 |
| Date                 : 26 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : associe une expression a son identificateur
| Reference conception : DCP module 11             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;
extern int monyylineno;

/*--------------- FONCTIONS EXTERNES -------------*/
extern TShortInt erreAnal(TChaine message, TChaine param);
extern TShortInt erreAutr(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : attaArb                  |
| Role                  : associe une expression a son identificateur
| Parametres d'entree   : classe ordre Noeud       |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 11            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal erre Autr        |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt attaArb(classe, ordre, Noeud)
     TShortInt classe, ordre;
     TArbre * Noeud;

/*--------------- Fin identification fonction ----*/
{
  if (Noeud==NULL)
    {
      erreAutr(EUNEXPR, NULL);
    }
  else
    {
      switch(classe)
	{
	case CLF:
	  /* expression codant f */
	  if (GModSpecif.IdeF.arbre!=NULL)
	    {
	      erreAnal(EREEXPR,
		       GModSpecif.PPident.ident[GModSpecif.
						IdeF.ident].libelle);
	    }
	  else
	    {
	      GModSpecif.IdeF.arbre=Noeud;
	    }
	  break;
	case CLV:
	  /* expression codant v */
	  if (GModSpecif.IdeV.arbre!=NULL)
	    {
	      erreAnal(EREEXPR,
		       GModSpecif.PPident.ident[GModSpecif.
						IdeV.ident].libelle);
	    }
	  else
	    {
	      GModSpecif.IdeV.arbre=Noeud;
	    }
	  break;
	case CLDF:
	  /* expression codant dF */
	  if (GModSpecif.IdeLesDF.UnDF[ordre].arbre!=NULL)
	    {
	      erreAnal(EREEXPR,
		       GModSpecif.PPident.
		       ident[GModSpecif.IdeLesDF.UnDF[ordre].ident].libelle);
	    }
	  else
	    {
	      GModSpecif.IdeLesDF.UnDF[ordre].arbre=Noeud;
	    }
	  break;
	case CLAUX:
	  /* expression auxiliaire */
	  if (GModSpecif.Auxiliaire.UnAux[ordre].arbre!=NULL)
	    {
	      erreAnal(EREEXPR,
		       GModSpecif.PPident.
		       ident[GModSpecif.Auxiliaire.UnAux[ordre].
			     ident].libelle);
	    }
	  else
	    {
	      GModSpecif.Auxiliaire.UnAux[ordre].arbre=Noeud;
	    }
	  break;
	case CLCONS:
	  /* valeur d'une constante */
	  if (Noeud->fonction!=CONSTANTE)
	    {
	      erreAutr(EUNCST, NULL);
	    }
	  else
	    {
	      GModSpecif.Constantes.UneCst[ordre].valeur=Noeud->valeur;
	    }
	  break;
	}
    }
return (TShortInt)1;
}

