/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : chargCond.c               |
| Date                 : 20 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Charge les arbres conditionnellement aux declarations
| Reference conception : DCP module 30             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include <string.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;

/*--------------- FONCTIONS EXTERNES -------------*/

extern TShortInt chargArb();
extern TShortInt gereIden();
extern char *strcat(char *dest, const char *src);
extern void *malloc(size_t size);
extern TShortInt erreAnal(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : chargCond                |
| Role                  : Charge conditionnellement aux declarations
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 30            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : chargArb gereIden erreAutr|
| Fonctions appelantes : coheDecl                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt chargCond()

/*--------------- Fin identification fonction ----*/

{
  TShortInt* util;
  TModSpecif LuModSpecif;
  TDerivees LuDerivees;
  TPPident* LuLPPident;
  TChaine nom;
  TShortInt ret, i;

  util=GModSpecif.typeUsed;

  /* generation du nom de fichier, NomFich contient soit 0 (fichier de descr
   soit l'identificateur du nom de fichier */
  /* AB: pour que ca marche sous Linux, remplace:
  nom=(TChaine)
    malloc((strlen(GModSpecif.PPident.ident[GModSpecif.NomFich].libelle)
	    +4) * sizeof(TChar));
par:
  */
  nom=(TChaine)
    malloc((strlen(GModSpecif.PPident.ident[GModSpecif.NomFich].libelle)
	    +5) * sizeof(TChar));

  if (nom==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }
  strcpy(nom, GModSpecif.PPident.ident[GModSpecif.NomFich].libelle);
  strcat(nom, ".arb");      

  /* chargement dans des structures temporaires */
  if (chargArb(nom, &LuModSpecif, &LuDerivees)==OK)
    {
      LuLPPident=&LuModSpecif.PPident;
      /* copie conditionnelle dans GModSpecif */
      /* dans tous les cas */
      
      /* copie de varind (ou X) */
      if (util[IDEX]==NON)
	{
	  GModSpecif.IdeX.donnees=(TShortInt*)
	    malloc(LuModSpecif.IdeX.nbele * sizeof(TShortInt));
	  if (GModSpecif.IdeX.donnees==NULL)
	    {
	      erreAnal(EMEM, NULL);
	      return(FAUX);
	    }
	  else
	    {
	      GModSpecif.IdeX.nbele=LuModSpecif.IdeX.nbele;
	      for (i=0; i<LuModSpecif.IdeX.nbele; i++)
		{
		  ret=gereIden(strlen(LuLPPident->
				      ident[LuModSpecif.IdeX.donnees[i]].
				      libelle),
			       OUI,
			       LuLPPident->ident[LuModSpecif.IdeX.donnees[i]].
			       libelle);
		  if (ret>=0)
		    {
		      /* pas de conflit dans PPident */
		      GModSpecif.PPident.ident[ret].type=IDEX;
		      GModSpecif.IdeX.donnees[i]=ret;
		    }
		}
	    }
	}

      /* copie de aux */
      if (util[IDEAUX]==NON)
	{
	  GModSpecif.Auxiliaire.UnAux=(TUnAux*)
	    malloc(LuModSpecif.Auxiliaire.nbele * sizeof(TUnAux));
	  if (GModSpecif.Auxiliaire.UnAux==NULL)
	    {
	      erreAnal(EMEM, NULL);
	      return(FAUX);
	    }
	  else
	    {
	      GModSpecif.Auxiliaire.nbele=LuModSpecif.Auxiliaire.nbele;
	      for (i=0; i<LuModSpecif.Auxiliaire.nbele; i++)
		{
		  ret=gereIden(strlen(LuLPPident->
				      ident[LuModSpecif.
					    Auxiliaire.UnAux[i].ident].
				      libelle), OUI,
			       LuLPPident->ident[LuModSpecif.
						 Auxiliaire.UnAux[i].ident].
			       libelle);
		  if (ret>=0)
		    {
		      /* pas de conflit dans PPident */
		      GModSpecif.PPident.ident[ret].type=IDEAUX;
		      GModSpecif.Auxiliaire.UnAux[i].ident=ret;
		      GModSpecif.Auxiliaire.UnAux[i].arbre=
			LuModSpecif.Auxiliaire.UnAux[i].arbre;
		    }
		}
	    }
	}

      /* copie de Constate */
      if (util[IDECONST]==NON)
	{
	  GModSpecif.Constantes.UneCst=(TUneCst*)
	    malloc(LuModSpecif.Constantes.nbele * sizeof(TUneCst));
	  if (GModSpecif.Constantes.UneCst==NULL)
	    {
	      erreAnal(EMEM, NULL);
	      return(FAUX);
	    }
	  else
	    {
	      GModSpecif.Constantes.nbele=LuModSpecif.Constantes.nbele;
	      for (i=0; i<LuModSpecif.Constantes.nbele; i++)
		{
		  ret=gereIden(strlen(LuLPPident->
				      ident[LuModSpecif.
					    Constantes.UneCst[i].ident].
				      libelle),
			       OUI,
			       LuLPPident->ident[LuModSpecif.
						 Constantes.UneCst[i].ident].
			       libelle);
		  if (ret>=0)
		    {
		      /* pas de conflit dans PPident */
		      GModSpecif.PPident.ident[ret].type=IDECONST;
		      GModSpecif.Constantes.UneCst[i].ident=ret;
		      GModSpecif.Constantes.UneCst[i].valeur=
			LuModSpecif.Constantes.UneCst[i].valeur;
		    }
		}
	    }
	}

      /* si resp=1 */
      if (LuModSpecif.Resp==OUI)
	{
	  /* copie de resp */
	  if (util[IDEF]==NON)
	    {
	      ret=gereIden(strlen(LuLPPident->ident[LuModSpecif.IdeF.ident].
				  libelle),
			   OUI,
			   LuLPPident->ident[LuModSpecif.IdeF.ident].libelle);
	      if (ret>=0)
		{
		  /* l'indentificateur ne cree pas de conflit dans PPident */
		  GModSpecif.PPident.ident[ret].type=IDEF;
		  GModSpecif.IdeF.ident=ret;
		  GModSpecif.IdeF.arbre=LuModSpecif.IdeF.arbre;
		}
	    }

	  /* copie de pbisresp (ou GamF) */
	  if (util[IDEGAMF]==NON)
	    {
	      GModSpecif.IdeGamF.donnees=(TShortInt*)
		malloc(LuModSpecif.IdeGamF.nbele * sizeof(TShortInt));
	      if (GModSpecif.IdeGamF.donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      else
		{
		  GModSpecif.IdeGamF.nbele=LuModSpecif.IdeGamF.nbele;
		  for (i=0; i<LuModSpecif.IdeGamF.nbele; i++)
		    {
		      ret=gereIden(strlen(LuLPPident->
					  ident[LuModSpecif.IdeGamF.
						donnees[i]].libelle),
				   OUI,
				   LuLPPident->ident[LuModSpecif.IdeGamF.
						     donnees[i]].libelle);
		      if (ret>=0)
			{
			  /* pas de conflit dans PPident */
			  GModSpecif.PPident.ident[ret].type=IDEGAMF;
			  GModSpecif.IdeGamF.donnees[i]=ret;
			}
		    }
		}
	    }
	}

      /* si resp=1 ou vari=1 */
      if (LuModSpecif.Resp==OUI || LuModSpecif.Vari==OUI)
	{
	  /* copie de parresp (ou THETA) */
	  if (util[IDETHETA]==NON)
	    {
	      GModSpecif.IdeTheta.donnees=(TShortInt*)
		malloc(LuModSpecif.IdeTheta.nbele * sizeof(TShortInt));
	      if (GModSpecif.IdeTheta.donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      else
		{
		  GModSpecif.IdeTheta.nbele=LuModSpecif.IdeTheta.nbele;
		  for (i=0; i<LuModSpecif.IdeTheta.nbele; i++)
		    {
		      ret=gereIden(strlen(LuLPPident->
					  ident[LuModSpecif.IdeTheta.
						donnees[i]].libelle),
				   OUI,
				   LuLPPident->ident[LuModSpecif.IdeTheta
						     .donnees[i]].libelle);
		      if (ret>=0)
			{
			  /* pas de conflit dans PPident */
			  GModSpecif.PPident.ident[ret].type=IDETHETA;
			  GModSpecif.IdeTheta.donnees[i]=ret;
			}
		    }
		}
	    }
	}

      /* si vari=1 */
      if (LuModSpecif.Vari==OUI)
	{
	  /* copie de var */
	  if (util[IDEV]==NON)
	    {
	      ret=gereIden(strlen(LuLPPident->ident[LuModSpecif.IdeV.ident].
				  libelle),
			   OUI,
			   LuLPPident->ident[LuModSpecif.IdeV.ident].libelle);
	      if (ret>=0)
		{
		  /* l'indentificateur ne cree pas de conflit dans PPident */
		  GModSpecif.PPident.ident[ret].type=IDEV;
		  GModSpecif.IdeV.ident=ret;
		  GModSpecif.IdeV.arbre=LuModSpecif.IdeV.arbre;
		}
	    }

	  /* copie de parvar (ou Beta) */
	  if (util[IDEBETA]==NON)
	    {
	      GModSpecif.IdeBeta.donnees=(TShortInt*)
		malloc(LuModSpecif.IdeBeta.nbele * sizeof(TShortInt));
	      if (GModSpecif.IdeBeta.donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      else
		{
		  GModSpecif.IdeBeta.nbele=LuModSpecif.IdeBeta.nbele;
		  for (i=0; i<LuModSpecif.IdeBeta.nbele; i++)
		    {
		      ret=gereIden(strlen(LuLPPident->
					  ident[LuModSpecif.IdeBeta.
						donnees[i]].libelle),
				   OUI,
				   LuLPPident->ident[LuModSpecif.IdeBeta.
						     donnees[i]].libelle);
		      if (ret>=0)
			{
			  /* pas conflit dans PPident */
			  GModSpecif.PPident.ident[ret].type=IDEBETA;
			  GModSpecif.IdeBeta.donnees[i]=ret;
			}
		    }
		}
	    }
	  
	  /* copie de pbisvar (ou GamV) */
	  if (util[IDEGAMV]==NON)
	    {
	      GModSpecif.IdeGamV.donnees=(TShortInt*)
		malloc(LuModSpecif.IdeGamV.nbele * sizeof(TShortInt));
	      if (GModSpecif.IdeGamV.donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      else
		{
		  GModSpecif.IdeGamV.nbele=LuModSpecif.IdeGamV.nbele;
		  for (i=0; i<LuModSpecif.IdeGamV.nbele; i++)
		    {
		      ret=gereIden(strlen(LuLPPident->
					  ident[LuModSpecif.IdeGamV.
						donnees[i]].libelle),
				   OUI,
				   LuLPPident->ident[LuModSpecif.IdeGamV.
						     donnees[i]].libelle);
		      if (ret>=0)
			{
			  /* pas de conflit dans PPident */
			  GModSpecif.PPident.ident[ret].type=IDEGAMV;
			  GModSpecif.IdeGamV.donnees[i]=ret;
			}
		    }
		}
	    }
	}

      /* si casSedo=1 */
      if (LuModSpecif.CasSedo==OUI)
	{
	  /* copie de varint */
	  if (util[IDEVARINT]==NON)
	    {
	      ret=gereIden(strlen(LuLPPident->ident[LuModSpecif.IdeVarInt].
				  libelle),
			   OUI,
			   LuLPPident->ident[LuModSpecif.IdeVarInt].libelle);
	      if (ret>=0)
		{
		  /* l'indentificateur ne cree pas de conflit dans PPident */
		  GModSpecif.PPident.ident[ret].type=IDEVARINT;
		  GModSpecif.IdeVarInt=ret;
		}
	    }
	  
	  
	  /* copie de lesF */
	  if (util[IDELESF]==NON)
	    {
	      GModSpecif.IdeLesF.donnees=(TShortInt*)
		malloc(LuModSpecif.IdeLesF.nbele * sizeof(TShortInt));
	      if (GModSpecif.IdeLesF.donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      else
		{
		  GModSpecif.IdeLesF.nbele=LuModSpecif.IdeLesF.nbele;
		  for (i=0; i<LuModSpecif.IdeLesF.nbele; i++)
		    {
		      ret=gereIden(strlen(LuLPPident->
					  ident[LuModSpecif.IdeLesF.
						donnees[i]].libelle),
				   OUI,
				   LuLPPident->ident[LuModSpecif.IdeLesF.
						     donnees[i]].libelle);
		      if (ret>=0)
			{
			  /* pas de conflit dans PPident */
			  GModSpecif.PPident.ident[ret].type=IDELESF;
			  GModSpecif.IdeLesF.donnees[i]=ret;
			}
		    }
		}
	    }
	  
	  /* copie de valint */
	  if (util[IDEVALINT]==NON)
	    {
	      GModSpecif.IdeValInt.donnees=(TShortInt*)
		malloc(LuModSpecif.IdeValInt.nbele * sizeof(TShortInt));
	      if (GModSpecif.IdeValInt.donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      else
		{
		  GModSpecif.IdeValInt.nbele=LuModSpecif.IdeValInt.nbele;
		  for (i=0; i<LuModSpecif.IdeValInt.nbele; i++)
		    {
		      ret=gereIden(strlen(LuLPPident->
					  ident[LuModSpecif.IdeValInt.
						donnees[i]].libelle),
				   OUI,
				   LuLPPident->ident[LuModSpecif.IdeValInt.
						     donnees[i]].libelle);
		      if (ret>=0)
			{
			  /* pas de conflit dans PPident */
			  GModSpecif.PPident.ident[ret].type=IDEVALINT;
			  GModSpecif.IdeValInt.donnees[i]=ret;
			}
		    }
		}
	    }
	  
	  /* copie de CondInit */
	  if (util[IDECONDINIT]==NON)
	    {
	      GModSpecif.IdeCondInit.donnees=(TShortInt*)
		malloc(LuModSpecif.IdeCondInit.nbele * sizeof(TShortInt));
	      if (GModSpecif.IdeCondInit.donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      else
		{
		  GModSpecif.IdeCondInit.nbele=LuModSpecif.IdeCondInit.nbele;
		  for (i=0; i<LuModSpecif.IdeCondInit.nbele; i++)
		    {
		      ret=gereIden(strlen(LuLPPident->
					  ident[LuModSpecif.IdeCondInit.
						donnees[i]].libelle),
				   OUI,
				   LuLPPident->ident[LuModSpecif.IdeCondInit.
						     donnees[i]].libelle);
		      if (ret>=0)
			{
			  /* pas de conflit dans PPident */
			  GModSpecif.IdeCondInit.donnees[i]=ret;
			}
		    }
		}
	    }
	  
	  /* copie de LesDF */
	  if (util[IDELESDF]==NON)
	    {
	      GModSpecif.IdeLesDF.UnDF=(TUnDF*)
		malloc(LuModSpecif.IdeLesDF.nbele * sizeof(TUnDF));
	      if (GModSpecif.IdeLesDF.UnDF==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      else
		{
		  GModSpecif.IdeLesDF.nbele=LuModSpecif.IdeLesDF.nbele;
		  for (i=0; i<LuModSpecif.IdeLesDF.nbele; i++)
		    {
		      ret=gereIden(strlen(LuLPPident->
					  ident[LuModSpecif.IdeLesDF.UnDF[i].
						ident].libelle),
				   OUI,
				   LuLPPident->
				   ident[LuModSpecif.IdeLesDF.UnDF[i].
					 ident].libelle);
		      if (ret>=0)
			{
			  /* pas de conflit dans PPident */
			  GModSpecif.PPident.ident[ret].type=IDELESDF;
			  GModSpecif.IdeLesDF.UnDF[i].ident=ret;
			  GModSpecif.IdeLesDF.UnDF[i].arbre=
			    LuModSpecif.IdeLesDF.UnDF[i].arbre;
			}
		    }
		}
	    }
	}
    }
return (TShortInt)1;
}
