/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : decoCons.c                |
| Date                 : 19 aou. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : Olivier NICOLE            |
| Role                 : calcule la valeur d'une constante
| Reference conception : DCP module 7              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : decoCons                 |
| Role                  : calcule la valeur d'une constante
| Parametres d'entree   : yylength monyytext          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 7             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur lexical         |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TDouble decoCons(monyylenght, monyytext)
     int monyylenght;
     TChaine monyytext;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TShortInt asc;
  TDouble som;
  TDouble j;
  TShortInt exp;
  TShortInt sig;
  TShortInt mansig;
  TShortInt k;

  i=0;
  som=0.0;
  asc=(int)(monyytext[0]);
  mansig=1;
  if (asc==43 || asc==45)
    {
      /* signe en tete de constante */
      if (asc==45)
	mansig=-1;
      i++;
      asc=(int)(monyytext[i]);
    }
  while (asc>=48 && asc<=57 && i<monyylenght)
    {
      /* partie entiere de la mantisse */
      som=(double)(som*10.0);
      som=som+(double)(asc-48);
      i++;
      if (i<monyylenght)
	asc=(int)(monyytext[i]);
    }
  if (i==monyylenght)
    return(som * (double)mansig);
  if (asc==46)
    {
      /* partie decimale de la mantisse */
      i++;
      if (i==monyylenght)
	return(som * (double)mansig);
      j=1;
      asc=(int)(monyytext[i]);
      while (asc>=48 && asc<=57 && i<monyylenght)
	{
	  j=j/10.0;
	  som=som + ((double)(asc-48) * j);
	  i++;
	  if (i<monyylenght)
	    asc=(int)(monyytext[i]);
	}
      if (i==monyylenght)
	return(som * (double)mansig);
    }
  if (asc==101) /* "e" */
    {
      /* exposant */
      i++;
      asc=(int)(monyytext[i]);
      sig=1;
      if (asc==45) /* "-" */
	sig=-1;
      i++;
      exp=0;
      asc=(int)(monyytext[i]);
      while (i<monyylenght)
	{
	  exp=exp*10;
	  exp=exp+asc-48;
	  i++;
	  if (i<monyylenght)
	    asc=(int)(monyytext[i]);
	}
      /* elevation a la bonne puissance */
      if (sig==1) /* positive */
	for (k=exp; k>0; k--)
	  som=som * (double)10;
      else        /* ou negative */
	for (k=1; k<=exp; k++)
	  som=som / (double) 10;
      return(som * (double)mansig);
    }
return (TDouble)0;
}
