/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : decorArb.c                |
| Date                 : 15 jan. 1992              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : associe a chaque noeud de l'arbre la liste des
identificateurs qui interviennent dans l'arbre
| Reference conception : DCP module 19             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
extern void *malloc(size_t size);
extern void *realloc(void *ptr, size_t size);
extern TShortInt erreAnal(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : decorArb                 |
| Role                  : decore un arbre codant une expression
| Parametres d'entree   : liste typeIdent          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    : arbre                    |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : deriv                     |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TLogic decorArb(arbre, liste, typeIdent)
     TArbDe * arbre;
     TVectShort liste;
     TShortInt * typeIdent;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TLogic test;
  
  if (arbre==NULL)
    {
      return(VRAI);
    }
  
  /* on reconnait un identificateur */
  if (arbre->fonction<0)
    {
      /* si cet identificateur est resp ou aux on garde la liste dans
	 sa totalite, on ne sait jamais */
      if (typeIdent[-arbre->fonction]==IDEF ||
	  typeIdent[-arbre->fonction]==IDEAUX ||
	  typeIdent[-arbre->fonction]==IDELESF)
	{
	  arbre->Liste.nbele=liste.nbele;
	  arbre->Liste.donnees=liste.donnees;
	  return(VRAI);
	}

      /* si cet identificateur est dans la liste on l'ajoute a la liste
	 du noeud courant */
      i=0;
      test=FAUX;
      while (i<liste.nbele && test==FAUX)
	{
	  if (liste.donnees[i]==-arbre->fonction)
	    {
	      test=VRAI;
	      arbre->Liste.donnees=(TShortInt *)malloc(sizeof(TShortInt));
	      if (arbre->Liste.donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      arbre->Liste.donnees[0]= -arbre->fonction;
	      arbre->Liste.nbele=1;
	    }
	  i++;
	}
      return(VRAI);
    }

  /* on reconnait une F[T], on traite comme aux ou resp, on ne sait jamais */
  if (arbre->fonction==VALINT)
    {
      arbre->Liste.nbele=liste.nbele;
      arbre->Liste.donnees=liste.donnees;
      return(VRAI);
    }

  /* on traite le fils droit s'il existe */
  if (arbre->filsD!=NULL)
    {
      if (decorArb(arbre->filsD, liste, typeIdent)==FAUX)
	{
	  return(FAUX);
	}
      arbre->Liste.nbele=arbre->filsD->Liste.nbele;
      arbre->Liste.donnees=(TShortInt *)
	malloc(arbre->Liste.nbele*sizeof(TShortInt));
      if (arbre->Liste.donnees==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
      for (i=0; i<arbre->Liste.nbele; i++)
	{
	  arbre->Liste.donnees[i]=arbre->filsD->Liste.donnees[i];
	}
    }
  else
    {
      /* on cree une liste vide pour arbre->Liste.donnees */
      arbre->Liste.donnees=(TShortInt *)malloc(sizeof(TShortInt));
      if (arbre->Liste.donnees==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
    }

  /* on traite le fils gauche ensuite s'il existe */
  if (arbre->filsG!=NULL)
    {
      if (decorArb(arbre->filsG, liste, typeIdent)==FAUX)
	{
	  return(FAUX);
	}
      /* AB: rajout du test suivant pour que ca marche sous linux */
if (arbre->Liste.nbele+arbre->filsG->Liste.nbele != 0) {

      arbre->Liste.donnees=(TShortInt *)realloc
	(arbre->Liste.donnees, (arbre->Liste.nbele+arbre->filsG->Liste.nbele)
		* sizeof(TShortInt));
      if (arbre->Liste.donnees==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
      for (i=0; i<arbre->filsG->Liste.nbele; i++)
	{
	  arbre->Liste.donnees[i+arbre->Liste.nbele]=
	    arbre->filsG->Liste.donnees[i];
	}
      arbre->Liste.nbele=arbre->Liste.nbele+arbre->filsG->Liste.nbele;
} /* fin  if (arbre->Liste.nbele+arbre->filsG->Liste.nbele != 0) */
   }
        
  return(VRAI);
}
