/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : dfcodes.h                 |
| Date                 : 18 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Defini des constantes utilisees dans les modules
| Reference conception : DCP                       |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/* Valeurs diverses */

#define INDEFINI -1

/* Valeur des fonctions des noeuds des arbres */

/* noeud terminaux */
#define IDENTIFICATEUR 1
#define CONSTANTE 2
/* arbres unaires */
#define NOT 11
#define TG 13
#define LN 14
#define LOG 15
#define EXP 16
#define SIN 17
#define COS 18
/* abrbres binaires */
#define PLUS 21
#define MOINS 22
#define MULT 23
#define DIV 24
#define PUISSANCE 25
#define VALINT 26
#define IF 27
#define AND 28
#define OR 29
#define EQ 30
#define NEQ 31
#define LE 32
#define LEQ 33
#define GE 34
#define GEQ 35
#define THENELSE 36

/* Libelles des operateurs */
#define LNOT "not"
#define LTG "tg"
#define LLN "ln"
#define LLOG "log"
#define LEXP "exp"
#define LSIN "sin"
#define LCOS "cos"
#define LPLUS "+"
#define LMOINS "-"
#define LMULT "*"
#define LDIV "/"
#define LIF "if"
#define LTHENELSE "then ... else"
#define LPUISSANCE "**"
#define LAND "and"
#define LOR "or"
#define LIBEQ "=="
#define LNEQ "!="
#define LLE "<"
#define LLEQ "<="
#define LGE ">"
#define LGEQ ">="
#define LIBVALINT "...[...]"

/* Classes possibles des identificateurs */
#define CLDTE 1
#define CLLESF 2
#define CLVALINT 3
#define CLGCH 4

/* Classes retournees si l'identificateur est de CLGCH */
#define CLF 0
#define CLV 1
#define CLDF 2
#define CLAUX 3
#define CLCONS 4

/* Selection de l'arbre a evaluer */
#define TRF 0
#define TRV 1
#define TRPHI 2
#define TRSEDO 3
#define TRJAC 4

/* Types des identificateurs */
#define IDEF 1
#define IDEV 2
#define IDEX 3
#define IDETHETA 4
#define IDEBETA 5
#define IDEGAMF 6
#define IDEGAMV 7
#define IDELESDF 8
#define IDELESF 9
#define IDEVARINT 10
#define IDEVALINT 11
#define IDECONDINIT 12
#define IDEAUX 13
#define IDECONST 14
#define IDEFICH 15
#define IDESUBR 16

/* Nom des debuts de regle de declaration */
#define LRESP "resp"
#define LVAR "var"
#define LVARIND "varind"
#define LPARRESP "parresp"
#define LPARVAR "parvar"
#define LPBISRESP "pbisrep"
#define LPBISVAR "pbisvar"
#define LLESDF "dF"
#define LLESF "F"
#define LVARINT "varint"
#define LVALINT "valint"
#define LCONDINT "condinit"
#define LAUX "aux"
#define LCONST "const"
#define LNOMFICH "filename"
#define LSUBROUTINE "subroutine"

/* lieux d'erreur dans le modele genere */
#define LA "A"
#define LDADT "DADT"
#define LDADB "DADB"
#define LF "F"
#define LDFDT "DFDT"
#define LERRV "V"
#define LDVDT "DVDT"
#define LDVDB "DVDB"

/* messages d'erreur de yacc */
#define SYNTERR "syntax error\0"
#define OUTMEM  "out of memory\0"
#define STACKOWF "yacc stack overflow\0"
#define CANTBACK "syntax error - cannot backup\0"

/* messages d'erreur */
#define EYSYNT "syntax error\0"
#define EYSTACK "stack error (yacc)\0"
#define EYMEM "memory error (yacc)\0"
#define EYBACK "syntax error, backup not possible (yacc)\0"
#define EYAUTRE "non defined error (yacc)\0"

#define ELCAR "wrong character\0"

#define EREDECL "variable name already used\0"
#define EUNDECL "variable name non declared\0"
#define EMEM "memory allocation problem\0"
#define EELEM "element of the model already declared\0"
#define ECODECL1 "declaration of Resp but not of Parresp\0"
#define ECODECL2 "no declaration of Resp nor Var\0"
#define ECODECL3 "no declaration of Varind\0"
#define ECODECL4 "declaration of Parresp but not of Resp nor Var\0"
#define ECODECL5 "declaration of Var but not of Parresp nor Parvar\0"
#define ECODECL6 "declaration of Parvar but not of Var\0"
#define ECODECL7 "declaration of Parresp but not of Resp\0"
#define ECODECL8 "declaration of differential equation(s) but not of Resp\0"
#define ECODECL9 "declaration of differential equation(s) but not of Varint\0"
#define ECODECL10 "declaration of differential equation(s) but not of Valint\0"
#define ECODECL11 "declaration of differential equation(s) but not of F\0"
#define ECODECL12 "declaration of differential equation(s) but not of dF\0"
#define ECODECL13 "declarations of F and dF are not of same length\0"
#define ECODECL14 "declarations of F and Condinit are not of same length\0"
#define ECODECL15 "declaration length of Condinit greater than the one of Parresp\0"
#define ECODECL16 "initial condition not among the first elements of Parresp\0"
#define ETYPE "variable utilization not corresponding to its declaration\0"
#define EUNEXPR "expression wrong at the right of the = operator\0"
#define EREEXPR "model element already specified\0"
#define EUNCST "expression non constant at the right of the = operator\0"
#define EEXPR "wrong expression at the right of the = operator\0"
#define EUNBIN "non-binary operator\0"
#define EUNUN "non-unary operator\0"
#define ECOEXPR1 "model element non coded by an expression\0"
#define ECOEXPR2 "auxiliary variable declared but never used\0"
#define ECOEXPR3 "constant declared but never used\0"
#define ECOEXPR4 "variable declared but never used\0"
#define ECOEXPR5 "parameter declared but never used\0"
#define ECOEXPR6 "differential equation declared but never used\0"
#define ECOEXPR7 "integration value declared but never used\0"
#define ECOEXPR8 "parameters used neither in the 'sedo' nor in the initial conditions\0"
#define ECOEXPR9 "the parameter does not appear in the 'sedo' and is in a wrong place\0"
#define ENOMFICH "the file name is not defined\0"
#define EFICH "the formal description file does not exist\0"
#define EFATAL "Error(s) in the formal description file: end of execution\n"
#define EMEM2 "Memory allocation problem\n"
#define EBOUCL "loop in the auxialiary expressions\0"
#define EIDENT "expression with a non-permitted variable\0"
#define EINCLVI "integration value of wrong type\0"
#define EINCLCI "initial condition not corresponding to a Parresp\0"
#define EFOUT "write error on the output file\0"
#define EFIN "read error on the input file\0"
#define EARBRE "internal error, expression badly conformed\0"
#define WSUBR "Warning: no 'subroutine;' declaration in the formal description file\n"
