/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : erreAnal.c                |
| Date                 : 3 dec. 1991               |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : gere les messages d'erreur des analyseur
| Reference conception : DCP module 15             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include <string.h>
#include "nltypes.h"
#include "dftypes.h"
#include "dfcodes.h"
#include "nlcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern int monyylineno;
extern TModSpecif GModSpecif;

/*--------------- FONCTIONS EXTERNES -------------*/
extern char *strcat(char *dest, const char *src);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : erreAnal                 |
| Role                  : gere les messages d'erreur des analyseurs
| Parametres d'entree   : message param            |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 15            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : tous modules des analyseurs
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt erreAnal(TChaine message, TChaine param)
     /*     TChaine message, param; */

/*--------------- Fin identification fonction ----*/
{
  char ligne[256];

  strcpy(ligne, "line %3d: ");
  strcat(ligne, message);
  
  if (param!=NULL)
    {
      fprintf(stderr, (char *)strcat(ligne, ": %s\n\0"), monyylineno, param);
    }
  else
    {
      fprintf(stderr, (char *)strcat(ligne, "\n\0"), monyylineno);
    }
  GModSpecif.yaerr=OUI;
  GModSpecif.erraff=OUI;
return (TShortInt )2;
}
/*--------------- Identification fonction ----------
| Nom de la fonction    : warnAnal                 |
| Role                  : gere les messages d'erreur des analyseurs
| Parametres d'entree   : message param            |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 15            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : tous modules des analyseurs
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt warnAnal(message, param)
     TChaine message, param;

/*--------------- Fin identification fonction ----*/
{
  char ligne[256];

  strcpy(ligne, "attention line %3d: ");
  strcat(ligne, message);
  
  if (param!=NULL)
    {
      fprintf(stderr, (char *)strcat(ligne, ": %s\n\0"), monyylineno, param);
    }
  else
    {
      fprintf(stderr, (char *)strcat(ligne, "\n\0"), monyylineno);
    }
return (TShortInt )2;
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : erreAutr                 |
| Role                  : gere les messages d'erreur des autres modules
| Parametres d'entree   : message param            |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 15            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : tous modules des analyseurs
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt erreAutr(message, param)
     TChaine message, param;

/*--------------- Fin identification fonction ----*/
{
  char ligne[256];

  strcpy(ligne, "line %3d: ");
  strcat(ligne, message);
  
  if (GModSpecif.erraff==NON)
    {
      if (param!=NULL)
	{
	  fprintf(stderr, (char *)strcat(ligne, ": %s\n\0"), monyylineno, param);
	}
      else
	{
	  fprintf(stderr, (char *)strcat(ligne, "\n\0"), monyylineno);
	}
      GModSpecif.yaerr=OUI;
      GModSpecif.erraff=OUI;
    }
return (TShortInt )2;
}
