/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : prepDer.c                 |
| Date                 : 13 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : prepare et lance les appels au derivateur
| Reference conception : DCP module 16             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
extern void *malloc(size_t size);
extern TShortInt deriv(TModStandard ModStandard, TDeriv * Deriv, TDerivAux * DerivAux, TShortInt borne);
extern TShortInt erreAnal(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : copieArb                 |
| Role                  : cree un arbre decore a partir d'un arbre simple
| Parametres d'entree   : arbre                    |
| Parametres de sortie  : error                    |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 16            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : prepDer                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TArbDe * copieArb(arbre, error)
     TArbre * arbre;
     TLogic * error;

/*--------------- Fin identification fonction ----*/

{
  TArbDe * Noeud;

  if (arbre==NULL || *error==OUI)
    {
      return(NULL);
    }
  Noeud=(TArbDe *)malloc(sizeof(TArbDe));
  if (Noeud==NULL)
    {
      fprintf(stderr, EMEM2);
      *error=OUI;
      return(NULL);
    }
  Noeud->fonction=arbre->fonction;
  Noeud->valeur=arbre->valeur;
  Noeud->Liste.nbele=0;
  Noeud->Liste.donnees=NULL;
  Noeud->filsG=copieArb(arbre->filsG, error);
  Noeud->filsD=copieArb(arbre->filsD, error);
  return(Noeud);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : prepDer                  |
| Role                  : prepare et lance les appels au derivateur
| Parametres d'entree   : GModSpecif               |
| Parametres de sortie  : Derivees                 |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 16            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : deriv copieArb            |
| Fonctions appelantes : analDer                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt prepDer(GModSpecif, Derivees)
     TModSpecif GModSpecif;
     TDerivees * Derivees;

/*--------------- Fin identification fonction ----*/

{
  TModStandard ModStandard;
  TDeriv Deriv;
  TDerivAux DerivAux;
  TShortInt i, j;
  TLogic error;


  /* definition des types des indentificateurs utilises */
  ModStandard.TypeIdent.nbele=GModSpecif.PPident.nbele;
  ModStandard.TypeIdent.donnees=(TShortInt *)
    malloc(ModStandard.TypeIdent.nbele*sizeof(TShortInt));
  if (ModStandard.TypeIdent.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<ModStandard.TypeIdent.nbele; i++)
    {
      ModStandard.TypeIdent.donnees[i]=GModSpecif.PPident.ident[i].type;
    }

  /* recopie des expressions auxiliaires */
  ModStandard.Auxiliaire.nbele=0;
  if (GModSpecif.Auxiliaire.nbele>0)
    {
      ModStandard.Auxiliaire.nbele=GModSpecif.Auxiliaire.nbele;
      ModStandard.Auxiliaire.UnAux=(TUnAuxDe *)
	malloc(ModStandard.Auxiliaire.nbele*sizeof(TUnAuxDe));
      /* copie des arbres des aux */
      error=NON; /* cette affectation est valable pour tout le temps */
      for (i=0; i<ModStandard.Auxiliaire.nbele; i++)
	{
	  ModStandard.Auxiliaire.UnAux[i].arbre=
	    copieArb(GModSpecif.Auxiliaire.UnAux[i].arbre, &error);
	  if (ModStandard.Auxiliaire.UnAux[i].arbre==NULL || error==OUI)
	    {
	      return(FAUX);
	    }
	  ModStandard.Auxiliaire.UnAux[i].ident=
	    GModSpecif.Auxiliaire.UnAux[i].ident;
	}
    }
  
  /* recopie des constantes */
  ModStandard.Constantes.nbele=GModSpecif.Constantes.nbele;
  ModStandard.Constantes.UneCst=GModSpecif.Constantes.UneCst;
  
  /* il n'y a pas encore de derivee pour les aux */
  DerivAux.nbele=0;

  /* Cas simple ou on n'a defini que la reponse du modele */
  if (GModSpecif.Resp==OUI && GModSpecif.CasSedo==NON)
    {
      ModStandard.Expressions.nbele=1;
      ModStandard.Expressions.arbre=(TArbDe **)malloc(sizeof(TArbDe *));
      if (ModStandard.Expressions.arbre==NULL)
	{
	  fprintf(stderr, EMEM2);
	  return(FAUX);
	}
      /* copie de l'arbre de f */

      ModStandard.Expressions.arbre[0]=
	copieArb(GModSpecif.IdeF.arbre, &error);
      if (ModStandard.Expressions.arbre==NULL || error==OUI)
	{
	  return(FAUX);
	}
      
      /* on derive par rapport a theta */
      ModStandard.IdentDeriv.nbele=GModSpecif.IdeTheta.nbele;
      ModStandard.IdentDeriv.donnees=GModSpecif.IdeTheta.donnees;

      /* les variables fixes sont X et GammaF */
      ModStandard.IdentFixe.nbele=GModSpecif.IdeX.nbele +
	GModSpecif.IdeGamF.nbele;
      ModStandard.IdentFixe.donnees=(TShortInt *)
	malloc(ModStandard.IdentFixe.nbele*sizeof(TShortInt));
      if (ModStandard.IdentFixe.donnees==NULL)
	{
	  fprintf(stderr, EMEM2);
	  return(FAUX);
	}
      j=0;
      for (i=0; i<GModSpecif.IdeX.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeX.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeGamF.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeGamF.donnees[i];
	  j++;
	}


      /* appel du derivateur */
      if (deriv(ModStandard, &Deriv, &DerivAux, -1)
	  ==FAUX)
	{
	  return(FAUX);
	}

      /* sauvegarde des resultats */
      Derivees->DerivF.nbele=Deriv.nbele;
      Derivees->DerivF.arbre=Deriv.arbre;
    }

  /* Cas ou le modele est defini par un SEDO, on derive d'abord f */
  if (GModSpecif.CasSedo==OUI)
    {
      ModStandard.Expressions.nbele=1;
      ModStandard.Expressions.arbre=(TArbDe **)malloc(sizeof(TArbDe *));
      if (ModStandard.Expressions.arbre==NULL)
	{
	  fprintf(stderr, EMEM2);
	  return(FAUX);
	}
      /* copie de l'arbre de f */
      ModStandard.Expressions.arbre[0]=
	copieArb(GModSpecif.IdeF.arbre, &error);
      if (ModStandard.Expressions.arbre==NULL || error==OUI)
	{
	  return(FAUX);
	}
      
      /* on derive par rapport a theta */
      ModStandard.IdentDeriv.nbele=GModSpecif.IdeTheta.nbele;
      ModStandard.IdentDeriv.donnees=GModSpecif.IdeTheta.donnees;
      
      /* les variables fixes sont X, GammaF, LesF et ValInt */
      ModStandard.IdentFixe.nbele=GModSpecif.IdeX.nbele +
	GModSpecif.IdeGamF.nbele + GModSpecif.IdeLesF.nbele +
	  GModSpecif.IdeValInt.nbele;
      ModStandard.IdentFixe.donnees=(TShortInt *)
	malloc(ModStandard.IdentFixe.nbele*sizeof(TShortInt));
      if (ModStandard.IdentFixe.donnees==NULL)
	{
	  fprintf(stderr, EMEM2);
	  return(FAUX);
	}
      j=0;
      for (i=0; i<GModSpecif.IdeX.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeX.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeGamF.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeGamF.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeLesF.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeLesF.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeValInt.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeValInt.donnees[i];
	  j++;
	}

      /* appel du derivateur */
      if (deriv(ModStandard, &Deriv, &DerivAux, GModSpecif.IdeCondInit.nbele+
		GModSpecif.NbThetaSedo)==FAUX)
	{
	  return(FAUX);
	}

      /* sauvegarde des resultats */
      Derivees->DerivF.nbele=Deriv.nbele;
      Derivees->DerivF.arbre=Deriv.arbre;
    }

  /* Cas ou la variance est definie */
  if (GModSpecif.Vari==OUI)
    {
      /* derivee de la variance */
      ModStandard.Expressions.nbele=1;
      ModStandard.Expressions.arbre=(TArbDe **)malloc(sizeof(TArbDe *));
      if (ModStandard.Expressions.arbre==NULL)
	{
	  fprintf(stderr, EMEM2);
	  return(FAUX);
	}
      /* copie de l'arbre de v */
      ModStandard.Expressions.arbre[0]=
	copieArb(GModSpecif.IdeV.arbre, &error);
      if (ModStandard.Expressions.arbre==NULL || error==OUI)
	{
	  return(FAUX);
	}
      
      /* on derive par rapport a theta et beta */
      ModStandard.IdentDeriv.nbele=GModSpecif.IdeTheta.nbele +
	GModSpecif.IdeBeta.nbele;
      ModStandard.IdentDeriv.donnees=(TShortInt *)
	malloc(ModStandard.IdentDeriv.nbele*sizeof(TShortInt));
      if (ModStandard.IdentDeriv.donnees==NULL)
	{
	  fprintf(stderr, EMEM2);
	  return(FAUX);
	}
      j=0;
      for (i=0; i<GModSpecif.IdeTheta.nbele; i++)
	{
	  ModStandard.IdentDeriv.donnees[j]=GModSpecif.IdeTheta.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeBeta.nbele; i++)
	{
	  ModStandard.IdentDeriv.donnees[j]=GModSpecif.IdeBeta.donnees[i];
	  j++;
	}

      /* les variables fixes sont X, GammaF et GammaV */
      ModStandard.IdentFixe.nbele=GModSpecif.IdeX.nbele +
	GModSpecif.IdeGamF.nbele + GModSpecif.IdeGamV.nbele;
      ModStandard.IdentFixe.donnees=(TShortInt *)
	malloc(ModStandard.IdentFixe.nbele*sizeof(TShortInt));
      if (ModStandard.IdentFixe.donnees==NULL)
	{
	  fprintf(stderr, EMEM2);
	  return(FAUX);
	}
      j=0;
      for (i=0; i<GModSpecif.IdeX.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeX.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeGamF.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeGamF.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeGamV.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeGamV.donnees[i];
	  j++;
	}

      /* appel du derivateur */
      if (deriv(ModStandard, &Deriv, &DerivAux, GModSpecif.IdeTheta.nbele)
	  ==FAUX)
	{
	  return(FAUX);
	}

      /* sauvegarde des resultats */
      Derivees->DerivV.nbele=Deriv.nbele;
      Derivees->DerivV.arbre=Deriv.arbre;
    }

  /* Cas ou le modele est defini par equations diferentielles */
  if (GModSpecif.CasSedo==OUI)
    {
      ModStandard.Expressions.nbele=GModSpecif.IdeLesDF.nbele;
      ModStandard.Expressions.arbre=(TArbDe **)
	malloc(ModStandard.Expressions.nbele*sizeof(TArbDe *));
      if (ModStandard.Expressions.arbre==NULL)
	{
	  fprintf(stderr, EMEM2);
	  return(FAUX);
	}
      /* copie des arbres de dF */
      for (i=0; i<GModSpecif.IdeLesDF.nbele; i++)
	{
	  ModStandard.Expressions.arbre[i]=
	    copieArb(GModSpecif.IdeLesDF.UnDF[i].arbre, &error);
	  if (ModStandard.Expressions.arbre[i]==NULL || error==OUI)
	    {
	      return(FAUX);
	    }
	}
      
      /* on derive par rapport aux theta conditions initiales et intervenant
       dans le sedo*/
      ModStandard.IdentDeriv.nbele=GModSpecif.NbThetaSedo+
	GModSpecif.IdeCondInit.nbele;
      ModStandard.IdentDeriv.donnees=(TShortInt *)
	malloc(ModStandard.IdentDeriv.nbele*sizeof(TShortInt));
      if ( ModStandard.IdentDeriv.donnees==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
      for(i=0; i<GModSpecif.IdeCondInit.nbele; i++)
	{
	  ModStandard.IdentDeriv.donnees[i]=GModSpecif.IdeTheta.donnees[i];
	}
      for(i=GModSpecif.IdeCondInit.nbele; i<ModStandard.IdentDeriv.nbele; i++)
	{
	  ModStandard.IdentDeriv.donnees[i]=GModSpecif.IdeTheta.donnees[i];
	}
      
      /* les variables fixes sont X, GammaF, LesF, ValInt et VarInt */
      ModStandard.IdentFixe.nbele=GModSpecif.IdeX.nbele +
	GModSpecif.IdeGamF.nbele + GModSpecif.IdeLesF.nbele +
	  GModSpecif.IdeValInt.nbele + 1;
      ModStandard.IdentFixe.donnees=(TShortInt *)
	malloc(ModStandard.IdentFixe.nbele*sizeof(TShortInt));
      if (ModStandard.IdentFixe.donnees==NULL)
	{
	  fprintf(stderr, EMEM2);
	  return(FAUX);
	}
      j=0;
      for (i=0; i<GModSpecif.IdeX.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeX.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeGamF.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeGamF.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeLesF.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeLesF.donnees[i];
	  j++;
	}
      for (i=0; i<GModSpecif.IdeValInt.nbele; i++)
	{
	  ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeValInt.donnees[i];
	  j++;
	}
      ModStandard.IdentFixe.donnees[j]=GModSpecif.IdeVarInt;

      /* appel du derivateur */
      if (deriv(ModStandard, &Deriv, &DerivAux, -1)==FAUX)
	{
	  return(FAUX);
	}

      /* sauvegarde des resultats */
      Derivees->DerivSedo.nbele=Deriv.nbele;
      Derivees->DerivSedo.arbre=Deriv.arbre;
    }
  
  /* sauvegarde des derivees des expressions auxiliaires */
  Derivees->DerivAux.nbele=DerivAux.nbele;
  Derivees->DerivAux.arbre=DerivAux.arbre;
  
  return(VRAI);
}
