/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : NLDetru                   |
| Date                 : 18 mai 95                 |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : A. Bouvier                |
| Role                 : Detruire les structures   |
| de nl
| PAR RAPPORT A LA VERSION NON INTERFACEE AVEC SPLUS
|   identique mais non inclus dans la library      |
|   car au 1ier niveau d'appel des fonctions S     |
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>

#include "nlchoix.h"
#include "nlcodes.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "errcodes.h"
#include "nlglobal.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
 
/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruMatC                 |
| Role                  :                          |
|    Desallouer le composant donnees dans une      |
|    structure de type TMat                        |
|    quand les elements ont ete alloues de facon   |
|    contigue                                      |
|    et affecter aux composants nblig et nbcol     |
|    la valeur 0                               |
| Parametres d'e./s.    :                          |
|    pmat: adresse de la structure TMat            |   
|    en sortie le composant donnees de la          |
|    structure pointee par pmat est desalloue      |
| Reference conception  :                          |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Modules appelants    :                           |
| Macros utilisees: DETRU_T1 , DETRU_T2            |
--------------------------------------------------*/

/*--------------- Definition fonction -----------*/
void DetruMatC(TMat *pmat)
/*--------------- Fin identification fonction ----*/
{
TShortInt  nbl, nbc;


nbl = MAX(1,pmat->nblig);
nbc = MAX(1,pmat->nbcol);


if (pmat->donnees[0]!=NULL)  DETRU_T1(pmat->donnees[0], nbc*nbl, TDouble);
if (pmat->donnees!=NULL)  DETRU_T2(pmat->donnees, nbl, TDouble);

pmat->nblig=0;
pmat->nbcol=0;

}

/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruMatShort            |
| Role                  :                          |
|    Desallouer le composant donnees dans une      |
|    structure de type TMatShort                   |
|    et affecter aux composants nblig et nbcol     |
|    la valeur 0                               |
| Parametres d'e./s.    :                          |
|    pmat: adresse de la structure TMatShort            |   
|    en sortie le composant donnees de la          |
|    structure pointee par pmat est desalloue      |
| Reference conception  :                          |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Modules appelants    :                           |
| Macros utilisees: DETRU_T1 , DETRU_T2            |
--------------------------------------------------*/

/*--------------- Definition fonction -----------*/
void DetruMatShort(pmat)
TMatShort *pmat;
/*--------------- Fin identification fonction ----*/
{
TShortInt i, nbl, nbc;
nbl = pmat->nblig;
nbc = pmat->nbcol;

if (nbl>0 && nbc>0)
  {
  for(i=0; i<nbl; i++)
    {
    if (pmat->donnees[0] != NULL)
      DETRU_T1(pmat->donnees[i], nbc, TShortInt);
    }
    if (pmat->donnees != NULL)
      DETRU_T2(pmat->donnees, nbl, TShortInt);
  }

pmat->nblig=0;
pmat->nbcol=0;
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruVectLong            |
| Role                  :                          |
|    Desallouer le composant donnees dans une      |
|    structure de type TVectLong                   |
|    et affecter au composant nbele la valeur 0    |
| Parametres d'e./s.    :                          |
|    pvect: adresse de la structure TVectLong      |   
|    en sortie le composant donnees de la          |
|    structure pointee par pvect est desalloue     |
| Reference conception  :                          |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Modules appelants    :                           |
| Macros utilisees: DETRU_T1                       |
--------------------------------------------------*/

/*--------------- Definition fonction -----------*/
void DetruVectLong(pvect)
TVectLong *pvect;
/*--------------- Fin identification fonction ----*/
{
TShortInt nb;
    nb=MAX(1,pvect->nbele);
    if (pvect->donnees != NULL)
      DETRU_T1(pvect->donnees, nb, TLongInt);
    pvect->nbele=0;
}



/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruVectStr           |
| Role                  :                          |
|    Desallouer le composant donnees dans une      |
|    structure de type TVectStr                  |
|    et affecter au composant nbele la valeur 0    |
| Parametres d'e./s.    :                          |
|    pvect: adresse de la structure TVectStr     |   
|    en sortie le composant donnees de la          |
|    structure pointee par pvect est desalloue     |
| Reference conception  :                          |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Modules appelants    :                           |
| Macros utilisees: DETRU_T1                       |
--------------------------------------------------*/

/*--------------- Definition fonction -----------*/
void DetruVectStr(pvect)
TVectStr *pvect;
/*--------------- Fin identification fonction ----*/
{
TShortInt i;
TShortInt nb;
    nb= MAX(1,pvect->nbele);
  for(i=0; i<pvect->nbele; i++)
    {
      if (pvect->donnees[i]!=NULL)
	DETRU_T1(pvect->donnees[i], MAXCH, char);
    }

    if (pvect->donnees != NULL)
      DETRU_T2(pvect->donnees, pvect->nbele, char);

  pvect->nbele=0;


}


/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruMat                 |
| Role                  :                          |
|    Desallouer le composant donnees dans une      |
|    structure de type TMat                        |
|    et affecter aux composants nblig et nbcol     |
|    la valeur 0                               |
| Parametres d'e./s.    :                          |
|    pmat: adresse de la structure TMat            |   
|    en sortie le composant donnees de la          |
|    structure pointee par pmat est desalloue      |
| Reference conception  :                          |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Modules appelants    :                           |
|       NLAutres,                                  |
|       NLEtape,                                   |
|       PussIter                                   |
| Macros utilisees: DETRU_T1 , DETRU_T2            |
--------------------------------------------------*/

/*--------------- Definition fonction -----------*/
void DetruMat(pmat)
TMat *pmat;
/*--------------- Fin identification fonction ----*/
{
TShortInt i, nbl, nbc;


nbl = pmat->nblig;
nbc = pmat->nbcol;

if (nbl>0 && nbc>0)
  {
  for(i=0; i<nbl; i++)
    {
     DETRU_T1(pmat->donnees[i], nbc, TDouble);
    }
  DETRU_T2(pmat->donnees, nbl, TDouble);
  }

pmat->nblig=0;
pmat->nbcol=0;
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruVect                |
| Role                  :                          |
|    Desallouer le composant donnees dans une      |
|    structure de type TVect                       |
|    et affecter au composant nbele la valeur 0    |
| Parametres d'e./s.    :                          |
|    pvect: adresse de la structure TVect          |   
|    en sortie le composant donnees de la          |
|    structure pointee par pvect est desalloue     |
| Reference conception  :                          |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Modules appelants    :                           |
|       NLAutres,                                  |
|       NLEtape,                                   |
|       PussIter                                   |
| Macros utilisees: DETRU_T1                       |
--------------------------------------------------*/

/*--------------- Definition fonction -----------*/
void DetruVect(TVect *pvect)
/*--------------- Fin identification fonction ----*/
{
if(pvect->nbele>0)
  {
  DETRU_T1(pvect->donnees, pvect->nbele, TDouble);
  }
pvect->nbele=0;
}



/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruVectShort           |
| Role                  :                          |
|    Desallouer le composant donnees dans une      |
|    structure de type TVectShort                  |
|    et affecter au composant nbele la valeur 0    |
| Parametres d'e./s.    :                          |
|    pvect: adresse de la structure TVectShort     |   
|    en sortie le composant donnees de la          |
|    structure pointee par pvect est desalloue     |
| Reference conception  :                          |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Modules appelants    :                           |
|       NLAutres,                                  |
| Macros utilisees: DETRU_T1                       |
--------------------------------------------------*/

/*--------------- Definition fonction -----------*/
void DetruVectShort(pvect)
TVectShort *pvect;
/*--------------- Fin identification fonction ----*/
{
if(pvect->nbele>0)
  {
  DETRU_T1(pvect->donnees, pvect->nbele, TShortInt);
  }
pvect->nbele=0;
}


  

/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruDon                  |
| Role                  : 
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
| Globales en e./s.     :                          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : NLDetru
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void DetruDon(TDonnees *Donnees)
/* ............... Arguments d'entree ............................ */
/*--------------- Fin identification fonction ----*/
{

DetruVect(&(Donnees->Poids));
DetruVectLong(&(Donnees->NbObsC));
DetruVectLong(&(Donnees->NbRepet));
DetruMatC(&(Donnees->XObs));
DetruVectStr(&(Donnees->NomC)); 
DetruVectStr(&(Donnees->NomObs));
DetruVectStr(&(Donnees->NomX));
	free ((char *) Donnees->NomY);

DetruVect(&(Donnees->StatDon.Y1));
DetruVect(&(Donnees->StatDon.Y2));
DetruVect(&(Donnees->StatDon.S2));
DetruVect(&(Donnees->PoidsT));

DetruVectStr(&(Donnees->NomCT));  

DetruVectStr(&(Donnees->NomObsT));

return;
}
  


/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruMod                  |
| Role                  : 
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
| Globales en e./s.     :                          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : NLDetru
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void  DetruMod(TModele *Modele)
/* ............... Arguments d'entree ............................ */
/*--------------- Fin identification fonction ----*/
{
DetruVectStr(&(Modele->NomTheta)); 
  DetruVectStr(&(Modele->NomBeta));
  DetruVectStr(&(Modele->NomGamF)); 
  DetruVectStr(&(Modele->NomGamV));
free ((char *) Modele->NomFichier);

DetruVectShort(&(Modele->CTheta0.EgalP));
DetruVect(&(Modele->CTheta0.EgalN));
DetruVect(&(Modele->CTheta0.BInf));
DetruVect(&(Modele->CTheta0.BSup));
DetruVectShort(&(Modele->CBeta0.EgalP));
DetruVect(&(Modele->CBeta0.EgalN));
DetruVect(&(Modele->CBeta0.BInf));
DetruVect(&(Modele->CBeta0.BSup));
return;
}



/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruCtxPuss                  |
| Role                  : 
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
| Globales en e./s.     :                          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : NLDetru
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void DetruCtxPuss(CtxPuss)
/* ............... Arguments d'entree ............................ */
TCtxPuss *CtxPuss;
/*--------------- Fin identification fonction ----*/
{

DetruVect(&(CtxPuss->Theta0));
DetruVect(&(CtxPuss->Beta0));
DetruVect(&(CtxPuss->Mu3));
DetruVect(&(CtxPuss->Mu4));
return;
}



/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruPara                  |
| Role                  : 
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
| Globales en e./s.     :                          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : NLDetru
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void DetruPara(Param)
/* ............... Arguments d'entree ............................ */
TParam *Param;
/*--------------- Fin identification fonction ----*/
{
/* ne pas detruire les noms car ce sont des pointeurs sur ceux dans le modele
 qui sont detruits par ailleurs */
/* ne pas detruire Init: ce sont des pointeurs sur
  les parametres du modele */
  DetruVect(&(Param->Eff));
  DetruVect(&(Param->Act));
  DetruVect(&(Param->Estim));
  DetruMatShort(&(Param->Pass));
return;
}



/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruSedo                  |
| Role                  : Detruire les sorties de NL
| concernant le SEDO
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes : DetruNL                          |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

  
void DetruSedo (TLongInt NbObs, TSedo *Sedo)

/* ............... Arguments d'entree-sortie....................... */
/*--------------- Fin identification fonction ----*/

{
/* locals */
TShortInt  i, j;

  for (i = 0; i < NbObs; i++)
    {
    for (j =0; j < GNLCtxInteg.NbJ; j++)
      {
      free ((char *) Sedo->FSedo[i][j]);
      free ((char *) Sedo->DFSedo[i][j]);
      }
    free ((char *) Sedo->FSedo[i]);
    free ((char *) Sedo->DFSedo[i]);
    }
return; 
}



/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruStat                  |
| Role                  : 
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
| Globales en e./s.     :                          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : NLDetru
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void DetruStat(CasSedo, NbBeta, NbObs,  ResStat )
/* ............... Arguments d'entree ............................ */
TLogic CasSedo;
TShortInt NbBeta;
TLongInt NbObs;


TResStat *ResStat;

/*--------------- Fin identification fonction ----*/
{
  /* les ajustes */
  DetruVect(&( ResStat->Ajustes.Valf));
  DetruVect(&( ResStat->Ajustes.VarY));

  /* les fctsensib */
  DetruMatC(&( ResStat->FctSensib.DValf));
  DetruMatC(&( ResStat->FctSensib.DVarYTheta));
    DetruMatC(&(ResStat->FctSensib.DVarYBeta));

  /* les equations normales */
  DetruMat(&( ResStat->EquN.ValB));
  DetruVect(&( ResStat->EquN.ValEta));
  DetruMat(&( ResStat->EquN.ValD));
 
  /* le sedo */
  if (CasSedo==VRAI)
    DetruSedo(NbObs, &(ResStat->Sedo));

  /* le reste de ResStat */
  DetruMat(&( ResStat->AsVar));
  DetruMat(&( ResStat->BVarZBP));
  DetruMat(&( ResStat->Corr));
  DetruVect(&( ResStat->Mu3));
  DetruVect(&( ResStat->Mu4));
  DetruVect(&( ResStat->Residus));
  DetruVect(&( ResStat->ResidusR));
  DetruMat(&( ResStat->ValW));
  DetruVect(&( ResStat->ValZ));
return;

}



/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruCtxI                  |
| Role                  : 
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
| Globales en e./s.     :                          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : NLDetru
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void DetruCtxI( TShortInt NbCourbe)
/* ............... Arguments d'entree ............................ */

{
TShortInt i;

  DetruVect( &(GNLCtxInteg.atol));
  DetruVectShort(&(GNLCtxInteg.IndicTj));

  if (GNLCtxInteg.liw >0)
    DetruVectLong(&(GNLCtxInteg.iwork));
  DetruVect( &(GNLCtxInteg.rtol));
  if (GNLCtxInteg.lrw >0)
    DetruVect(&(GNLCtxInteg.rwork));
  DetruVect( &(GNLCtxInteg.T0T));

  if ( GNLCtxInteg.IndicX == FAUX &&  GNLCtxInteg.Tj[0].nblig >1)
    {
    for (i=0; i< NbCourbe; i++)
      {
      DetruVect( &(GNLCtxInteg.TjBis[i]));
      DetruVectShort( &(GNLCtxInteg.TjBisNb[i]));
      free ((char *)  (GNLCtxInteg.TjDes[i]));
      }
    free ((char *) GNLCtxInteg.TjBis);
    free ((char *) GNLCtxInteg.TjBisNb);
    free ((char *) GNLCtxInteg.TjDes);
    }


/* attention: ne desallouer Tj qu'apres ce qui est au-dessus */
  for (i=0; i<NbCourbe; i++)
    {
     DetruVect( &(GNLCtxInteg.T0[i]));
     DetruMat(&(GNLCtxInteg.Tj[i]));
    }
  free ((char *) GNLCtxInteg.T0);

  free ((char *) GNLCtxInteg.Tj);

  DetruVect( &(GNLCtxInteg.T0Bis));
  if (GNLCtxInteg.IndicCi==0)
    {
    for (i=0; i<NbCourbe; i++)
      DetruVect( &(GNLCtxInteg.VectCi[i]));
    }
  free ((char *) GNLCtxInteg.VectCi);

return;

}



/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruTrace           |
| Role                  :                          |
|    Desallouer la trace
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Modules appelants    :                           |
--------------------------------------------------*/

/*--------------- Definition fonction -----------*/
void DetruTrace()
/*--------------- Fin identification fonction ----*/
{
TShortInt i;
if (GNLControle.LgTrace>0)
  {
  /*  desallocation de la memoire pour chaque element de la liste */
  for (i=0; i< GNLControle.LgTrace ; i++)
    {
    DETRU_T1(GNLTrace[i], 1, TTrace);
    }

  DETRU_T2(GNLTrace , GNLControle.LgTrace, TTrace);
  }
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruItSedo                  |
| Role                  : Detruire les sorties de NL
| concernant le SEDO des iterations
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes : DetruIter                          |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

  
void DetruItSedo (NbItSv, NbObs,
                       ItStat)

TShortInt NbItSv;
TLongInt NbObs;
TResStat *ItStat;
/*--------------- Fin identification fonction ----*/

{
/* locals */
TShortInt  i, j, iter;

for (iter=0; iter < NbItSv; iter++)
  {
  for (i = 0; i < NbObs; i++)
    {
    for (j =0; j < GNLCtxInteg.NbJ; j++)
      {
      free ((char *) &(ItStat[iter].Sedo.FSedo[i][j]));
      }
    free ((char *) &(ItStat[iter].Sedo.FSedo[i]));
    }

  }


return; 
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruIt                  |
| Role                  : Detruire les sorties de NL
| concernant les resultats par iteration
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  
| Fonctions appelantes : NLDetru                          |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

  
void DetruIt(NbItSv, ItStat, ItTheta, ItBeta, ItDirec)

/* les resultats des iterations */
  TShortInt NbItSv;
  TResStat *ItStat;
  TVect *ItTheta, *ItBeta, *ItDirec;
     
/*--------------- Fin identification fonction ----*/

{
TShortInt iter;

for (iter=0; iter< NbItSv; iter++)
  {
  if (GNLControle.VouluIt.ResNum)
    {
    DetruVect(&(ItDirec[iter]));
    }
  if(GNLControle.VouluIt.Estim)
    {
    DetruVect(&(ItTheta[iter]));
    DetruVect(&(ItBeta[iter]));
    }
  if(GNLControle.VouluIt.Ajustes)
    {
    DetruVect(&(ItStat[iter].Ajustes.Valf));
    DetruVect(&(ItStat[iter].Ajustes.VarY));
    }
  
  if(GNLControle.VouluIt.EquN)
    {
    DetruMat(&(ItStat[iter].EquN.ValB));
    DetruMat(&(ItStat[iter].EquN.ValD));
    DetruVect(&(ItStat[iter].EquN.ValEta));
    }
  if(GNLControle.VouluIt.FctSensib)
    {
    DetruMatC( &(ItStat[iter].FctSensib.DValf));
    DetruMatC( &(ItStat[iter].FctSensib.DVarYTheta));
    DetruMatC(&(ItStat[iter].FctSensib.DVarYBeta));
    }
  } /* fin boucle sur iter */

return;
}



/*--------------- Identification fonction ----------
| Nom de la fonction    : DetruIter                  |
| Role                  : 
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
| Globales en e./s.     :                          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : NLDetru
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/
void DetruIter(EtapeIt, CasSedo,NbItSv,NbObs,
    ItStat, ItTheta, ItBeta, ItDirec)
/* ............... Arguments d'entree ............................ */
/* les resultats des iterations */
TLogic EtapeIt, CasSedo;
TShortInt NbItSv;
TLongInt NbObs;
TResStat *ItStat;
TVect *ItTheta, *ItBeta, *ItDirec;

{

  if ((EtapeIt==VRAI) && (NbItSv>0))
    {
    DetruIt(NbItSv, 
              ItStat,
              ItTheta, ItBeta,
              ItDirec); 
    if ((CasSedo== VRAI) && (GNLControle.VouluIt.Sedo==VRAI))
      DetruItSedo(NbItSv, NbObs, ItStat);
    }

return;
}






/*--------------- Identification fonction ----------
| Nom de la fonction    : NLDetru                  |
| Role                  : 
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
| Globales en e./s.     :                          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : l'utilisateur             |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/
/* A VOIR: la destruction de l'arbre cr par analder */

void NLDetru(TDonnees *Donnees, TModele *Modele, TCtxPuss *CtxPuss, TCtxNum CtxNum[],
             TParam Theta[], TParam Beta[], TResStat ResStat[],
             TShortInt NbItSv[MAXETAP], 
	     TResStat ItStat[MAXETAP][MAXSVIT], 
	     TVect ItTheta[MAXETAP][MAXSVIT], TVect ItBeta[MAXETAP][MAXSVIT],
	     TVect ItDirec[MAXETAP][MAXSVIT])


/* ............... Arguments d'entree ............................ 
TDonnees *Donnees;
TModele *Modele;
TCtxPuss *CtxPuss;
TCtxNum CtxNum[];
TParam Theta[], Beta[];
TResStat ResStat[];

 les resultats des iterations 
TShortInt NbItSv[MAXETAP];
TResStat ItStat[MAXETAP][MAXSVIT];
TVect ItTheta[MAXETAP][MAXSVIT], ItBeta[MAXETAP][MAXSVIT], ItDirec[MAXETAP][MAXSVIT];
*/

/*--------------- Fin identification fonction ----*/
{
TShortInt i, NbBeta;

NbBeta=Modele->NomBeta.nbele;
 
if (Modele->CasSedo==VRAI)
  DetruCtxI(Donnees->NbCourbe);

DetruDon(Donnees);

DetruMod(Modele);
DetruCtxPuss(CtxPuss);

for (i=0; i<CtxPuss->NbEtapes; i++)
  {
  DetruPara(Theta[i]);
       DetruPara(Beta[i]);
  DetruStat(Modele->CasSedo, NbBeta, Donnees->NbObs, &(ResStat[i]));
  DetruIter(GNLControle.EtapeIt[i], Modele->CasSedo, NbItSv[i],
            Donnees->NbObs,
             &(ItStat[i]), &(ItTheta[i]),  &(ItBeta[i]), &(ItDirec[i]));
  }

/* ne pas detruire les contraintes: ce sont des vecteurs
sur Init des parametres ou sur les contraintes du modele ou
ce sont des vecteurs a zero elements */

   DetruTrace();
return;
}
