/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : NLVCrole                  |
| Date                 :  27 dec 91                |
| Derniere mise a jour :                           |
| Concepteur           : A. Bouvier                |
| Role                 : Verifier et initialiser   |
|   la structure de controle: GNLControle          |
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|.
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nlcodes.h"
#include "nlchoix.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "errcodes.h"
#include "nlglobal.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
/* fonctions des autres modules */
TShortInt GerMessage();

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : NLVCrole                 |
| Role                  : Verifier les valeurs     |
|  contenues dans la structure GNLControle         |
|   S'il y a une erreur, on emet un warning et on  |
|   positionne le code de retour;                  |
| Parametres d'entree   :                          |
| Parametres d'e.s      :                          |
| Parametres de sortie  :                          |
|   Code : code d'erreur ou OK                     |
| Globale en entree     : GNLControle              |
| Conditions d'appel    : GNLControle.AVerif.VCrole|
|  est VRAI                                        |
| Retour fonction       : OK                       |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : VerifInt, VerifLogic      |
| Fonctions appelantes : NLVInit                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/
TShortInt NLVCrole(CasSedo, Code)

/* argument entree */
  TLogic CasSedo;

/* argument de sortie */
  TShortInt *Code;

/*--------------- Fin identification fonction ----*/
  {
  /* locals */
  TShortInt i;
  /* pointeur sur les fonctions appelees */
  TShortInt VerifInt(), VerifLogic();

 /* Mettre son nom dans la trace */
  ECRTRACE("NLVCrole");

  *Code = OK;

 /* verification de AVerif */
  APPEL(VerifLogic(GNLControle.AVerif.VCtxInteg, "AVerif.VCtxInteg", Code));
  APPEL(VerifLogic(GNLControle.AVerif.VCtxNum, "AVerif.VCtxNum", Code));
  APPEL(VerifLogic(GNLControle.AVerif.VCtxPuss, "AVerif.VCtxPuss", Code));
  APPEL(VerifLogic(GNLControle.AVerif.VDon, "AVerif.VDon", Code));
  APPEL(VerifLogic(GNLControle.AVerif.VMod, "AVerif.VMod", Code));
/* fin de verif de AVerif */

/* verification de divers logiques */
  APPEL(VerifLogic(GNLControle.FinTrait, "FinTrait", Code));
  APPEL(VerifLogic(GNLControle.TypeLgMess, "TypeLgMess", Code));


 /* verification de Voulu */
  APPEL(VerifLogic(GNLControle.Voulu.Ajustes, "wanted-fitted", Code));
  APPEL(VerifLogic(GNLControle.Voulu.AsVar, "wanted-as.var", Code));
  APPEL(VerifLogic(GNLControle.Voulu.BVarZBP, "wanted-BVarZB", Code));
  APPEL(VerifLogic(GNLControle.Voulu.Corr, "wanted-correlation", Code));
  APPEL(VerifLogic(GNLControle.Voulu.Data, "wanted-data", Code));
  APPEL(VerifLogic(GNLControle.Voulu.EquN, "wanted-est.eq", Code));
  APPEL(VerifLogic(GNLControle.Voulu.Estim, "wanted-estim", Code));
  APPEL(VerifLogic(GNLControle.Voulu.FctSensib, "wanted-deriv.fct", Code));
  APPEL(VerifLogic(GNLControle.Voulu.Mu, "wanted-mu", Code));
  APPEL(VerifLogic(GNLControle.Voulu.Residus, "wanted-residuals", Code));
  APPEL(VerifLogic(GNLControle.Voulu.ResNum, "wanted-num.res", Code));
  APPEL(VerifLogic(GNLControle.Voulu.Sedo, "wanted-odes", Code));
  APPEL(VerifLogic(GNLControle.Voulu.ValW, "wanted-W", Code));
  APPEL(VerifLogic(GNLControle.Voulu.Z, "wanted-Z", Code));
/* fin de verif de Voulu */


 /* verification de VouluIp */
  APPEL(VerifLogic(GNLControle.VouluIp.Ajustes, "wanted.print-fitted", Code));
  APPEL(VerifLogic(GNLControle.VouluIp.EquN, "wanted.print-score", Code));
  APPEL(VerifLogic(GNLControle.VouluIp.Estim, "wanted.print-estim", Code));
  APPEL(VerifLogic(GNLControle.VouluIp.FctSensib, "wanted.print-deriv.fct", Code));
  APPEL(VerifLogic(GNLControle.VouluIp.NbIter, "wanted.print-iter", Code));
  APPEL(VerifLogic(GNLControle.VouluIp.ResNum, "wanted.print-num.res", Code));
  APPEL(VerifLogic(GNLControle.VouluIp.Sedo, "wanted.print-sedo", Code));
/* fin de verif de VouluIp */

 /* verification de VouluIt */
  APPEL(VerifLogic(GNLControle.VouluIt.Ajustes, "wanted.iters.sv-fitted", Code));
  APPEL(VerifLogic(GNLControle.VouluIt.EquN, "wanted.iters.sv-score", Code));
  APPEL(VerifLogic(GNLControle.VouluIt.Estim, "wanted.iters.sv-estim", Code));
  APPEL(VerifLogic(GNLControle.VouluIt.FctSensib, "wanted.iters.sv-deriv.fct", Code));
  APPEL(VerifLogic(GNLControle.VouluIt.NbIter, "wanted.iters.sv-iter", Code));
  APPEL(VerifLogic(GNLControle.VouluIt.ResNum, "wanted.iters.sv-num.res", Code));
  APPEL(VerifLogic(GNLControle.VouluIt.Sedo, "wanted.iters.sv-sedo", Code));
/* fin de verif de VouluIt */

  if (CasSedo==FAUX)
    {
    GNLControle.VouluIp.Sedo=FAUX;
    GNLControle.VouluIt.Sedo=FAUX;
    }

  for (i=0; i<MAXETAP;i++)
    {
    APPEL(VerifLogic(GNLControle.EtapeIt[i],"step.iters.sv", Code));
    }

/* verification des entiers */

  APPEL(VerifInt( GNLControle.NbWAnaly, "anal.warn", Code));
  APPEL(VerifInt( GNLControle.NbWInteg, "integ.warn", Code));
  APPEL(VerifInt( GNLControle.NbWMethe, "meth.warn", Code));
  APPEL(VerifInt( GNLControle.NbWNumer, "num.warn", Code));
  APPEL(VerifInt( GNLControle.NbWTotal, "all.warn", Code));

/* Les NbW doivent etre inf a NbWTotal */
   if ( (GNLControle.NbWTotal < GNLControle.NbWAnaly)
     && ( (GNLControle.NbWAnaly == DEFWANALY) || (GNLControle.NbWTotal != DEFWTOTAL)))
      {
      GNLControle.NbWAnaly = GNLControle.NbWTotal;
      }
   if ( (GNLControle.NbWTotal < GNLControle.NbWInteg)
     && ( (GNLControle.NbWInteg == DEFWINTEG) || (GNLControle.NbWTotal != DEFWTOTAL)))
      {
      GNLControle.NbWInteg = GNLControle.NbWTotal;
      }
   if ( (GNLControle.NbWTotal < GNLControle.NbWMethe)
     && ( (GNLControle.NbWMethe == DEFWMETHO) || (GNLControle.NbWTotal != DEFWTOTAL)))
      {
      GNLControle.NbWMethe = GNLControle.NbWTotal;
      }
   if ( (GNLControle.NbWTotal < GNLControle.NbWNumer)
     && ( (GNLControle.NbWNumer == DEFWNUMER) || (GNLControle.NbWTotal != DEFWTOTAL)))
      {
      GNLControle.NbWNumer = GNLControle.NbWTotal;
      }


   if ( (GNLControle.NbWTotal >  GNLControle.NbWAnaly)
     &&  (GNLControle.NbWAnaly == DEFWANALY))
      {
      GNLControle.NbWAnaly = GNLControle.NbWTotal;
      }
   if ( (GNLControle.NbWTotal >  GNLControle.NbWInteg)
     &&  (GNLControle.NbWInteg == DEFWINTEG))
      {
      GNLControle.NbWInteg = GNLControle.NbWTotal;
      }
   if ( (GNLControle.NbWTotal >  GNLControle.NbWMethe)
     &&  (GNLControle.NbWMethe == DEFWMETHO))
      {
      GNLControle.NbWMethe = GNLControle.NbWTotal;
      }
   if ( (GNLControle.NbWTotal >  GNLControle.NbWNumer)
     &&  (GNLControle.NbWNumer == DEFWNUMER) )
      {
      GNLControle.NbWNumer = GNLControle.NbWTotal;
      }


             
/* On met NbWTotal= le mini des valeurs des NbW */
  if (GNLControle.NbWAnaly< GNLControle.NbWTotal)
    {
    GNLControle.NbWTotal= GNLControle.NbWAnaly;
    }
  if (GNLControle.NbWInteg< GNLControle.NbWTotal)
    {
    GNLControle.NbWTotal= GNLControle.NbWInteg;
    }
  if (GNLControle.NbWMethe< GNLControle.NbWTotal)
    {
    GNLControle.NbWTotal= GNLControle.NbWMethe;
    }
  if (GNLControle.NbWNumer< GNLControle.NbWTotal)
    {
    GNLControle.NbWTotal= GNLControle.NbWNumer;
    }


/* initialisation des compteurs de warnings */
 GNLControle.CWarAna=0 ;  /* nbre de warnings pour l'analyseur-derivateur */
 GNLControle.CWarInt=0 ;  /* nbre de warnings pour l'integrateur */
 GNLControle.CWarMet=0 ;  /* nbre de warnings de type methodologique */
 GNLControle.CWarNum=0 ;  /* nbre de warnings de type numerique */
 GNLControle.CWarTot=0 ;  /* nbre de warnings tous types */


  /* retour */
  return(OK);
  }


/*--------------- Identification fonction ----------
| Nom de la fonction    : VerifInt                 |
| Role                  : Verifier qu'une valeur   |
|  de type TShortInt de la structure GNLControle   |
|  est positive ou nulle                           |
| Parametres d'entree   :                          |
|   Compo : valeur du composant de GNLControle a   |
|           verifier                               |
|   Nom : nom de celui-ci                          |
| Parametres d'e.s      :                          |
|   Code : code d'erreur                           |
|         modifie en sortie, si il y a une erreur  | 
| Retour fonction       : OK                       |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  aucune                   |
| Fonctions appelantes : NLVCrole                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/
TShortInt VerifInt(Compo, Nom, Code)

/* argument d'entree */
TShortInt Compo;
TChar *Nom;

/* arguments d'entree- sortie */
  TShortInt *Code;

/*--------------- Fin identification fonction ----*/
{

/* locals */
TChar Mess1[5];

  if (Compo <0)
    {
    sprintf(Mess1,"%hd", Compo);
   /* MESSAGE ecrit par NLWARNING: */
   /*
    printf("GNLControle.%s% est egal \`a %s\n", Nom, Mess1);
    printf("Il est n\'egatif \n");
   */
    /* FIN MESSAGE */
    NLWARNING((WARVCO2,3,"NLVCrole",Nom, Mess1, WMETHO));
    *Code = WARVCO2;
    }

return(OK);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : VerifLogic               |
| Role                  : Verifier qu'une valeur   |
|  de type TLogic  de la structure GNLControle     |
|  est VRAI ou FAUSSE                              |
| Parametres d'entree   :                          |
|   Compo : valeur du composant de GNLControle a   |
|           verifier                               |
|   Nom : nom de celui-ci                          |
| Parametres d'e.s      :                          |
|   Code : code d'erreur                           |
|         modifie en sortie, si il y a une erreur  | 
| Retour fonction       : OK                       |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  aucune                   |
| Fonctions appelantes : NLVCrole                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/
TShortInt VerifLogic(Compo, Nom, Code)

/* argument d'entree */
TLogic Compo;
TChar *Nom;

/* arguments d'entree- sortie */
  TShortInt *Code;

/*--------------- Fin identification fonction ----*/
{

/* locals */
TChar Mess1[5];


  if ((Compo != VRAI) &&  (Compo != FAUX))
    {
    sprintf(Mess1,"%hd", Compo);
   /* MESSAGE ecrit par NLWARNING: */
   /*
    printf("GNLControle.%s est egal a %s (different de VRAI (1) ou FAUX (0))\n",
     Nom, Mess1);
   */
    /* FIN MESSAGE */
    NLWARNING((WARVCO1,3,"NLVCrole",Nom,Mess1, WMETHO));
    *Code = WARVCO1;
    }

return(OK);
}

