/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : NLVDonM                   |
| Date                 : 1991                      |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : A. Bouvier                |
| Role                 : Verifier la coherence     |
|  entre le nombre de parametres et le nombre      |
|  d'observations                                  |
| Reference conception :                           |
| Lecteur              :  A. Bouvier               |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>

#include "nlchoix.h"
#include "nlcodes.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "errcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
/* fonctions des autres modules */
TShortInt GerMessage();

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

  

/*--------------- Identification fonction ----------
| Nom de la fonction    : NLVDonM                  |
| Role                  : Verifier la coherence    |
|  entre le nombre de parametres et le nombre      |
|  d'observations                                  |
| Parametres d'entree   :                          |
|  NbTheta: le nombre de parametres du modele de f |                                   |
|  NbBeta: le nombre de parametres  du modele de v |
|  NbObsC: nombre d'observations par courbe        |
| Parametres d'e./s.    :                          |
| Parametres de sortie  :                          |
|  Code: code de warning ou OK                     |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Fonctions appelantes : NLVInit                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt NLVDonM(NbTheta, NbBeta, NbObsC, Code)
/* ............... Arguments d'entree ............................ */
TShortInt NbTheta, NbBeta;
TVectLong  *NbObsC ;    /* nombre d'observations de chaque courbe - dim: NbCourbe */
/* ............... Argument de sortie ............................ */
TShortInt *Code;

/*--------------- Fin identification fonction ----*/
{
/* locals */
TShortInt i, NbParam, NbCourbe;
TChar Mess1[5], Mess2[5], Mess3[5];
TLongInt *nbobsc;

/* Ecriture de la trace */
ECRTRACE("NLVDonM");

*Code=OK;
NbParam = NbTheta + NbBeta;
NbCourbe = NbObsC->nbele;
nbobsc = NbObsC->donnees;

for(i=0; i<NbCourbe; i++)
  {
  if(nbobsc[i] < NbParam)
    {
    sprintf(Mess1,"%hd", (i+1));
    sprintf(Mess2, "%ld", nbobsc[i]);
    sprintf(Mess3, "%hd", NbParam);
    /* Actions effectuees par la macro :
    printf ("Le nombre d'observations de la %s ieme courbe, %s\n",
             Mess1, Mess2);
    printf("est inferieur au nombre total de parametres de base\n");
    printf("soit: %s\n", Mess3);
    */
    NLWARNING ((WARVDONM,4,"NLVDonM",Mess1, Mess2, Mess3, WMETHO)) ;
    *Code = WARVDONM;
    }
  }

return(OK);
}

