
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : NLVDon                    |
| Date                 : 14Nov91 / 14:26:50        |
| Derniere mise a jour :                           |
| Concepteur           : A.Posty et A.Bouvier      |
| Role                 :Verifier et initialiser    |
|  la structure  Donnees                           |
| Reference conception :                           |
| Lecteur              : A. Posty et A. Bouvier    |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <string.h>
#include <stdio.h>
#include<math.h>

#include "nlchoix.h"
#include "nlcodes.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "errcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
/* fonctions des autres modules */

TShortInt CreerMat( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerMatC( TShortInt nblig, TShortInt nbcol, TMat *pmat);
TShortInt CreerVect( TShortInt nbele, TVect *pvect);
TShortInt CreerVectLong( TShortInt nbele, TVectLong *pvect);
TShortInt CreerVectStr( TShortInt nbele, TVectStr *pvect);
TShortInt CreerVectShort(TShortInt nbele, TVectShort *pvect);

void DetruVectShort(TVectShort *pvect);
TShortInt GerMessage( );

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/



/*--------------- Identification fonction ----------
| Nom de la fonction    : ChangerDim               |
| Role                  : Creer les donnees en     |
|   dimension NbObs, c'est-a-dire, sans les        |
|   repetitions ni les donnees de poids nuls       |
| Parametres d'entree   :                          |
|  NbCourbe: nombre de courbes                     |
|  PoidsT: poids des observations                  |
|         avec les repetitions et les donnees de   |
|         poids nuls, ou vecteur de dimension 0    |
|         s'il n'y a pas de poids                  |
|  NomCT: noms de la courbe des observations dans  |
|         la meme dimension que PoidsT             |
|         Meme s'il n'y a qu'une seule courbe, ce  |
|         vecteur existe:                          |
|         tous ses elements ont alors la meme      |
|         valeur                                   |
|  NomObsT: noms des observations dans la meme     |
|          dimension que PoidsT                    |
|  XObsT: matrice des observations                 |
|         avec les repetitions et les donnees de   |
|         poids nuls.                              |
| Parametres d'e/s      :                          |
| Parametres de sortie  :                          |
|  NbObs: nombre d'observations, en ne comptant    |
|         qu'une fois les repetitions et sans      |
|         compter les donnees de poids nuls        |
|  NbObsC: nombre d' observations de chaque        |
|         courbe (dimension NbCourbe)              |
|  NbRepet: nombre de repetitions de chaque        |
|        observation (dimension NbObs)             |
|  NomC: noms de la courbe des observations en     |
|        dimension NbObs                           |
|  NomObs:  noms des observations en dimension     |
|        NbObs.                                    |
|        Quand il y a des repetitions, on choisit  |
|        la valeur de NomObsT qui correspond a la  |
|        1-iere repetition de l'observation        |
|  Poids: poids des observations  en dimension     |
|         NbObs, ou vecteur de dimension 0 s'il n'y|
|         a pas de poids                           |
|  XObs: matrice des observations                  |
|        sans les repetitions ni les donnees de    |
|         poids nuls                               |
|  Code : OK ou WARPOIDS (tous les poids sont nuls)|
| Retour fonction       : OK                       |
| Arret de l'execution :                           |
|  si probleme d'allocation memoire                | 
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|   CreerVect                                      |
|   CreerVectLong,                                 |
|   CreerVectShort,                                |
|   CreerVectStr,                                  |
|   MemeTUple                                      | 
| Fonctions appelantes :  NLVDon                   |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

TShortInt ChangerDim( NbCourbe, PoidsT, NomObsT,NomCT,  XObsT,
                      NbObs, NbObsC, NbRepet, NomC, NomObs, Poids, XObs,
                      Code)

/* arguments d'entree */
TShortInt NbCourbe;
TVect *PoidsT;
TVectStr *NomCT, *NomObsT;
TMat *XObsT;

/* arguments de sortie */
TLongInt  *NbObs;
TVectLong *NbObsC, *NbRepet;
TVectStr *NomC, *NomObs;
TVect *Poids;
TMat *XObs;
TShortInt *Code;

/*--------------- Fin identification fonction ----*/

{
/* locals */
TShortInt i, isuiv, j, IObs, IDeb, ICourbe;
TVectShort ITrav;
TChar NomCourbe[MAXCH];
TShortInt poidstn, NbObsTT, nbx;

/* pointeur sur les fonctions du module appelees */
TShortInt MemeTUple();

/* pointeurs pour ameliorer la performance */
TDouble *poids, *poidst;
TLongInt *nbobsc, *nbrepet;
TChar **nomobs, **nomobst, **nomc, **nomct;
TDouble **xobs, **xobst;


/* Ecriture de la trace */
ECRTRACE("ChangerDim");

*Code =OK;

/* Creation d'un vecteur de travail, ITrav, qui sera rempli ainsi:
  ITrav[i] = 1 si la ligne i de XObsT correspond a la 1iere repetition
             d'une observation,
  ITrav[i] = 0 si la ligne i de XObsT correspond a la repetition
             d'une observation precedente,
  ITrav[i] = -1 si la ligne i de XObsT correspond a une donnee de poids nul
*/
APPEL(CreerVectShort(XObsT->nblig, &ITrav));


/* COMPTER NbObs: nombre de lignes non identiques de XObsT -
                  celles correspondant a des poids nuls
*/

i = 0;
poidstn = PoidsT->nbele;
poidst = PoidsT->donnees;

if (poidstn > 0)
{
/* recherche du 1ier tuple de poids non nul */
while ((poidst[i] == (TDouble)ZERO) && (i < poidstn))
  {
  ITrav.donnees[i] = -1;
  i = i + 1;
  }
if (i == poidstn)
  {
/*
  printf("Erreur dans les poids: tous les poids sont nuls \n");
*/
  NLWARNING((WARPOIDS2,1 ,"ChangerDim",WMETHO));
  *Code =WARPOIDS2;
  return(OK);
  }
}
else
{
i = 0; /* quand il n'y a pas de poids, le 1ier t-uple est celui recherche */
}

IDeb = i; /* on memorise l'emplacement du 1ier tuple a considerer
            ca servira dans le remplissage des sorties */

ITrav.donnees[i] = 1;
*NbObs = 1;
NbObsTT = XObsT->nblig;

while ( i < (NbObsTT - 1))
  {
  /* recherche du premier tuple qui suit le i-ieme, de poids non nul et
     non identique au i-ieme */
  for (isuiv = (i + 1); isuiv < NbObsTT ; isuiv++)
    {
    if ((poidstn > 0) && (poidst[isuiv]  == 0))
      {
      ITrav.donnees[isuiv] = -1; /* ignorer isuiv */
      }
    else
      {
      /* il n'y a pas de poids ou bien isuiv a un poids non nul */
      if (MemeTUple(i, isuiv, PoidsT,  NomCT, XObsT))
        {
        /*  isuiv est une repetition de i, a prendre en compte */
        ITrav.donnees[isuiv] = 0;
        }
      else
        {
        /* isuiv est une nouvelle observation a prendre en compte */
        ITrav.donnees[isuiv] = 1;
        *NbObs = *NbObs + 1;
        break; /* sortie de la boucle sur isuiv */
        }
      } /* fin du cas ou il n'y a pas de poids ou bien isuiv a un poids non nul */

    } /* fin boucle sur isuiv 
         quand on sort de cette boucle, c'est que isuiv = XObsT->nblig
         ou que isuiv pointe sur une nouvelle observation */        
  i = isuiv; /* on repart de la nouvelle observation */
  } /* fin while sur i */



/* ALLOUER LES SORTIES */
if (poidstn >0)
  {
  APPEL(CreerVect((TShortInt)(*NbObs), Poids));
  }
else
  {
  APPEL(CreerVect((TShortInt)0, Poids));
  }
APPEL(CreerVectLong((TShortInt)(NbCourbe), NbObsC));
APPEL(CreerVectLong((TShortInt)(*NbObs), NbRepet));
APPEL(CreerVectStr((TShortInt)(*NbObs), NomObs));
APPEL(CreerVectStr((TShortInt)(*NbObs), NomC));
APPEL(CreerMatC((TShortInt)(*NbObs), XObsT->nbcol, XObs));

/* REMPLIR LES SORTIES */
/* affectation des pointeurs  pour eviter d'avoir a chercher des elements de structures */
poids = Poids->donnees;
nbobsc = NbObsC->donnees;
nbrepet = NbRepet->donnees;
nomobs = NomObs->donnees;
nomobst = NomObsT->donnees;
nomc =  NomC->donnees;
nomct =  NomCT->donnees;
xobs = XObs->donnees;
xobst = XObsT->donnees;

nbx = XObsT->nbcol;

IObs = 0; /* indice courant dans la dimension NbObs */
i = IDeb; /* i: indice courant dans la dimension XObsT.nblig */

ICourbe = 0;
strncpy(NomCourbe, nomct[i], MAXCH);
nbobsc[ICourbe]=0;

while ( i < NbObsTT)
  {
  nbrepet[IObs] = 1;
  if(poidstn > 0)
    {
    poids[IObs] = poidst[i];
    }

/*   nomc[IObs] = nomct[i];*/
  strncpy( nomc[IObs], nomct[i], MAXCH);
  if(strncmp (NomCourbe, nomc[IObs], MAXCH) == 0)
    {
    /* meme courbe */
    nbobsc[ICourbe] = nbobsc[ICourbe] +1;
    }
  else
    {
    strncpy(NomCourbe, nomc[IObs], MAXCH);
    ICourbe = ICourbe + 1;
    nbobsc[ICourbe] = 1;
    }

/*  nomobs[IObs] = nomobst[i]; */
   strncpy( nomobs[IObs], nomobst[i], MAXCH);

  /* Remarque: on prend comme nom de l'observation,
  le nom de la 1iere repetition de celle-ci */

  for (j = 0;j < nbx; j++)
    {
    xobs[IObs][j] = xobst[i][j];
    }

  for (isuiv = (i + 1); isuiv < NbObsTT; isuiv++)
    {
    if (ITrav.donnees[isuiv] == 0) 
      {
      /* repetition de l'observation */
      nbrepet[IObs] = nbrepet[IObs] + 1;
      }
    if (ITrav.donnees[isuiv] == 1) 
      {
      /*  nouvelle observation */
      IObs = IObs + 1;
      break ; /* sortie de la boucle sur isuiv */
      }
    } /* fin boucle sur isuiv */
  i = isuiv; /* on passe a l'observation suivante */
  } /* fin while sur i */

/* retour */
DetruVectShort(&ITrav);

return(OK);

}

/*--------------- Identification fonction ----------
| Nom de la fonction    : CStatDon                 |
| Role                  : Calculer les statistiques|
|                       : sur les donnees          |
| Parametres d'entree   :                          |
|  NbRepet: nombre de repetitions de chaque        |
|    observation                                   |
|  ValY: valeurs de la variable a expliquer Y      |
|  PoidsT: poids sur les observations              |
|   s'il n'y en a pas,c'est un vecteur a 0 element |
|  (un poids nul = observation a ne pas prendre    |
|   en compte)                                     |
| Parametres de sortie  : StatDon, structure qui   |
|    comprend:                                     |
|  Y1 : somme sur l'ensemble des repetitions d'une |
|       observation, des valeurs de la  reponse    |
|       ponderee par le nombre de repetitions      |
|  Y2 : somme sur l'ensemble des repetitions d'une |
|       observation, des valeurs au carre de la    |
|       reponse ponderee par le nombre repetitions |
|  S2 : somme des carres                           |
| Retour fonction       : OK                       |
| Arret de l'execution :                           |
|  si probleme d'allocation memoire                | 
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : CreerVect                 |
| Fonctions appelantes :  NLVDon                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/
TShortInt CStatDon(NbRepet, ValY, PoidsT, StatDon) 

/* ................. Arguments d'entree ................................... */
TVectLong *NbRepet ;
TVect *ValY, *PoidsT;

/* ................. Arguments de sortie .................................. */
TStatDon *StatDon ;
/*--------------- Fin identification fonction ------------------------------*/

{
/* locals */
  TShortInt i,j,tab,NbObs,poidstn ;
  TDouble inter,inter1 ;
  /* pointeurs sur des elements de structures pour ameliorer la performance */
  TLongInt *nbrepet;
  TDouble *valy, *poidst, *y1, *y2, *s2;

/* Ecriture de la trace */
  ECRTRACE("CStatDon");

  tab = 0 ;
  NbObs = NbRepet->nbele;

/* ...........................Creation des sorties ......................  */
  APPEL(CreerVect(NbObs, &(StatDon->Y1)));
  APPEL(CreerVect(NbObs, &(StatDon->Y2)));
  APPEL(CreerVect(NbObs, &(StatDon->S2)));


/* .......................... Calcul de Y1, Y2, S2 ........................ */
  /* Affectation des pointeurs */
  nbrepet = NbRepet->donnees;
  valy = ValY->donnees;
  poidst =  PoidsT->donnees;
  y1 = StatDon->Y1.donnees;
  y2 = StatDon->Y2.donnees;
  s2 = StatDon->S2.donnees;

  poidstn = PoidsT->nbele;

  for (i = 0 ; i < NbObs ; i++)
    {
      inter = 0 ;
      inter1 = 0 ;
      for (j = 0 ; j < nbrepet[i] ; j++)
	{
	  if (poidstn == 0)
	    {
	      inter = inter + valy[tab];
	      inter1 = inter1 + (valy[tab] * valy[tab]) ;
	    }
          else
            {
            while  (poidst[tab] == 0) 
              {
              tab = tab + 1;
              }
	      inter = inter + valy[tab];
	      inter1 = inter1 + (valy[tab] * valy[tab]) ;
            }
	  tab = tab + 1 ;
	}
      y1[i] = inter / ((TDouble)nbrepet[i]) ;
      y2[i] = inter1 / ((TDouble)nbrepet[i]) ;
      if (nbrepet[i] > 1)
        {
        s2[i] = ((TDouble)nbrepet[i] / (TDouble)(nbrepet[i] - 1));
        s2[i] = s2[i] * (y2[i] - (y1[i] * y1[i])) ;
        }
      else
        {
        s2[i] = 0; /* quand pas de repetitions, S2 est ignore */
        }

    }

/* ........... retour ........................................................ */
return(OK);
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : MemeTUple                |
| Role                  : Determiner si 2 individus|
|  de Donnees sont des repetitions d'une meme      |
|  observation, c'est-a-dire, ont les memes valeurs|
|  de courbe, poids et variables explicatives      |
| Parametres d'entree   :                          |
|  i1: indice dans la matrice des donnees du 1ier  |
|     individu                                     |
|  i2: indice dans la matrice des donnees du 2ieme |
|     individu                                     |
|  PoidsT: vecteur des poids                       |
|  NomCT: noms des courbes                         |
|  XObsT: matrice des variables explicatives       |
| Parametres d'e/s      :                          |
| Parametres de sortie  :                          |
| Retour fonction       : VRAI si les individus    |
|  sont des repetitions, FAUX sinon.               |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  aucune                   |
| Fonctions appelantes :  ChangerDim               |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

TShortInt MemeTUple(i1, i2, PoidsT,  NomCT, XObsT)

/* arguments d'entree */
TShortInt i1, i2;
TVect *PoidsT;
TVectStr *NomCT;
TMat *XObsT;

/*--------------- Fin identification fonction ----*/

{
/* locals */
TShortInt i, nbx;

/* comparaison de la courbe */
if (strcmp(NomCT->donnees[i1],NomCT->donnees[i2]) != 0)
  { 
  return(FAUX);
  }

/* comparaison des poids */
if (PoidsT->nbele >0) 
  {
  if (PoidsT->donnees[i1] != PoidsT->donnees[i2])
    {
    return(FAUX);
    }
  }


/* comparaison des valeurs des variables explicatives */
nbx = XObsT->nbcol;
for (i = 0; i<nbx; i++)
  {
  if (XObsT->donnees[i1][i] != XObsT->donnees[i2][i])
    {
    return(FAUX);
    }
  }

/* retour */
return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : PreparVar                |
| Role                  :                          |
|  - Verifier les parametres d'entree et           |
|      d'entrees-sorties,                          |
|  - Affecter des valeurs par defaut aux           |
|      entrees-sorties.                            |
| Parametres d'entree   :                          |
|  ValY: valeurs de la variable a expliquer Y      |
|  PoidsT: poids sur les observations              |
|   s'il n'y en a pas, c'est un vecteur a 0 element|
|  (un poids nul = observation a ne pas prendre    |
|   en compte)                                     |
|  XObsT: matrice des variables explicatives       |
| Parametres d'e./s.    :                          |
|  NomX: noms des variables explicatives           |
|   s'il n'y en a pas, en entree, c'est un vecteur |
|   a 0 element et en sortie, un vecteur de        |
|   "x1", "x2", etc,...                            |
|  NomCT: noms des courbes de chaque observation   |
|   s'il n'y en a pas, en entree, c'est un vecteur |
|   a 0 element et en sortie, un vecteur de        |
|    (NbObsT+nombre d'observations de poids nuls)  |
|    elements egaux a "c1"                         |
|  NomObsT: noms des repetitions de chaque         |
|     observation.                                 |
|   s'il n'y en a pas, en entree, c'est un vecteur |
|   a 0 elements et en sortie, un vecteur de       |
|    (NbObsT+nombre d'observations de poids nuls)  |
|    elements egaux a "i1", "i2", "i3",etc..       |
| Parametres de sortie  :                          |
|  NbX: nombre de variables explicatives           |
|  NbCourbe: nombre de courbes                     |
|  NbObsT: nombre d'observations en comptant les   |
|   repetitions                                    |
|  Code : OK ou WARDON                             |
| Retour fonction       : OK                       |
| Arret de l'execution :                           |
|  si probleme d'allocation memoire                | 
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  CreerVectStr             |
| Fonctions appelantes : NLVDon                    |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt PreparVar(ValY, PoidsT, XObsT,
                     NomX, NomCT,NomObsT,
                    NbX,NbCourbe,NbObsT, Code) 
/* ............... Arguments d'entree ............................ */
TVect *ValY;
TVect *PoidsT ;
TMat *XObsT ;

/* ............... Arguments d'entree-sortie ..................... */
TVectStr *NomX, *NomCT, *NomObsT ;

/* ............... Arguments de sortie .......................... */
TShortInt *NbX ,*NbCourbe ;
TLongInt *NbObsT ;
  TShortInt *Code;

/*--------------- Fin identification fonction ----*/

{
/* ............... variables internes ............................ */
  TShortInt i, NbObsTT ;
  TChar  Mess1[5];

/* pointeurs sur des elements de structures pour ameliorer la performance */
  TDouble *poidst;
  TChar **nomx, **nomct, **nomobst;

/* Ecriture de la trace */
ECRTRACE("PreparVar");

*Code=OK;

/* .......... Verification des dimensions de XObsT ............... */
  if ((XObsT->nblig <= 0 ) || (XObsT->nbcol <= 0 ))
    {
      sprintf(Mess1,"%hd, %hd", XObsT->nblig, XObsT->nbcol);
/*    
      printf ("Les dimensions , %s, de %s sont erronees \n ",
               Mess1,  "XObsT") ;           
 */
      NLWARNING ((WARDON1,2,"PreparVar", Mess1, WMETHO)) ; 
      *Code = WARDON;
    }

if (*Code == OK)
  {
  *NbX = XObsT->nbcol ;
   NbObsTT = ValY->nbele;

/*  Verification de la dimension de XObsT par rapport a celle de ValY */
  if (XObsT->nblig != NbObsTT)
    {
      sprintf(Mess1,"%hd, %hd", XObsT->nblig, XObsT->nbcol);
/*
      printf ("Les dimensions , %s, de %s sont erronees \n ",
               Mess1,  "XObsT") ;           
*/

      NLWARNING ((WARDON1,2,"PreparVar",Mess1,WMETHO)) ;
      *Code = WARDON;
    }
  }


if (*Code != WARDON)
  {
  *NbObsT = ValY->nbele;

/* ............. Verification de PoidsT .......................... */
/* ............... que ses valeurs soient positives .............. */
/* ............... que sa dimension egale celle de ValY .......... */
/* ..............On compte NbObsT ................................ */


  if (PoidsT->nbele >0)
    {
     if (PoidsT->nbele != NbObsTT)
       {
       sprintf(Mess1,"%hd", PoidsT->nbele);
/*  
       printf ("La dimension , %s, de %s est erronee\n",
             Mess1, "PoidsT");
*/
       NLWARNING (( WARDON2,2,"PreparVar",Mess1, WMETHO)) ;
       *Code = WARDON;
       }	
      else
       {
       poidst = PoidsT->donnees;
       for ( i = 0 ; i < NbObsTT ; i ++)
    	 {
    	 if (poidst[i]  < 0)
  	   {
	   sprintf (Mess1,"%d",(i+1)) ;
/*
           printf ("Erreur dans les PoidsT :la %s-ieme valeur
                     est negative \n",Mess1);                 
*/
	   NLWARNING ((WARPOIDS1,2,"PreparVar",Mess1,WMETHO)) ;
           *Code = WARPOIDS1;
	   }
	 else 
	   {
	   if (poidst[i] == (TDouble)ZERO)
             {
	     *NbObsT = *NbObsT - 1;
             }
	   } /* fin du else PoidsT <0 */
         }  /* fin boucle sur i */
       } /* fin du else PoidsT->nbele != ValY->nbele */
    } /* fin du if PoidsT.nbele>0 */


/* ................. Verification du vecteur NomCT ...................... */
/* ................... Verification que sa .............................. */
/* ................... dimension soit egale a celle de ValY ............. */
/* ................... Mise en place de NbCourbe ........................ */

  *NbCourbe = 1 ;

  if (NomCT->nbele == 0)
    {
      APPEL (CreerVectStr (NbObsTT , NomCT)) ;
      nomct = NomCT->donnees;
      for (i = 0 ; i < NbObsTT ; i++)
	{
/* ........ Si NomCT n'existe pas : on suppose qu'il n'y a qu'une ....... */
/* ........ courbe . On lui donne par defaut le nom de " c1" ............ */
/* 	  NomCT->donnees[i] = "c1"; */
          strncpy(NomCT->donnees[i], "c1", MAXCH);

	}
    }
  else
    {
      if (NomCT->nbele != NbObsTT)
	{
        sprintf(Mess1,"%hd", NomCT->nbele);
/*
       printf ("La dimension, %s, de %s, est erronee \n",
         Mess1, "NomCT");
*/
	NLWARNING (( WARDON3,2,"PreparVar",Mess1, WMETHO)) ;
        *Code = WARDON;
	}
      else
        {
        nomct = NomCT->donnees;
        for ( i = 1 ; i < NbObsTT ; i ++)
	  {
	  if (strcmp (nomct[i],nomct[i-1]) != 0)
	    {
/* ...................On change de courbe ................................ */
	      *NbCourbe = *NbCourbe + 1  ;

	    }
	  }
      } /* fin du cas NomCT bien dimensionne */
    } /*          fin du else NomCT.nbele non nul ........................ */



/* ............... Verification de NomObsT ............................... */
/* ............... Sa  dimension est egale a celle de ValY  .............. */

  if (NomObsT->nbele == 0 )
    {
/* ............ Si il n'y a pas de noms d'observations ................... */
/* ............ On leur donne par default : "i1", "i2" , "i3" ............ */
      APPEL (CreerVectStr(NbObsTT,NomObsT )) ;
      nomobst = NomObsT->donnees;
      for (i = 0 ; i < NbObsTT ; i ++ )
	{
        sprintf(nomobst[i],"i%d", (i+1));
	}
    }
  else 
    {
      if (NomObsT->nbele != NbObsTT)
	{
        sprintf(Mess1,"%hd", NomObsT->nbele);
/*
      printf ("La dimension, %s de %s, est erronee \n",
        Mess1, "NomObsT");
*/
        NLWARNING (( WARDON4,2,"PreparVar",Mess1, WMETHO)) ;
        *Code = WARDON;
        }
    } /* fin du else NomObsT.nbele  nul */

/* .......... Affectation des noms des variables par defaut  .......... */

  if (NomX->nbele == 0)
    {
    APPEL(CreerVectStr(*NbX, NomX));
    nomx = NomX->donnees;
    for (i = 0 ; i < *NbX ; i ++ )
      {
      sprintf(nomx[i],"x%d", (i+1));
      }
    }
  else
    {
    if (NomX->nbele != *NbX)
      {
      sprintf(Mess1,"%hd", NomX->nbele);
/*
      printf("La dimension, %s, de %s est erronee\n", Mess1, "NomX");

*/
      NLWARNING (( WARDON5,2,"PreparVar",Mess1, WMETHO)) ;
      *Code = WARDON;
      }
    } /* fin du else (NomX->nbele == 0) */

  } /* fin du *Code != WARDON */

/* ............ Retour ..................................................  */

  return(OK) ;
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : NLVDon                   |
| Role                  :                          |
|   Verifier les sous-structures de Donnees en     |
|   entree et en entree-sortie (voir ci-dessous),  |
|   affecter, si necessaire, les valeurs par defaut|
|   aux sous-structures en entree-sortie,          |
|   et determiner les sous-structures en sortie.   |  
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
|  Donnees: la structure des donnees.              |
|    En entree:                                    |
|  ValY: valeurs de la variable a expliquer Y      |
|  PoidsT: poids sur les observations              |
|   s'il n'y en a pas, c'est un vecteur a 0 element|
|  (un poids nul = observation a ne pas prendre    |
|   en compte)                                     |
|  XObsT: matrice des variables explicatives       |
|    En entree-sortie:                             |
|  NomX: noms des variables explicatives           |
|   s'il n'y en a pas, en entree, c'est un vecteur |
|   a 0 element et en sortie, un vecteur de        |
|   "x1", "x2", etc,...                            |
|  NomCT: noms des courbes de chaque observation   |
|   s'il n'y en a pas, en entree, c'est un vecteur |
|   a 0 element et en sortie, un vecteur de        |
|    (NbObsT+nombre d'observations de poids nuls)  |
|    elements egaux a "c1"                         |
|  NomObsT: noms des repetitions de chaque         |
|     observation.                                 |
|   s'il n'y en a pas, en entree, c'est un vecteur |
|   a 0 elements et en sortie, un vecteur de       |
|    (NbObsT+nombre d'observations de poids nuls)  |
|    elements egaux a "i1", "i2", "i3",etc..       |
|     En sortie:                                   |
|  NbX: nombre de variables explicatives           |
|  NbCourbe: nombre de courbes                     |
|  NbObsT: nombre d'observations en comptant les   |
|   repetitions                                    |
|  NbObs: nombre d'observations, en ne comptant    |
|         qu'une fois les repetitions et sans      |
|         compter les donnees de poids nuls        |
|  NbObsC: nombre d' observations de chaque        |
|         courbe (dimension NbCourbe)              |
|  NbRepet: nombre de repetitions de chaque        |
|        observation (dimension NbObs)             |
|  NomC: noms de la courbe des observations en     |
|        dimension NbObs                           |
|  NomObs:  noms des observations en dimension     |
|        NbObs.                                    |
|        Quand il y a des repetitions, on choisit  |
|        la valeur de NomObsT qui correspond a la  |
|        1-iere repetition de l'observation        |
|  Poids: poids des observations  en dimension     |
|         NbObs, ou vecteur de dimension 0 s'il n'y|
|         a pas de poids                           |
|  XObs: matrice des observations                  |
|        sans les repetitions ni les donnees de    |
|         poids nuls                               |
|  StatDon: statistiques sur les donnees           |
| Parametres de sortie  :                          |
|  Code : OK ou Code de warning                    |
| Retour fonction       : OK                       |
| Arret de l'execution :                           |
|  si probleme d'allocation memoire                | 
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|                         ChangerDim               |
|                         CStatDon                 |
|                         PreparVar                |
| Fonctions appelantes : NLVInit                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt NLVDon(TDonnees *Donnees, TShortInt *Code)
/* ............... Arguments d'entree-sortie ..................... */
     /* TDonnees *Donnees;*/

/* argument de sortie */
     /* TShortInt *Code; */

/*--------------- Fin identification fonction ----*/
{

/* Ecriture de la trace */
ECRTRACE("NLVDon");

*Code = OK;

/* Verification de Donnees, et affectation des valeurs par defaut
  des composants en dimension: nombre total de repetitions, y compris
  les donnees de poids nul : appel de PreparVar: */

APPEL(PreparVar(&(Donnees->ValY),  &(Donnees->PoidsT), &(Donnees->XObsT),
                 &(Donnees->NomX),
                  &(Donnees->NomCT), &(Donnees->NomObsT), 
                  &(Donnees->NbX), &(Donnees->NbCourbe), &(Donnees->NbObsT),
                  Code));

if (*Code !=OK)
  {
  /* on arrete la suite du traitement sur les donnees */
   return(OK);
   }



/* Determination des composants en dimension: nombre d'observations,
  c.a.d sans les repetitions ni les donnees de poids nuls : appel de ChangerDim : */

  APPEL(ChangerDim(Donnees->NbCourbe, &(Donnees->PoidsT), &(Donnees->NomObsT), 
                  &(Donnees->NomCT), &(Donnees->XObsT),
                  &(Donnees->NbObs), &(Donnees->NbObsC), &(Donnees->NbRepet), &(Donnees->NomC), 
                  &(Donnees->NomObs), &(Donnees->Poids), &(Donnees->XObs),
                  Code ));


if (*Code !=OK)
  {
  /* on arrete la suite du traitement sur les donnees */
   return(OK);
   }

/* Calcul des statistiques elementaires: appel de CStatDon: */
APPEL(CStatDon( &(Donnees->NbRepet), &(Donnees->ValY), &(Donnees->PoidsT),
                 &(Donnees->StatDon)));

/* Retour */
return(OK);

}












