/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : NL                        |
| Date                 : 1992                      |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : A. Bouvier                |
| Role                 : Programme racine de NL    |
| PAR RAPPORT A LA VERSION NON INTERFACEE AVEC SPLUS
|   identique mais non inclus dans la library      |
|   car au 1ier niveau d'appel des fonctions S     |
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nlcodes.h"
#include "nlchoix.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "errcodes.h"
#include "nlglobal.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
/* fonctions des autres modules */
TShortInt NLVInit(TDonnees *Donnees, TModele *Modele, 
		  TCtxPuss *CtxPuss, TCtxNum CtxNum[]);
TShortInt NLEtape(TShortInt Etape, TDonnees *Donnees, TModele *Modele, 
		  TCtxPuss *CtxPuss, TCtxNum *CtxNum,
                  TVect *ThetaPred1, TVect *ThetaPred2, 
		  TVect *BetaPred1, TVect *BetaPred2,
                  TVect *Valf1,TMat * DValf1,
                  TParam  *Theta, TParam  *Beta, 
		  TContr *CTheta, TContr *CBeta, TContr *CThetaE, TContr *CBetaE,
		  TResNum *ResNum, TResStat *ResStat,
                  TShortInt *NbItSv, TResNum *ItNum, TResStat *ItStat,
		  TVect *ItTheta, TVect *ItBeta, TVect *ItDirec, TDouble *ItOmega);

TShortInt NLAutres(TDonnees * Donnees, TCtxPuss *CtxPuss, TCtxNum CtxNum[], 
		   TParam Theta[], TParam Beta[],
		   TContr CTheta[], TContr CBeta[],  
		   TContr CThetaE[],  TContr CBetaE[],
                   TResNum ResNum[], TResStat ResStat[]);

TShortInt GerMessage( );
TShortInt CreerVect( TShortInt nbele, TVect *pvect);
void DetruVect(TVect *pvect);
TShortInt NLVTrace();

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : NL                       |
| Role                  :  Gerer l'appel aux       |
|  programmes de NL                                |
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
|  Donnees: la structure des donnees               |
|  Modele: la structure du modele                  |
|  CtxPuss: le contexte du processus statistique   |
|  CtxNum: le contexte numerique                   |
| Globales en e./s.     :                          |
|  GNLControle: la structure de controle           |
|  GNLCtxInteg: le contexte d'integration          |
| Parametres de sortie  :                          |
|  CTheta, CBeta: les contraintes sur les          |
|   parametres Theta, Beta                         |
|  Theta, Beta: les parametres Theta, Beta         |
|  ResNum: les resultats numeriques                |
|  ResStat: les resultats statistiques             |
| Retour fonction       : OK  ou code d'erreur     |
| Reference conception  :                          |
 --------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|                        CreerVect,                |
|                        NLAutres,                 |
|                        NLEtape,                  |
|                        NLVInit,                  |
|                        NLVTrace,                 |
| Fonctions appelantes :  l'utilisateur            |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

TShortInt NL(TDonnees *Donnees, TModele *Modele, TCtxPuss *CtxPuss, TCtxNum CtxNum[],
             TContr CTheta[], TContr CBeta[], TParam Theta[], TParam Beta[],
	     TResNum ResNum[], TResStat ResStat[],
             TShortInt NbItSv[MAXETAP], TResNum ItNum[MAXETAP][MAXSVIT],
	     TResStat ItStat[MAXETAP][MAXSVIT], 
	     TVect ItTheta[MAXETAP][MAXSVIT], TVect ItBeta[MAXETAP][MAXSVIT], 
	     TVect ItDirec[MAXETAP][MAXSVIT], TDouble ItOmega[MAXETAP][MAXSVIT])

/* ............... Arguments d'entree-sortie....................... 
TDonnees *Donnees;
TModele *Modele;
TCtxPuss *CtxPuss;
TCtxNum CtxNum[];

 ............... Arguments de sortie ............................ 
TContr CTheta[], CBeta[];
TParam Theta[], Beta[];
TResNum ResNum[];
TResStat ResStat[];

 les resultats des iterations 
TShortInt NbItSv[MAXETAP];
TResNum ItNum[MAXETAP][MAXSVIT];
TResStat ItStat[MAXETAP][MAXSVIT];
TVect ItTheta[MAXETAP][MAXSVIT], ItBeta[MAXETAP][MAXSVIT], ItDirec[MAXETAP][MAXSVIT];
TDouble ItOmega[MAXETAP][MAXSVIT];
*/

/*--------------- Fin identification fonction ----*/

{
/* locals */
TContr CThetaE[MAXETAP], CBetaE[MAXETAP];
TShortInt  Etape, IndEtap, Code;
TChar Mess1[5], Mess2[5];
TVect ThetaPred1, ThetaPred2, BetaPred1, BetaPred2;

 /* creation de la trace */
 /* on verifie auparavant sa longueur */
  if ((GNLControle.LgTrace <0) || (GNLControle.LgTrace > MAXLGTRACE))
    {
    sprintf(Mess1,"%hd", GNLControle.LgTrace);
    sprintf(Mess2,"%hd", MAXLGTRACE);
   /* MESSAGE ecrit par NLERREUR: */
   /*
    printf("GNLControle.LgTrace est egal \`a %s\n", Mess1);
    printf("Il est negatif ou superieur a %s\n", Mess2);
   */
    /* FIN MESSAGE */
    ResNum[0].CodePuss=ERRTRACE;
    NLERREUR((ERRTRACE,3,"NL", Mess1, Mess2, ERR));
    }

  APPEL(NLVTrace());

ECRTRACE("NL");
/* initialisation du code de retour des etapes */
if ((CtxPuss->NbEtapes > 0 ) && (CtxPuss->NbEtapes <= MAXETAP))
  {
  for (Etape=0; Etape<CtxPuss->NbEtapes; Etape++)
    {
    ResNum[Etape].CodePuss = NONFAIT;
    }
  }
  

/* APPEL  DES VERIFICATIONS */
Code = NLVInit(Donnees, Modele, CtxPuss, CtxNum);
if (Code !=OK)
  {
  ResNum[0].CodePuss = Code;
  return(Code);
  }


/* INITIALISATIONS */
/* on cree des vecteurs bidon pour pouvoir faire l'appel a NL
avec les memes arguments, qu'il y ait des valeurs precedemment estimees
ou non */
APPEL(CreerVect((TShortInt)0, &ThetaPred1));
APPEL(CreerVect((TShortInt)0, &ThetaPred2));
APPEL(CreerVect((TShortInt)0, &BetaPred1));
APPEL(CreerVect((TShortInt)0, &BetaPred2));


/* APPEL  DE NLEtape */
  for(Etape=1; Etape<=CtxPuss->NbEtapes; Etape++)
    {
    IndEtap = Etape - 1; /* indice dans les structures */

    switch(Etape)
      {
      case 1:
        APPEL(NLEtape(Etape, Donnees, Modele, CtxPuss, &(CtxNum[IndEtap]),
              &ThetaPred1, &ThetaPred2, &BetaPred1, &BetaPred2,
              &(ResStat[IndEtap].Ajustes.Valf),
              &(ResStat[IndEtap].FctSensib.DValf),
              &(Theta[IndEtap]), &(Beta[IndEtap]), 
              &(CTheta[IndEtap]), &(CBeta[IndEtap]),
              &(CThetaE[IndEtap]), &(CBetaE[IndEtap]),
              &(ResNum[IndEtap]), &(ResStat[IndEtap]),
              &(NbItSv[IndEtap]),
              ItNum[IndEtap], ItStat[IndEtap],
              ItTheta[IndEtap], ItBeta[IndEtap],
              ItDirec[IndEtap], ItOmega[IndEtap]));


         break;
      case 2:
        APPEL(NLEtape(Etape, Donnees, Modele, CtxPuss, &(CtxNum[IndEtap]),
              &(Theta[IndEtap-1].Estim), &ThetaPred2, 
              &(Beta[IndEtap-1].Estim), &BetaPred2,
              &(ResStat[IndEtap].Ajustes.Valf),
              &(ResStat[IndEtap].FctSensib.DValf),
              &(Theta[IndEtap]), &(Beta[IndEtap]), 
              &(CTheta[IndEtap]), &(CBeta[IndEtap]),
              &(CThetaE[IndEtap]), &(CBetaE[IndEtap]),
              &(ResNum[IndEtap]), &(ResStat[IndEtap]),
              &(NbItSv[IndEtap]),
              ItNum[IndEtap], ItStat[IndEtap],
              ItTheta[IndEtap], ItBeta[IndEtap],
              ItDirec[IndEtap] ,ItOmega[IndEtap]));

         break;
      default:
        APPEL(NLEtape(Etape, Donnees, Modele, CtxPuss, &(CtxNum[IndEtap]),
               &(Theta[IndEtap-1].Estim), &(Theta[IndEtap-2].Estim),
               &(Beta[IndEtap-1].Estim), &(Beta[IndEtap-2].Estim),
              &(ResStat[IndEtap-1].Ajustes.Valf),
              &(ResStat[IndEtap-1].FctSensib.DValf),
              &(Theta[IndEtap]), &(Beta[IndEtap]), 
              &(CTheta[IndEtap]), &(CBeta[IndEtap]),
              &(CThetaE[IndEtap]), &(CBetaE[IndEtap]),
              &(ResNum[IndEtap]), &(ResStat[IndEtap]),
              &(NbItSv[IndEtap]),
              ItNum[IndEtap], ItStat[IndEtap],
              ItTheta[IndEtap], ItBeta[IndEtap],
              ItDirec[IndEtap], ItOmega[IndEtap]));

        break;

      } /* fin du switch */
    } /* fin boucle sur Etape */

  /* Calcul des autres sorties */
  APPEL(NLAutres( Donnees, CtxPuss, CtxNum, Theta, Beta, CTheta, CBeta, CThetaE, CBetaE,
                   ResNum, ResStat));


  /* Desallouer CThetaE */
  for(Etape=1; Etape<=CtxPuss->NbEtapes; Etape++)
    {
    IndEtap = Etape - 1; /* indice dans les structures */
    if (CThetaE[IndEtap].Ctr ==VRAI)
      {
/*
      if ((CThetaE[IndEtap].EgalP.nbele >0) &&
	  (CThetaE[IndEtap].EgalP.donnees != NULL))
       DetruVectShort(&(CThetaE[IndEtap].EgalP));
*/

      if (CThetaE[IndEtap].EgalN.nbele >0)
       DetruVect(&(CThetaE[IndEtap].EgalN));
      if (CThetaE[IndEtap].BInf.nbele >0)
       DetruVect(&(CThetaE[IndEtap].BInf));
      if (CThetaE[IndEtap].BSup.nbele >0)
       DetruVect(&(CThetaE[IndEtap].BSup));
      }
    if (CBetaE[IndEtap].Ctr ==VRAI)
      {
	/*
      if (CBetaE[IndEtap].EgalP.nbele >0)
       DetruVectShort(&(CBetaE[IndEtap].EgalP));
	*/
      if (CBetaE[IndEtap].EgalN.nbele >0)
       DetruVect(&(CBetaE[IndEtap].EgalN));
      if (CBetaE[IndEtap].BInf.nbele >0)
       DetruVect(&(CBetaE[IndEtap].BInf));
      if (CBetaE[IndEtap].BSup.nbele >0)
       DetruVect(&(CBetaE[IndEtap].BSup));
      }
    } /* fin boucle sur Etape */

return(OK);
}
