
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
/* ------------------------------------------------------- */

/* Programme d'interface entre C et un programme de calcul 
   du modele ecrit en Fortran:
   Conversion des arguments de type TShortInt en type int
 -------------------------------------------------------- */

/*--------------- INCLUDES -----------------------*/

#include "nlcodes.h"
#include "nltypes.h"
#include "errcodes.h"

/*----------------FONCTIONS EXTERNES ------------*/
 int mycalcfx_(int * nbt, int * nbg, int * nbl, int * nbc,
	     double *t, double *g, double *x, double *f, double *df,
	     int * le, int *ie);

int mycalcvx_ (int *nbtheta,int *nbbeta,int *nbgamma,int *nbobs,int *nbvar,
	     double *theta,double *beta,
	     double *gamma,double *fmod,double *dfmod,
	     double *x,
             double *vmod, double *dvmodt, double *dvmodb,
	     int *le,int *ie);

 int mycalcinvf_( int *nbp,  int *nbga, 
		     int *nbl,  int *nbgv,
		    double *p, double *ga, double *ord,
		    double *gv, double *abs, 
		    double *dabsdp, double *dabsdo, 
		    double *varord,  int *le,  int *ie);

/* ----------------------------------------------------------------------
             Fonction calcinvf_
 ----------------------------------------------------------------------- */
      TShortInt calcinvf_ (nbp, nbga, nbl, nbgv, p, ga, ord,
                gv, abs, dabsdp, dabsdo, varord, le, ie)

/* ................. Arguments d'entree ................................... */
 TShortInt nbp, nbga, nbl, nbgv;
 TDouble *p, *ga, *gv, *ord;

/* ................. Arguments de sortie ................................. */
 TDouble *abs, **dabsdp, *dabsdo, *varord;
 TShortInt *le, *ie;

{
TShortInt Code;
int nbpf, nbgaf, nblf, nbgvf, lef, ief;
int Codee;
  /* Conversion des arguments d'entree */
  nbpf = (int)nbp;
  nbgaf = (int)nbga;
  nblf = (int)nbl;
  nbgvf = (int)nbgv;

  /* Appel du programme Fortran */
  Codee = mycalcinvf_( &nbpf, &nbgaf, &nblf, &nbgvf,
                     p ,ga, ord, gv, abs, &(dabsdp[0][0]),
                     dabsdo, varord, &lef,&ief); 
  /* Conversion des arguments de sortie et du retour de la 
     fonction */
  *le =(TShortInt)lef;
  *ie = (TShortInt)ief;
  Code = (TShortInt)Codee;
  return(Code);
}


/* ----------------------------------------------------------------------
             Fonction calcfx_
 ----------------------------------------------------------------------- */
      TShortInt calcfx_ (nbtheta,nbgamma,nbobs,nbvar,
                        theta,gamma,x,fmod,dfmod,le,ie)
/* ................. Arguments d'entree ................................... */
 TShortInt nbtheta, nbgamma, nbobs, nbvar;
 TDouble *theta, *gamma, **x;
/* ................. Arguments de sortie ................................. */
 TDouble *fmod, **dfmod;
 TShortInt *le, *ie;

{
TShortInt Code;
int nbthetaf, nbgammaf, nbobsf, nbvarf, lef, ief;
int Codee;
  /* Conversion des arguments d'entree */
  nbthetaf = (int)nbtheta;
  nbgammaf = (int)nbgamma;
  nbobsf = (int)nbobs;
  nbvarf = (int)nbvar;

  /* Appel du programme Fortran */
  Codee = mycalcfx_( &nbthetaf, &nbgammaf, &nbobsf, &nbvarf,
                     theta ,gamma, &(x[0][0]),fmod,
                     &(dfmod[0][0]),&lef,&ief); 
  /* Conversion des arguments de sortie et du retour de la 
     fonction */
  *le =(TShortInt)lef;
  *ie = (TShortInt)ief;
  Code = (TShortInt)Codee;
  return(Code);
}

/* ----------------------------------------------------------------------
             Fonction calcvx_
 ----------------------------------------------------------------------- */
      TShortInt calcvx_ (nbtheta,nbbeta,nbgamma,nbobs,nbvar,
                        theta,beta,gamma,fmod,dfmod,x,
                        vmod, dvmodt, dvmodb,le,ie)
/* ................. Arguments d'entree ................................... */
 TShortInt nbtheta, nbbeta, nbgamma, nbobs, nbvar;
 TDouble *theta, *beta, *gamma, *fmod, **dfmod, **x;
/* ................. Arguments de sortie ................................. */
 TDouble *vmod, **dvmodt, **dvmodb;
 TShortInt *le, *ie;

{
TShortInt Code;
int nbthetaf, nbbetaf, nbgammaf, nbobsf, nbvarf, lef, ief;
int Codee;
  /* Conversion des arguments d'entree */
  nbthetaf = (int)nbtheta;
  nbbetaf = (int)nbbeta;
  nbgammaf = (int)nbgamma;
  nbobsf = (int)nbobs;
  nbvarf = (int)nbvar;
  /* Appel du programme Fortran */
  Codee = mycalcvx_( &nbthetaf, &nbbetaf, &nbgammaf, &nbobsf, &nbvarf,
                     theta , beta, gamma,fmod, &(dfmod[0][0]), &(x[0][0]),
                     vmod, &(dvmodt[0][0]), &(dvmodb[0][0]),&lef,&ief);
  /* Conversion des arguments de sortie et du retour de la 
     fonction */
  *le =(TShortInt)lef;
  *ie = (TShortInt)ief;
  Code = (TShortInt)Codee;
  return(Code);
}
