/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <math.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"

/* pour l'appel de analder */
#include "dftypes.h" 


/*--------------- VARIABLES EXTERNES -------------*/
 /* les variables globales de analDer */
TModSpecif GModSpecif;
TDerivees Derivees;

/* les donnees */
TDonnees Donnees;

/* dcl des sorties de analDer */
 TRetModele RetModele;
  TRetInteg RetInteg;
 int monyylineno;

/*----------------FONCTIONS EXTERNES ------------*/
extern TShortInt analDer(TChaine NomDescr, int gfile, TRetModele * RetModele, 
		  TRetInteg * RetInteg);

/*--------------- Identification fonction ----------
| Nom de la fonction    : initglob                 |
| Role                  : initialisation des       |
|  variables globales de analDer                   |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: analDernls2                      |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void initglob()
/*--------------- Fin identification fonction ----*/
{
int i;

Derivees.DerivF.nbele=0;
Derivees.DerivV.nbele=0;
Derivees.DerivAux.nbele=0;
Derivees.DerivSedo.nbele=0;
Derivees.DerivJac.nbele=0;

GModSpecif.PPident.nbele=0;
GModSpecif.IdeF.ident=0;
GModSpecif.IdeV.ident=0;
GModSpecif.IdeX.nbele=0;
GModSpecif.IdeTheta.nbele=0;
GModSpecif.IdeBeta.nbele=0;
GModSpecif.IdeGamF.nbele=0;
GModSpecif.IdeGamV.nbele=0;
GModSpecif.IdeLesDF.nbele=0;
GModSpecif.IdeLesF.nbele=0;
GModSpecif.IdeVarInt=0;
GModSpecif.IdeValInt.nbele=0;
GModSpecif.IdeCondInit.nbele=0;
GModSpecif.Resp=0;
GModSpecif.Vari=0;
GModSpecif.CasSedo=0;
GModSpecif.Auxiliaire.nbele=0;
GModSpecif.Constantes.nbele=0;
GModSpecif.IndicTj.nbele=0;
GModSpecif.IndicX=0;
GModSpecif.NbThetaSedo=0;
GModSpecif.Subroutine=0;
for (i=0;i<17;i++)
  {GModSpecif.typeUsed[i]=0;}
GModSpecif.Unique=0;
GModSpecif.yaerr=0;
GModSpecif.erraff=0;
GModSpecif.AuxVar.nbele=0;
GModSpecif.AuxResp.nbele=0;
GModSpecif.AuxSedo.nbele=0;

monyylineno=0;

}
/*--------------- Fin fonction initglob -------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : analDernls2              |
| Role                  : appeler l'analyseur      |
|  formel et renvoyer les parametres de sorties    |
| Parametres d'entree   :                          |
|  ficmod: nom du fichier                          |
| Parametres de sortie  :                          |
|   le reste: voir notices NL et analDer           |
|   Code: OK ou ERR                                |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   :  analDer                  |
| Fonctions appelantes :                           |
|   la fonction S analDernls2                      |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void analDernls2(ficmod, NbThetaSedo, Code)

/* arguments d'entree */
char **ficmod;

/* arguments de sortie */
TFuncInt *NbThetaSedo;
TFuncInt *Code;

/*--------------- Fin identification fonction ----*/

{

int gfile=0; /* on veut pas generer un fichier */
 char NomModele[255];
strcpy(NomModele, *ficmod);

/* Appel de analDer */
/* ----------------- */

  if (analDer(NomModele, gfile, &RetModele, &RetInteg) == FAUX)
    {
     fprintf(stderr,
"\n Error in the execution of the formal derivator\n");
     *Code=ERR;
     return;
    }

*NbThetaSedo=(TFuncInt)RetInteg.NbThetaSedo;
*Code=(TFuncInt)OK;

return;
}
/* -------------- Fin fonction analDernls2 ----------------- */

