#ifndef CODESH
#define CODESH

/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : nlcodes.sh/ES0/e1/i9      |
| Date                 : 27Sep91 / 15:31:52        |
| Derniere mise a jour : 10Sep91 / 11:11:00        |
| Concepteur           : A. Bouvier                |
| Role                 : definition des constantes:| 
|                         d'interet general,       |
|                         specifiques a NL,        |
|                         et des codes d'erreur    |
| Reference conception : Normes programmation      |
|                         ( Annexe)                |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|Iteration 001 ___ Thu May 23 14:44:34 1991
|Creation
----------------------------------------------*/
#line 21
/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */
/*.... DEFINITIONS DE CONSTANTES D'INTERET GENERAL ........................ */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */

/* ........ valeur indefinie : ............................................ */
#ifndef UNDEF
#define UNDEF -1 
#endif

/* ........ valeurs logiques : VRAI-FAUX................................... */
#ifndef VRAI
#define FAUX 0
#define VRAI 1
#endif

/* ........ valeurs logiques : OUI-NON...................................... */
#ifndef OUI
#define NON 0
#define OUI 1
#endif

/* ........ code de debut de fichier utilise par fseek (norme ANSI) : ..... */
#ifndef SEEK_SET
#define SEEK_SET 0
#endif

/* la constante zero en double precision */
#define ZERO 0.0


/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */
/*.... DEFINITIONS DE CONSTANTES POUR  DES CODAGES STATISTIQUES...........  */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */

#define DEFAUT -1 /* on laisse le programme choisir */

/* ........ LES VALEURS DE Algo.......................................... */
/* incluent aussi DEFAUT */
#define  GN    1 /* Gauss-Newton */
#define  GM    2 /* Gauss-Marquardt */

/* ........ LES VALEURS DE Estim .......................................... */
/* incluent aussi DEFAUT */
#define MVTB    1 /* MV(theta,beta) */
#define MCMTB   2 /* MCM(theta,beta) */
#define MVT     4 /* MV(theta) */
#define MCPT    5 /* MCP(theta) */
#define MCOT    6 /* MCO(theta) */
#define MCMT    7 /* MCM(theta) */
#define MCPVIT  8 /* MCPVI(theta) */
#define MCOB    9 /* MCO(beta) */
#define MCMB   10 /* MCM(beta) */
#define QVTB    11 /* QuasiLikelihood = MCMTB */
#define QVT     12 /* QuasiLikelihood = MCMT */
#define QVB    13 /* QuasiLikelihood = MCMB */
#define LEMIEN 14 /* un estimateur fourni par l'utilisateur */

/* ........ LES VALEURS DE Famille ........................................ */
#define GAUSS 1
#define POISSON 2
#define BINOM 3
#define BERNOULLI 4
#define MULTINOM 5

/* ........ LES VALEURS DE LieuErr......................................... */
#define F 1 /* erreur dans le calcul de f */
#define V 2 /* erreur dans le calcul de v */
#define DFDT 3 /* erreur dans le calcul des derivees de f par rapport aux theta */
#define DVDT 4 /* erreur dans le calcul des derivees de v par rapport aux theta */
#define DVDB 5 /* erreur dans le calcul des derivees de v par rapport aux beta */
#define A 6 /* erreur dans le calcul des variables auxiliaires du modele */
#define DADT 7 /* erreur dans le calcul des derivees des auxiliaires par rapport aux theta */
#define DADB 8 /* erreur dans le calcul des derivees des auxiliaires par rapport aux beta */
#define AUXF 9 /* erreur dans le calcul des variables auxiliaires du modele de f */
#define AUXV 10 /* erreur dans le calcul des variables auxiliaires du modele de v */
/* ces 2 dernieres valeurs sont determinees par CModele a partir des
   sorties de calcf_ ou ModSedo: transformation du code A */
#define SEDO 11 /* erreur dans le calcul du sedo */

/* ........ LES VALEURS DE Symm .......................................... */
/* incluent aussi DEFAUT */
#define SYM     1 /* si la matrice est symetrique */
#define SYMBLOC 2 /* si elle est symetrique par blocs */
#define NONSYM  3 /* s'il s'agit d'une matrice carree quelconque. */

/* ........ LES VALEURS DE TypeCritStat .................................. */
#define CLV        1 /* english: LOGV  -2 Log(Vraisemblance) */
#define CARRET     2 /* english: STOPCRIT egal au critere d'arret */
#define CSCRNP     3 /* english: NWSST somme des carres non ponderee (cf Tn Reference Manual) */
#define CSCRPV     4 /* english: VWSS somme des carres ponderee  par variance (cf Sn) */
#define CSCRPS2    5 /* english: IVWSS somme des carres ponderee  par Sigma (cf Un) */
#define CSCR2NP    6 /* english: NWSSB (cf Rn) */
#define CRITSIG    7 /* english: SIGMA2 le critere stat est egal a Sigma */

/* ........ LES VALEURS DE TypeMu ....................................... */
/*  incluent aussi DEFAUT, CONNU */
#define MUGAUSS    2 /* les moments sont ceux d'une gaussienne: mu3=0,mu4=3*v^4 */
#define MURES      3 /* variance des erreurs supposee constante: 
                          estimation a partir des residus */
#define MURESREPET 4 /* il y a au moins MINREPMU repet en chaque point:
                          estimation a partir des residus sur les repet */

/* ........ LES VALEURS DE TypeSigma...................................... */
/* incluent aussi DEFAUT */
#define CONNU    1
#define VARREPET 2  /* estimation par la variance intra-repet */
#define VARRESID   3  /* estimation par la variance residuelle */
#define IGNORE 4 /* il n'y a pas de sigma dans l'estimation de la variance */
#define VARINTRA 5 /* cas de MCPVIT: variance intra-repet */

/* ........ LES VALEURS DE Vari ........................................... */
/* incluent aussi DEFAUT */
#define CTE 1 /* la variance est constante (V_i=sigma^2) */
#define SP  2 /* la variance est ponderee: (V_i=sigma^2/ p_i) */
#define VST 3 /* la variance depend de theta seulement:
                   V_i = sigma^2* v(x_i,theta)/p_i.  */
#define VB  4 /* la variance depend de beta seulement:
                   V_i = v(x_i,beta)/p_i.  */
#define VSB 5 /* la variance depend de beta seulement et est
                 connue au coefficient sigma^2 pres:
                  V_i = sigma^2* v(x_i,beta)/p_i. */
#define VSTB 6 /* la variance depend de theta et beta et est
                 connue au coefficient sigma^2 pres:
                V_i=sigma^2*v(x_i,theta,beta)/p_i. */
#define  VTB 7 /* la variance depend de theta et beta:
                 V_i=v(x_i,theta,beta)/p_i.  */

#define VI 8 /* cas de MCPVIT: variance intra-repet:
                V_i= S2_i et sigma =1 */ 

/* .................................................. */
/* .....POUR LA GESTION DES IP ET ERREURS ........... */
/* .................................................. */

/* COURT indique qu'on veut l'impression des messages sous forme courte */
#define COURT 0

/* LONG indique qu'on veut l'impression des messages sous forme courte et
 longue */
#define LONG 1

#define EXIT 0   /* sortie par exit en cas d'erreur */
#define RETURN 1 /* sortie par return en cas d'erreur */


/* .....  types des messages a imprimer ....................................... */
#define IMP      0       /*  impression intermediaire */
#define ERR      1       /*  erreur */
#define TRACE    2       /*  trace */
#define WANALY 3       /*  warning de l'analyseur  */
#define WINTEG 4       /*  warning de l'integrateur  */
#define WNUMER 5       /*  warning numerique */
#define WMETHO 6       /*  warning methodologique */


/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */
/*.... DEFINITIONS DE CONSTANTES POUR  LES CODES D'ERREUR      ...........  */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  */

#define OK 0
#define ERRALLOC 661

/* code d'erreur dans une fonction math */
#define ERRMATH 150

#endif
