
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <float.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"
#include "nlglobal.h"

/*--------------- VARIABLES GLOBALES -------------*/
long nn; /* used in calls to mysignaling_nan */


/*--------------- VARIABLES EXTERNES -------------*/
#include "nldcl.h"     /* les arguments de NL */
#include "dftypes.h"

/*--------------- Identification fonction ----------
| Nom de la fonction    : recupCodeNa
| Role                  : recuperer le code adopte |
|  dans le C pour coder les val. manquantes de     |
| facon a le communiquer aux fonctions S           |
--------------------------------------------------*/
void recupCodeNa(codeNa)
double *codeNa;
{

 *codeNa = (double) mysignaling_nan(nn); 

return;
}



/*--------------- Identification fonction ----------
| Nom de la fonction    : recupDatanls2             |
| Role                  : recuperer ce qui concerne|
|  les donnees                                     |
| Parametres d'entree   :                          |
|  k: voir notice NL                               |
|  NbObsLu: nombre total d'observations+ nombre de |
|           poids nuls                             |
|  wanted: 1 si on veut tout
| Parametres de sortie  :                          |
|     voir notice NL                               |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupDatanls2                     |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void recupDatanls2(wanted,
     k, NbObsLu,NomObs, NomObsT, NbRepet,PoidsT, Y1,Y2,S2)

/* scalaire */
TFuncInt  *wanted, *k,  *NbObsLu;
/* vecteurs dimension k ou NbObsLu */
char ***NomObs, ***NomObsT;
TFuncInt *NbRepet;
double *PoidsT, *Y1, *Y2, *S2;
{
/*--------------- Fin identification fonction ----*/
TShortInt  i;

for(i=0;i< *k; i++)
  {
  if (*wanted == 1)
    {
  NbRepet[i]=(TFuncInt)Donnees.NbRepet.donnees[i];
  Y1[i]=(double)Donnees.StatDon.Y1.donnees[i]; 
  Y2[i]=(double)Donnees.StatDon.Y2.donnees[i]; 
  S2[i]=(double)Donnees.StatDon.S2.donnees[i]; 
    }
  strcpy((NomObs[i]), Donnees.NomObs.donnees[i]);
  }

for(i=0;i< *NbObsLu; i++)
  {
  strcpy((NomObsT[i]), Donnees.NomObsT.donnees[i]);
  if (Donnees.PoidsT.nbele >0)
    {
    PoidsT[i]= Donnees.PoidsT.donnees[i];
    }
  else
    {
     PoidsT[i]=1;
    }
  }


return;

}
/* -------------- Fin fonction recupDatanls2 ----------------- */

/*--------------- Identification fonction ----------
| Nom de la fonction    : recupCtxnls2             |
| Role                  : recuperer ce qui concerne|
|  CtxPuss                                         |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
|     voir notice NL                               |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupCtxnls2                     |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void recupCtxnls2(
         Algo, DirecC, Lambda0, LambdaC1, LambdaC2,
         MaxCritArret, MaxDeb, MaxErr, MaxIter,MaxLambda,
         OmegaPas, TypeMu, TypeSigma, Famille
         )
TFuncInt *Algo;
double *DirecC, *Lambda0, *LambdaC1, *LambdaC2, *MaxCritArret;
TFuncInt *MaxDeb,*MaxErr, *MaxIter;
double *MaxLambda;
double *OmegaPas;
TFuncInt *TypeMu, *TypeSigma, *Famille;
{
/*--------------- Fin identification fonction ----*/

*Algo=(TFuncInt)CtxPuss.Algo;
*DirecC=(double)CtxPuss.DirecC;
*Lambda0=(double)CtxPuss.Lambda0;
*LambdaC1=(double)CtxPuss.LambdaC1;
*LambdaC2=(double)CtxPuss.LambdaC2;
*MaxCritArret=(double)CtxPuss.MaxCritArret;
*MaxDeb=(TFuncInt)CtxPuss.MaxDeb;
*MaxErr=(TFuncInt)CtxPuss.MaxErr;
*MaxIter=(TFuncInt)CtxPuss.MaxIter;
*MaxLambda=(double)CtxPuss.MaxLambda;
*OmegaPas=(TFuncInt)CtxPuss.OmegaPas;
*TypeMu=(TFuncInt)CtxPuss.TypeMu;
*TypeSigma=(TFuncInt)CtxPuss.TypeSigma;
 *Famille=(TFuncInt)CtxPuss.Famille;
return;

}
/* -------------- Fin fonction recupCtxnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : recupPnls2               |
| Role                  : recuperer les valeurs    |
|  estimees des parametres                         |
|  a l'etape 'ietap'                               |
| Parametres d'entree   :                          |
|   pmult, qmult: voir notice NL                   |
| Parametres de sortie  :                          |
|   ThetaRes,BetaRes:                              |
|   les valeurs  estimees des parametres           |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupPnls2                       |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void recupPnls2(ietap, pmult, qmult,
         ThetaRes,BetaRes
         )
TFuncInt *ietap, *pmult, *qmult;

double *ThetaRes, *BetaRes;
{
/*--------------- Fin identification fonction ----*/
TShortInt i,j;

i= *ietap-1;

  if (Theta[i].Estim.nbele >0)
    {
    for(j=0;j<Theta[i].Estim.nbele;j++)
      {
      ThetaRes[j]=Theta[i].Estim.donnees[j];
      }
    }
  else
    {
    for(j=0;j<*pmult;j++)
      {
      ThetaRes[j]=(double)mysignaling_nan(nn);
      }
    }
  
  if (Beta[i].Estim.nbele>0)
    {
    for(j=0;j<Beta[i].Estim.nbele;j++)
      {
      BetaRes[j]=Beta[i].Estim.donnees[j];
      }
    }
  else
    {
    for(j=0;j<*qmult;j++)
      {
      BetaRes[j]=(double)mysignaling_nan(nn);
      }
    }

return;

}
/* -------------- Fin fonction recupPnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : recupNumnls2             |
| Role                  : recuperer les resultats  |
|  numeriques                                      |
|  a l'etape 'ietap'                               |
| Parametres d'entree   :                          |
|  ietap: voir notice NL                        |
| Parametres de sortie  :                          |
|  voir notice NL                                  |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupNumnls2                     |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void recupNumnls2(
         ietap,
         CodePuss,
         CritArret, CritStat, Lambda, Log,
	 LogFamille, Deviance,
         NbIter,Norme,Scr,ScrNP,Sigma,
	 ResidusDev
         )
/* scalaire */
TFuncInt    *ietap; 

TFuncInt  *CodePuss;
double *CritArret, *CritStat, *Lambda, *Log, *LogFamille, *Deviance;
TFuncInt *NbIter;
double  *Norme, *Scr, *ScrNP, *Sigma, *ResidusDev ;
{
/*--------------- Fin identification fonction ----*/
TShortInt  i,j ;

i= *ietap-1;

*CodePuss=(TFuncInt)ResNum[i].CodePuss;
*CritArret=(double)ResNum[i].CritArret;
*CritStat=(double)ResNum[i].CritStat;
*Lambda=(double)ResNum[i].Lambda;
*Log=(double)ResNum[i].Log;
*LogFamille=(double)ResNum[i].LogFamille;
*Deviance=(double)ResNum[i].Deviance;
*NbIter=(TFuncInt)ResNum[i].NbIter;
*Norme=(double)ResNum[i].Norme;
*Scr=(double)ResNum[i].Scr;
*ScrNP=(double)ResNum[i].ScrNP;
*Sigma=(double)ResNum[i].Sigma;

  if(ResNum[i].ResidusDev.nbele>0)
    {
    for(j=0;j<ResNum[i].ResidusDev.nbele;j++)
      {
      ResidusDev[j]=ResNum[i].ResidusDev.donnees[j];
      }
    }
return;

}
/* -------------- Fin fonction recupNumnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : recupStat1nls2            |
| Role                  : recuperer les resultats  |
|  statistiques                                    |
|  a l'etape 'ietap'                               |
| Parametres d'entree   :                          |
|  ietap, k, n, pbase, qbase, pmult, qmult,     |
|  pact,qact,nh: voir notice NL                    |
| Parametres de sortie  :                          |
|  voir notice NL                                  |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupStatnls2                    |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void recupStat1nls2(
           wfitted,           wasvar,           wbvarzb,
           wcorrelation,
         ietap, k, n, 
         pbase, qbase, pmult, qmult, pact,qact,nh,
         Valf, VarY,
         AsVar, BVarZBP, Corr
              )

TFuncInt       *wfitted,           *wasvar,           *wbvarzb,
           *wcorrelation;
TFuncInt  *ietap, *k, *n, *pbase, *qbase, *pmult, *qmult,
      *pact, *qact, *nh; 

double   *Valf, *VarY;
double  *AsVar,  *BVarZBP, *Corr;


{
/*--------------- Fin identification fonction ----*/
TShortInt i, j,l, multtot, acttot; 
 TShortInt indAsVar, indBVarZBP, indCorr;

multtot=*pmult + *qmult;

indAsVar=0;
indBVarZBP=0;
indCorr=0;

i=*ietap-1;

acttot = *pact + *qact;

if (*wfitted==1)
  {
  if (ResStat[i].Ajustes.Valf.nbele>0)
    {
    for(j=0;j<ResStat[i].Ajustes.Valf.nbele;j++)
      {
      Valf[j]=ResStat[i].Ajustes.Valf.donnees[j];
      }
    }
  else
    {

    for(j=0;j<*k;j++)
      {
      Valf[j]=(double)mysignaling_nan(nn);
      }
    }


  if (ResStat[i].Ajustes.VarY.nbele >0)
    {
    for(j=0;j<ResStat[i].Ajustes.VarY.nbele;j++)
      {
      VarY[j]=ResStat[i].Ajustes.VarY.donnees[j];
      }
    }
  else
    {
    for(j=0;j<*k;j++)
      {
      VarY[j]=(double)mysignaling_nan(nn);
      }
    }
  } /* fin wfitted */

if (*wasvar==1)
  {
  if(ResStat[i].AsVar.nblig>0)
    {
    for(j=0; j<ResStat[i].AsVar.nblig;j++)
      {
      for (l=0; l<ResStat[i].AsVar.nbcol; l++)
        {
        AsVar[indAsVar]=ResStat[i].AsVar.donnees[j][l];
        indAsVar=indAsVar+1;
        }
      }
    }
  else
    {
    for(j=0; j< (multtot*multtot) ;j++)
      {
      AsVar[j]=(double)mysignaling_nan(nn);
      }
    }
  }

if (*wbvarzb==1)
  {
  if(ResStat[i].BVarZBP.nblig>0)
    {
    for(j=0; j<ResStat[i].BVarZBP.nblig;j++)
      {
      for (l=0; l<ResStat[i].BVarZBP.nbcol; l++)
        {
        BVarZBP[indBVarZBP]=ResStat[i].BVarZBP.donnees[j][l];
        indBVarZBP=indBVarZBP+1;
        }
      }
    }
  else
    {
    for(j=0; j<(acttot * acttot);j++)
      {
      BVarZBP[j]=(double)mysignaling_nan(nn);
      }
    }
  }

if (*wcorrelation==1)
  {
  if(ResStat[i].Corr.nblig>0)
    {
    for(j=0; j<ResStat[i].Corr.nblig;j++)
      {
      for (l=0; l<ResStat[i].Corr.nbcol; l++)
        {
        Corr[indCorr]=ResStat[i].Corr.donnees[j][l];
        indCorr=indCorr+1;
        }
      }
    }
  else
    {
    for(j=0; j<(multtot * multtot) ;j++)
      {
      Corr[j]=(double)mysignaling_nan(nn);
      }
    }
  }


return;

}
/* -------------- Fin fonction recupStat1nls2 ----------------- */



/*--------------- Identification fonction ----------
| Nom de la fonction    : recupEquNnls2            |
| Role                  : recuperer les resultats  |
|  statistiques                                    |
|  a l'etape 'ietap'                               |
| Parametres d'entree   :                          |
|  ietap, k, n, pbase, qbase, pmult, qmult,     |
|  pact,qact,nh: voir notice NL                    |
| Parametres de sortie  :                          |
|  voir notice NL                                  |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupStatnls2                    |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void recupEquNnls2(
         ietap, k, n, 
         pbase, qbase, pmult, qmult, pact,qact,nh,
         ValB,ValD,ValEta
              )

TFuncInt  *ietap, *k, *n, *pbase, *qbase, *pmult, *qmult,
      *pact, *qact, *nh; 

double *ValB, *ValD,  *ValEta;

{
/*--------------- Fin identification fonction ----*/
TShortInt i, j,l, multtot, acttot; 
TShortInt     indValB,indValD;


multtot=*pmult + *qmult;
indValB=0;
indValD=0;

i=*ietap-1;

acttot = *pact + *qact;


  if (ResStat[i].EquN.ValB.nblig>0)
    {
    for(j=0; j<ResStat[i].EquN.ValB.nblig;j++)
      {
      for (l=0; l<ResStat[i].EquN.ValB.nbcol; l++)
        {
        ValB[indValB]=ResStat[i].EquN.ValB.donnees[j][l];
        indValB=indValB+1;
        }
      }
    }
  else
    {
    for(j=0; j<(*nh * acttot);j++)
      {
      ValB[j]=(double)mysignaling_nan(nn);
      }
    }

  if(ResStat[i].EquN.ValD.nblig>0)
    {
    for(j=0; j<ResStat[i].EquN.ValD.nblig;j++)
      {
      for (l=0; l<ResStat[i].EquN.ValD.nbcol; l++)
        {
        ValD[indValD]=ResStat[i].EquN.ValD.donnees[j][l];
        indValD=indValD+1;
        }
      }
    }
  else
    {
    for(j=0; j<(*nh * acttot);j++)
      {
      ValD[j]=(double)mysignaling_nan(nn);
      }
    }

  if(ResStat[i].EquN.ValEta.nbele>0)
    {
    for(j=0;j<ResStat[i].EquN.ValEta.nbele;j++)
      {
      ValEta[j]=ResStat[i].EquN.ValEta.donnees[j];
      }
    }
  else
    {
    for(j=0;j<*nh;j++)
      {
      ValEta[j]=(double)mysignaling_nan(nn);
      }
    }


return;

}
/* -------------- Fin fonction recupEquNnls2 ----------------- */




/*--------------- Identification fonction ----------
| Nom de la fonction    : recupStat2nls2            |
| Role                  : recuperer les resultats  |
|  statistiques                                    |
|  a l'etape 'ietap'                               |
| Parametres d'entree   :                          |
|  ietap, k, n, pbase, qbase, pmult, qmult,     |
|  pact,qact,nh: voir notice NL                    |
| Parametres de sortie  :                          |
|  voir notice NL                                  |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupStatnls2                    |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void recupStat2nls2(
           wderivfct,
           wmu,           wresiduals,           ww,           wz,
         ietap, k, n, 
         pbase, qbase, pmult, qmult, pact,qact,nh,
         DValf, DVarYTheta,  DVarYBeta,
         Mu3, Mu4,Residus, ResidusR,
         ValW, ValZ
              )

TFuncInt            *wderivfct,
           *wmu,           *wresiduals,           *ww,           *wz ;
TFuncInt  *ietap, *k, *n, *pbase, *qbase, *pmult, *qmult,
      *pact, *qact, *nh; 

double *DValf, *DVarYTheta, *DVarYBeta;
double *Mu3, *Mu4, *Residus, *ResidusR;
double *ValW, *ValZ;


{
/*--------------- Fin identification fonction ----*/
TShortInt i, j,l, multtot, acttot; 
TShortInt   indDValf, indDVarYTheta, indDVarYBeta,
          indValW;


multtot=*pmult + *qmult;

indDValf=0;
indDVarYTheta=0;
indDVarYBeta=0;
indValW=0;

i=*ietap-1;

acttot = *pact + *qact;

if (*wderivfct ==1)
  {
  if(ResStat[i].FctSensib.DValf.nblig>0)
    {
    for(j=0; j<ResStat[i].FctSensib.DValf.nblig;j++)
      {
      for (l=0; l<ResStat[i].FctSensib.DValf.nbcol; l++)
        {
        DValf[indDValf]=ResStat[i].FctSensib.DValf.donnees[j][l];
        indDValf=indDValf+1;
        }
      }
    }
  else
    {
    for(j=0; j<(*k * *pbase) ;j++)
      {
      DValf[j]=(double)mysignaling_nan(nn);
      }
    }
  if(ResStat[i].FctSensib.DVarYTheta.nblig>0)
    {
    for(j=0; j<ResStat[i].FctSensib.DVarYTheta.nblig;j++)
      {
      for (l=0; l<ResStat[i].FctSensib.DVarYTheta.nbcol; l++)
        {
        DVarYTheta[indDVarYTheta]=ResStat[i].FctSensib.DVarYTheta.donnees[j][l];
        indDVarYTheta=indDVarYTheta+1;
        }
      }
    }
  else
    {
    for(j=0; j<(*k * *pbase);j++)
      {
      DVarYTheta[j]=(double)mysignaling_nan(nn);
      }
    }

  if(ResStat[i].FctSensib.DVarYBeta.nblig>0)
    {
    for(j=0; j<ResStat[i].FctSensib.DVarYBeta.nblig;j++)
      {
      for (l=0; l<ResStat[i].FctSensib.DVarYBeta.nbcol; l++)
        {
        DVarYBeta[indDVarYBeta]=ResStat[i].FctSensib.DVarYBeta.donnees[j][l];
        indDVarYBeta=indDVarYBeta+1;
        }
      }
    }
  else
    {
    for(j=0; j<(*k * *qbase);j++)
      {
      DVarYBeta[j]=(double)mysignaling_nan(nn);
      }
    }
  }

if (*wmu ==1)
  {
  if(ResStat[i].Mu3.nbele>0)
    {
    for(j=0;j<ResStat[i].Mu3.nbele;j++)
      {
      Mu3[j]=ResStat[i].Mu3.donnees[j];
      }
    }
  else
    {
    for(j=0;j<*k;j++)
      {
      Mu3[j]=(double)mysignaling_nan(nn);
      }
    }
   
  if(ResStat[i].Mu4.nbele>0)
    {
    for(j=0;j<ResStat[i].Mu4.nbele;j++)
      {
      Mu4[j]=ResStat[i].Mu4.donnees[j];
      }
    }
  else
    {
    for(j=0;j<*k;j++)
      {
      Mu4[j]=(double)mysignaling_nan(nn);
      }
    }
  }

if (*wresiduals==1)
  {
  if(ResStat[i].Residus.nbele>0)
    {
    for(j=0;j<ResStat[i].Residus.nbele;j++)
      {
      Residus[j]=ResStat[i].Residus.donnees[j];
      }
    }
  else
    {
    for(j=0;j< *n;j++)
      {
      Residus[j]=(double)mysignaling_nan(nn);
      }
    }
  if(ResStat[i].ResidusR.nbele>0)
    {
    for(j=0;j<ResStat[i].ResidusR.nbele;j++)
      {
      ResidusR[j]=ResStat[i].ResidusR.donnees[j];
      }
    }
  else
    {
    for(j=0;j< *n;j++)
      {
      ResidusR[j]=(double)mysignaling_nan(nn);
      }
    }
  }

if (*ww==1)
  {
  if(ResStat[i].ValW.nblig>0)
    {      
    for(j=0; j<ResStat[i].ValW.nblig;j++)
      {
      for (l=0; l<ResStat[i].ValW.nbcol; l++)
        {
        ValW[indValW]=ResStat[i].ValW.donnees[j][l];
        indValW=indValW+1;
        }
      }
    }
  else
    {      
    for(j=0; j<(acttot * acttot);j++)
      {
      ValW[j]=(double)mysignaling_nan(nn);
      }
    }
  }

if (*wz==1)
  {
  if(ResStat[i].ValZ.nbele>0)
    {
    for(j=0;j<ResStat[i].ValZ.nbele;j++)
      {
      ValZ[j]=ResStat[i].ValZ.donnees[j];
      }
    }
  else
    {
    for(j=0;j<*nh;j++)
      {
      ValZ[j]=(double)mysignaling_nan(nn);
      }
    }
  }


return;

}
/* -------------- Fin fonction recupStat2nls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : recupItnls2              |
| Role                  : recuperer les resultats  |
| par iteration sauf le sedo                       |
|  a l'etape 'ietap'                               |
| Parametres d'entree   :                          |
|  ietap, k, pbase, qbase, pmult, qmult,        |
|  pact,qact,nh, nbitsv: voir notice NL            |
| Parametres de sortie  :                          |
|  voir notice NL                                  |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupItnls2                      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void recupItnls2(
         ietap, k, 
         pbase, qbase, pmult, qmult, pact,qact,nh,
         nbitsv,
         CritArret, CritStat,Lambda,
         NbIter,Sigma,
         ThetaRes, BetaRes,
         Valf, VarY,
         ValB,ValD,ValEta,
         DValf, DVarYTheta,  DVarYBeta,
         Direc, Omega
         )

/* scalaires */
TFuncInt  *ietap, *k, *pbase, *qbase, *pmult, *qmult,
      *pact, *qact, *nh; 

TFuncInt *nbitsv;

/* vecteurs en sortie */
double *CritArret, *CritStat, *Lambda, *Sigma;
TFuncInt *NbIter;
double *ThetaRes, *BetaRes;
double   *Valf, *VarY;
double *ValB, *ValD,  *ValEta;
double *DValf, *DVarYTheta, *DVarYBeta;
double *Direc;
double *Omega;

{
/*--------------- Fin identification fonction ----*/
TShortInt i,iter, j,l, acttot; 
TShortInt indNum,
          indTheta, indBeta,
          indValf, indVarY,
          indValB,indValD, indValEta,
          indDValf, indDVarYTheta, indDVarYBeta,
          indDirec, indCritArret, indCritStat, indSigma;

indNum=0;
indTheta=0;
indBeta=0;
indValf=0;
indVarY=0;
indValB=0;
indValD=0;
indValEta=0;
indDValf=0;
indDVarYTheta=0;
indDVarYBeta=0;
indDirec=0;
indCritArret=0;
indCritStat=0;
indSigma=0;

i=*ietap-1;

acttot = *pact+*qact;

  for(iter=0; iter<*nbitsv; iter++)
    {
    /* on recupere dans tous les cas NbIter */
    NbIter[iter]=(TFuncInt)ItNum[i][iter].NbIter;

    if (GNLControle.VouluIt.Ajustes == VRAI)
      {
      if (ItStat[i][iter].Ajustes.Valf.nbele>0)
        {
        for(j=0;j<ItStat[i][iter].Ajustes.Valf.nbele;j++)
          {
          Valf[indValf]=ItStat[i][iter].Ajustes.Valf.donnees[j];
          indValf=indValf+1;
          }
        }
      else
        {
        for(j=0;j<*k;j++)
          {
          Valf[indValf]=(double)mysignaling_nan(nn);
          indValf=indValf+1;
          }
        }
      if (ItStat[i][iter].Ajustes.VarY.nbele >0)
        {
        for(j=0;j<ItStat[i][iter].Ajustes.VarY.nbele;j++)
          {
          VarY[indVarY]=ItStat[i][iter].Ajustes.VarY.donnees[j];
          indVarY=indVarY+1;
          }
        }
      else
        {
        for(j=0;j<*k;j++)
          {
          VarY[indVarY]=(double)mysignaling_nan(nn);
          indVarY=indVarY+1;
          }
        }
      } /* fin VouluIt.Ajustes */


    if (GNLControle.VouluIt.EquN == VRAI)
      {
      if (ItStat[i][iter].EquN.ValB.nblig>0)
        {
        for(j=0; j<ItStat[i][iter].EquN.ValB.nblig;j++)
          {
          for (l=0; l<ItStat[i][iter].EquN.ValB.nbcol; l++)
            {
            ValB[indValB]=ItStat[i][iter].EquN.ValB.donnees[j][l];
            indValB=indValB+1;
            }
          }
        }
      else
        {
        for(j=0; j<(*nh * acttot);j++)
          {
          ValB[indValB]=(double)mysignaling_nan(nn);
          indValB=indValB+1;
          }
        }
    
      if(ItStat[i][iter].EquN.ValD.nblig>0)
        {
        for(j=0; j<ItStat[i][iter].EquN.ValD.nblig;j++)
          {
          for (l=0; l<ItStat[i][iter].EquN.ValD.nbcol; l++)
            {
            ValD[indValD]=ItStat[i][iter].EquN.ValD.donnees[j][l];
            indValD=indValD+1;
            }
          }
        }
      else
        {
        for(j=0; j<(*nh * acttot);j++)
          {
          ValD[indValD]=(double)mysignaling_nan(nn);
          indValD=indValD+1;
          }
        }
    
      if(ItStat[i][iter].EquN.ValEta.nbele>0)
        {
        for(j=0;j<ItStat[i][iter].EquN.ValEta.nbele;j++)
          {
          ValEta[indValEta]=ItStat[i][iter].EquN.ValEta.donnees[j];
          indValEta=indValEta+1;
          }
        }
      else
        {
        for(j=0;j<*nh;j++)
          {
          ValEta[indValEta]=(double)mysignaling_nan(nn);
          indValEta=indValEta+1;
          }
        }

      } /* fin VouluIt.Ajustes */


    if (GNLControle.VouluIt.FctSensib == VRAI)
      {
      if(ItStat[i][iter].FctSensib.DValf.nblig>0)
        {
        for(j=0; j<ItStat[i][iter].FctSensib.DValf.nblig;j++)
          {
          for (l=0; l<ItStat[i][iter].FctSensib.DValf.nbcol; l++)
            {
            DValf[indDValf]=ItStat[i][iter].FctSensib.DValf.donnees[j][l];
            indDValf=indDValf+1;
            }
          }
        }
      else
        {
        for(j=0; j<(*k * *pbase);j++)
          {
          DValf[indDValf]=(double)mysignaling_nan(nn);
          indDValf=indDValf+1;
          }
        }
    
      if(ItStat[i][iter].FctSensib.DVarYTheta.nblig>0)
        {
        for(j=0; j<ItStat[i][iter].FctSensib.DVarYTheta.nblig;j++)
          {
          for (l=0; l<ItStat[i][iter].FctSensib.DVarYTheta.nbcol; l++)
            {
            DVarYTheta[indDVarYTheta]=ItStat[i][iter].FctSensib.DVarYTheta.donnees[j][l];
            indDVarYTheta=indDVarYTheta+1;
            }
          }
        }
      else
        {
        for(j=0; j<(*k * *pbase);j++)
          {
          DVarYTheta[indDVarYTheta]=(double)mysignaling_nan(nn);
          indDVarYTheta=indDVarYTheta+1;
          }
        }
    
    
      if(ItStat[i][iter].FctSensib.DVarYBeta.nblig>0)
        {
        for(j=0; j<ItStat[i][iter].FctSensib.DVarYBeta.nblig;j++)
          {
          for (l=0; l<ItStat[i][iter].FctSensib.DVarYBeta.nbcol; l++)
            {
            DVarYBeta[indDVarYBeta]=ItStat[i][iter].FctSensib.DVarYBeta.donnees[j][l];
            indDVarYBeta=indDVarYBeta+1;
            }
          }
        }
      else
        {
        for(j=0; j<(*k * *qbase);j++)
          {
          DVarYBeta[indDVarYBeta]=(double)mysignaling_nan(nn);
          indDVarYBeta=indDVarYBeta+1;
          }
        }
      } /* fin VouluIt.FctSensib */

    if (GNLControle.VouluIt.ResNum == VRAI)
      {
      /* la direction de descente */
      if((NbIter[iter]!=0)  && (ItDirec[i][iter].nbele>0))
        {
        /* jamais de direction de descente a la 1iere iteration*/
          for(j=0; j<ItDirec[i][iter].nbele;j++)
            {
            Direc[indDirec]=ItDirec[i][iter].donnees[j];
            indDirec=indDirec+1;
            }
          }
      else
        {
        for(j=0; j<acttot;j++)
          {
          Direc[indDirec]=(double)mysignaling_nan(nn);
          indDirec=indDirec+1;
          }
        }
      if (NbIter[iter]!=0)
         Omega[indNum]=(double)ItOmega[i][iter];
      else
         Omega[indNum]=(double)mysignaling_nan(nn);
      Lambda[indNum]=(double)ItNum[i][iter].Lambda;
      indNum=indNum+1;

        CritArret[indCritArret]=(double)ItNum[i][iter].CritArret;
        indCritArret=indCritArret+1;
        CritStat[indCritStat]=(double)ItNum[i][iter].CritStat;
        indCritStat=indCritStat+1;
        Sigma[indSigma]=(double)ItNum[i][iter].Sigma;
        indSigma=indSigma+1;
      } /* fin VouluIt.ResNum */



    if (GNLControle.VouluIt.Estim==VRAI)
      {      
      if (ItTheta[i][iter].nbele >0)
        {
        for(j=0;j<ItTheta[i][iter].nbele;j++)
          {
          ThetaRes[indTheta]=ItTheta[i][iter].donnees[j];
          indTheta=indTheta+1;
          }
        }
      else
        {
        for(j=0;j<*pmult;j++)
          {
          ThetaRes[indTheta]=(double)mysignaling_nan(nn);
          indTheta=indTheta+1;
          }
        }
      
      if (ItBeta[i][iter].nbele>0)
        {
        for(j=0;j<ItBeta[i][iter].nbele;j++)
          {
          BetaRes[indBeta]=ItBeta[i][iter].donnees[j];
          indBeta=indBeta+1;
          }
        }
      else
        {
        for(j=0;j<*qmult;j++)
          {
          BetaRes[indBeta]=(double)mysignaling_nan(nn);
          indBeta=indBeta+1;
          }
        }
      } /* fin VouluIt.Estim */

    } /* fin boucle sur nbiter */


return;

}
/* -------------- Fin fonction recupItnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : recupItSedonls2          |
| Role                  :                          |
|  Recuperation des valeurs du sedo                |
|  a l'etape 'ietap'                               |
| Parametres d'entree   :                          |
|   k, NbEq, NbJ: voir notice NL                   |
| Parametres de sortie  :                          |
|   FSedo, : valeurs du sedo
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupItnls2                    |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void recupItSedonls2(
         ietap, k, NbEq, NbJ, nbitsv,
         FSedo)

TFuncInt  *ietap, *k, *NbEq, *NbJ, *nbitsv;
double   *FSedo;

{
/*--------------- Fin identification fonction ----*/
TShortInt i, ik, iNbEq, iNbJ;
TShortInt indFSedo, iter;

indFSedo=0;

i=*ietap-1;

for(iter=0; iter<*nbitsv; iter++)
  {
  for(ik=0; ik<*k; ik++)
    {  
    for(iNbJ=0; iNbJ<*NbJ; iNbJ++)
      {
      for (iNbEq=0; iNbEq < *NbEq; iNbEq++)
        {
        FSedo[indFSedo]=ItStat[i][iter].Sedo.FSedo[ik][iNbJ][iNbEq];
        indFSedo=indFSedo+1;
        }
      }
    }
  } /* fin boucle sur iterations */

return;

}
/* -------------- Fin fonction recupItSedonls2 ----------------- */




/*--------------- Identification fonction ----------
| Nom de la fonction    : recupDivnls2             |
| Role                  :                          |
|  recuperations diverses                          |
|  a l'etape 'ietap'                               |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
|  voir notice NL                                  |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupDivnls2                     |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void recupDivnls2(
         ietap, 
         Estim, TypeCritStat, Famille,
	 IndiceN,
         NbZ, Effic, Symm )

TFuncInt    *ietap; 
TFuncInt *Estim, *TypeCritStat, *Famille, *IndiceN, *NbZ, *Effic, *Symm;
{
/*--------------- Fin identification fonction ----*/
TShortInt i;

i=*ietap-1;

  *Estim=(TFuncInt)CtxNum[i].Estim;
  *TypeCritStat=(TFuncInt)CtxNum[i].TypeCritStat;
  *Famille=(TFuncInt)CtxPuss.Famille;
  *IndiceN=(TFuncInt)Donnees.IndiceN;
  *NbZ=(TFuncInt)CtxNum[i].NbZ;
  *Effic=(TFuncInt)CtxNum[i].Effic;
  *Symm=(TFuncInt)CtxNum[i].Symm;
return;

}
/* -------------- Fin fonction recupDivnls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : recupVarinls2             |
| Role                  :                          |
|  recuperation de Vari
| Parametres de sortie  :                          |
|  voir notice NL                                  |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupVarinls2                     |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void recupVarinls2(Vari )

TFuncInt  *Vari;
{
/*--------------- Fin identification fonction ----*/

*Vari=(TFuncInt)Modele.Vari;

return;

}
/* -------------- Fin fonction recupVarinls2 ----------------- */


/*--------------- Identification fonction ----------
| Nom de la fonction    : recupSedonls2            |
| Role                  :                          |
|  Recuperation des valeurs du sedo                |
|  a l'etape 'ietap'                               |
| Parametres d'entree   :                          |
|   k, NbEq, NbJ: voir notice NL                   |
|   Lg: 3ieme dimension de DFSedo                  |
| Parametres de sortie  :                          |
|   FSedo, DFSedo: valeurs du sedo et de ses       |
|   derivees
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :                           |
|  la fonction S: recupSedonls2                    |
--------------------------------------------------*/


/*--------------- Definition fonction ------------*/

void recupSedonls2(
         ietap, k, NbEq, NbJ, Lg,
         FSedo, DFSedo)

TFuncInt  *ietap, *k, *NbEq, *NbJ, *Lg;
double   *FSedo, *DFSedo;

{
/*--------------- Fin identification fonction ----*/
TShortInt i, ik, iNbEq, iNbJ, iLg;
TShortInt indFSedo, indDFSedo;

indFSedo=0;
indDFSedo =0;



i=*ietap-1;

  for(ik=0; ik<*k; ik++)
    {  
    for(iNbJ=0; iNbJ<*NbJ; iNbJ++)
      {
      for (iNbEq=0; iNbEq < *NbEq; iNbEq++)
        {
        FSedo[indFSedo]=ResStat[i].Sedo.FSedo[ik][iNbJ][iNbEq];
        indFSedo=indFSedo+1;
        }
      }
    }

  for(ik=0; ik<*k; ik++)
    {
    for(iNbJ=0; iNbJ<*NbJ; iNbJ++)
      {
      for(iLg=0; iLg< *Lg; iLg++)
        {
        DFSedo[indDFSedo]=ResStat[i].Sedo.DFSedo[ik][iNbJ][iLg];
        indDFSedo=indDFSedo+1;
        }
      }
    }

return;

}
/* -------------- Fin fonction recupSedonls2 ----------------- */
