
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <math.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"
#include "nlglobal.h"

/* pour les structures de analder */
#include "dftypes.h"



/*--------------- VARIABLES EXTERNES -------------*/
#include "nldcl.h"     /* les arguments de NL */

/*----------------FONCTIONS EXTERNES ------------*/
TShortInt NLVDon(TDonnees *Donnees, TShortInt *Code);
TShortInt NLVDonM(TShortInt NbTheta, TShortInt NbBeta, TVectLong  *NbObsC,
		  TShortInt *Code);

void create_mat(double *val, TFuncInt nblig, TFuncInt nbcol, TMat *Struct);

/* les sorties de analDer */
 TRetModele RetModele;

/*--------------- Identification fonction ----------
| Nom de la fonction    : crDataRnls2
| Role                  :                          |
|  reinitialisation des structures donnees de NL avant     |
|  les calculs effectifs par rexnls2                |
| Parametres d'entree   :                          |
|  PoidsT: nouvelles valeurs des poids
| Parametres de sortie  :                          |
|   NbObsLu:n+nombre de poids nuls                 |
|   la suite: cf notice NL                         |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void crDataRnls2(
         XObsT, NbLig, NbCol,
	 NbObsLu, Code)

/* vecteurs en entree*/
double *XObsT;
/* scalaire en entree */
TFuncInt *NbLig, *NbCol;
/* scalaire en sortie */
TFuncInt *NbObsLu, *Code;
{
/*--------------- Fin identification fonction ----*/
*Code=OK;
*NbObsLu=(TFuncInt)Donnees.ValY.nbele;

if ((*NbLig != *NbObsLu) || (*NbCol != (TFuncInt)Donnees.NomX.nbele))
  {
  *Code=-1;
  return;
  }

create_mat(XObsT, *NbLig, *NbCol, &(Donnees.XObsT));
return;
}
/* ------------------ fin crDataRnls2 -------------------- */

/* ------------------------------------------------------ */
void RetDimnls2(
         k,n,NbCourbe,
         NbTheta, NbBeta, NbGamF,NbGamV, pmult, qmult,
         NbEq, NbJ, NbDF, LgDSedo)


/* scalaires  en sortie */
TFuncInt *k, *n, *NbCourbe, *NbTheta, *NbBeta, * NbGamF, *NbGamV, *pmult,*qmult;
TFuncInt   *NbEq,*NbJ,*NbDF, *LgDSedo;
{
/*--------------- Fin identification fonction ----*/

/* reinitialisation des compteurs de warnings */
 GNLControle.CWarAna=0 ;  /* nbre de warnings pour l'analyseur-derivateur */
 GNLControle.CWarInt=0 ;  /* nbre de warnings pour l'integrateur */
 GNLControle.CWarMet=0 ;  /* nbre de warnings de type methodologique */
 GNLControle.CWarNum=0 ;  /* nbre de warnings de type numerique */
 GNLControle.CWarTot=0 ;  /* nbre de warnings tous types */


/*retour des dimensions */
*k= (TFuncInt)Donnees.NbObs;
*n=(TFuncInt)Donnees.NbObsT;

*NbCourbe= (TFuncInt)Donnees.NbObsC.nbele;

*NbTheta=(TFuncInt)Modele.NomTheta.nbele;
*NbBeta=(TFuncInt)Modele.NomBeta.nbele;
*NbGamF=(TFuncInt)Modele.NomGamF.nbele;
*NbGamV=(TFuncInt)Modele.NomGamV.nbele;
*pmult=(TFuncInt)CtxPuss.Theta0.nbele;
*qmult=(TFuncInt)CtxPuss.Beta0.nbele;

if (Modele.CasSedo ==1)
  {
  *NbJ= GNLCtxInteg.NbJ;
  *NbEq= GNLCtxInteg.NbEq;
  *NbDF=(TFuncInt)RetModele.NomLesDF.nbele;
  *LgDSedo= GNLCtxInteg.LongSys -  GNLCtxInteg.NbEq;
  }
else
  {
  *NbJ=0;
  *NbEq=0;
  *NbDF=0;
  *LgDSedo=0;
  }
return;

}
/* -------------- Fin fonction RetDimnls2 ----------------- */



/*--------------- Identification fonction ----------
| Nom de la fonction    : nlvdonRnls2             | 
| Role                  :                          |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
--------------------------------------------------*/


/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|  Le programme de NL: NLVDon, NVLDonM             |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

void nlvdonRnls2(
         Code)

/* scalaire */
TFuncInt   *Code;

{
/*--------------- Fin identification fonction ----*/
TShortInt mycode, NbTheta, NbBeta, NbCourbes, Taille1, Taille2;

*Code=OK;
mycode=OK;

/* pour verifier: le nombre de courbes doit rester inchange */
NbCourbes=Donnees.NbObsC.nbele;
/* pour verifier: la taille des lots doit rester inchangee */
Taille1=Donnees.NbObsT;
Taille2=Donnees.NbObs;

/* init, verif des donnees */
*Code = NLVDon( &(Donnees), &mycode);


if ((*Code != OK) || (mycode !=OK))
  {
  fprintf(stderr,"\nError  %d in the data reinitialisation, program 'NLVDon' \n",
      *Code);
  return;
  }

if ((Taille1 != Donnees.NbObsT) || (Taille2 !=Donnees.NbObs))
  {
  fprintf(stderr,"\nError in the data reinitialisation:\n");
  fprintf(stderr,"the number of observations should remain the same:\n\
 (initial total number of replications:%d,  current number:%ld \n\
 (initial total number of observations:%d,  current number:%ld \n",
    Taille1, Donnees.NbObsT,Taille2 ,Donnees.NbObs);
  Donnees.NbObsT=Taille1;
  Donnees.NbObs=Taille2;
  *Code=-1;
  return;
}

/* Verif de la concordance entre donnees et modele: le nombre d'observations
   doit rester sup au nombre de parametres */
NbTheta = Modele.NomTheta.nbele;
NbBeta = Modele.NomBeta.nbele;

*Code = NLVDonM(NbTheta, NbBeta, &(Donnees.NbObsC), &mycode);

return;

}
/* -------------- Fin fonction nlvdonRnls2 ----------------- */
