/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <string.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "dfcodes.h"
#include "nlglobal.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"
/* les arguments de NL: */
#include "nldcl.h"
#include "dftypes.h"


#define MAXLIG 255
#define MAXMOT 11

/*----------------FONCTIONS EXTERNES ------------*/
void cptemots(FILE *fic, TFuncInt *Nb, TFuncInt *Code);
void mots(FILE *fic, TFuncInt *Nb, char ***PointeurNoms, TFuncInt *Code);
short int calcinvf_(short int nbp, short int nbga, 
		    short int nbl, short int nbgv,
		    double *p, double *ga, double *ord,
		    double *gv, double *abs, 
		    double **dabsdp, double *dabsdo, 
		    double *varord, short int *le, short int *ie);


TShortInt CreerMatC( TShortInt nblig, TShortInt nbcol, TMat *pmat);
void DetruMatC(TMat *pmat);

/* -----------------nameInvnls2 ------------------------ 
 Role: renvoyer les noms des  listes du fichier de description
-------------------------------------------------------- */

void nameInvnls2(ficmod, NbParact,NbPbisabs, NbPbisvar,
            NomParact, NomPbisabs, NomPbisvar,
            Code)
/* arguments d'entree */
char **ficmod;
TFuncInt *NbParact, *NbPbisabs, *NbPbisvar;
/* arguments de sortie */
char ***NomParact, ***NomPbisabs, ***NomPbisvar;
TFuncInt *Code;
{
char ch[MAXLIG];
char motlu[MAXMOT];

FILE *fic;

/* char NomModele[MAXLGFIC]; strcpy(NomModele, *ficmod); */

if( (fic=fopen(*ficmod,"r")) == NULL)
  {
  fprintf(stderr,
"\nError when opening the model description file %s \n", *ficmod);
  *Code=ERR;
  return;
  }

while( fscanf(fic,"%s", motlu) != EOF)

    {
    if (strncmp(motlu, "%",1) ==0)
      {
      fgets(ch, MAXLIG, fic);
      continue;
      }


    if (strcmp(motlu,"paract")==0)
      {
      mots(fic, NbParact, NomParact,Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strcmp(motlu,"pbisabs")==0)
      {
      mots(fic, NbPbisabs, NomPbisabs,Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strcmp(motlu,"pbisvar")==0)
      {
      mots(fic, NbPbisvar, NomPbisvar,Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"subroutine", 10)==0)
      {
      break;
      }

  } /* fin du while  */

fclose(fic);
return;
}
/* ---------------- end of  nameInvnls2 ----------------- */


/* -----------------nbInvnls2 ---------------------- */
/* compter les elements des listes du fichier de 
 description de inv */
void nbInvnls2(ficmod,
         NbParact, NbPbisabs, NbPbisvar,
         YaSubr,
         Code)

/* arguments d'entree */
char **ficmod;
/* arguments de sortie */
TFuncInt *NbParact, *NbPbisabs, *NbPbisvar;
TFuncInt *YaSubr, *Code;

{
char  motlu[MAXMOT], ch[MAXLIG];
FILE *fic;

/* char NomModele[MAXLGFIC]; strcpy(NomModele, *ficmod); */

if( (fic=fopen(*ficmod,"r")) == NULL)
  {
  fprintf(stderr,
"\nError when opening the model description file %s \n", *ficmod);
  *Code=ERR;
  return;
  }

while( fscanf(fic,"%s", motlu) != EOF)

    {
    if (strncmp(motlu, "%",1) ==0)
      {
      fgets(ch, MAXLIG, fic);
      continue;
      }


    if (strcmp(motlu,"paract")==0)
      {
      cptemots(fic, NbParact, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strcmp(motlu,"pbisabs")==0)
      {
      cptemots(fic, NbPbisabs, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strcmp(motlu,"pbisvar")==0)
      {
      cptemots(fic, NbPbisvar, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"subroutine", 10)==0)
      {
      *YaSubr=1;
      break;
      }

  } /* fin du while  */

fclose(fic);
return;
}

/* ---------------- end of nbInvnls2 ---------------------- */


/* ----------------- calcinvnls2 ---------------------- */
void calcinvnls2(nbp, nbga, nbl, nbgv, p, ga, ord,
                gv, abs, dabsdp, dabsdo, varord, le, ie)
/* les entrees */
      TFuncInt *nbp, *nbga, *nbl, *nbgv;
      double *p, *ga, *gv, *ord;
/* les sorties */
      double *abs, *dabsdp;
      double *dabsdo, *varord;
      TFuncInt *le, *ie;
{

short int i,j,l, RetCode;
TMat dfo;

/* mettre les derivees sous forme de matrice allouee continuement  */
CreerMatC(*nbl, *nbp, &dfo);
i=j=0;

RetCode=calcinvf_((short int)*nbp, (short int)*nbga, 
            (short int)*nbl, (short int)*nbgv,
            p, ga,ord,gv, abs, &(dfo.donnees[0]),
            dabsdo, varord, &i, &j);

if(RetCode !=OK)
  {
  *le=i;
  *ie=j;
  return;
  }


/* Mettre dfo dans dabsp */
l=0;
for(i=0; i<*nbl; i++)
  {
  for (j=0; j< *nbp; j++)
    {
     dabsdp[l]=dfo.donnees[i][j]; 
     l=l+1;
    }
  }

/* desallouer dfo */
DetruMatC( &dfo);


*ie=0;
*le=0;

return;
}
/* ---------------- end of calcinvnls2 -----------------*/
