
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <math.h>
#include <float.h>
#include <string.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"
#include "nlglobal.h"

/* pour determiner si les sol sont dans un intervalle */
#define PASCOM 0
#define COM 1
#define FINI 2

/* Precision des calculs */
#define PRECISION 1.e-10

/* pour genxnls2 */
#define MAXLIG 255
#define MAXMOT 11


/* -------------- VARIABLES GLOBALES --------------- */
/* indicateur pour determiner si R est un intervalle */
static int etatint;

/* icoup=nombre de fois ou on a decoupe un intervalle */
 static int icoup;

/*--------------- VARIABLES EXTERNES -------------*/
#include "nldcl.h"     /* les arguments de NL */
TContr CThetaE[MAXETAP], CBetaE[MAXETAP];


/*----------------FONCTIONS EXTERNES ------------*/
TShortInt CLv( TLongInt NbObsT,
	       TVectLong *NbRepet, TVect *Y1, TVect *Y2, TVect *Valf, TVect *VarY,
               TDouble *Lv);
TShortInt NLEtape(TShortInt Etape, TDonnees *Donnees, TModele *Modele, 
		  TCtxPuss *CtxPuss, TCtxNum *CtxNum,
                  TVect *ThetaPred1, TVect *ThetaPred2, 
		  TVect *BetaPred1, TVect *BetaPred2,
                  TVect *Valf1,TMat * DValf1,
                  TParam  *Theta, TParam  *Beta, 
		  TContr *CTheta, TContr *CBeta, TContr *CThetaE, TContr *CBetaE,
		  TResNum *ResNum, TResStat *ResStat,
                  TShortInt *NbItSv, TResNum *ItNum, TResStat *ItStat,
		  TVect *ItTheta, TVect *ItBeta, TVect *ItDirec, TDouble *ItOmega);

TShortInt CResidus(TLongInt NbObsT, TVectLong *NbRepet,
		   TVect *PoidsT, TVect *ValY, TVect *Valf, 
                   TVect *Residus);

short int calcf_(short int nbt, short int nbg, short int nbl, 
		 short int nbc, 
		 double *t, double *g, double **x, 
		 double *f, double **df, 
		 short int *le, short int *ie);


short int calcv_(short int nbt, short int nbb, short int nbg, short int nbl, 
		 short int nbc, 
		 double *t, double *b, double *g,
		 double *f, double **df, double **x, double *v, 
		 double **dtv, double **dbv, short int *le, short int *ie);

TShortInt CreerVect( TShortInt nbele, TVect *pvect);
TShortInt CreerMatC( TShortInt nblig, TShortInt nbcol, TMat *pmat);
void DetruMatC(TMat *pmat);
void cptemots(FILE *fic, TFuncInt*Nb, TFuncInt*Code);
void mots(FILE *fic, TFuncInt*Nb, char ***PointeurNoms, TFuncInt*Code);
 int mycalcinvf_( int *nbp,  int *nbga, 
		     int *nbl,  int *nbgv,
		    double *p, double *ga, double *ord,
		    double *gv, double *abs, 
		    double *dabsdp, double *dabsdo, 
		    double *varord,  int *le,  int *ie);


/* --------------------------------------------------------------
 genxnls2
----------------------------------------------------------------------- */
void genxnls2(ficmod, ficsup, Code)
/* arguments d'entree */
char **ficmod, **ficsup;
/* arguments de sortie */
TFuncInt*Code;
{
char  motlu[MAXMOT], ch[MAXLIG];
FILE *ificmod, *ificsup;
/* AVANT le 10/04/2003 char carlu[1]; */
 char carlu[2];

if ( (ificmod= fopen(*ficmod,"r")) == NULL)
  {
  fprintf(stderr,
"\nError when opening the model description file %s \n", *ficmod);
  *Code=ERR;
  return;
  }


if ( (ificsup= fopen(*ficsup,"w")) == NULL)
  {
  fprintf(stderr,
"\nError when opening the temporary model description file %s \n", *ficsup);
  *Code=ERR;
  return;
  }

while ( (fscanf(ificmod,"%s", motlu) != EOF) && 
         (strncmp(motlu,"subroutine", 10) != 0))
  {
  /* lire et recopier sur ificsup */
  fputs(motlu, ificsup);
  if (strncmp(motlu,"parresp", 7) !=0)
    {
   fgets(ch, MAXLIG, ificmod);
    fputs(ch, ificsup);
    }
  else
    {
    /* Ecrire en otant le ";" et rajouter "estimated_abscissa" */
    fputs(" ", ificsup);
    fscanf(ificmod,"%1s", carlu);
    while ( strncmp(carlu,  ";", 1) !=0 )
      {
      fputs(carlu, ificsup);
      fscanf(ificmod,"%1s", carlu);
      }
    fputs(",estimated_abs;\n",  ificsup);
/* Ne pas ecrire qqche trop long, sinon ca plante */
    }
  } /* fin du while  */

fclose(ificmod);
fclose(ificsup);
return;
}

/* ------------- fin genxnls2 -------------------------------------- */


/* -----------------------------------------------------------------------
 cresidnls2
 calcul des residus
----------------------------------------------------------------------- */
short int cresidnls2(Residus)

/* argu en sortie */
double *Residus;
{
TShortInt i,IndEtap;

IndEtap=CtxPuss.NbEtapes-1;


if(CResidus(Donnees.NbObsT,&(Donnees.NbRepet), &(Donnees.PoidsT), 
                   &(Donnees.ValY), &(ResStat[IndEtap].Ajustes.Valf),
                   &(ResStat[IndEtap].Residus)) !=OK) return((short int)1);


/* recuperation des residus */
if(ResStat[IndEtap].Residus.nbele<=0)
  return((short int)1);

for(i=0;i<ResStat[IndEtap].Residus.nbele;i++)
  {
  Residus[i]=ResStat[IndEtap].Residus.donnees[i];
  }

return((short int)0);
}
/* ----------- fin de cresidnls2 ------------------------------------- */

/* ------------------------------------------------------------------
init2xnls2
--------------------------------------------------------------------- */
short int init2xnls2(n,m,Rgrid,step, xval, modif)
/* argu en entree */
TFuncInt n,m, Rgrid;
double  step;
/* argu en e/s */
double *xval;
/* argu en s */
double *modif;
{
int i;

/* reinitialisation des compteurs de warnings */
GNLControle.CWarAna=0 ;  /* nbre de warnings pour l'analyseur-derivateur */
GNLControle.CWarInt=0 ;  /* nbre de warnings pour l'integrateur */
GNLControle.CWarMet=0 ;  /* nbre de warnings de type methodologique */
GNLControle.CWarNum=0 ;  /* nbre de warnings de type numerique */
GNLControle.CWarTot=0 ;  /* nbre de warnings tous types */


/* mettre dans la structure globale Donnees, les m nouvelles valeurs */
/* Pour que le 1ier point rajoute ne soit pas considere comme
un repet du dernier des donnees de base, on le modifie: */
*modif=0;
if (*xval== Donnees.XObsT.donnees[n-1][0])
  {
  *modif=(step / Rgrid);
  *xval= *xval + *modif;
  }


for (i=n; i<(n+m) ; i++)
  {
  Donnees.XObsT.donnees[i][0]=*xval;
  }

Donnees.XObs.donnees[Donnees.NbObs-1][0]=*xval;

return( (short int)0);

}
/* --------------------- fin de initxnls2 ------------------------- */

/* ---------------------------------------------------------
 cherchepoints:
 Recherche des points solutions
 On determine si l1, l2 conviennent, ou bien, si une redecoupe
   est demandee, s'il y a des points entre [l1,l2] qui conviennent
  par un appel recursif a calcRloop
Si un point et un seul a pour Rvalue NaN, on redecoupe
 ------------------------------------------------------- */
short int cherchepoints( 
          n,m,  pbase, nbgf, nsplit, nval, gridpoints, maxpoints,
          l1, l2, r1, r2, Schapeau,logchapeau,Zmoy,
          confbounds, ord, residus,thetachapeau, gamf,
          trav,
          npoints, nx, points, Rx, Rvalues,cestint,
          TousCodes)


/* argu en entree */
TFuncInt n,m, pbase, nbgf, nsplit, nval,  gridpoints, maxpoints;
double l1, l2, r1, r2,Schapeau,logchapeau,Zmoy ;
double *confbounds, *ord, *residus, *thetachapeau, *gamf ;

/* tableau de travail */
double *trav;

/* argu en e-sortie */
TFuncInt *npoints, *nx, *cestint, *TousCodes; 
double *points, *Rx, *Rvalues;

{
extern short int calcRloop();
double petitestep;
int oncoupe, trouveR;

trouveR=oncoupe=0;


if ( !myisnan(r1) && (r1 >= confbounds[0]) && (r1 <= confbounds[1]))
  {
  /* on considere que l1 est dans l'intervalle de confiance */
  trouveR=1;
  }

if ( !myisnan(r2) && (r2 >= confbounds[0]) && (r2 <= confbounds[1]))
  {
  /* on considere que l2 est dans l'intervalle de confiance */
  trouveR=trouveR+1;
  } /* fin de  on considere que  l2 est dans l'intervalle de confiance */

if ( (!myisnan(r1) && myisnan(r2)) ||
     (myisnan(r1) && !myisnan(r2)))
   trouveR=1;

if  (trouveR==1) 
  {
  /* un point et un seul point parmi l1 et l2 est dans l'intervalle */
  if (icoup < nsplit)
    {
    /* on redecoupe l'intervalle l1,l2  en gridpoints */
    oncoupe=1;
    icoup=icoup+1;
    petitestep=  (l2-l1)/(double)(gridpoints-1);
  
    /* appel recursif */
    if(calcRloop(l1,l2, r1, r2,
          n,m, pbase, nbgf, nsplit, nval,   gridpoints, maxpoints,
          petitestep, Schapeau,logchapeau,Zmoy,
          confbounds, ord, residus,thetachapeau, gamf,
          trav,
          npoints, nx, points, Rx, Rvalues, cestint, TousCodes) != OK)
                 return((short int)1);
    } /* fin de  on redecoupe l'intervalle l1,l2  en gridpoints */
  } /* fin de trouveR=1 */

if  (oncoupe==0)
  {
  /* on n'a pas examine encore l1 */
  if ( !myisnan(r1) && (r1 >= confbounds[0]) && (r1 <= confbounds[1]))
    {
    /* on considere que l1 est dans l'intervalle de confiance */
    if (*npoints < maxpoints)
      {
      points[*npoints]=l1;
      }
    else
      {
      /*  si le tableau de sortie n'est pas assez grand
            on met dans sa derniere position, le dernier element trouve
             en sortie, ce sera le plus grand */
      points[(maxpoints-1)]=l1;
      }
    *npoints=*npoints+1;
    if (etatint==PASCOM)   etatint=COM;
    if (etatint==FINI)    *cestint=0;
    } /* fin de  on considere que  l1 est dans l'intervalle de confiance */
  else
    {
    if (etatint==COM)      etatint=FINI;
    }
  } /* fin de oncoupe=0 */

return((short int)0);
}
/* --------- fin de cherchepoints ------------------------*/
/* ----------------------------------------------------------------
appelxnls2
nls2 a deja ete appele avec renls2=T
et les  m dernieres valeurs des donnees ont ete modifiees
On a besoin de refaire nls2 car on veut les residus ou loglik
------------------------------------------------------------------ */
short int appelxnls2(CodePuss, TousCodes)
TShortInt  *CodePuss, *TousCodes;
{
TShortInt  Code, i, Etape;
TVect ThetaPred1, ThetaPred2, BetaPred1, BetaPred2;

TShortInt NbCodesErr=11;
TShortInt CodesErr[11];

/* CodesErr: les codes de retour de NL pour lesquels les sorties sont non valides */
/* erreur fatale dans ces cas */
CodesErr[0]=NONFAIT;
CodesErr[1]=ERRTYPES;
CodesErr[2]=ERRTRACE;
CodesErr[3]=ERRVINIT;
CodesErr[4]=ERWT;
CodesErr[5]=ERWM;
CodesErr[6]=ERWI;
CodesErr[7]=ERWN;
CodesErr[8]=ERRCMU;
CodesErr[9]=EPBALLOC;
CodesErr[10]=ERRALLOC;


/* INITIALISATIONS */
/* on cree des vecteurs bidon pour pouvoir faire l'appel a NL
avec les memes arguments, qu'il y ait des valeurs precedemment estimees
ou non */
CreerVect((TShortInt)0, &ThetaPred1);
CreerVect((TShortInt)0, &ThetaPred2);
CreerVect((TShortInt)0, &BetaPred1);
CreerVect((TShortInt)0, &BetaPred2);
Etape=1;

/* APPEL  DE NLEtape */
if ((Code=NLEtape(Etape, &Donnees, &Modele, &CtxPuss, &(CtxNum[0]),
            &ThetaPred1, &ThetaPred2, &BetaPred1, &BetaPred2,
            &(ResStat[0].Ajustes.Valf),
            &(ResStat[0].FctSensib.DValf),
            &(Theta[0]), &(Beta[0]), 
            &(CTheta[0]), &(CBeta[0]),
            &(CThetaE[0]), &(CBetaE[0]),
            &(ResNum[0]), &(ResStat[0]),
            &(NbItSv[0]),
            ItNum[0], ItStat[0],
            ItTheta[0], ItBeta[0],
            ItDirec[0], ItOmega[0])) != OK)
    {
     /* Erreur fatale */
    /* Impression en cas d'erreur */
    /* -------------------------- */
    fprintf(stderr, "\n Error %d when estimating the parameters\n",
          Code);
    for (i=0; i<NbCodesErr; i++)
      {
      if (Code == CodesErr[i])
        return((short int) 1);
      }
    } /* fin de Code !=OK */
	
*CodePuss = ResNum[0].CodePuss;
if (ResNum[0].CodePuss !=0)
  {
  *TousCodes=1;
  }
return((short int)0);
}
/* --------------------- fin  de appelxnls2 --------------------------- */

/* ------------------------------ ---------------------------
   calibffnls2:
   Role:  Appeler calcf_ sur des entrees qui ne sont pas 
          dans des structures nl
 ------------------------------------------------------------- */

void calibffnls2(x, nblig, nbcol,
      pbase, nbgf,  Theta, GamF, f, df, le, ie)
      double *x;
      TFuncInt*nblig, *nbcol, *pbase, *nbgf;
      double *Theta, *GamF,  *f, *df;
      TFuncInt*le, *ie;
{

short int i,j,l,lee, iee, RetCode;
TMat dfo;

/* mettre df sous forme de matrice allouee continuement  */
CreerMatC(*nblig, *pbase, &dfo);

/* pas de courbe ici */
lee=iee=0;
  RetCode=calcf_((short int)*pbase, (short int)*nbgf, 
              (short int)*nblig, (short int)*nbcol, 
              Theta,  GamF, &x,
              f, &(dfo.donnees[0]), &lee, &iee);

  if(RetCode !=OK)
    {
    *ie = iee ;
    *le = lee;
    return;
    }

/* Mettre dfo dans df */
l=0;
for(i=0; i<*nblig; i++)
  {
  for (j=0; j< *pbase; j++)
    {
     df[l]=dfo.donnees[i][j]; 
     l=l+1;
    }
  }

/* desallouer dfo */
DetruMatC( &dfo);


*ie=0;
*le=0;

return;
}
/* ---------------- end of calibffnls2 -----------------*/


/* --------------------------------------------------------------------
 verifmonotnls2:
 appele par la fonction S: calib.nls2.s
 Verifie que f est strictement monotone entre debut et fin en la calculant
 sur une grille de gridpoints
 ------------------------------------------------------------------- */
void  verifmonotnls2(
        pbase,  nbgf,gridpoints,
        debut,fin,
	thetachapeau, gamf,
        trav,
	pasmonot, code)
/* argu en entree:
pbase, nbgf: nbre de theta et da gamf
gridpoints: nbre de points desires dans la grille
debut, fin:  bornes incluses de la grille de recherche 
thetachapeau: les theta estimes sur les observations de base
gamf: les gamf
*/
TFuncInt *pbase, *nbgf, *gridpoints;
double *debut, *fin;
/* les vecteurs */
double *thetachapeau, *gamf, *trav;

/* argu en sortie :
pasmonot=1 si f n'est pas monotone
code=0 si OK 1 sinon
*/
TFuncInt*pasmonot, *code;
{
double **x1, *x2, f[1], flpred,xval, xvalpred, increment;
short int decroit, nbl, nbc, lee, iee;

*pasmonot=*code=0;
lee=iee=0;
nbl=nbc=1;
increment = (*fin - *debut)/(*gridpoints-1);


decroit= -1; 

/* calcul au 1ier point: */
if(calcf_((short int)*pbase, (short int)*nbgf, 
              nbl, nbc, 
              thetachapeau,  gamf, &debut,
              f, &trav, &lee, &iee) !=OK)
    {
    fprintf(stderr,
       "Problem when calculating f for checking the monotony on the point %g\n", *debut);
    *code=1;
    return;
    }
flpred=f[0];
xvalpred=*debut;

x2=&xval;
x1=&x2;

for (xval=(*debut+increment); xval <= *fin ; xval=xval+increment)
  {
  if(calcf_((short int)*pbase, (short int)*nbgf, 
              nbl, nbc, 
              thetachapeau,  gamf, x1,
              f, &trav, &lee, &iee) !=OK)
    {
    fprintf(stderr,
       "Problem when calculating f for checking the monotony on the point %g\n", xval);
    *code=1;
    return;
    }
  if (decroit != -1)
    {
    if ( ((f[0] >= flpred) && (decroit==1)) || 
          ((f[0] <= flpred) && (decroit==0)))
      {
       fprintf(stderr,
         "Problem when checking the monotony of the regression function\n");
       if (decroit ==0)
         fprintf(stderr,
         "The regression function is increasing but its value in %g (%g) \
  is less than its value in %g (%g)\n",
          xval, f[0], xvalpred, flpred);
       else
         fprintf(stderr,
         "The regression function is decreasing but its value in %g (%g) \
  is greater than its value in %g (%g)\n",
          xval, f[0], xvalpred, flpred);
  
     *pasmonot=1;  /* The regression function is not monotonous */
      return;
      }
    }
  else
    {
    /* determiner si la courbe est croissante ou decroissante */
    if (f[0] > flpred) decroit=0; else decroit=1;
    }

  flpred=f[0];
  xvalpred=xval;
  } /* fin boucle sur xval */

return;
}
/* --------------- fin de verifmonotnls2 --------------------- */

/* -----------------------------------------------------------
calcR1
Calcul de R en 1 point x
calcR1 appelle calcf car a besoin de la reponse f 
en x calculee avec thetachapeau
calcR1 appelle aussi le calcul des residus calcules en rajoutant x
aux donnees de base 
Jamais d'erreur fatale: si erreur, Ir non modifie
 -----------------------------------------------------------*/
void calcR1(n,m,pbase, nbgf,
              Schapeau, logchapeau,Zmoy,
              x,thetachapeau, gamf,residus, trav,
              Ir)
/* argu en entree */
TFuncInt n,m, pbase, nbgf;
double Schapeau, logchapeau,Zmoy, *x;
double *thetachapeau, *gamf;

/* argu en e/s */
double *residus;
/* tableau de travail */
double *trav;
/* argu en s */
double  *Ir;
{
short int  cresidnls2();
double  f[1];
short int nbl, nbc, lee, iee;

/* Cas ou la variance est cte 
   --------------------------
*/
/* calcul des residus: nls2 a ete appele juste avant en
  rajoutant x aux observations de base */

if (Modele.Vari ==CTE)
  {
  if(cresidnls2(residus) !=OK)
    {
    fprintf(stderr,"Problem for calculating the residuals when the point %g is added\n", *x);
    return;
    }
  *Ir=0;
  for (nbl=0; nbl<(n+m); nbl++)
    {
    *Ir=*Ir+(residus[nbl]*residus[nbl]);
    }
  *Ir=sqrt( (m+n) * log(*Ir/Schapeau));
  } /*  Fin variance cte */

else
  {

  /* variance non cte: prendre -2logV/n au lieu des residus */
  if( CLv( Donnees.NbObsT,
                &(Donnees.NbRepet), &(Donnees.StatDon.Y1),
                &(Donnees.StatDon.Y2),
                &(ResStat[0].Ajustes.Valf),  &(ResStat[0].Ajustes.VarY),
                &(ResNum[0].Log))  !=OK) 
    {
    fprintf(stderr,"Error when calculating -2log(likelihood)/n \n");
    return;
    }

  *Ir = - (m+n) * (logchapeau - ResNum[0].Log);


  if (*Ir <=0)
    {
    *Ir=-*Ir;
    } 

/* Ce qui suit peut arriver uniquement a cause d'erreurs de precision
donc, on peut oter cette verif 
    fprintf(stderr,
"Problem to calculate R when adding point %g: loglik hat=%g current=%g\n",
    *x,logchapeau, ResNum[0].Log );
    fprintf(stderr,
" -2log(likelihood)/n at mean(Z): %g and when adding the point: %g\n\
   Not possible to calculate sqrt(-(%d)*(%g - %g))\n",
      logchapeau, *x,
     (m+n),logchapeau, ResNum[0].Log);
    return;
*/

    *Ir = sqrt(*Ir);

} /* FIN variance non cte */


lee=iee=0;
nbl=nbc=1;
if(calcf_((short int)pbase, (short int)nbgf, 
              nbl, nbc, 
              thetachapeau,  gamf, &x,
              f, &trav, &lee, &iee) !=OK)
  {
  fprintf(stderr,"Problem when calculating f on the point %g\n", *x);
  return;
  }
if ((Zmoy-f[0]) <0) 
    *Ir=-*Ir;

return;
}
/* ----------------- fin de calcR1 ------------------------------*/

/* --------------------------------------------------
  calcRloop
Boucle de recherche des points de l'intervalle de confiance
 --------------------------------------------------- */
short int calcRloop(debut, fin, rdebut, rfin,
          n,m, pbase, nbgf, nsplit, nval,   gridpoints, maxpoints,
          step, Schapeau, logchapeau,Zmoy,
          confbounds, ord, residus,thetachapeau, gamf,
          trav,
          npoints,  nx,  points, Rx, Rvalues, cestint,
          TousCodes)
/* argu en entree */
double debut, fin, rdebut, rfin;
/* points de debut et fin de l'intervalle, ceux-ci inclus,
et valeur de R au point debut */
TFuncInt n,m, pbase, nbgf, nsplit, nval,  gridpoints, maxpoints;
double step,Schapeau, logchapeau, Zmoy ;
double *confbounds, *ord, *residus, *thetachapeau, *gamf ;

/* tableau de travail */
double *trav;

/* argu en e-sortie */
TFuncInt *npoints, *nx,  *cestint, *TousCodes ; 
double *points, *Rx, *Rvalues;
{
short int appelxnls2(), init2xnls2(), cherchepoints();
double l1, l2, r1, r2, modif;
/* l1, l2: les 2 points de la grille courants,
   r1, r2: les valeurs de R correspondantes */
long int nan;
TShortInt  CodePuss, dernier;


/* initialisation */
l1=debut;
r1=rdebut;
l2=l1+step;

dernier=0; 
/*dernier =1 quand on traitera le dernier point de la grille courante */

while(l2 <= fin)
  {
  if ( (dernier==1) && (icoup>0))
    {
    /* on est dans une redecoupe: R au dernier point de l'intervalle
    a deja ete calcule */
    r2=rfin;
    }
  else
    {
    /* appel de nls2 en rajoutant m fois le point l2 
       -------------------------------------------- */
    /* reinitialisation des donnees */
    if (init2xnls2(n,m,gridpoints,step, &l2, &modif) !=OK) return((short int)1);
    /* appel a nls2 */
    if (appelxnls2(&CodePuss, TousCodes)  !=OK) return((short int)1);
    r2=  mysignaling_nan(nan);
    /* calcul de R en l2 */
    if (CodePuss == 0)
      {
      calcR1(n,m, pbase, nbgf,
                Schapeau,logchapeau,Zmoy,&l2,thetachapeau, gamf,residus, trav,
                 &r2);
      }
    /* on enregistre le point */
    if (*nx < nval)
      {
      Rx[*nx]=l2;
      Rvalues[*nx]=r2; 
      }
    *nx = *nx +1; /* compter le nbre de points de calcul */
    } /* fin du else  ((l2 == fin) && (icoup>0)) */

  /*
   on determine si l1, l2 conviennent, ou bien, si une redecoupe
   est demandee, s'il y a des points entre [l1,l2] qui conviennent */
  if (cherchepoints( 
          n,m, pbase, nbgf, nsplit, nval, gridpoints, maxpoints,
          l1, l2, r1, r2, Schapeau,logchapeau,Zmoy,
          confbounds, ord, residus,thetachapeau, gamf, trav,
          npoints, nx,  points, Rx,Rvalues,cestint, TousCodes)  !=OK)
      return((short int)1);

    /* passer au point suivant */
  l1=l2;
  /* pas la peine de recalculer R en ce nouveau l1: ca a deja ete fait */
  r1=r2;
  l2=l2+ (step-modif);
  /* init2 a pu modifier legerement l2 (l2+modif) pour pas qu'il soit pris
  pour une repet, donc on ote modif */
  if ( (l2 > fin) && (dernier==0))
    {
    /* on force l2 a fin de facon a ce que le dernier point de la grille courante
    soit traite, car il se peut qu'il ne le soit pas si l2 ne tombe pas
    pile dessus a cause des arrondis de precisions de la machine */
    dernier=1;
    l2=fin;
    }
  } /* fin du while sur l2 */

icoup=icoup-1;


/* traiter le dernier point de la grille de base */
if (icoup<0)
  {
  if ( !myisnan(r1) && (r1 >= confbounds[0]) && (r1 <= confbounds[1]))
    {
    /* on considere que l1 est dans l'intervalle de confiance */
    if (*npoints < maxpoints)
      points[ *npoints]=l1;
    else
      {
      /*  si le tableau de sortie n'est pas assez grand
          on met dans sa derniere position, le dernier element trouve
           en sortie, ce sera le plus grand */
      points[(maxpoints-1)]=l1;
      }
    *npoints=*npoints+1;


    if (etatint==PASCOM)    etatint=COM;
    if (etatint==FINI)      *cestint=0;
    } /* fin de  on considere que  l1 est dans l'intervalle de confiance */
  else
    {
    if (etatint==COM)      etatint=FINI;
    }
  } /* fin de (icoup<=0) */
return((short int)0);

} 
/* ------------- fin de calcRloop -----------------------*/

/* ------------------------------------------------------------------
 calcRnls2
 appele par la fonction S: calib.nls2.s
 R a deja ete calcule au 1ier point de la grille de recherche,
 calcRnls2 calcule R aux points suivants. 
 ------------------------------------------------------------------- */
void calcRnls2(debut, fin,
          n,m, pbase,  nbgf,
          gridpoints,
          maxpoints, nsplit,
          nval,  gridstep,
          Schapeau, logchapeau,
          Zmoy,
          confbounds, ord, residus,thetachapeau,gamf,
          trav,
          npoints, nx, 
          points, Rx, Rvalues,
          cestint, Code, TousCodes)
double *debut, *fin;
TFuncInt*n, *m, *pbase,*nbgf, *gridpoints, *maxpoints, *nsplit, *nval;
double *gridstep, *Schapeau, *logchapeau, *Zmoy ;
double *confbounds, *ord, *residus, *thetachapeau, *gamf ; 
double *trav;
TFuncInt*npoints, *nx, *cestint, *Code, *TousCodes ; 
double *points, *Rx, *Rvalues;

/* argu en entree:
debut, fin:  bornes incluses de la grille de recherche 
n: nbre d'observations de base
m: nbre d'observations rajoutees
pbase, nbgf: nbre de theta et da gamf
gridpoints: nbre de points desires dans la grille
maxpoints: nbre maxi de points solution
nsplit: nbre de redecoupes desirees
nval: nbre de valeurs de x et des R associes que l'on veut garder 
gridstep: espacement entre les points
Schapeau, Zmoy: servent au calcul
zchapeau=f-1(Zmoy) ou les x.bounds si Zmoy en-dehors de celles-ci
confbounds: bornes de l'intervalle de confiance
ord: valeurs de f a rajouter
residus: les residus calcules en rajoutant le 1ier point (pour
ne pas les recalculer et pour benificier de la place memoire de ceux-ci
pour mettre les suivants
thetachapeau: les theta estimes sur les observations de base
gamf: les gamf

 trav:tableau de travail: sert a mettre les derivees de f dont on
ne sert pas mais qu'on recupere obligatoirement quand on
appelle calcf 

 argu en sortie:
npoints: nbre de points solution
nx: nbre de points de calcul
cestint: 1 si les solutions sont dans un intervalle
points: les x qui sont solution
Rx: valeurs des x ou R est calcule, 
Rvalues: valeurs de R correspondantes 
Code =0 si OK , 1 sinon
*/
{
double  rdebut, rfin;
long int nan;

/* initialisations */

/* TousCodes=1 des que NL detecte une erreur non fatale
Code=1 si fatale */

*Code=*npoints= *nx=  0;
*cestint=1;  /* les sol sont dans un intervalle */
etatint=PASCOM; /* l'intervalle n'est pas commence */
icoup=0; /* on est dans la grille de base :pas encore de redecoupe */



rdebut=  mysignaling_nan(nan);
if (*Code == 0)
  {
  calcR1(*n,*m, *pbase, *nbgf,
           *Schapeau, *logchapeau, 
            *Zmoy, debut,thetachapeau, gamf,residus, trav,
            &rdebut);
  }

/* on enregistre le point meme si erreur: */
if (*nx < *nval)
  {
  Rx[*nx]= *debut;
  Rvalues[*nx]=rdebut; 
  }
*nx = *nx +1; /* compter le nbre de points de calcul */

/* boucle sur les points de recherche suivants */
if (calcRloop(*debut, *fin, rdebut, rfin,
          *n, *m, *pbase, *nbgf, *nsplit, *nval,  *gridpoints, *maxpoints,
          *gridstep, *Schapeau, *logchapeau, *Zmoy,
          confbounds, ord, residus,thetachapeau, gamf,
          trav,
          npoints, nx,  points, Rx, Rvalues,cestint, TousCodes) !=OK)
  {
  *Code=1;
  return;
  }
}

/* --------------------fin de calcRnls2 ----------------*/


