#include <stdio.h>
#include <string.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlglobal.h"
#include "nlchoix.h"
#include "dftypes.h"

/* les arguments de NL: */
#include "nldcl.h"

#define MAXLIG 255
#define MAXMOT 11
/*----------------FONCTIONS EXTERNES ------------*/
TShortInt calcpsi_ (TShortInt nbtheta,TShortInt nbgamma,
		    TShortInt nbobs,TShortInt nbvar,
		    TDouble *theta,TDouble *gamma,TDouble **z,
		    TDouble *psi,TDouble **dpsi,
		    TShortInt *le,TShortInt *ie);

TShortInt CreerMatC( TShortInt nblig, TShortInt nbcol, TMat *pmat);
void DetruMatC(TMat *pmat);
void cptemots(FILE *fic, TFuncInt *Nb, TFuncInt *Code);
void mots(FILE *fic, TFuncInt *Nb, char ***PointeurNoms, TFuncInt *Code);

/* ----------------- delPsinls2 -------------------------------
 Role: detruire les structures de NL crees
--------------------------------------------------------------- */
void delPsinls2()
{
DetruMatC(&(Donnees.XObsT));
return;
}
/* ----------------- end of delPsinls2 ----------------------------- */


/* -----------------namePsinls2 ------------------------ 
 Role: renvoyer les noms des  listes du fichier de description
-------------------------------------------------------- */

void namePsinls2(ficmod, NbPpsi,NbPbispsi, NbPsi, NbVarPsi,
            NomPpsi, NomPbispsi, NomPsi, NomVarPsi,
            Code)
/* arguments d'entree */
char **ficmod;
TFuncInt *NbPpsi, *NbPsi, *NbPbispsi, *NbVarPsi;
/* arguments de sortie */
char ***NomPpsi, ***NomPsi, ***NomPbispsi, ***NomVarPsi;
TFuncInt *Code;
{
char ch[MAXLIG];
char motlu[MAXMOT];

FILE *fic;

/* char NomModele[MAXLGFIC] ;strcpy(NomModele, *ficmod); */


if( (fic=fopen(*ficmod,"r")) == NULL)
  {
  fprintf(stderr,
"\nError when opening the model description file %s \n", *ficmod);
  *Code=ERR;
  return;
  }

while( fscanf(fic,"%s", motlu) != EOF)

    {
    if (strncmp(motlu, "%",1) ==0)
      {
      fgets(ch, MAXLIG, fic);
      continue;
      }


    if (strcmp(motlu,"psi")==0)
      {
      mots(fic, NbPsi, NomPsi,Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strcmp(motlu,"varpsi")==0)
      {
      mots(fic, NbVarPsi, NomVarPsi,Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strcmp(motlu,"ppsi")==0)
      {
      mots(fic, NbPpsi, NomPpsi,Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strcmp(motlu,"pbispsi")==0)
      {
      mots(fic, NbPbispsi, NomPbispsi,Code);
      if (*Code !=OK) return;
      continue;
      }
    if (strncmp(motlu,"subroutine", 10)==0)
      {
      break;
      }

  } /* fin du while */

fclose(fic);
return;
}

/* ---------------- end of  namePsinls2 ----------------- */

/* ----------------- crVarPsinls2 ---------------------- */
void crVarPsinls2(val, nblig, nbcol)

/* arguments d'entree */
double  *val;
TFuncInt *nblig,*nbcol;

{
int i,j;
int l=0;


/* allocation contigue: */
CreerMatC((TShortInt)*nblig, (TShortInt)*nbcol, &(Donnees.XObsT));

/* affectation */
for (j=0;j<*nbcol;j++)
  {
  for(i=0;i<*nblig;i++)
    {
    Donnees.XObsT.donnees[i][j]=val[l];
    l=l+1;
    }
  }

return;
}


/* ---------------- end of crVarPsinls2 ---------------------- */

/* -----------------nbPsinls2 ---------------------- */
/* compter les elements des listes du fichier de 
 description de psi */
void nbPsinls2(ficmod,
         NbPpsi, NbPbispsi, NbPsi, NbVarPsi,
         YaSubr,
         Code)

/* arguments d'entree */
char **ficmod;
/* arguments de sortie */
TFuncInt *NbPpsi, *NbPbispsi, *NbPsi, *NbVarPsi;
TFuncInt *YaSubr, *Code;

{
char motlu[MAXMOT], ch[MAXLIG];
FILE *fic;

/* char NomModele[MAXLGFIC]; strcpy(NomModele, *ficmod); */


if( (fic=fopen(*ficmod,"r")) == NULL)
  {
  fprintf(stderr,
"\nError when opening the model description file %s \n", *ficmod);
  *Code=ERR;
  return;
  }

while( fscanf(fic,"%s", motlu) != EOF)

    {
    if (strncmp(motlu, "%",1) ==0)
      {
      fgets(ch, MAXLIG, fic);
      continue;
      }


    if (strcmp(motlu,"varpsi")==0)
      {
      cptemots(fic, NbVarPsi, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strcmp(motlu,"psi")==0)
      {
      cptemots(fic, NbPsi, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strcmp(motlu,"ppsi")==0)
      {
      cptemots(fic, NbPpsi, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strcmp(motlu,"pbispsi")==0)
      {
      cptemots(fic, NbPbispsi, Code);
      if (*Code !=OK) return;
      continue;
      }

    if (strncmp(motlu,"subroutine", 10)==0)
      {
      *YaSubr=1;
      break;
      }


  } /* fin du while  */

fclose(fic);
return;
}

/* ---------------- end of nbPsinls2 ---------------------- */


/* ----------------- calcpsinls2 ---------------------- */
void calcpsinls2(pact, nbgf, 
            nbl, nbc,
            Ppsi, Pbispsi,
            psi, dpsi, le, ie)
      TFuncInt *pact, *nbgf, *nbc, *nbl;
      double *Ppsi, *Pbispsi,  *psi, *dpsi;
      TFuncInt *le, *ie;
{

short int i,j,l,lee,iee, RetCode;
TMat dfo;


/* mettre dpsi sous forme de matrice allouee continuement  */
CreerMatC(*nbl, *pact, &dfo);
lee=iee=0;

RetCode=calcpsi_((short int)*pact, (short int)*nbgf, 
            (short int)*nbl, (short int)*nbc,
            Ppsi, Pbispsi, 
            &(Donnees.XObsT.donnees[0]),
            psi, &(dfo.donnees[0]), &lee, &iee);

if(RetCode !=OK)
  {
  *ie=iee;
  *le=lee;
  return;
  }


/* Mettre dfo dans dpsi */
l=0;
for(i=0; i<*nbl; i++)
  {
  for (j=0; j< *pact; j++)
    {
     dpsi[l]=dfo.donnees[i][j]; 
     l=l+1;
    }
  }

/* desallouer dfo */
DetruMatC( &dfo);


*ie=0;
*le=0;

return;
}
/* ---------------- end of calcpsinls2 -----------------*/

