/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : dftypes.h                 |
| Date                 : 14 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Types pour le derivateur  |
| Reference conception : DCP, chap. 5              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/* Arbre:  type correspondant aux  noeuds  des arbres codants pour
les expressions */
typedef struct SArbre
{
  TDouble          valeur          /* Valeur du noeud */;
  TShortInt        fonction        /* Fonction attachee au noeud */;
  struct SArbre *  filsG           /* Sous-arbre gauche */;
  struct SArbre *  filsD           /* Sous-arbre droit */;
} TArbre;

/* ArbDe: type correspondant aux noeuds d'un arbre decore */
typedef struct SArbDe
{
  TDouble          valeur          /* Valeur du noeud */;
  TShortInt        fonction        /* Fonction attachee au noeud */;
  struct SArbDe *  filsG           /* Sous-arbre gauche */;
  struct SArbDe *  filsD           /* Sous-arbre droit */;
  TVectShort        Liste           /* liste des identificateurs employes */;
} TArbDe;

/*  Deriv: liste des arbres  des derivees pour  les expressions,
les derivees  sont rangees   par  expression puis    pour chaque
expression par variable de derivation */
typedef struct SDeriv
{
  TShortInt        nbele           /* nombre d'arbres de derivee */;
  TArbre **        arbre           /* listee des arbres de derivees */;
} TDeriv;

/* Derivees: structure contenant les derivees pour f, v, les
expressions auxiliaires,   et   le  jacobien, les   derivees  sont
rangees par expression puis  pour  chaque expression par variable de
derivation */
typedef struct SDerivees
{
  struct {
    TShortInt      nbele    /* nombre d'arbres de derivee */;
    TArbre **      arbre    /* liste des arbres de derivees */;
  }                DerivPsi   /* Derivees pour l'expression de f */;
  struct {
    TShortInt      nbele    /* nombre d'arbres de derivee */;
    TArbre **      arbre    /* liste des arbres de derivees */;
  }                DerivAux /* Derivees pour les expressions aux. */;
} TDeriveesPsi;

/* DerivAux: liste des arbres  des derivees pour les expressions
auxiliaires, les derivees sont  rangees par expression puis pour
chaque expression par variable de derivation */
typedef struct SDerivAux
{
  TShortInt        nbele    /* nombre d'arbres de derivee */;
  TArbre **        arbre    /* liste des arbres de derivees */;
} TDerivAux;

/* ident: sous-type de PPident, definit la structure associee a un
idenfificateur particulier */
typedef struct Sident
{
  TChaine        libelle         /* chaine de caractere */;
  TShortInt      nbutil          /* nombre d'utilisation */;
  TShortInt      type            /* type de l'identificateur (X, theta...) */;
} Tident;


/* PPident: sous-type de ModSpecif, definit la table des
identificateurs */
typedef struct SPPident
{
  TShortInt        nbele           /* nombre d'identificateurs */;
  Tident *         ident           /* sturcture d'un identificateur */;
} TPPident;

/* Sous-type de ModSpecif */
typedef struct SUnPsiF
{
  TShortInt   ident                /* identificateur associe */;
  TArbre *    arbre                /* arbre associe */;
} TUnPsi;

/* UnAux: sous-type de ModSpecif, definit la liste des identificateurs
correspondants aux Auxiliaires */
typedef struct SUnAux
{
  TShortInt   ident                /* identificateur associe */;
  TArbre *    arbre                /* arbre associe */;
} TUnAux;

/* UneCst: sous-type de ModSpecif, definit la liste ds identificateurs
correspondants aux Constantes */
typedef struct SUneCst
{
  TShortInt   ident               /* identificateur associe */;
  TDouble     valeur              /* valeur associe */;
} TUneCst;
/* ModSpecif: structure contenant les informations decodees
du fichier de description formelle */
typedef struct SModSpecif
{
  TPPident PPident                /* Table des identificateurs */;
  struct {
    TShortInt     nbele ;
    TUnPsi *      UnPsi ;
  } IdePsi                        /* description de psi */;
  struct {
    TShortInt     ident           /* identificateur associe */;
    TArbre *      arbre           /* arbre associe */;
  } IdeV                          /* Description de v */;
  TVectShort      IdeZ            /* Description des X */;
  TVectShort      IdeAct          /* Description des theta */;
  TVectShort      IdeGam          /* Description des gamma_f */;
  TShortInt       Resp            /* Si 1 : il y a une expression codant f */;

  struct {
    TShortInt     nbele           /* nombre d'expressions auxiliaires */;
    TUnAux *      UnAux           /* liste des aux */;
  } Auxiliaire                  /* Description des expressions auxiliaires */;
  struct {
    TShortInt     nbele           /* nombre de constantes */;
    TUneCst * UneCst              /* liste des constantes */;
  } Constantes                    /* Description des constantes */;
  TShortInt       Subroutine   /* =1 si des subroutines doivent etre crees */;
  TLogic          typeUsed[17]    /* controle de declaration */;
  TShortInt       NomFich         /* identificateur du nom de fichier */;
  TShortInt       Unique          /* indique declaration / affectation */;
  TLogic          yaerr           /* indique une erreur rencontree */;
  TLogic          erraff          /* indique une erreur dans 1 affectation */;
  TArbre **       ParamEntre      /* tableau ou sont affectes les parametres
                                     d'entree lors de l'appel a l'eval. */;
} TModSpecifPsi;

/* UnAuxDe: sous-type utilise pour les auxiliaires du modele standard */
typedef struct SUnAuxDe
{
  TShortInt   ident           /* identificateur associe */;
  TArbDe *    arbre           /* arbre associe */;
} TUnAuxDe;

/* ModStandard: structure necessaire a la partie derivation
(  cette   structure est standardisee   de   facon   a ce  que
l'ensemble   des  modules correspondant   a la derivation  restent
reutilisables) */
typedef struct SModStandard
{
  TVectShort      TypeIdent       /* Liste des types des identificateurs */;
  TVectShort      IdentDeriv      /* Liste des variables de derivation */;
  TVectShort      IdentFixe       /* Liste des autres variables */;
  struct {
    TShortInt     nbele           /* nombre d'expressions auxiliaires */;
    TUnAuxDe *    UnAux;
  } Auxiliaire                    /* Liste des expressions auxiliaires */;
  struct {
    TShortInt     nbele           /* nombre de constantes */;
    TUneCst *     UneCst;
  } Constantes                    /* Liste des constantes */;
  struct {
    TShortInt     nbele           /* Nombre d'expressions a deriver */;
    TArbDe **     arbre           /* Liste des expressions a deriver */;
       } Expressions;
} TModStandard;

/* RetModele:  structure necessaire a l'interface avec NL */
typedef struct SRetModele
{
  TVectStr        NomPsi ;
  TVectStr        NomZ            /* Noms des X */;
  TVectStr        NomAct        /* Noms des theta */; 
  TVectStr        NomGam         /* Noms des gamma_f */;
  TChaine         NomFich         /* Nom du fichier de sortie */;
} TRetModelePsi;
