
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/
/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlmacros.h"
#include "nlchoix.h"

/*----------------FONCTIONS EXTERNES ------------*/
void generxnls2(double theta, double se, 
		double extends0, double extends1, 
		double bounds0, double bounds1, 
		TFuncInt nbpoints0, TFuncInt nbpoints1,double *x);
/* ------------------------------------------------------------------
ellipsnls2: Computing the confidence ellipsoides on given parameters values 
---------------------------------------------------------------------- */
void ellipsnls2(theta1, theta2, cor12, se1, se2, 
           nbpoints, extends, bounds,
           x, y, z)
/* arguments d'entree */
/* scalaires */
double *theta1, *theta2, *cor12, *se1, *se2;
/* vecteurs */
TFuncInt *nbpoints;
double *extends, *bounds;

/* argu de sortie */
double *x, *y;
double *z;

{
int i,j,l, nbx, nby;
double det,a11, a22, a12;

/* generation des coordonnees des points */
generxnls2(*theta1, *se1, extends[0], extends[1], 
                bounds[0], bounds[1],nbpoints[0], nbpoints[1], x);
generxnls2(*theta2, *se2, extends[2], extends[3], 
                bounds[2], bounds[3],nbpoints[2], nbpoints[3], y);

det= *cor12 * *cor12;
a11=1. /((1 -det) * (*se1 * *se1));
a22=1. /((1 -det) * (*se2 * *se2));
a12= - *cor12 / ((1. -det) * *se1 * *se2);

nbx= nbpoints[0]+ nbpoints[1];
nby= nbpoints[2]+ nbpoints[3];

l=0;
for (i=0; i<nbx; i++)
  {
  for (j=0; j<nby; j++)
    {
    z[l]= a11 * (x[i] - *theta1)* (x[i] - *theta1) +
          a22 * (y[j] - *theta2)* (y[j] - *theta2) +
          2. * a12 * (x[i] - *theta1) * (y[j] - *theta2);
    l=l+1;
    }
  }
return;
}

/* -------------- fin fonction  ellipsnls2 ---------------- */


