/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- MODULE IDENTIFICATION ------------
| Name                 : ToMyOwn                   |
| Role                 : the programmes the user   |
| must provide when the method is MYOWN            |
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <math.h>
#include <stdio.h>

#include "nlcodes.h"
#include "nlchoix.h"
#include "nltypes.h"
#include "nlglobal.h"
#include "nlmacros.h"
#include "errcodes.h"

#include "nldcl.h"
/* ----------- To acces global variables: ----------
It may be necessary to access variables in addition
to those accessible through the argument-lists.
Some are global variables:
see include/nldcl.h and include/nltypes.h
For example, Theta[0] contains the values of the
regression parameters for the first step.
Its "Act" component contains the values of the
active parameters and "Estim", the corresponding
values of the multiple parameters.
ResStat[0] contains the current results of the
first step. 
For example, ResStat[0].FctSensib.DValf contains 
the derivatives of f with respect to the multiple 
parameters and ResStat[0].FctSensib.DVarYTheta,
ResStat[0].FctSensib.DVarYBeta contain the derivatives
of the variance of Y, with respect to the multiple 
parameters Theta and Beta , respectively.
 -------------------------------------------------*/

/*--------------- Function identification ----------
| Function name         : calcb                    |
| Role                  : Calculate B              |
|  You can inspire from the programs CB* of file   |
|  NLEquN.c in the source-directory of NL          |
| Input arguments       :                          |
|  NbRepet: number of replications of each         |
|          observation                             |
|  Valf: values of the regression function f       |
|  VarY: values of the variance of Y               |
|  S2: the intra-replications variance.            |
|  DValf: derivates of the function f with respect |
|     to the active parameters Theta               |
|  DVarYTheta: derivates of the variance of Y      |
|     with respect to the active parameters Theta  |
|     or matrix of dimensions equal to zero        |
|  DVarYBeta: derivates of the variance of Y       |
|     with respect to the active parameters Beta   |
|     or matrix of dimensions equal to zero        |
| Output arguments      :                          |
|  ValB: matrix B                                  |
|        dimension: NbZ*NbObs, (NbTheta+NbBeta)    | 
|    Already allocated                             |
| Return value          : OK (=0) or error code    |
--------------------------------------------------*/

/*--------------- Cross references ----------------
| Functions called     :  <insert here the names   |
|    of the functions called>                      |
| Calling functions    : CCovNu2, CCovNu3, PussIter|
|       Retablir                                   |
|  through the function pointer PCValB             |
--------------------------------------------------*/


/*--------------- Function definition ------------*/

TShortInt calcb(NbRepet, Valf, VarY, S2, DValf, DVarYTheta, DVarYBeta,
                 ValB)

/* input arguments */
TVectLong *NbRepet; /* dimension NbObs */
TVect *Valf, *VarY, *S2; /* dimension NbObs */
TMat *DValf; /* dimension NbObs, NbTheta */
TMat *DVarYTheta; /* dimension NbObs, NbTheta */
TMat *DVarYBeta;  /* dimension NbObs, NbBeta */


/* output arguments */
TMat *ValB; /* dim: NbZ*NbObs, NbTheta+NbBeta */

/*--------------- End function definition ----*/

{
/* If wanted, write into the trace of the called programs */
ECRTRACE("calcb");

/* insert here the function body */

return(OK);
}


/*--------------- Function identification ----------
| Function name         : calcd                    |
| Role                  : Calculate D              |
|  You can inspire from the programs CD* of file   |
|  NLEquN.c in the source-directory of NL          |
| Input arguments       :                          |
|  Valf: values of the regression function f       |
|  DValf: derivates of the function f with respect |
|     to the active parameters Theta               |
|  DVarYTheta: derivates of the variance of Y      |
|     with respect to the active parameters Theta  |
|     or matrix of dimensions equal to zero        |
|  DVarYBeta: derivates of the variance of Y       |
|     with respect to the active parameters Beta   |
|     or matrix of dimensions equal to zero        |
| Output arguments      :                          |
|  ValD: matrix D                                  |
|        dimension: NbZ*NbObs,(NbTheta+NbBeta)     | 
|    Already allocated                             |
| Return value          : OK (=0) or error code    |
--------------------------------------------------*/

/*--------------- Cross references ----------------
| Functions called     :  <insert here the names   |
|    of the functions called>                      |
| Calling functions    : CCovNu2, CCovNu3, PussIter|
|       Retablir                                   |
|  through the function pointer PCValD             |
--------------------------------------------------*/

/*--------------- Function definition ------------*/

TShortInt calcd( Valf, DValf, DVarYTheta, DVarYBeta,
                 ValD)

/* input arguments */
TVect *Valf; /* dimension NbObs */
TMat *DValf; /* dimension NbObs, NbTheta */
TMat *DVarYTheta; /* dimension NbObs, NbTheta */
TMat *DVarYBeta;  /* dimension NbObs, NbBeta */


/* output arguments */
TMat *ValD; /* dim: NbZ*NbObs, NbTheta+NbBeta */

/*--------------- End function definition ----*/

{

/* If wanted, write into the trace of the called programs */
ECRTRACE("calcd");

/* insert here the function body */


return(OK);
}


/*--------------- Function identification ----------
| Function name         : calceta                  |
| Role                  : Calculate Eta            |
|  You can inspire from the programs CEta* of file |
|  NLEquN.c in the source-directory of NL          |
| Input arguments       :                          |
|  Valf: values of the regression function f       |
|  VarY: values of the variance of Y               |
| Output arguments      :                          |
|  ValEta: vector Eta                              |
|        dimension: NbZ*NbObs                      | 
|    Already allocated                             |
| Return value          : OK (=0) or error code    |
--------------------------------------------------*/

/*--------------- Cross references ----------------
| Functions called     :  <insert here the names   |
|    of the functions called>                      |
| Calling functions    :  PussIter, Retablir       |
|  through the function pointer PCValEta           |
--------------------------------------------------*/

/*--------------- Function definition ------------*/

TShortInt calceta( Valf, VarY,
                 ValEta)

/* input arguments */
TVect *Valf; /* dimension NbObs */
TVect *VarY; /* dimension NbObs */

/* output arguments */
TVect *ValEta; /* dim: NbZ*NbObs */

/*--------------- End function definition ----*/

{

/* If wanted, write into the trace of the called programs */
ECRTRACE("calceta");

/* insert here the function body */


return(OK);
}



/*--------------- Function identification ----------
| Function name         : calcz                    |
| Role                  : Calculate the vector of  |
|  the sufficient statistics Z and calculate its   |
|  values                                          |
|  You can inspire from the programs CZ* of file   |
|  NLExhau.c in the source-directory of NL         |
| Input arguments       :                          |
|  Y1: the sum of the response values on the       |
|     replications weighted by the number of       |
|      replications                                |
|  Y2: the sum of the squared values of the        |
|      response on the replications weighted by the|
|      number of replications                      |
| Output arguments      :                          |
|  ValZ: the vector Z                              |
|    Dimension NbObs*nh                            |
|    Already allocated                             |
| Return value          : OK (=0) or error code    |
--------------------------------------------------*/

/*--------------- Cross references ----------------
| Functions called     :  <insert here the names   |
|    of the functions called>                      |
| Calling functions    : NLEtape                   |
|  through the function pointer PCValZ             |
--------------------------------------------------*/

/*--------------- Function definition ------------*/
TShortInt calcz(Y1,Y2,ValZ)

  /* input arguments */
  TVect *Y1,*Y2;

  /* output argument */
  TVect *ValZ;


/*--------------- End function definition ----*/
{
/* If wanted, write into the trace of the called programs */
 ECRTRACE("calcz");


/* insert here the function body */

return(OK);
}


/*--------------- Function identification ----------
| Function name         : calcvarz                 |
| Role                  : Create the vector of the |
|  variance of Z and calculate its value           |
|  You can inspire from the programs CVarZ* of file|
|  NLExhau.c in the source-directory of NL         |
| Input arguments       :                          |
|  NbObsT: number of observations, replications    |
|   included                                       |
|  NbRepet: number of replications of each         |
|          observation                             |
|  PoidsT: weighting values affected on the        |
|   observations, replications included            |
|  ValY: observed values of the response           |
|  Ajustes: a structure that contains:             |
|      Valf: values of the regression function f   |
|      VarY: values of the variance of Y           |
| Input-output arguments :                         |
|  TypeMu: code for the way of calculating the     |
|    moments                                       |
|  Residus : the non-standardized residuals        |
|  Mu3 : moments of order 3                        |
|  Mu4 : moments of order 4                        |
| Output arguments      :                          |
|  VarZ: matrix that contains the variance of Z    |
|    Already allocated                             |
|    Dimension NbObs*nh, NbObs*nh                  |
|  Code:  OK (=0) or error code                    |
| Return value          : OK (=0) or error code    |
|  when the error is fatal for the remaining of the|
|  execution                                       |
--------------------------------------------------*/

/*--------------- Cross references ----------------
| Functions called     :  <insert here the names   |
|    of the functions called>                      |
| Functions called     :                           |
| Calling functions    :  CBVarZBP                 |
|   through the function pointer PCValZ            |
--------------------------------------------------*/

/*--------------- Function definition ------------*/


TShortInt calcvarz( NbObsT, NbRepet, PoidsT, ValY, Ajustes,
              TypeMu, Residus, Mu3, Mu4,
              VarZ, Code)

/* input arguments */
TLongInt NbObsT;
TVectLong *NbRepet;
TVect *PoidsT, *ValY;
TAjustes *Ajustes;

/* input-output arguments */
TShortInt *TypeMu;
TVect *Residus;
TVect *Mu3, *Mu4;

/* output arguments*/
TMat *VarZ; /* dimension NbObs*NbZ, NbObs*NbZ  */
TShortInt *Code;

/*--------------- End function definition ----*/
{
/* If wanted, write into the trace of the called programs */
ECRTRACE("calcvarz");

/* insert here the function body */

return(OK);
}


/*--------------- Function identification ----------
| Function name         : myinv                    |
| Role                  : invert the matrix W      |
|  when it is no SYM neither SYMB                  |
| Input arguments       :                          |
|  ValW: matrix W                                  |
| Output arguments      :                          |
|  ValWInv: matrix of same dimension than ValW     |
|    Already allocated                             |
| Return value          : OK (=0) or error code    |
--------------------------------------------------*/

/*--------------- Cross references -----------------
| Functions called     :  <insert here the names   |
|    of the functions called>                      |
| Calling functions    :  CArret                   |
--------------------------------------------------*/


/*--------------- Function definition ------------*/

TShortInt myinv(ValW, ValWInv)

/* input arguments */
TMat *ValW;

/* output arguments*/
TMat *ValWInv;

/*--------------- End function definition ----*/

{

/* insert here the function body */

return(OK);
}

/*--------------- Function identification ----------
| Function name         : calcc                    |
| Role                  : Calculate the fitting    |
|  criterion: to provide only if the way of        |
|  calculating it is your own                      |
|  You can inspire from the programs of file       |
|  Critere.c in the source-directory of NL         |
| Input arguments       :                          |
|  Sigma2:  the estimated value of square sigma    |
|  NbObsT:  number of observations, replications   |
|           included                               |
|  NbRepet: number of replications of each         |
|          observation                             |
|  Y1: the sum of the response values on the       |
|     replications weighted by the number of       |
|      replications                                |
|  Y2: the sum of the squared values of the        |
|      response on the replications weighted by the|
|      number of replications                      |
|  S2: the intra-replications variance.            |
|  Valf: values of the regression function f       |
|  VarY: values of the variance of Y               |
| Output arguments      :                          |
|  Crit: the fitting criterion                     |
| Return value          : OK (=0) or error code    |
--------------------------------------------------*/

/*--------------- Cross references ----------------
| Functions called     :  <insert here the names   |
|    of the functions called>                      |
| Calling functions    :  PussIter                 |
--------------------------------------------------*/


/*--------------- Function definition ------------*/

TShortInt calcc(Sigma2, NbObsT, NbRepet, Y1, Y2, S2, Valf, VarY,
                Crit)

/* input arguments */
TDouble Sigma2;
TLongInt NbObsT;
TVectLong *NbRepet; /* dimension NbObs */
TVect *Y1, *Y2, *S2, *Valf, *VarY; /* dimension NbObs */

/* output arguments */
TDouble *Crit;

/*--------------- End function definition ----*/

{
/* If wanted, write into the trace of the called programs */
ECRTRACE("calcc");

/* insert here the function body */

return(OK);
}


