/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : alloueIde.c               |
| Date                 : 19 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : gere le type de l'identificateur dans PPident
| Reference conception : DCP module 8              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;
extern int monyylineno;

/*--------------- FONCTIONS EXTERNES -------------*/
extern void *calloc(size_t nmemb, size_t size);
extern void *malloc(size_t size);

extern TShortInt erreAnal(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : alloueIde                |
| Role                  : gere le type de l'identificateur dans PPident
| Parametres d'entree   : type liste               |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 8             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt alloueIde(type, liste)
     TShortInt type;
     TVectShort liste;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TPPident * LPPident;

  LPPident=&GModSpecif.PPident;
  for (i=0; i<liste.nbele; i++)
    {
      LPPident->ident[liste.donnees[i]].type=type;
    }
return (TShortInt)1;
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : copiConst                |
| Role                  : met a jour GModSpecif.Constantes
| Parametres d'entree   : liste                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 5 et 8        |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt copiConst(liste)
     TVectShort liste;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  GModSpecif.Constantes.nbele=liste.nbele;
  GModSpecif.Constantes.UneCst=(TUneCst *)malloc(liste.nbele*sizeof(TUneCst));
  if (GModSpecif.Constantes.UneCst==NULL)
    {
      erreAnal(EMEM, NULL);
    }
  else
    {
      for (i=0; i<liste.nbele; i++)
	{
	  GModSpecif.Constantes.UneCst[i].ident=liste.donnees[i];
	}
    }
return (TShortInt)1;
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : copiAux                 |
| Role                  : met a jour GModSpecif.Auxiliaires
| Parametres d'entree   : liste                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 5 et 8        |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt copiAux(liste)
     TVectShort liste;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  GModSpecif.Auxiliaire.nbele=liste.nbele;
  GModSpecif.Auxiliaire.UnAux=(TUnAux *)calloc(liste.nbele, sizeof(TUnAux));
  if (GModSpecif.Auxiliaire.UnAux==NULL)
    {
      erreAnal(EMEM, NULL);
    }
  else
    {
      
      for (i=0; i<liste.nbele; i++)
	{
	  GModSpecif.Auxiliaire.UnAux[i].ident=liste.donnees[i];
	}
    }
return (TShortInt)1;
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : copiLesdF                |
| Role                  : met a jour GModSpecif.IdeLesDF
| Parametres d'entree   : liste                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 5 et 8        |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt copiLesdF(liste)
     TVectShort liste;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  GModSpecif.IdeLesDF.nbele=liste.nbele;
  GModSpecif.IdeLesDF.UnDF=(TUnDF *)calloc(liste.nbele, sizeof(TUnDF));
  if (GModSpecif.IdeLesDF.UnDF==NULL)
    {
      erreAnal(EMEM, NULL);
    }
  else
    {
      for (i=0; i<liste.nbele; i++)
	{
	  GModSpecif.IdeLesDF.UnDF[i].ident=liste.donnees[i];
	}
    }
return (TShortInt)1;
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : TestUtil                 |
| Role                  : test si une declaration a deja ete faite
| Parametres d'entree   : type                     |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 5 et 8        |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TLogic TestUtil(type)
     TShortInt type;

/*--------------- Fin identification fonction ----*/

{
  if (GModSpecif.typeUsed[type] == NON)
    {
      GModSpecif.typeUsed[type]=OUI;
      return(VRAI);
    }
  else
    {
      switch(type)
	{
	case IDEF:
	  erreAnal(EELEM, LRESP);
	  break;
	case IDEV:
	  erreAnal(EELEM, LVAR);
	  break;
	case IDEX:
	  erreAnal(EELEM, LVARIND);
	  break;
	case IDETHETA:
	  erreAnal(EELEM, LPARRESP);
	  break;
	case IDEBETA:
	  erreAnal(EELEM, LPARVAR);
	  break;
	case IDEGAMF:
	  erreAnal(EELEM, LPBISRESP);
	  break;
	case IDEGAMV:
	  erreAnal(EELEM, LPBISVAR);
	  break;
	case IDELESDF:
	  erreAnal(EELEM, LLESDF);
	  break;
	case IDELESF:
	  erreAnal(EELEM, LLESF);
	  break;
	case IDEVARINT:
	  erreAnal(EELEM, LVARINT);
	  break;
	case IDEVALINT:
	  erreAnal(EELEM, LVALINT);
	  break;
	case IDEAUX:
	  erreAnal(EELEM, LAUX);
	  break;
	case IDECONST:
	  erreAnal(EELEM, LCONST);
	  break;
	case IDEFICH:
	  erreAnal(EELEM, LNOMFICH);
	  break;
	case IDESUBR:
	  erreAnal(EELEM, LSUBROUTINE);
	  break;
	}
      return(FAUX);
    }
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : InclValInt               |
| Role                  : teste si les valeur d'integrations sont incluses
                          strictement dans les variables du modele
| Parametres d'entree   : valint                   |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 8             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : errAnal                   |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TLogic InclValInt(valint)
     TVectShort valint;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TLogic test;
  TShortInt type;

  test=VRAI;
  type=GModSpecif.PPident.ident[valint.donnees[0]].type;
  if (type!=IDEX && type>=IDEF)
    {
      test=FAUX;
      erreAnal(EINCLVI, GModSpecif.PPident.
	       ident[valint.donnees[0]].libelle);     
      return(test);
    }
  i=0;
  while (test==VRAI && i<valint.nbele)
    {
      if (GModSpecif.PPident.ident[valint.donnees[i]].type!=type)
	{
	  test=FAUX;
	  erreAnal(EINCLVI, GModSpecif.PPident.
		   ident[valint.donnees[i]].libelle);
	}
      i++;
    }
return(test);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : InclCondInit             |
| Role                  : verifie l'inclusion des conditions initiales
                          dans les parametres du modele
| Parametres d'entree   : condinit                 |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 8             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TLogic InclCondInit(condinit)
     TVectShort condinit;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  for (i=0; i<condinit.nbele; i++)
    {
      if (GModSpecif.PPident.ident[condinit.donnees[i]].type!=IDETHETA)
	{
	  erreAnal(EINCLCI, GModSpecif.PPident.
		   ident[condinit.donnees[i]].libelle);
	  return(FAUX);
	}
    }
  return(VRAI);
}
