/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : analDer.c                 |
| Date                 : 12 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : point d'entre de l'analyseur derivateur
| Reference conception : DCP module 1              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"
#include "nlglobal.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;
extern TDerivees Derivees;

/*--------------- FONCTIONS EXTERNES -------------*/
extern void *malloc(size_t size);
extern TShortInt alloueIde(TShortInt type, TVectShort liste);
extern TShortInt prepDer(TModSpecif  GModSpecif, TDerivees * Derivees);
extern TShortInt geneSubr(TModSpecif GModSpecif, TDerivees Derivees, TChaine NomDescr);
extern TShortInt prepEval();
extern TShortInt analyse(TChaine  NomDescr);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : analDer                  |
| Role                  : point d'entree de l'analyseur derivateur
| Parametres d'entree   : NomDescr                 |
| Parametres de sortie  : RetModele RetInteg       |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 1             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : analyse prepDer geneSubr  |
| Fonctions appelantes :                           |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt analDer(TChaine NomDescr, int gfile, TRetModele * RetModele, 
		  TRetInteg * RetInteg)

/*--------------- Fin identification fonction ----*/
{
  TShortInt i;
  /* appel de l'analyseur */
  analyse(NomDescr);

  if (GModSpecif.yaerr==OUI)
    {
      fprintf(stderr, EFATAL);
      return(FAUX);
    }

  /* appel du derivateur */
  if (prepDer(GModSpecif, &Derivees)==FAUX)
    {
      fprintf(stderr, EFATAL);
      return(FAUX);
    }

  /* appel au stockage des subroutines en C */
  if (GModSpecif.Subroutine==OUI)
    {
      if (gfile == 1)
	geneSubr(GModSpecif, Derivees, NomDescr);
      if (GModSpecif.yaerr==OUI)
	{
	  fprintf(stderr, EFATAL);
	  return(FAUX);
	}
    }
   else
     fprintf(stderr, WSUBR);


  /* appel a la preparation en vue de l'evaluation des arbres */
  if (prepEval(GModSpecif, Derivees) == FAUX)
    {
      fprintf(stderr, EFATAL);
      return(FAUX);
    }

  /* gere les structures a retourner en sortie */
  if (GModSpecif.IdeCondInit.nbele!=0)
    {
      RetInteg->IndicCi=OUI;
    }
  else
    {
      RetInteg->IndicCi=NON;
    }
  RetInteg->IndicTj.nbele=GModSpecif.IndicTj.nbele;
  RetInteg->IndicTj.donnees=GModSpecif.IndicTj.donnees;
  RetInteg->IndicX=GModSpecif.IndicX;
  RetInteg->NbJ=GModSpecif.IdeValInt.nbele;
  RetInteg->NbEq=GModSpecif.IdeLesDF.nbele;
  RetInteg->NbThetaSedo=GModSpecif.NbThetaSedo;

  RetModele->NomX.nbele=GModSpecif.IdeX.nbele;
  RetModele->NomX.donnees=(TChaine *)malloc(GModSpecif.IdeX.nbele*
					   sizeof(TChaine));
  if (RetModele->NomX.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModele->NomX.nbele; i++)
    {
      RetModele->NomX.donnees[i]=GModSpecif.PPident.
	ident[GModSpecif.IdeX.donnees[i]].libelle;
    }

  RetModele->NomY=GModSpecif.PPident.ident[GModSpecif.IdeF.ident].libelle;
  RetModele->NomV=GModSpecif.PPident.ident[GModSpecif.IdeV.ident].libelle;

  RetModele->NomTheta.nbele=GModSpecif.IdeTheta.nbele;
  RetModele->NomTheta.donnees=(TChaine *)malloc(GModSpecif.IdeTheta.nbele*
					   sizeof(TChaine));
  if (RetModele->NomTheta.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }

  for (i=0; i<RetModele->NomTheta.nbele; i++)
    {
      RetModele->NomTheta.donnees[i]=GModSpecif.PPident.
	ident[GModSpecif.IdeTheta.donnees[i]].libelle;
    }

  RetModele->NomBeta.nbele=GModSpecif.IdeBeta.nbele;
  RetModele->NomBeta.donnees=(TChaine *)malloc(GModSpecif.IdeBeta.nbele*
					   sizeof(TChaine));
  if (RetModele->NomBeta.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModele->NomBeta.nbele; i++)
    {
      RetModele->NomBeta.donnees[i]=GModSpecif.PPident.
	ident[GModSpecif.IdeBeta.donnees[i]].libelle;
    }

  RetModele->NomGamF.nbele=GModSpecif.IdeGamF.nbele;
  RetModele->NomGamF.donnees=(TChaine *)malloc(GModSpecif.IdeGamF.nbele*
					   sizeof(TChaine));
  if (RetModele->NomGamF.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModele->NomGamF.nbele; i++)
    {
      RetModele->NomGamF.donnees[i]=GModSpecif.PPident.
	ident[GModSpecif.IdeGamF.donnees[i]].libelle;
    }

  RetModele->NomGamV.nbele=GModSpecif.IdeGamV.nbele;
  RetModele->NomGamV.donnees=(TChaine *)malloc(GModSpecif.IdeGamV.nbele*
					   sizeof(TChaine));
  if (RetModele->NomGamV.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModele->NomGamV.nbele; i++)
    {
      RetModele->NomGamV.donnees[i]=GModSpecif.PPident.
	ident[GModSpecif.IdeGamV.donnees[i]].libelle;
    }

  RetModele->NomFich=GModSpecif.PPident.ident[GModSpecif.NomFich].libelle;
  RetModele->CasSedo=GModSpecif.CasSedo;
  RetModele->YaCalcV=GModSpecif.Vari;
  RetModele->NomValInt.nbele=GModSpecif.IdeValInt.nbele;
  RetModele->NomValInt.donnees=(TChaine *)malloc(GModSpecif.IdeValInt.nbele *
						sizeof(TChaine));
  if (RetModele->NomValInt.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModele->NomValInt.nbele; i++)
    {
      RetModele->NomValInt.donnees[i]=GModSpecif.PPident.
	ident[GModSpecif.IdeValInt.donnees[i]].libelle;
    }
  RetModele->NomLesF.nbele=GModSpecif.IdeLesF.nbele;
  RetModele->NomLesF.donnees=(TChaine *)malloc(GModSpecif.IdeLesF.nbele *
						sizeof(TChaine));
  if (RetModele->NomLesF.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModele->NomLesF.nbele; i++)
    {
      RetModele->NomLesF.donnees[i]=GModSpecif.PPident.
	ident[GModSpecif.IdeLesF.donnees[i]].libelle;
    }
  RetModele->NomLesDF.nbele=GModSpecif.IdeLesDF.nbele;
  RetModele->NomLesDF.donnees=(TChaine *)malloc(GModSpecif.IdeLesDF.nbele *
						sizeof(TChaine));
  if (RetModele->NomLesDF.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModele->NomLesDF.nbele; i++)
    {
      RetModele->NomLesDF.donnees[i]=GModSpecif.PPident.
	ident[GModSpecif.IdeLesDF.UnDF[i].ident].libelle;
    }
  return(VRAI);
}
