/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : bouclArb.c                |
| Date                 : 16 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Detecte les bouclages dans les auxiliaires
| Reference conception : DCP module 18             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include <stdlib.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;

/*--------------- FONCTIONS EXTERNES -------------*/
extern TShortInt erreAnal(TChaine message, TChaine param);
extern void *malloc(size_t size);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : lireAux                  |
| Role                  : rempli la table de contingence pour un auxiliaire
| Parametres d'entree   : arbre                    |
| Parametres de sortie  : table                    |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 18            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : bouclArb                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt lireAux(table, arbre)
     TShortInt * table;
     TArbre * arbre;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  
  if (arbre==NULL)
    {
      return ((TShortInt)0);
    }
  if (arbre->fonction<0)
    {
      /* on est sur un identificateur */
      if (GModSpecif.PPident.ident[-arbre->fonction].type==IDEAUX)
	{
	  /* cet identificateur est un auxiliaire */

	  i=0;
	  /* on localise son rang dans les auxiliaires */
	  while (GModSpecif.Auxiliaire.UnAux[i].ident!=-arbre->fonction)
	    {
	      i++;
	    }
	  /* on rempli la table */
	  table[i]=1;
	}
    }
  else
    {
      /* on parcours l'arbre */
      lireAux(table, arbre->filsG);
      lireAux(table, arbre->filsD);
    }
      return ((TShortInt)0);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : bouclArb                 |
| Role                  : Detecte les bouclages dans les auxiliaires
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 18            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal lireAux          |
| Fonctions appelantes : coheExpr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt bouclArb()

/*--------------- Fin identification fonction ----*/

{
  TShortInt ** table;
  TShortInt indice;
  TShortInt i, j, k;
  TShortInt max;
  TArbre * arbre;
  
  max=GModSpecif.Auxiliaire.nbele;
  indice=0;

  /* creation de la table de contingence */
  table=(TShortInt **)malloc(max*sizeof(TShortInt*));
  if (table==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }
  for (i=0; i<max; i++)
    {
      table[i]=(TShortInt *)malloc((max+2)*sizeof(TShortInt));
      if (table[i]==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
    }

  /* remplissage de la table de contingence */
  for (i=0; i<max; i++)
    {
      /* initialisation de la table */
      for (j=0;j<max+2; j++)
	{
	  table[i][j]=0;
	}
      /* remplissage de la ligne i */

      lireAux(table[i], GModSpecif.Auxiliaire.UnAux[i].arbre);
    }

  /* exploitation de la table de contingence */
  i=0;
  while (i<max)
    {
      /* on calcule les sommes de contingence par ligne (table[j][max+1])*/
      for (j=0; j<max; j++)
	{
	  table[j][max+1]=0;
	  for (k=0; k<max; k++)
	    {
	      table[j][max+1]=table[j][max+1] + table[j][k];
	    }
	}

      /* on cherche une ligne ayant une somme nulle et non encore triee */
      j=0;
      while(j<max && table[j][max]!=table[j][max+1])
	{
	  j++;
	}

      /* on est sur un cas d'erreur */
      if (j==max)
	{
	  erreAnal(EBOUCL, NULL);
	  return(FAUX);
	}

      /* on traite la ligne selectionnee */
      indice++;
      /* on lui affecte un numero d'ordre */
      table[j][max]=indice;
      /* on supprime l'expression de la table de contingence */
      for (k=0; k<max; k++)
	{
	  table[k][j]=0;
	}

      /* on traite une autre ligne de la table */
      i++;
    }

  /* tri des expressions auxiliaires */
  for (i=0; i<max; i++)
    {
      j=i;
      while (table[j][max]!=i+1)
	{
	  j++;
	}
      /* on inverse */
      if (j!=i)
	{
	  table[j][max]=table[i][max];
	  k=GModSpecif.Auxiliaire.UnAux[j].ident;
	  GModSpecif.Auxiliaire.UnAux[j].ident=
	    GModSpecif.Auxiliaire.UnAux[i].ident;
	  GModSpecif.Auxiliaire.UnAux[i].ident=k;
	  arbre=GModSpecif.Auxiliaire.UnAux[j].arbre;
	  GModSpecif.Auxiliaire.UnAux[j].arbre=
	    GModSpecif.Auxiliaire.UnAux[i].arbre;
	  GModSpecif.Auxiliaire.UnAux[i].arbre=arbre;
	}
    }

  return(VRAI);  
}
