/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : chargArb.c                |
| Date                 : 16 aout 1991              |
| Derniere mise a jour : %e%    / %u%              |
| Concepteur           : Alain POSTY               |
| Role                 : charger les structures ModSpecif et Derivees
| Reference conception : DCP module 23             |
| Lecteur              : Olivier NICOLE            |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include<stdio.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "nlmacros.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : lireArb                  |
| Role                  : lit un arbre dans le fichier
| Parametres d'entree   : fichier                  |
| Parametres de sortie  : arbre                    |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 23            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : chargArb                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt lireArb(fichier, arbre)
     FILE* fichier;
     TArbre* arbre;

/*--------------- Fin identification fonction ----*/
{
  ECRTRACE("lireArb");
  CREER_T1(arbre, 1, TArbre);
  LEC_SIN(fichier, arbre->fonction);
  LEC_DOU(fichier, arbre->valeur);

  arbre->filsG=NULL;
  arbre->filsD=NULL;
  /* lecture du sous arbre gauche */
  if (arbre->fonction>=NOT)
    {
      APPEL(lireArb(fichier, arbre->filsG));
    }

  /* lecture du sous arbre droit */
  if (arbre->fonction>=PLUS)
    {
      APPEL(lireArb(fichier, arbre->filsD));
    }
  return(OK);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : chargArb                 |
| Role                  : charger les structures ModSpecif et Derivees
| Parametres d'entree   : NomFich                  |
| Parametres de sortie  : ModSpecif Derivees       |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 23            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : lireArb                   |
| Fonctions appelantes : coheDecl                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt chargArb(NomFich, ModSpecif, Derivees)
     TChaine NomFich;
     TModSpecif ModSpecif;
     TDerivees Derivees;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  FILE *nfichier;

/*  ECRTRACE("chargArb");*/

  /* ouverture du fichier */
  if ((nfichier=fopen(NomFich, "r")) == NULL )
    {
/*      printf("Le fichier %s n'existe pas, fin de lecture\n", NomFich);*/

      return(-999);
    }

  /** Les tailles des tableaux **/
  /* valeurs lues dans tous les cas */
  LEC_SIN(nfichier, ModSpecif.Resp);
  LEC_SIN(nfichier, ModSpecif.Vari);
  LEC_SIN(nfichier, ModSpecif.CasSedo);
  LEC_SIN(nfichier, ModSpecif.PPident.nbele);
  LEC_SIN(nfichier, ModSpecif.IdeX.nbele);
  LEC_SIN(nfichier, ModSpecif.Auxiliaire.nbele);
  LEC_SIN(nfichier, ModSpecif.Constantes.nbele);
  LEC_SIN(nfichier, Derivees.DerivAux.nbele);

  /* cas Resp=1 ou Vari=1 */
  if (ModSpecif.Resp==OUI || ModSpecif.Vari==OUI)
    {
      LEC_SIN(nfichier, ModSpecif.IdeTheta.nbele);
    }

  /* cas Resp = 1 */
  if (ModSpecif.Resp==OUI )
    {
      LEC_SIN(nfichier, ModSpecif.IdeGamF.nbele);
      LEC_SIN(nfichier, Derivees.DerivF.nbele);
    }

  /* cas Vari=1 */
  if (ModSpecif.Vari==OUI )
    {
      LEC_SIN(nfichier, ModSpecif.IdeBeta.nbele);
      LEC_SIN(nfichier, ModSpecif.IdeGamV.nbele);
      LEC_SIN(nfichier, Derivees.DerivV.nbele);
    }

  /* cas CasSedo=1 */
  if (ModSpecif.CasSedo==OUI)
    {
      LEC_SIN(nfichier, ModSpecif.IdeLesF.nbele);
      LEC_SIN(nfichier, ModSpecif.IdeValInt.nbele);
      LEC_SIN(nfichier, ModSpecif.IdeCondInit.nbele);
      LEC_SIN(nfichier, ModSpecif.IdeLesDF.nbele);
      LEC_SIN(nfichier, Derivees.DerivSedo.nbele);
      LEC_SIN(nfichier, Derivees.DerivJac.nbele);
    }

  /** Les contenus des tableaux **/
  /* dans tous les cas */
  /* les types des identificateurs */
  for (i=0; i<ModSpecif.PPident.nbele; i++)
    {
      LEC_SIN(nfichier, ModSpecif.PPident.ident[i].type);
    }
  /* les libelles des identificateurs */
  for (i=0; i<ModSpecif.PPident.nbele; i++)
    {
      LEC_CHN(nfichier, ModSpecif.PPident.ident[i].libelle);
    }
  /* les identificateurs pour parresp */
  for (i=0; i<ModSpecif.IdeX.nbele; i++)
    {
      LEC_SIN(nfichier, ModSpecif.IdeX.donnees[i]);
    }
  /* les identificateurs pour les aux */
  for (i=0; i<ModSpecif.Auxiliaire.nbele; i++)
    {
      LEC_SIN(nfichier, ModSpecif.Auxiliaire.UnAux[i].ident);
    }
  /* lis identificateurs pour les const */
  for (i=0; i<ModSpecif.Constantes.nbele; i++)
    {
      LEC_SIN(nfichier, ModSpecif.Constantes.UneCst[i].ident);
    }
  /* les valeurs pour les const */
  for (i=0; i<ModSpecif.Constantes.nbele; i++)
    {
      LEC_DOU(nfichier, ModSpecif.Constantes.UneCst[i].valeur);
    }
  /* les arbres pour les aux */
  for (i=0; i<ModSpecif.Auxiliaire.nbele; i++) 
    {
      APPEL(lireArb(nfichier,  &ModSpecif.Auxiliaire.UnAux[i].arbre));
    }
  /* les arbres pour les derivees des aux */
  for (i=0; i<Derivees.DerivAux.nbele; i++)
    {
      APPEL(lireArb(nfichier, Derivees.DerivAux.arbre));
    }

  /* cas ou Resp=1 ou Vari=1 */
  if (ModSpecif.Resp==OUI || ModSpecif.Vari==OUI)
    {
      /* identificateurs de theta */
      for (i=0; i<ModSpecif.IdeTheta.nbele; i++)
        {
          LEC_SIN(nfichier, ModSpecif.IdeTheta.donnees[i]);
        }
    }

  /* cas ou Resp=1 */
  if (ModSpecif.Resp==OUI )
    {
      /* identificateur de resp */
      LEC_SIN(nfichier, ModSpecif.IdeF.ident);
      /* identificateurs de Gamma F */
      for (i=0; i<ModSpecif.IdeGamF.nbele; i++)
        {
          LEC_SIN(nfichier, ModSpecif.IdeGamF.donnees[i]);
        }
      /* arbre pour resp */
      APPEL(lireArb(nfichier, ModSpecif.IdeF.arbre));
      /* arbre pour les derivees de resp */
      for (i=0; i<Derivees.DerivF.nbele; i++)
        {
          APPEL(lireArb(nfichier, Derivees.DerivF.arbre[i]));
        }
    }

  /* cas ou Vari=1 */
  if (ModSpecif.Vari==OUI )
    {
      /* identificateur de Var */
      LEC_SIN(nfichier, ModSpecif.IdeV.ident);
      /* identificateurs pour Beta */
      for (i=0; i<ModSpecif.IdeBeta.nbele; i++)
        {
          LEC_SIN(nfichier, ModSpecif.IdeBeta.donnees[i]);
        }
      /* identificateurs pour Gamma V */
      for (i=0; i<ModSpecif.IdeGamV.nbele; i++ )
        {
          LEC_SIN(nfichier, ModSpecif.IdeGamV.donnees[i]);
        }
      /* arbre pour Var */
      APPEL(lireArb(nfichier, ModSpecif.IdeV.arbre));
      /* arbres pour les derivees de Var */
      for (i=0; i<Derivees.DerivV.nbele; i++)
        {
          APPEL(lireArb(nfichier, Derivees.DerivV.arbre[i]));
        }
    }

  /* cas ou CasSedo=1 */
  if (ModSpecif.CasSedo==OUI)
    {
      /* identificateurs de F */
      for (i++; i<ModSpecif.IdeLesF.nbele; i++)
        {
          LEC_SIN(nfichier, ModSpecif.IdeLesF.donnees[i]);
        }
      /* identificateur de VarInt */
      LEC_SIN(nfichier, ModSpecif.IdeVarInt);
      /* identificateurs de ValInt */
      for (i=0; i<ModSpecif.IdeValInt.nbele; i++)
        {
          LEC_SIN(nfichier, ModSpecif.IdeValInt.donnees[i]);
        }
      /* identificateurs de CondInit */
      for (i=0; i<ModSpecif.IdeCondInit.nbele; i++)
        {
          LEC_SIN(nfichier, ModSpecif.IdeCondInit.donnees[i]);
        }
      /* indentificateurs de dF */
      for (i=0; i<ModSpecif.IdeLesDF.nbele; i++)
        {
          LEC_SIN(nfichier, ModSpecif.IdeLesDF.UnDF[i].ident);
        }
      /* longueur du vecteur de reperage des Tj */
      LEC_SIN(nfichier, ModSpecif.IndicTj.nbele);
      /* valeurs de reperage des Tj */
      for (i=0; i<ModSpecif.IndicTj.nbele; i ++)
        {
          LEC_SIN(nfichier, ModSpecif.IndicTj.donnees[i]);
        }
      /* indique si les observations interrviennent dans le sedo */
      LEC_SIN(nfichier, ModSpecif.IndicX);
      /* nombre de parametres intervenants dans le sedo */
      LEC_SIN(nfichier, ModSpecif.NbThetaSedo);
      /* arbres du sedo */
      for (i=0; i<ModSpecif.IdeLesDF.nbele; i++)
        {
          APPEL(lireArb(nfichier, ModSpecif.IdeLesDF.UnDF[i].arbre));
        }
      /* derivees des arbres du sedo */
      for (i=0; i<Derivees.DerivSedo.nbele; i++) 
        {
          APPEL(lireArb(nfichier, Derivees.DerivSedo.arbre[i]));
        }
      /* arbres du jacobien */
      for (i=0; i<Derivees.DerivJac.nbele; i++)
        {
          APPEL(lireArb(nfichier, Derivees.DerivJac.arbre[i]));
        }
    }
  fclose(nfichier);
return (TShortInt)1;
}
