/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : coheDecl.c                |
| Date                 : 20 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Assure la coherence des declarations
| Reference conception : DCP module 9              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;

/*--------------- FONCTIONS EXTERNES -------------*/

extern TShortInt chargCond();
extern void *malloc(size_t size);
extern TShortInt erreAnal(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : coheDecl                 |
| Role                  : assure la coherence des declarations
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 9             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : chargCond                 |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt coheDecl()

/*--------------- Fin identification fonction ----*/

{
  TShortInt * util;
  TShortInt i, j, max;
  TLogic test;

  /* charge ce qui existe deja dans un fichier */
  chargCond();

  util=GModSpecif.typeUsed;

  /* resp */
  if (util[IDEF]==OUI && util[IDETHETA]==NON)
    {
      erreAnal(ECODECL1, NULL);
    }
  if (util[IDEF]==NON && util[IDEV]==NON)
    {
      erreAnal(ECODECL2, NULL);
    }
  /* varind */
  if (util[IDEX]==NON)
    {
      erreAnal(ECODECL3, NULL);
    }
  /* parresp */
  if (util[IDETHETA]==OUI && util[IDEF]==NON && util[IDEV]==NON)
    {
      erreAnal(ECODECL4, NULL);
    }
  /* var */
  if (util[IDEV]==OUI && util[IDETHETA]==NON && util[IDEBETA]==NON)
    {
      erreAnal(ECODECL5, NULL);
    }
  /* parvar */
  if (util[IDEBETA]==OUI && util[IDEV]==NON)
    {
      erreAnal(ECODECL6, NULL);
    }
  /* pbisresp */
  if (util[IDEGAMF]==OUI && util[IDEF]==NON)
    {
      erreAnal(ECODECL7, NULL);
    }
  /* parvar */
  if (util[IDEGAMV]==OUI && util[IDEV]==NON)
    {
      erreAnal(ECODECL6, NULL);
    }
  /* cas sedo */
  if (util[IDEVARINT]==OUI || util[IDEVALINT]==OUI || util[IDELESF]==OUI
      || util[IDELESDF]==OUI || util[IDECONDINIT]==OUI)
    {
      GModSpecif.CasSedo=OUI;
      if (util[IDEF]==NON)
	{
	  erreAnal(ECODECL8, NULL);
	}
      if (util[IDEVARINT]==NON)
	{
	  erreAnal(ECODECL9, NULL);
	}
      if (util[IDEVALINT]==NON)
	{
	  erreAnal(ECODECL10, NULL);
	}
      if (util[IDELESF]==NON)
	{
	  erreAnal(ECODECL11, NULL);
	}
      if (util[IDELESDF]==NON)
	{
	  erreAnal(ECODECL12, NULL);
	}
    }
  /* lesF & lesdF */
  if (util[IDELESF]==OUI && util[IDELESDF]==OUI &&
      GModSpecif.IdeLesF.nbele!=GModSpecif.IdeLesDF.nbele)
    {
      erreAnal(ECODECL13, NULL);
    }
  /* lesF & condinit */
  if (util[IDELESF]==OUI && util[IDECONDINIT]==OUI &&
      GModSpecif.IdeLesF.nbele!=GModSpecif.IdeCondInit.nbele)
    {
      erreAnal(ECODECL14, NULL);
    }
  /* condinit */
  if (util[IDECONDINIT]==OUI && util[IDETHETA]==OUI)
    {
      if (GModSpecif.IdeCondInit.nbele > GModSpecif.IdeTheta.nbele)
	{
	  erreAnal(ECODECL15, NULL);
	}
      else
	{
	  /* condinit prefixe de parresp */
	  max=GModSpecif.IdeCondInit.nbele;
	  for (i=0; i<max; i++)
	    {
	      test=VRAI;
	      j=0;
	      while (test==VRAI && j<max)
		{
		  if (GModSpecif.IdeCondInit.donnees[i]==
		      GModSpecif.IdeTheta.donnees[j])
		    {
		      test=FAUX;
		    }
		  j++;
		}
	      if (test==VRAI)
		{
		  erreAnal(ECODECL16,
			   GModSpecif.PPident.
			   ident[GModSpecif.IdeCondInit.
				 donnees[i]].libelle);
		  GModSpecif.yaerr=OUI;
		}
	    }
	}
    }
  /* gestion de IndicTj */
  if (util[IDEVALINT]==OUI && GModSpecif.IdeValInt.nbele>0)
    {
      j=0;
      test=FAUX;
      while (j<GModSpecif.IdeX.nbele)
	{
	  if (GModSpecif.IdeValInt.donnees[0]==GModSpecif.IdeX.donnees[j])
	    {
	      test=VRAI;
	    }
	  j++;
	}
      if (test==VRAI)
	{
	  /* les valeur d'integration sont des variables explicatives */
	  GModSpecif.IndicTj.nbele=GModSpecif.IdeValInt.nbele;
	  GModSpecif.IndicTj.donnees=(TShortInt*)
	    malloc(GModSpecif.IdeValInt.nbele*sizeof(TShortInt));
	  if (GModSpecif.IndicTj.donnees==NULL)
	    {
	      erreAnal(EMEM, NULL);
	      GModSpecif.yaerr=OUI;
	    }
	  else
	    {
	      for (i=0; i<GModSpecif.IdeValInt.nbele; i++)
		{
		  j=0;
		  while (GModSpecif.IdeValInt.donnees[i]
			 !=GModSpecif.IdeX.donnees[j])
		    {
		      j++;
		    }
		  GModSpecif.IndicTj.donnees[i]=j;
		}
	    }
	}
    }
  if (util[IDEF]==OUI)
    {
      GModSpecif.Resp=OUI;
    }
  if (util[IDEV]==OUI)
    {
      GModSpecif.Vari=OUI;
    }
return (TShortInt)1;
}
