/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : coheExpr.c                |
| Date                 : 28 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : realise un controle semantique des expressions
| Reference conception : DCP module 14             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;

/*--------------- FONCTIONS EXTERNES -------------*/
extern void *malloc(size_t size);
extern void *calloc(size_t nmemb, size_t size);
extern void *realloc(void *ptr, size_t size);
extern TShortInt erreAnal(TChaine message, TChaine param);
extern TShortInt bouclArb();
extern TShortInt warnAnal(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : testX                    |
| Role                  : parcours un arbre et decode les identificateurs
| Parametres d'entree   : arbre                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    : indicX                   |
| Reference conception  : DCP module 14            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : coheExpr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt testX(indicX, arbre)
     TShortInt * indicX;
     TArbre * arbre;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  if (arbre!=NULL && *indicX==NON)
    {
      if (arbre->fonction<0)
	{
	  /* on reconnait un identificateur */
	  i=0;
	  while(*indicX==NON && i<GModSpecif.IdeX.nbele)
	    {
	      if (-arbre->fonction==GModSpecif.IdeX.donnees[i])
		{
		  *indicX=OUI;
		}
	      i++;
	    }
	}
      else
	{
	  testX(indicX, arbre->filsG);
	  testX(indicX, arbre->filsD);
	}
    }
return (TShortInt)1;
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : cmptTheta                |
| Role                  : identifie les theta utilises dans les sedo
| Parametres d'entree   : arbre                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    : listeTheta               |
| Reference conception  : DCP module 14            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : coheExpr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt cmptTheta(listeTheta, arbre)
     TLogic * listeTheta;
     TArbre * arbre;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  if(arbre==NULL)
    {
      return ((TShortInt)2);
    }
  if (arbre->fonction<0)
    {
      /* on reconnait un identificateur */
      if (GModSpecif.PPident.ident[-arbre->fonction].type==IDETHETA)
	{
	  i=0;
	  while (-arbre->fonction!=GModSpecif.IdeTheta.donnees[i])
	    {
	      i++;
	    }
	  listeTheta[i]=OUI;
	}
      else if (GModSpecif.PPident.ident[-arbre->fonction].type==IDEAUX)
	{
	  i=0;
	  while (-arbre->fonction!=GModSpecif.Auxiliaire.UnAux[i].ident)
	    {
	      i++;
	    }
	  cmptTheta(listeTheta, GModSpecif.Auxiliaire.UnAux[i].arbre);
	}
    }
  else
    {
      cmptTheta(listeTheta, arbre->filsG);
      cmptTheta(listeTheta, arbre->filsD);
    }
return (TShortInt)2;
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : testIde                  |
| Role                  : teste les identificateur d'une expression
| Parametres d'entree   : arbre classe libelle     |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 14            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : coheExpr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt testIde(arbre, classe, libelle)
     TArbre * arbre;
     TShortInt classe;
     TChaine libelle;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  
  if (arbre==NULL)
    {
      return (TShortInt)2;
    }
  if (arbre->fonction < 0)
    {
      /* on a reconnu un identificateur */
      if (GModSpecif.PPident.ident[-arbre->fonction].type==IDEAUX)
	{
	  /* on a reconnu un aux, application recursive */
	  i=0;
	  /* on le localise dans la liste des aux */
	  while (GModSpecif.Auxiliaire.UnAux[i].ident!=-arbre->fonction)
	    {
	      i++;
	    }
	  testIde(GModSpecif.Auxiliaire.UnAux[i].arbre,
		  classe, GModSpecif.PPident.
		  ident[GModSpecif.Auxiliaire.UnAux[i].ident].libelle);
	}
      else
	{
	  /* on teste le type de la variable */
	  switch(GModSpecif.PPident.ident[-arbre->fonction].type)
	    {
	    case IDEBETA:
	    case IDEGAMV:
	    case IDEF:
	      if (classe!=CLV)
		{
		  erreAnal(EIDENT, libelle);
		}
	      break;
	    case IDEGAMF:
	      if (classe==CLV)
		{
		  erreAnal(EIDENT, libelle);
		}
	      break;
	    case IDELESF:
	      if (classe==CLV)
		{
		  erreAnal(EIDENT, libelle);
		}
	      break;
	    case IDEVALINT:
	      if (classe!=CLF)
		{
		  erreAnal(EIDENT, libelle);
		}
	      break;
	    case IDEVARINT:
	      if (classe!=CLDF)
		{
		  erreAnal(EIDENT, libelle);
		}
	      break;
	    default:
	      break;
	    }
	}
    }
  else
    {
      /* test recursif de l'arbre */
      testIde(arbre->filsG, classe, libelle);
      testIde(arbre->filsD, classe, libelle);
    }
return (TShortInt)2; 
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : listeVAux                |
| Role                  : cree la liste des expressions auxiliaires utilisees
                          dans l'expression de Var
| Parametres d'entree   : arbre                    |
| Parametres de sortie  : liste                    |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 14            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : coheExpr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TLogic listeVAux(arbre, liste)
     TArbre * arbre;
     TVectShort * liste;

/*--------------- Fin identification fonction ----*/

{
  TLogic test;
  TShortInt i;

  if (arbre==NULL)
    {
      return(VRAI);
    }
  if (arbre->fonction < 0)
    {
      /* on a reconnu un identificateur */
      if (GModSpecif.PPident.ident[-arbre->fonction].type==IDEAUX)
	{
	  /* on a reconnu un aux */
	  /* on test si l'identificateur est dans la liste (des AuxVar) */
	  test=FAUX;
	  i=0;
	  while (test==FAUX && i<liste->nbele)
	    {
	      if (-arbre->fonction==liste->donnees[i])
		{
		  test=VRAI;
		}
	      i++;
	    }
	  if (test==FAUX)
	    {
	      /* l'aux n'est pas dans la liste, on l'ajoute */
	      /* sinon, il a deja ete teste, ainsi que tous ses sous-aux */
	      liste->nbele=liste->nbele+1;
	      liste->donnees=(TShortInt *)
		realloc(liste->donnees, liste->nbele*sizeof(TShortInt));
	      if (liste->donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      liste->donnees[liste->nbele-1]=-arbre->fonction;
	      /* on applique recursivement sur l'aux */
	      i=0;
	      while (GModSpecif.Auxiliaire.UnAux[i].ident!=-arbre->fonction)
		{
		  i++;
		}
	      listeVAux(GModSpecif.Auxiliaire.UnAux[i].arbre, liste);
	    }
	}
    }
  else
    {
      /* on n'est pas sur un identificateur, on applique recursivement */
      listeVAux(arbre->filsG, liste);
      listeVAux(arbre->filsD, liste);
    }
  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : listeRAux                |
| Role                  : cree la liste des expressions auxiliaires utilisees
                          dans l'expression de Resp
| Parametres d'entree   : arbre                    |
| Parametres de sortie  : liste                    |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 14            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : coheExpr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TLogic listeRAux(arbre, liste)
     TArbre * arbre;
     TVectShort * liste;

/*--------------- Fin identification fonction ----*/

{
  TLogic test;
  TShortInt i;

  if (arbre==NULL)
    {
      return(VRAI);
    }
  if (arbre->fonction < 0)
    {
      /* on a reconnu un identificateur */
      if (GModSpecif.PPident.ident[-arbre->fonction].type==IDEAUX)
	{
	  /* on a reconnu un aux */
	  /* on test si l'identificateur est dans la liste (des AuxVar) */
	  test=FAUX;
	  i=0;
	  while (test==FAUX && i<liste->nbele)
	    {
	      if (-arbre->fonction==liste->donnees[i])
		{
		  test=VRAI;
		}
	      i++;
	    }
	  if (test==FAUX)
	    {
	      /* l'aux n'est pas dans la liste, on l'ajoute */
	      /* sinon, il a deja ete teste, ainsi que tous ses sous-aux */
	      liste->nbele=liste->nbele+1;
	      liste->donnees=(TShortInt *)
		realloc(liste->donnees, liste->nbele*sizeof(TShortInt));
	      if (liste->donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      liste->donnees[liste->nbele-1]=-arbre->fonction;
	      /* on applique recursivement sur l'aux */
	      i=0;
	      while (GModSpecif.Auxiliaire.UnAux[i].ident!=-arbre->fonction)
		{
		  i++;
		}
	      listeRAux(GModSpecif.Auxiliaire.UnAux[i].arbre, liste);
	    }
	}
    }
  else
    {
      /* on n'est pas sur un identificateur, on applique recursivement */
      listeRAux(arbre->filsG, liste);
      listeRAux(arbre->filsD, liste);
    }
  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : listeSAux                |
| Role                  : cree la liste des expressions auxiliaires utilisees
                          dans une expression de dF
| Parametres d'entree   : arbre                    |
| Parametres de sortie  : liste                    |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 14            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : coheExpr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TLogic listeSAux(arbre, liste)
     TArbre * arbre;
     TVectShort * liste;

/*--------------- Fin identification fonction ----*/

{
  TLogic test;
  TShortInt i;

  if (arbre==NULL)
    {
      return(VRAI);
    }
  if (arbre->fonction < 0)
    {
      /* on a reconnu un identificateur */
      if (GModSpecif.PPident.ident[-arbre->fonction].type==IDEAUX)
	{
	  /* on a reconnu un aux */
	  /* on test si l'identificateur est dans la liste (des AuxVar) */
	  test=FAUX;
	  i=0;
	  while (test==FAUX && i<liste->nbele)
	    {
	      if (-arbre->fonction==liste->donnees[i])
		{
		  test=VRAI;
		}
	      i++;
	    }
	  if (test==FAUX)
	    {
	      /* l'aux n'est pas dans la liste, on l'ajoute */
	      /* sinon, il a deja ete teste, ainsi que tous ses sous-aux */
	      liste->nbele=liste->nbele+1;
	      liste->donnees=(TShortInt *)
		realloc(liste->donnees, liste->nbele*sizeof(TShortInt));
	      if (liste->donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      liste->donnees[liste->nbele-1]=-arbre->fonction;
	      /* on applique recursivement sur l'aux */
	      i=0;
	      while (GModSpecif.Auxiliaire.UnAux[i].ident!=-arbre->fonction)
		{
		  i++;
		}
	      listeSAux(GModSpecif.Auxiliaire.UnAux[i].arbre, liste);
	    }
	}
    }
  else
    {
      /* on n'est pas sur un identificateur, on applique recursivement */
      listeSAux(arbre->filsG, liste);
      listeSAux(arbre->filsD, liste);
    }
  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : coheExpr                 |
| Role                  : realise un controle semantique des expressions
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 14            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : testX cmptTheta bouclArb testIde listeVAux listeRAux
                         listSAux
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt coheExpr()

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TLogic * listeTheta;

  /* controle de l'existance des expressions */
  if (GModSpecif.typeUsed[IDEF]==OUI && GModSpecif.IdeF.arbre==NULL)
    {
      erreAnal(ECOEXPR1,
	       GModSpecif.PPident.ident[GModSpecif.IdeF.ident].libelle);
    }
  if (GModSpecif.typeUsed[IDEV]==OUI && GModSpecif.IdeV.arbre==NULL)
    {
      erreAnal(ECOEXPR1,
	       GModSpecif.PPident.ident[GModSpecif.IdeV.ident].libelle);
    }
  if (GModSpecif.typeUsed[IDELESDF]==OUI)
    {
      for (i=0; i<GModSpecif.IdeLesDF.nbele; i++)
	{
	  if (GModSpecif.IdeLesDF.UnDF[i].arbre==NULL)
	    {
	      erreAnal(ECOEXPR1,
		     GModSpecif.PPident.
		     ident[GModSpecif.IdeLesDF.UnDF[i].ident].libelle);
	    }
	}
    }
  if (GModSpecif.typeUsed[IDEAUX]==OUI)
    {
      for (i=0; i<GModSpecif.Auxiliaire.nbele; i++)
	{
	  if (GModSpecif.PPident.
	      ident[GModSpecif.Auxiliaire.UnAux[i].ident].nbutil==1)
	    {
	      warnAnal(ECOEXPR2,
		     GModSpecif.PPident.
		     ident[GModSpecif.Auxiliaire.UnAux[i].ident].libelle);
	    }
	  else
	    {
	      if (GModSpecif.Auxiliaire.UnAux[i].arbre==NULL)
		{
		  erreAnal(ECOEXPR1,
			 GModSpecif.PPident.
			 ident[GModSpecif.Auxiliaire.UnAux[i].ident].libelle);
		}
	    }
	}
    }
  if (GModSpecif.typeUsed[IDECONST]==OUI)
    {
      for (i=0; i<GModSpecif.Constantes.nbele; i++)
	{
	  if (GModSpecif.PPident.
	      ident[GModSpecif.Constantes.UneCst[i].ident].nbutil==1)
	    {
	      warnAnal(ECOEXPR3,
		     GModSpecif.PPident.
		     ident[GModSpecif.Constantes.UneCst[i].ident].libelle);
	    }
	}
    }

  /* controle de l'utilisation des identificateurs declares */
  if (GModSpecif.typeUsed[IDEX]==OUI)
    {
      for (i=0; i<GModSpecif.IdeX.nbele; i++)
	{
	  if (GModSpecif.PPident.
	      ident[GModSpecif.IdeX.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR4,
		     GModSpecif.PPident.
		     ident[GModSpecif.IdeX.donnees[i]].libelle);
	    }
	}
    }
  if (GModSpecif.typeUsed[IDETHETA]==OUI)
    {
      for (i=0; i<GModSpecif.IdeTheta.nbele; i++)
	{
	  if (GModSpecif.PPident.
	      ident[GModSpecif.IdeTheta.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR5,
		     GModSpecif.PPident.
		     ident[GModSpecif.IdeTheta.donnees[i]].libelle);
	    }
	}
    }
  if (GModSpecif.typeUsed[IDEBETA]==OUI)
    {
      for (i=0; i<GModSpecif.IdeBeta.nbele; i++)
	{
	  if (GModSpecif.PPident.
	      ident[GModSpecif.IdeBeta.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR5,
		     GModSpecif.PPident.
		     ident[GModSpecif.IdeBeta.donnees[i]].libelle);
	    }
	}
    }
  if (GModSpecif.typeUsed[IDEGAMF]==OUI)
    {
      for (i=0; i<GModSpecif.IdeGamF.nbele; i++)
	{
	  if (GModSpecif.PPident.
	      ident[GModSpecif.IdeGamF.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR5,
		     GModSpecif.PPident.
		     ident[GModSpecif.IdeGamF.donnees[i]].libelle);
	    }
	}
    }
  if (GModSpecif.typeUsed[IDEGAMV]==OUI)
    {
      for (i=0; i<GModSpecif.IdeGamV.nbele; i++)
	{
	  if (GModSpecif.PPident.
	      ident[GModSpecif.IdeGamV.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR5,
		     GModSpecif.PPident.
		     ident[GModSpecif.IdeGamV.donnees[i]].libelle);
	    }
	}
    }
  if (GModSpecif.typeUsed[IDELESF]==OUI)
    {
      for (i=0; i<GModSpecif.IdeLesF.nbele; i++)
	{
	  if (GModSpecif.PPident.
	      ident[GModSpecif.IdeLesF.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR6,
		     GModSpecif.PPident.
		     ident[GModSpecif.IdeLesF.donnees[i]].libelle);
	    }
	}
    }
  if (GModSpecif.typeUsed[IDEVALINT]==OUI)
    {
      for (i=0; i<GModSpecif.IdeValInt.nbele; i++)
	{
	  if (GModSpecif.PPident.
	      ident[GModSpecif.IdeValInt.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR7,
		     GModSpecif.PPident.
		     ident[GModSpecif.IdeValInt.donnees[i]].libelle);
	    }
	}
    }

  if (GModSpecif.CasSedo==OUI)
    {
      /* instancie IndicX */
      GModSpecif.IndicX=NON;
      i=0;
      while(GModSpecif.IndicX==NON && i<GModSpecif.IdeLesDF.nbele)
	{
	  testX(&GModSpecif.IndicX, GModSpecif.IdeLesDF.UnDF[i].arbre);
	  i++;
	}
      
      /* instancie NbThetaSedo */
      GModSpecif.NbThetaSedo=0;
      /* cree une liste d'indicateur d'utilisation de chaque theta */
      listeTheta=(TLogic *)calloc(GModSpecif.IdeTheta.nbele,
				  sizeof(TLogic));
      if (listeTheta==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return 0;
	}
      else
	{
	  for (i=0; i<GModSpecif.IdeTheta.nbele; i++)
	    {
	      /*AB, 28/06/2001: je remplace      listeTheta[i]==NON; */
	    listeTheta[i]=NON;  
	    }
	}
      /* appel le test */
      for (i=0; i<GModSpecif.IdeLesDF.nbele; i++)
	{
	  cmptTheta(listeTheta, GModSpecif.IdeLesDF.UnDF[i].arbre);
	}
      /* fait la somme des theta utilises */
      for (i=0; i<GModSpecif.IdeTheta.nbele; i++)
	{
	  if (listeTheta[i]==OUI)
	    {
	      GModSpecif.NbThetaSedo++;
	    }
	}
      if (GModSpecif.NbThetaSedo!=0)
	{
	  /* verifie que les theta intervenant dans le Sedo sont groupes
	     apres les conditions intitiales */
	  for (i=GModSpecif.IdeCondInit.nbele; i<GModSpecif.IdeCondInit.nbele+
	       GModSpecif.NbThetaSedo; i++)
	    {
	      if (listeTheta[i]==NON)
		{
		  erreAnal(ECOEXPR9,
			   GModSpecif.PPident.
			   ident[GModSpecif.IdeTheta.donnees[i]].libelle);
		}
	    }
	}
      if (GModSpecif.NbThetaSedo==0 && GModSpecif.IdeCondInit.nbele==0)
	{
	  erreAnal(ECOEXPR8, NULL);
	}
    }

  /* teste les variables utilisees dans chaque expression */
  if (bouclArb()==VRAI)
    {
      if (GModSpecif.Resp==OUI)
	{
	  /* fait la liste des aux utilisees dans resp */
	  GModSpecif.AuxResp.nbele=0;
	  GModSpecif.AuxResp.donnees=(TShortInt *)malloc(sizeof(TShortInt));
	  if (GModSpecif.AuxResp.donnees==NULL)
	    {
	      erreAnal(EMEM, NULL);
	      return(FAUX);
	    }
	  if (listeRAux(GModSpecif.IdeF.arbre, &GModSpecif.AuxResp)!=VRAI)
	    {
	      return(FAUX);
	    }
	  testIde(GModSpecif.IdeF.arbre, CLF,
		  GModSpecif.PPident.ident[GModSpecif.IdeF.ident].libelle);
	}
      if (GModSpecif.Vari==OUI)
	{
	  /* fait la liste des aux utilisees dans var */
	  GModSpecif.AuxVar.nbele=0;
	  GModSpecif.AuxVar.donnees=(TShortInt *)malloc(sizeof(TShortInt));
	  if (GModSpecif.AuxVar.donnees==NULL)
	    {
	      erreAnal(EMEM, NULL);
	      return(FAUX);
	    }
	  if (listeVAux(GModSpecif.IdeV.arbre, &GModSpecif.AuxVar)!=VRAI)
	    {
	      return(FAUX);
	    }
	  testIde(GModSpecif.IdeV.arbre, CLV,
		  GModSpecif.PPident.ident[GModSpecif.IdeV.ident].libelle);
	}
      if (GModSpecif.CasSedo==OUI)
	{
	  /* on fait la liste des aux utilisees dans sedo */

	  GModSpecif.AuxSedo.nbele=0;
	  GModSpecif.AuxSedo.donnees=(TShortInt *)malloc(sizeof(TShortInt));
	  if (GModSpecif.AuxSedo.donnees==NULL)
	    {
	      erreAnal(EMEM, NULL);
	      return(FAUX);
	    }
	  for (i=0; i<GModSpecif.IdeLesDF.nbele; i++)
	    {
	      if (listeSAux(GModSpecif.IdeLesDF.UnDF[i].arbre,
			    &GModSpecif.AuxSedo)!=VRAI)
		{
		  return(FAUX);
		}
	    }
	  for (i=0; i<GModSpecif.IdeLesDF.nbele; i++)
	    {
	      testIde(GModSpecif.IdeLesDF.UnDF[i].arbre, CLDF,
		      GModSpecif.PPident.
		      ident[GModSpecif.IdeLesDF.UnDF[i].ident].libelle);
	    }
	}
    }
return (TShortInt)2;
}
