/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : constBin.c                |
| Date                 : 26 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : construit un arbre bianire|
| Reference conception : DCP module 12 & 13        |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;
extern int monyylineno;

/*--------------- FONCTIONS EXTERNES -------------*/
extern void *malloc(size_t size);
extern TShortInt erreAutr(TChaine message, TChaine param);
extern TShortInt erreAnal(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : constBin                 |
| Role                  : construit un abrbre binaire
| Parametres d'entree   : SsArbG SsArbD fonction   |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 12            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal erreAutr         |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TArbre * constBin(SsArbG, SsArbD, fonction)
     TArbre * SsArbG, *SsArbD;
     TShortInt fonction;

/*--------------- Fin identification fonction ----*/

{
  TArbre * Noeud;

  if (SsArbG==NULL || SsArbD==NULL)
    {
      erreAutr(EEXPR, NULL);
      return(NULL);
    }

  if (fonction<PLUS)
    {
      switch(fonction)
	{
	case NOT:
	  erreAutr(EUNBIN, LNOT);
	  break;
	case TG:
	  erreAutr(EUNBIN, LTG);
	  break;
	case LN:
	  erreAutr(EUNBIN, LLN);
	  break;
	case LOG:
	  erreAutr(EUNBIN, LLOG);
	  break;
	case EXP:
	  erreAutr(EUNBIN, LEXP);
	  break;
	case SIN:
	  erreAutr(EUNBIN, LSIN);
	  break;
	case COS:
	  erreAutr(EUNBIN, LCOS);
	  break;
	}
      return(NULL);
    }

  Noeud=(TArbre *) malloc(sizeof(TArbre));
  if (Noeud==NULL)
    {
      erreAnal(EMEM, NULL);
      return(NULL);
    }
  Noeud->fonction=fonction;
  Noeud->filsG=SsArbG;
  Noeud->filsD=SsArbD;
  return(Noeud);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : constUn                  |
| Role                  : construit un abrbre unaire
| Parametres d'entree   : SsArbG fonction CstVal   |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 13            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal erreAutr         |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TArbre * constUn(SsArbG, fonction, CstVal)
     TArbre * SsArbG;
     TShortInt fonction;
     TDouble CstVal;

/*--------------- Fin identification fonction ----*/

{
  TArbre * Noeud;

  if (fonction>CONSTANTE && SsArbG==NULL)
    {
      erreAutr(EEXPR, NULL);
      return(NULL);
    }

  if (fonction>=PLUS)
    {
      switch(fonction)
	{
	case PLUS:
	  erreAutr(EUNUN, LPLUS);
	  break;
	case MOINS:
	  erreAutr(EUNUN, LMOINS);
	  break;
	case MULT:
	  erreAutr(EUNUN, LMULT);
	  break;
	case DIV:
	  erreAutr(EUNUN, LDIV);
	  break;
	case IF:
	  erreAutr(EUNUN, LIF);
	  break;
	case THENELSE:
	  erreAutr(EUNUN, LTHENELSE);
	  break;
	case PUISSANCE:
	  erreAutr(EUNUN, LPUISSANCE);
	  break;
	case AND:
	  erreAutr(EUNUN, LAND);
	  break;
	case OR:
	  erreAutr(EUNUN, LOR);
	  break;
	case EQ:
	  erreAutr(EUNUN, LIBEQ);
	  break;
	case NEQ:
	  erreAutr(EUNUN, LNEQ);
	  break;
	case LE:
	  erreAutr(EUNUN, LLE);
	  break;
	case LEQ:
	  erreAutr(EUNUN, LLEQ);
	  break;
	case GE:
	  erreAutr(EUNUN, LGE);
	  break;
	case GEQ:
	  erreAutr(EUNUN, LGEQ);
	  break;
	case VALINT:
	  erreAutr(EUNUN, LIBVALINT);
	  break;
	}
      return(NULL);
    }

  Noeud=(TArbre *) malloc(sizeof(TArbre));
  if (Noeud==NULL)
    {
      erreAnal(EMEM, NULL);
      return(NULL);
    }
  Noeud->fonction=fonction;
  Noeud->filsG=SsArbG;
  Noeud->filsD=NULL;

  if (fonction==CONSTANTE)
    {
      Noeud->valeur=CstVal;
    }
  
  return(Noeud);
}

