#ifndef DFTYPESH
#define DFTYPESH

/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : dftypes.h                 |
| Date                 : 14 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Types pour le derivateur  |
| Reference conception : DCP, chap. 5              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/


/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/* Arbre:  type correspondant aux  noeuds  des arbres codants pour
les expressions */
typedef struct SArbre
{
  TDouble          valeur          /* Valeur du noeud */;
  TShortInt        fonction        /* Fonction attachee au noeud */;
  struct SArbre *  filsG           /* Sous-arbre gauche */;
  struct SArbre *  filsD           /* Sous-arbre droit */;
} TArbre;

/* ArbDe: type correspondant aux noeuds d'un arbre decore */
typedef struct SArbDe
{
  TDouble          valeur          /* Valeur du noeud */;
  TShortInt        fonction        /* Fonction attachee au noeud */;
  struct SArbDe *  filsG           /* Sous-arbre gauche */;
  struct SArbDe *  filsD           /* Sous-arbre droit */;
  TVectShort        Liste           /* liste des identificateurs employes */;
} TArbDe;

/*  Deriv: liste des arbres  des derivees pour  les expressions,
les derivees  sont rangees   par  expression puis    pour chaque
expression par variable de derivation */
typedef struct SDeriv
{
  TShortInt        nbele           /* nombre d'arbres de derivee */;
  TArbre **        arbre           /* listee des arbres de derivees */;
} TDeriv;

/* Derivees: structure contenant les derivees pour f, v, les
expressions auxiliaires,   et   le  jacobien, les   derivees  sont
rangees par expression puis  pour  chaque expression par variable de
derivation */
typedef struct SDerivees
{
  struct {
    TShortInt      nbele    /* nombre d'arbres de derivee */;
    TArbre **      arbre    /* liste des arbres de derivees */;
  }                DerivF   /* Derivees pour l'expression de f */;
  struct {
    TShortInt      nbele    /* nombre d'arbres de derivee */;
    TArbre **      arbre    /* liste des arbres de derivees */;
  }                DerivV   /* Derivees pour l'expression de v */;
  struct {
    TShortInt      nbele    /* nombre d'arbres de derivee */;
    TArbre **      arbre    /* liste des arbres de derivees */;
  }                DerivAux /* Derivees pour les expressions aux. */;
  struct {
    TShortInt      nbele    /* nombre d'arbres de derivee */;
    TArbre **      arbre    /* liste des arbres de derivees */;
  }                DerivSedo/* Derivees poue le sedo */;
  struct {
    TShortInt      nbele    /* nombre d'arbres de derivee */;
    TArbre **      arbre    /* liste des arbres de derivees */;
  }                DerivJac /* Derivees pour le jacobien */;
} TDerivees;

/* DerivAux: liste des arbres  des derivees pour les expressions
auxiliaires, les derivees sont  rangees par expression puis pour
chaque expression par variable de derivation */
typedef struct SDerivAux
{
  TShortInt        nbele    /* nombre d'arbres de derivee */;
  TArbre **        arbre    /* liste des arbres de derivees */;
} TDerivAux;

/* ident: sous-type de PPident, definit la structure associee a un
idenfificateur particulier */
typedef struct Sident
{
  TChaine        libelle         /* chaine de caractere */;
  TShortInt      nbutil          /* nombre d'utilisation */;
  TShortInt      type            /* type de l'identificateur (X, theta...) */;
} Tident;


/* PPident: sous-type de ModSpecif, definit la table des
identificateurs */
typedef struct SPPident
{
  TShortInt        nbele           /* nombre d'identificateurs */;
  Tident *         ident           /* sturcture d'un identificateur */;
} TPPident;

/* UnDF: sous-type de ModSpecif, definit la liste des identificateurs
correspondants aux dF */
typedef struct SUnDF
{
  TShortInt   ident                /* identificateur associe */;
  TArbre *    arbre                /* arbre associe */;
} TUnDF;

/* UnAux: sous-type de ModSpecif, definit la liste des identificateurs
correspondants aux Auxiliaires */
typedef struct SUnAux
{
  TShortInt   ident                /* identificateur associe */;
  TArbre *    arbre                /* arbre associe */;
} TUnAux;

/* UneCst: sous-type de ModSpecif, definit la liste ds identificateurs
correspondants aux Constantes */
typedef struct SUneCst
{
  TShortInt   ident               /* identificateur associe */;
  TDouble     valeur              /* valeur associe */;
} TUneCst;
/* ModSpecif: structure contenant les informations decodees
du fichier de description formelle */
typedef struct SModSpecif
{
  TPPident PPident                /* Table des identificateurs */;
  struct {
    TShortInt     ident           /* identificateur associe */;
    TArbre *      arbre           /* arbre associe */;
  } IdeF                          /* Description de f */;
  struct {
    TShortInt     ident           /* identificateur associe */;
    TArbre *      arbre           /* arbre associe */;
  } IdeV                          /* Description de v */;
  TVectShort      IdeX            /* Description des X */;
  TVectShort      IdeTheta        /* Description des theta */;
  TVectShort      IdeBeta         /* Description des beta */;
  TVectShort      IdeGamF         /* Description des gamma_f */;
  TVectShort      IdeGamV         /* Description des gamma_v */;
  struct {
    TShortInt     nbele           /* nombre de DF */;
    TUnDF *       UnDF            /* liste de dF */;
  } IdeLesDF                      /* Description des DF */;
  TVectShort      IdeLesF         /* Description des F */;
  TShortInt       IdeVarInt       /* Description de t */;
  TVectShort      IdeValInt       /* Description des T */;
  TVectShort      IdeCondInit     /* Description des conditions initiales */;
  TShortInt       Resp            /* Si 1 : il y a une expression codant f */;
  TShortInt       Vari            /* Si 1 : il y a une expression codant v */;
  TShortInt       CasSedo         /* Si 1 : indique que le modele est
				     decrit par un sedo */;
  struct {
    TShortInt     nbele           /* nombre d'expressions auxiliaires */;
    TUnAux *      UnAux           /* liste des aux */;
  } Auxiliaire                  /* Description des expressions auxiliaires */;
  struct {
    TShortInt     nbele           /* nombre de constantes */;
    TUneCst * UneCst              /* liste des constantes */;
  } Constantes                    /* Description des constantes */;
  TVectShort      IndicTj         /* indique Tj=Xi sinon 0 */;
  TShortInt       IndicX          /* indique si X intervient dans le sedo */;
  TShortInt       NbThetaSedo     /* nb de parametre dans le sedo */;
  TShortInt       Subroutine   /* =1 si des subroutines doivent etre crees */;
  TLogic          typeUsed[17]    /* controle de declaration */;
  TShortInt       NomFich         /* identificateur du nom de fichier */;
  TShortInt       Unique          /* indique declaration / affectation */;
  TLogic          yaerr           /* indique une erreur rencontree */;
  TLogic          erraff          /* indique une erreur dans 1 affectation */;
  TVectShort      AuxVar          /* liste des aux utilisees dans var */;
  TVectShort      AuxResp         /* liste des aux utilisees dans resp */;
  TVectShort      AuxSedo         /* liste des aux utilisees dans sedo */;
  TArbre **       ParamEntre      /* tableau ou sont affectes les parametres
                                     d'entree lors de l'appel a l'eval. */;
} TModSpecif;

/* UnAuxDe: sous-type utilise pour les auxiliaires du modele standard */
typedef struct SUnAuxDe
{
  TShortInt   ident           /* identificateur associe */;
  TArbDe *    arbre           /* arbre associe */;
} TUnAuxDe;

/* ModStandard: structure necessaire a la partie derivation
(  cette   structure est standardisee   de   facon   a ce  que
l'ensemble   des  modules correspondant   a la derivation  restent
reutilisables) */
typedef struct SModStandard
{
  TVectShort      TypeIdent       /* Liste des types des identificateurs */;
  TVectShort      IdentDeriv      /* Liste des variables de derivation */;
  TVectShort      IdentFixe       /* Liste des autres variables */;
  struct {
    TShortInt     nbele           /* nombre d'expressions auxiliaires */;
    TUnAuxDe *    UnAux;
  } Auxiliaire                    /* Liste des expressions auxiliaires */;
  struct {
    TShortInt     nbele           /* nombre de constantes */;
    TUneCst *     UneCst;
  } Constantes                    /* Liste des constantes */;
  struct {
    TShortInt     nbele           /* Nombre d'expressions a deriver */;
    TArbDe **     arbre           /* Liste des expressions a deriver */;
       } Expressions;
} TModStandard;

/*  RetInteg:   structure   necessaire    pour   l'interface avec
l'integrateur LSODA */
typedef struct SRetInteg
{
  TLogic          IndicCi         /* OUI IdeCondInit.nbele != 0 */;
  TVectShort      IndicTj         /* sous ensemble de IdeX si les Tj = Xi */;
  TLogic          IndicX        /* OUI si les X interviennent dans le sedo */;
  TShortInt       NbJ             /* = IdeValInt.nbele */;
  TShortInt       NbEq            /* = IdeLesDF.nbele */;
  TShortInt       NbThetaSedo     /* nombre de parametres dans le sedo */;
} TRetInteg;

/* RetModele:  structure necessaire a l'interface avec NL */
typedef struct SRetModele
{
  TVectStr        NomX            /* Noms des X */;
  TChaine         NomY            /* Nom de Y */;
  TChaine         NomV            /* Nom de v */;
  TVectStr        NomTheta        /* Noms des theta */; 
  TVectStr        NomBeta         /* Noms des beta */;
  TVectStr        NomGamF         /* Noms des gamma_f */;
  TVectStr        NomGamV         /* Noms des gamma_v */;
  TChaine         NomFich         /* Nom du fichier de sortie */;
  TLogic          CasSedo         /* Si 1 : indique si le modele est decrit 
				     par un sedo */;
  TLogic          YaCalcV         /* Si 1 : il y a une expression codant v */;
  TVectStr        NomValInt      /* Noms des valeurs d'integration */;
  TVectStr        NomLesF         /* Noms des equations du modele */;
  TVectStr        NomLesDF        /* Noms des equations du sedo */;
} TRetModele;
#endif
