/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : gereIden.c                |
| Date                 : 14 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : Olivier NICOLE            |
| Role                 : Gere la liste des identificateurs
| Reference conception : DCP module 6              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include <stdlib.h>
#include <string.h>
#include "nltypes.h"
#include "dftypes.h"
#include "nlcodes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;
extern int monyylineno;

/*--------------- FONCTIONS EXTERNES -------------*/

extern void *malloc(size_t size);
extern void *realloc(void *ptr, size_t size);
extern TShortInt erreAnal(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : gereIden                 |
| Role                  : ajoute un identificateur |
|                         dans la liste si besoin  |
| Parametres d'entree   : monyylength, unique, monyytext |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 6             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : analyseur lexical         |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt gereIden(monyylength, unique, monyytext)
     int monyylength;
     TShortInt unique;
     TChaine monyytext;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TShortInt nbident;
  TPPident* LPPident;

  i=0;
  LPPident=&GModSpecif.PPident;
  nbident=LPPident->nbele;
  while (i<nbident && strcmp(monyytext, LPPident->ident[i].libelle))
    i++;  /* Recherche si l'identificateur existe deja dans PPident */
  if (i==nbident)  /* S'il n'existe pas */
    {
      if (unique==NON)
	{
	  /* Erreur l'identificateur aurait du deja exister */
	  erreAnal(EUNDECL, monyytext);
          return((TShortInt) -999);
	}
      else
	{
	  LPPident->ident=(Tident *)
	    realloc(LPPident->ident, (nbident+1) * sizeof(Tident));
	  /* Allocation d'une nouvelle entree dans le tableau PPident */
	  if (LPPident->ident == NULL )
	    {
	      /* Probleme de gestion memoire */
	      erreAnal(EMEM, NULL);
	      return((TShortInt) -999);
	    }
	  LPPident->ident[nbident].libelle=(char *)
	    malloc((monyylength+1)*sizeof (char));
	  /* Allocation d'une ligne de longueur exactement egale a la
	     longueur de l'identificateur */
	  if (LPPident->ident[nbident].libelle == NULL )
	    {
	      /* Probleme de gestion memoire */
	      erreAnal(EMEM, NULL);
	      return((TShortInt) -999);
	    }
	  strcpy(LPPident->ident[nbident].libelle,monyytext);
	  /* Recopie de l'identificateur dans le tableau PPident */
	  LPPident->ident[nbident].type=-1; /* protection */
          LPPident->ident[nbident].nbutil=1;
	  /* initialise le nb d'utilisation */
	  LPPident->nbele++;
	  return(nbident); /* Retour du numero de l'entree  PPident qui 
				continent l'identificateur */
	}
    }
  else
    {
      /* S'il existe deja, retour du numero de l'entree de PPident
	 qui contient l'identificateur */
      if (unique==OUI && LPPident->ident[i].type!=-1)
	{
	  /* Erreur l'identificateur n'aurait pas du exister deja */
	  /* sauf si le type vaut -1, il a ete utilise dans une ligne
	     erronee */
	  erreAnal(EREDECL, monyytext);
          return((TShortInt) -999);
	}
      else
	{
	  LPPident->ident[i].nbutil++; /* incremente le nb d'utilisations */
	  return(i);
	}
    }
}
