/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : veriType.c                |
| Date                 : 25 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Verifie que l'identificateur est de type autorise
| Reference conception : DCP module 10             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TModSpecif GModSpecif;
extern int monyylineno;

/*--------------- FONCTIONS EXTERNES -------------*/
extern TShortInt erreAutr(TChaine message, TChaine param);

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : veriType                 |
| Role                  : Verifie que l'identificateur est de type autorise
| Parametres d'entree   : IdRef classein           |
| Parametres de sortie  : ordre classeout          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 10            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt veriType(IdRef, classein, classeout, ordre)
     TShortInt IdRef, classein;
     TShortInt * ordre, * classeout;

/*--------------- Fin identification fonction ----*/
{
  TShortInt type;
  TShortInt i;

  type=GModSpecif.PPident.ident[IdRef].type;
  *classeout=-999;
  *ordre=-999;

  switch(classein)
    {
    case CLDTE:
      /* identificateur en partie droite */
      switch(type)
	{
	case IDEX:
	case IDETHETA:
	case IDEBETA:
	case IDEGAMF:
	case IDEGAMV:
	case IDEVARINT:
	case IDEVALINT:
	case IDELESF:
	case IDEAUX:
	case IDECONST:
	case IDEF:
	  break;
	default:
	  erreAutr(ETYPE, GModSpecif.PPident.ident[IdRef].libelle);
	  break;
	}
      break;
    case CLLESF:
      if (type!=IDELESF)
	{
	  erreAutr(ETYPE, GModSpecif.PPident.ident[IdRef].libelle);
	}
      break;
    case CLVALINT:
      if (type!=IDEVALINT && type!=IDEX)
	{
	  erreAutr(ETYPE, GModSpecif.PPident.ident[IdRef].libelle);
	}
      break;
    case CLGCH:
      switch(type)
	{
	  /* identificateur en partie gauche */
	case IDEF:
	  *classeout=CLF;
	  break;
	case IDEV:
	  *classeout=CLV;
	  break;
	case IDELESDF:
	  *classeout=CLDF;
	  for (i=0; i<GModSpecif.IdeLesDF.nbele; i++)
	    {
	      if (GModSpecif.IdeLesDF.UnDF[i].ident==IdRef)
		{
		  *ordre=i;
		}
	    }
	  break;
	case IDEAUX:
	  *classeout=CLAUX;
	  for (i=0; i<GModSpecif.Auxiliaire.nbele; i++)
	    {
	      if (GModSpecif.Auxiliaire.UnAux[i].ident==IdRef)
		{
		  *ordre=i;
		}
	    }
	  break;
	case IDECONST:
	  *classeout=CLCONS;
	  for (i=0; i<GModSpecif.Constantes.nbele; i++)
	    {
	      if (GModSpecif.Constantes.UneCst[i].ident==IdRef)
		{
		  *ordre=i;
		}
	    }
	  break;
	default:
	  erreAutr(ETYPE, GModSpecif.PPident.ident[IdRef].libelle);
	  break;
	}
      break;
    }
return (TShortInt)2;
}

