/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <math.h>
#include <stdio.h>
#include <float.h>
#include <string.h>
#include <stdlib.h>
#include "nltypes.h"
#include "nlcodes.h"
#include "dftypes.h"
#include "dfcodes.h"
#include "nlglobal.h"
#include "errcodes.h"
#include "nlchoix.h"
#include "nlmacros.h"

/* les arguments de NL: */
#include "nldcl.h"
#define monyyout stdout

/*--------------- VARIABLES EXTERNES -------------*/


 TModSpecifPsi GModSpecifPsi;
 TDeriveesPsi DeriveesPsi;
 TRetModelePsi RetModelePsi;

static int monyylineno=1;

FILE *monyyin;

/* ----------------variables for analSyntPsi.c --------------------*/
/* #include "analSynt.c" */

typedef union  {
	TShortInt court;
	TDouble dbl;
	TArbre *arb;
        TVectShort vecsht;
	} YYSTYPE;
# define Tpsi 257
# define Tvarpsi 258
# define Tppsi 259
# define Tconst 260
# define Taux 261
# define Tpbispsi 262
# define Tfilename 263
# define Tsubroutine 264
# define Tif 265
# define Tthen 266
# define Telse 267
# define Tfi 268
# define Texp 269
# define Tlog10 270
# define Tlog 271
# define Tsin 272
# define Tcos 273
# define Ttg 274
# define Tand 275
# define Tor 276
# define Tnot 277
# define Tbegin 278
# define Tend 279
# define Tidentificateur 280
# define Tconstante 281
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
static  int yychar;
static int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
# define YYNEWLINE 10
static YYSTYPE yylval, yyval;
# define YYERRCODE 256
static int monyyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 67
# define YYLAST 288
static int monyyact[]={

    61,    25,    87,    86,    77,    62,    36,    47,    35,    48,
    29,    26,    97,    61,    95,    74,    71,    57,    73,   117,
    47,    72,    48,    96,    23,    24,    61,    76,    60,    45,
    77,    38,    41,    47,    84,    48,    83,    67,    78,    61,
    44,    60,    68,    57,    12,    13,    14,    15,    16,    17,
    18,    19,    20,    66,    60,    82,    66,    21,    81,    80,
    63,    79,    64,    63,    22,    64,    40,    60,    12,    13,
    14,    15,    16,    17,    18,    19,    20,    43,    11,    10,
     9,    65,     2,   101,    65,   102,    66,   105,   106,     8,
    46,   113,     7,    63,    42,    64,    85,    92,    93,   100,
     6,    94,     5,    98,    88,    89,    90,    91,     4,    39,
   104,     3,   103,   116,    65,   115,    99,    49,   107,   108,
   109,   110,   111,   112,     1,   101,     0,   102,    66,   105,
   106,     0,     0,     0,   114,    63,     0,    64,    69,    70,
   118,   119,   120,   121,   122,   123,    66,     0,     0,     0,
     0,   129,   104,    63,   103,    64,    65,    66,    66,     0,
     0,     0,   128,   127,    63,    63,    64,    64,    66,   131,
     0,    66,    66,   126,    65,    63,   125,    64,    63,    63,
    64,    64,    66,    66,     0,    65,    65,   124,   113,    63,
    63,    64,    64,     0,     0,     0,    65,    28,     0,    65,
    65,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    65,    65,    30,    31,    32,    33,    34,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    37,     0,     0,    50,
    27,     0,     0,    53,    54,    55,    51,    52,    56,     0,
     0,    75,    50,     0,    58,    59,    53,    54,    55,    51,
    52,    56,     0,    96,     0,    50,     0,    58,    59,    53,
    54,    55,    51,    52,    56,     0,     0,     0,    50,     0,
    58,    59,    53,    54,    55,    51,    52,    56,     0,     0,
     0,     0,     0,    58,    59,   132,     0,   130 };
static int monyypact[]={

  -188, -1000,  -255,   -48, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,  -270,  -270,  -270,  -270,  -270,  -270,  -272,
 -1000, -1000,   -53, -1000,   -30, -1000,  -212, -1000,   -12, -1000,
   -12,   -12,   -12,   -12,   -12, -1000,  -255, -1000,   -23, -1000,
 -1000,  -275, -1000,   136,    -5, -1000, -1000,     3,     3,   -78,
   -36,    21,    19,    18,    15,    -4,    -6,   -23, -1000, -1000,
  -278,  -279, -1000,   -23,   -23,   -23,   -23,   -23,   -23, -1000,
 -1000,   -23,  -252,  -264, -1000,   -10, -1000,   -36,    92,   -23,
   -23,   -23,   -23,   -23,   -23,   147, -1000, -1000,    -5,    -5,
    -5,    -5, -1000, -1000, -1000,   -23,   -36,   -36, -1000,    50,
   -22,   -23,   -23,   -23,   -23,   -23,   -23,   146,   135,   132,
   122,   121,   110, -1000,    20,  -264, -1000, -1000,   136,   136,
   136,   136,   136,   136, -1000, -1000, -1000, -1000, -1000, -1000,
   -23,    17, -1000 };
static int monyypgo[]={

     0,   124,   197,    38,    40,    29,   117,    21,    18,    15,
    27,    90,    82,    57,   111,   108,   102,   100,    92,    89,
    80,    79,    78,    64 };
static int monyyr1[]={

     0,     1,    12,    12,    12,    14,    14,    14,    14,    14,
    14,    14,    14,    14,    15,    16,     2,     2,    17,    18,
    19,    20,    21,    22,    13,    13,    13,    23,    23,     3,
     3,     3,     3,     3,     4,     4,     4,     5,     5,     5,
    11,    11,    11,    11,    11,    11,    11,    11,    11,     6,
     6,     6,     6,     6,     7,     7,     8,     8,     9,     9,
    10,    10,    10,    10,    10,    10,    10 };
static int monyyr2[]={

     0,     4,     6,     7,     5,     2,     2,     2,     2,     2,
     2,     2,     2,     3,     5,     5,     7,     3,     5,     5,
     5,     5,     5,     3,     6,     5,     3,     7,     3,     7,
     7,     7,     7,     3,     7,     7,     3,     3,     5,     5,
     3,    15,     9,     9,     9,     9,     9,     9,     7,     7,
     3,     3,     5,     5,     7,     3,     7,     3,     5,     3,
     7,     7,     7,     7,     7,     7,     7 };
static int monyychk[]={

 -1000,    -1,   -12,   -14,   -15,   -16,   -17,   -18,   -19,   -20,
   -21,   -22,   256,   257,   258,   259,   260,   261,   262,   263,
   264,   -13,   -23,   279,   280,   256,    59,   278,    -2,   280,
    -2,    -2,    -2,    -2,    -2,   280,    59,   279,    61,   -12,
   278,    44,   -13,    -3,    -4,    -5,   -11,    43,    45,    -6,
   265,   272,   273,   269,   270,   271,   274,    40,   280,   281,
    64,    36,   280,    43,    45,    64,    36,    42,    47,   -11,
   -11,    94,    -7,    -8,    -9,   277,   -10,    40,    -3,    40,
    40,    40,    40,    40,    40,    -3,   281,   281,    -4,    -4,
    -4,    -4,    -5,    -5,    -5,   266,   275,   276,   -10,    -3,
    -7,    33,    35,    62,    60,    37,    38,    -3,    -3,    -3,
    -3,    -3,    -3,    41,    -3,    -8,    -9,    41,    -3,    -3,
    -3,    -3,    -3,    -3,    41,    41,    41,    41,    41,    41,
   267,    -3,   268 };
static int monyydef[]={

     0,    -2,     0,     0,     5,     6,     7,     8,     9,    10,
    11,    12,    13,     0,     0,     0,     0,     0,     0,     0,
    23,     1,     0,    26,     0,    28,     0,     4,    14,    17,
    15,    18,    19,    20,    21,    22,     0,    25,     0,     2,
     3,     0,    24,    27,    33,    36,    37,     0,     0,    40,
     0,     0,     0,     0,     0,     0,     0,     0,    50,    51,
     0,     0,    16,     0,     0,     0,     0,     0,     0,    38,
    39,     0,     0,    55,    57,     0,    59,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    52,    53,    29,    30,
    31,    32,    34,    35,    48,     0,     0,     0,    58,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    49,     0,    54,    56,    60,    61,    62,
    63,    64,    65,    66,    42,    43,    44,    45,    46,    47,
     0,     0,    41 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

static yytoktype yytoks[] =
{
	"Tpsi",	257,
	"Tvarpsi",	258,
	"Tppsi",	259,
	"Tconst",	260,
	"Taux",	261,
	"Tpbispsi",	262,
	"Tfilename",	263,
	"Tsubroutine",	264,
	"Tif",	265,
	"Tthen",	266,
	"Telse",	267,
	"Tfi",	268,
	"Texp",	269,
	"Tlog10",	270,
	"Tlog",	271,
	"Tsin",	272,
	"Tcos",	273,
	"Ttg",	274,
	"Tand",	275,
	"Tor",	276,
	"Tnot",	277,
	"Tbegin",	278,
	"Tend",	279,
	"Tidentificateur",	280,
	"Tconstante",	281,
	"-unknown-",	-1	/* ends search */
};

static char * yyreds[] =
{
	"-no such reduction-",
	"Rfichier : Rsuiteentete Rsuiteaff",
	"Rsuiteentete : Rentete ';' Rsuiteentete",
	"Rsuiteentete : Rentete ';' Tbegin",
	"Rsuiteentete : Rentete Tbegin",
	"Rentete : Rpsi",
	"Rentete : Rvarpsi",
	"Rentete : Rppsi",
	"Rentete : Rconst",
	"Rentete : Raux",
	"Rentete : Rpbispsi",
	"Rentete : Rfilename",
	"Rentete : Rsubroutine",
	"Rentete : error",
	"Rpsi : Tpsi Rsuiteident",
	"Rvarpsi : Tvarpsi Rsuiteident",
	"Rsuiteident : Rsuiteident ',' Tidentificateur",
	"Rsuiteident : Tidentificateur",
	"Rppsi : Tppsi Rsuiteident",
	"Rconst : Tconst Rsuiteident",
	"Raux : Taux Rsuiteident",
	"Rpbispsi : Tpbispsi Rsuiteident",
	"Rfilename : Tfilename Tidentificateur",
	"Rsubroutine : Tsubroutine",
	"Rsuiteaff : Raff ';' Rsuiteaff",
	"Rsuiteaff : Raff Tend",
	"Rsuiteaff : Tend",
	"Raff : Tidentificateur '=' Rexpr",
	"Raff : error",
	"Rexpr : Rexpr '+' Rexpr2",
	"Rexpr : Rexpr '-' Rexpr2",
	"Rexpr : Rexpr '@' Rexpr2",
	"Rexpr : Rexpr '$' Rexpr2",
	"Rexpr : Rexpr2",
	"Rexpr2 : Rexpr2 '*' Rexpr3",
	"Rexpr2 : Rexpr2 '/' Rexpr3",
	"Rexpr2 : Rexpr3",
	"Rexpr3 : Rexpr3bis",
	"Rexpr3 : '+' Rexpr3bis",
	"Rexpr3 : '-' Rexpr3bis",
	"Rexpr3bis : Rexpr4",
	"Rexpr3bis : Tif Rcond Tthen Rexpr Telse Rexpr Tfi",
	"Rexpr3bis : Tsin '(' Rexpr ')'",
	"Rexpr3bis : Tcos '(' Rexpr ')'",
	"Rexpr3bis : Texp '(' Rexpr ')'",
	"Rexpr3bis : Tlog10 '(' Rexpr ')'",
	"Rexpr3bis : Tlog '(' Rexpr ')'",
	"Rexpr3bis : Ttg '(' Rexpr ')'",
	"Rexpr3bis : Rexpr4 '^' Rexpr3",
	"Rexpr4 : '(' Rexpr ')'",
	"Rexpr4 : Tidentificateur",
	"Rexpr4 : Tconstante",
	"Rexpr4 : '@' Tconstante",
	"Rexpr4 : '$' Tconstante",
	"Rcond : Rcond Tand Rcond2",
	"Rcond : Rcond2",
	"Rcond2 : Rcond2 Tor Rcond3",
	"Rcond2 : Rcond3",
	"Rcond3 : Tnot Rcond4",
	"Rcond3 : Rcond4",
	"Rcond4 : '(' Rcond ')'",
	"Rcond4 : Rexpr '!' Rexpr",
	"Rcond4 : Rexpr '#' Rexpr",
	"Rcond4 : Rexpr '>' Rexpr",
	"Rcond4 : Rexpr '<' Rexpr",
	"Rcond4 : Rexpr '%' Rexpr",
	"Rcond4 : Rexpr '&' Rexpr",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( monyyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		analSerr( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
static int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

static int yynerrs;			/* number of errors */
static int monyyprevious = YYNEWLINE;

/* --------------fin des varaiables de analSyntPsi ----------------- */

/* --------------variables for analLex.c --------------------------------*/
/* #include "analLex.c" */
# define U(x) x
# define NLSTATE monyyprevious=YYNEWLINE
# define BEGIN monyybgin = monyysvec + 1 +
# define INITIAL 0
# define YYLERR monyysvec
# define YYSTATE (yyestate-monyysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,monyyout)
# define input() (((yytchar=monyysptr>yysbuf?U(*--monyysptr):getc(monyyin))==10?(monyylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')monyylineno--;*monyysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(monyyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
static int yyleng; 
static char yytext[YYLMAX];
static int yymorfg;
static int yytchar;

# define YYTYPE int
static struct yywork { YYTYPE verify, advance; } monyycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,6,	0,0,	
0,0,	0,0,	1,7,	0,0,	
0,0,	1,8,	1,9,	1,10,	
1,11,	1,12,	1,13,	10,39,	
1,14,	1,15,	11,40,	11,40,	
11,40,	11,40,	11,40,	11,40,	
11,40,	11,40,	11,40,	11,40,	
1,16,	1,17,	1,18,	1,19,	
6,36,	17,45,	1,20,	18,46,	
7,37,	19,47,	43,75,	44,76,	
0,0,	44,76,	0,0,	0,0,	
7,37,	7,38,	13,41,	13,41,	
13,41,	13,41,	13,41,	13,41,	
13,41,	13,41,	13,41,	13,41,	
0,0,	0,0,	0,0,	0,0,	
1,21,	0,0,	1,22,	0,0,	
1,3,	0,0,	1,23,	1,24,	
1,25,	0,0,	1,26,	1,27,	
24,51,	28,57,	1,28,	27,56,	
35,68,	1,29,	7,37,	1,30,	
1,31,	1,32,	2,6,	7,37,	
1,33,	1,34,	2,7,	1,35,	
23,49,	2,8,	2,9,	2,10,	
25,52,	2,12,	2,13,	23,50,	
2,14,	29,58,	30,59,	31,60,	
7,37,	49,77,	26,53,	50,78,	
26,54,	34,66,	34,67,	51,79,	
2,16,	2,17,	2,18,	2,19,	
32,61,	15,42,	26,55,	15,43,	
15,43,	15,43,	15,43,	15,43,	
15,43,	15,43,	15,43,	15,43,	
15,43,	33,64,	32,62,	52,80,	
53,82,	32,63,	7,37,	54,83,	
52,81,	55,84,	56,85,	58,86,	
59,87,	33,65,	61,88,	62,89,	
2,21,	63,90,	2,22,	64,91,	
65,92,	67,93,	2,23,	2,24,	
2,25,	68,94,	2,26,	2,27,	
70,95,	71,96,	2,28,	71,96,	
73,97,	2,29,	79,100,	2,30,	
2,31,	2,32,	80,101,	82,102,	
2,33,	2,34,	85,103,	2,35,	
15,44,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	74,98,	
86,104,	74,98,	88,105,	89,106,	
92,107,	93,108,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
94,109,	100,112,	101,113,	103,114,	
20,48,	104,115,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
20,48,	20,48,	20,48,	20,48,	
40,69,	105,116,	40,70,	40,70,	
40,70,	40,70,	40,70,	40,70,	
40,70,	40,70,	40,70,	40,70,	
41,72,	107,117,	41,73,	41,73,	
41,73,	41,73,	41,73,	41,73,	
41,73,	41,73,	41,73,	41,73,	
42,42,	42,42,	42,42,	42,42,	
42,42,	42,42,	42,42,	42,42,	
42,42,	42,42,	69,69,	69,69,	
69,69,	69,69,	69,69,	69,69,	
69,69,	69,69,	69,69,	69,69,	
72,72,	72,72,	72,72,	72,72,	
72,72,	72,72,	72,72,	72,72,	
72,72,	72,72,	109,118,	40,71,	
75,75,	75,75,	75,75,	75,75,	
75,75,	75,75,	75,75,	75,75,	
75,75,	75,75,	114,119,	41,74,	
116,120,	117,121,	118,122,	119,123,	
120,124,	121,125,	123,126,	125,127,	
127,128,	42,44,	128,129,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	69,71,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	72,74,	76,99,	76,99,	
76,99,	76,99,	76,99,	76,99,	
76,99,	76,99,	76,99,	76,99,	
95,95,	95,95,	95,95,	95,95,	
95,95,	95,95,	95,95,	95,95,	
95,95,	95,95,	96,110,	96,110,	
96,110,	96,110,	96,110,	96,110,	
96,110,	96,110,	96,110,	96,110,	
97,97,	97,97,	97,97,	97,97,	
97,97,	97,97,	97,97,	97,97,	
97,97,	97,97,	98,111,	98,111,	
98,111,	98,111,	98,111,	98,111,	
98,111,	98,111,	98,111,	98,111,	
0,0};


 struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};

static int monyyvstop[] = {
0,

48,
0,

1,
48,
0,

1,
0,

48,
0,

48,
0,

32,
48,
0,

33,
48,
0,

30,
48,
0,

26,
48,
-25,
0,

43,
48,
0,

28,
48,
-27,
0,

29,
48,
0,

47,
48,
0,

44,
48,
0,

38,
48,
0,

34,
48,
0,

37,
48,
0,

46,
48,
0,

41,
48,
0,

42,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

46,
48,
0,

36,
0,

45,
0,

31,
0,

25,
0,

27,
0,

47,
0,

47,
0,

40,
0,

35,
0,

39,
0,

46,
0,

46,
0,

46,
0,

46,
0,

46,
0,

46,
0,

46,
0,

46,
0,

13,
46,
0,

10,
46,
0,

46,
0,

46,
0,

21,
46,
0,

46,
0,

46,
0,

46,
0,

46,
0,

46,
0,

19,
46,
0,

46,
0,

46,
0,

25,
0,

25,
0,

27,
0,

27,
0,

47,
0,

20,
46,
0,

6,
46,
0,

46,
0,

46,
0,

18,
46,
0,

46,
0,

24,
46,
0,

14,
46,
0,

46,
0,

16,
46,
0,

22,
46,
0,

46,
0,

46,
0,

2,
46,
0,

17,
46,
0,

46,
0,

46,
0,

46,
0,

25,
0,

27,
0,

47,
0,

46,
0,

46,
0,

12,
46,
0,

46,
0,

46,
0,

46,
0,

4,
46,
0,

46,
0,

11,
46,
0,

46,
0,

25,
0,

27,
0,

23,
46,
0,

5,
46,
0,

46,
0,

15,
46,
0,

46,
0,

46,
0,

46,
0,

46,
0,

46,
0,

46,
0,

3,
46,
0,

46,
0,

7,
46,
0,

46,
0,

8,
46,
0,

46,
0,

46,
0,

9,
46,
0,
0};

static struct yysvf monyysvec[] = {
0,	0,	0,
monyycrank+-1,	0,		0,	
monyycrank+-81,	monyysvec+1,	0,	
monyycrank+0,	0,		monyyvstop+1,
monyycrank+0,	0,		monyyvstop+3,
monyycrank+0,	0,		monyyvstop+6,
monyycrank+3,	0,		monyyvstop+8,
monyycrank+-67,	0,		monyyvstop+10,
monyycrank+0,	0,		monyyvstop+12,
monyycrank+0,	0,		monyyvstop+15,
monyycrank+5,	0,		monyyvstop+18,
monyycrank+2,	0,		monyyvstop+21,
monyycrank+0,	0,		monyyvstop+25,
monyycrank+30,	0,		monyyvstop+28,
monyycrank+0,	0,		monyyvstop+32,
monyycrank+99,	0,		monyyvstop+35,
monyycrank+0,	0,		monyyvstop+38,
monyycrank+4,	0,		monyyvstop+41,
monyycrank+6,	0,		monyyvstop+44,
monyycrank+8,	0,		monyyvstop+47,
monyycrank+153,	0,		monyyvstop+50,
monyycrank+0,	0,		monyyvstop+53,
monyycrank+0,	0,		monyyvstop+56,
monyycrank+10,	monyysvec+20,	monyyvstop+59,
monyycrank+3,	monyysvec+20,	monyyvstop+62,
monyycrank+13,	monyysvec+20,	monyyvstop+65,
monyycrank+26,	monyysvec+20,	monyyvstop+68,
monyycrank+2,	monyysvec+20,	monyyvstop+71,
monyycrank+3,	monyysvec+20,	monyyvstop+74,
monyycrank+18,	monyysvec+20,	monyyvstop+77,
monyycrank+19,	monyysvec+20,	monyyvstop+80,
monyycrank+17,	monyysvec+20,	monyyvstop+83,
monyycrank+46,	monyysvec+20,	monyyvstop+86,
monyycrank+52,	monyysvec+20,	monyyvstop+89,
monyycrank+34,	monyysvec+20,	monyyvstop+92,
monyycrank+11,	monyysvec+20,	monyyvstop+95,
monyycrank+0,	0,		monyyvstop+98,
monyycrank+0,	monyysvec+7,	0,	
monyycrank+0,	0,		monyyvstop+100,
monyycrank+0,	0,		monyyvstop+102,
monyycrank+230,	0,		monyyvstop+104,
monyycrank+242,	0,		monyyvstop+106,
monyycrank+252,	0,		monyyvstop+108,
monyycrank+24,	monyysvec+15,	monyyvstop+110,
monyycrank+28,	0,		0,	
monyycrank+0,	0,		monyyvstop+112,
monyycrank+0,	0,		monyyvstop+114,
monyycrank+0,	0,		monyyvstop+116,
monyycrank+0,	monyysvec+20,	monyyvstop+118,
monyycrank+33,	monyysvec+20,	monyyvstop+120,
monyycrank+15,	monyysvec+20,	monyyvstop+122,
monyycrank+36,	monyysvec+20,	monyyvstop+124,
monyycrank+49,	monyysvec+20,	monyyvstop+126,
monyycrank+45,	monyysvec+20,	monyyvstop+128,
monyycrank+63,	monyysvec+20,	monyyvstop+130,
monyycrank+53,	monyysvec+20,	monyyvstop+132,
monyycrank+58,	monyysvec+20,	monyyvstop+134,
monyycrank+0,	monyysvec+20,	monyyvstop+137,
monyycrank+64,	monyysvec+20,	monyyvstop+140,
monyycrank+52,	monyysvec+20,	monyyvstop+142,
monyycrank+0,	monyysvec+20,	monyyvstop+144,
monyycrank+65,	monyysvec+20,	monyyvstop+147,
monyycrank+56,	monyysvec+20,	monyyvstop+149,
monyycrank+68,	monyysvec+20,	monyyvstop+151,
monyycrank+65,	monyysvec+20,	monyyvstop+153,
monyycrank+78,	monyysvec+20,	monyyvstop+155,
monyycrank+0,	monyysvec+20,	monyyvstop+157,
monyycrank+76,	monyysvec+20,	monyyvstop+160,
monyycrank+67,	monyysvec+20,	monyyvstop+162,
monyycrank+262,	0,		monyyvstop+164,
monyycrank+138,	monyysvec+40,	monyyvstop+166,
monyycrank+142,	0,		0,	
monyycrank+272,	0,		monyyvstop+168,
monyycrank+142,	monyysvec+41,	monyyvstop+170,
monyycrank+168,	0,		0,	
monyycrank+284,	monyysvec+42,	monyyvstop+172,
monyycrank+326,	0,		0,	
monyycrank+0,	monyysvec+20,	monyyvstop+174,
monyycrank+0,	monyysvec+20,	monyyvstop+177,
monyycrank+85,	monyysvec+20,	monyyvstop+180,
monyycrank+79,	monyysvec+20,	monyyvstop+182,
monyycrank+0,	monyysvec+20,	monyyvstop+184,
monyycrank+94,	monyysvec+20,	monyyvstop+187,
monyycrank+0,	monyysvec+20,	monyyvstop+189,
monyycrank+0,	monyysvec+20,	monyyvstop+192,
monyycrank+97,	monyysvec+20,	monyyvstop+195,
monyycrank+163,	monyysvec+20,	monyyvstop+197,
monyycrank+0,	monyysvec+20,	monyyvstop+200,
monyycrank+99,	monyysvec+20,	monyyvstop+203,
monyycrank+110,	monyysvec+20,	monyyvstop+205,
monyycrank+0,	monyysvec+20,	monyyvstop+207,
monyycrank+0,	monyysvec+20,	monyyvstop+210,
monyycrank+102,	monyysvec+20,	monyyvstop+213,
monyycrank+107,	monyysvec+20,	monyyvstop+215,
monyycrank+132,	monyysvec+20,	monyyvstop+217,
monyycrank+336,	monyysvec+69,	monyyvstop+219,
monyycrank+346,	0,		0,	
monyycrank+356,	monyysvec+72,	monyyvstop+221,
monyycrank+366,	0,		0,	
monyycrank+0,	monyysvec+76,	monyyvstop+223,
monyycrank+135,	monyysvec+20,	monyyvstop+225,
monyycrank+130,	monyysvec+20,	monyyvstop+227,
monyycrank+0,	monyysvec+20,	monyyvstop+229,
monyycrank+137,	monyysvec+20,	monyyvstop+232,
monyycrank+201,	monyysvec+20,	monyyvstop+234,
monyycrank+165,	monyysvec+20,	monyyvstop+236,
monyycrank+0,	monyysvec+20,	monyyvstop+238,
monyycrank+178,	monyysvec+20,	monyyvstop+241,
monyycrank+0,	monyysvec+20,	monyyvstop+243,
monyycrank+215,	monyysvec+20,	monyyvstop+246,
monyycrank+0,	monyysvec+96,	monyyvstop+248,
monyycrank+0,	monyysvec+98,	monyyvstop+250,
monyycrank+0,	monyysvec+20,	monyyvstop+252,
monyycrank+0,	monyysvec+20,	monyyvstop+255,
monyycrank+245,	monyysvec+20,	monyyvstop+258,
monyycrank+0,	monyysvec+20,	monyyvstop+260,
monyycrank+229,	monyysvec+20,	monyyvstop+263,
monyycrank+228,	monyysvec+20,	monyyvstop+265,
monyycrank+241,	monyysvec+20,	monyyvstop+267,
monyycrank+238,	monyysvec+20,	monyyvstop+269,
monyycrank+243,	monyysvec+20,	monyyvstop+271,
monyycrank+233,	monyysvec+20,	monyyvstop+273,
monyycrank+0,	monyysvec+20,	monyyvstop+275,
monyycrank+249,	monyysvec+20,	monyyvstop+278,
monyycrank+0,	monyysvec+20,	monyyvstop+280,
monyycrank+246,	monyysvec+20,	monyyvstop+283,
monyycrank+0,	monyysvec+20,	monyyvstop+285,
monyycrank+242,	monyysvec+20,	monyyvstop+288,
monyycrank+253,	monyysvec+20,	monyyvstop+290,
monyycrank+0,	monyysvec+20,	monyyvstop+292,
0,	0,	0};
static struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
static char yysbuf[YYLMAX];
static char *monyysptr = yysbuf;
static int *yyfnd;

static struct yysvf *yyestate;
static struct yysvf *monyybgin = monyysvec+1;


/* --------------fin des variables for analLex.c --------------------------------*/

/* -------------------fin de la dcl des variables ----------------*/

/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : erreAnal.c                |
| Date                 : 3 dec. 1991               |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : gere les messages d'erreur des analyseur
| Reference conception : DCP module 15             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : erreAnal                 |
| Role                  : gere les messages d'erreur des analyseurs
| Parametres d'entree   : message param            |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 15            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : tous modules des analyseurs
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt erreAnal(message, param)
     TChaine message, param;

/*--------------- Fin identification fonction ----*/
{
  char ligne[256];

  strcpy(ligne, "line %3d: ");
  strcat(ligne, message);
  
  if (param!=NULL)
    {
      fprintf(stderr, (char *)strcat(ligne, ": %s\n\0"), monyylineno, param);
    }
  else
    {
      fprintf(stderr, (char *)strcat(ligne, "\n\0"), monyylineno);
    }
  GModSpecifPsi.yaerr=OUI;
  GModSpecifPsi.erraff=OUI;
return(VRAI);

}

/*--------------- Identification fonction ----------
| Nom de la fonction    : warnAnal                 |
| Role                  : gere les messages d'erreur des analyseurs
| Parametres d'entree   : message param            |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 15            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : tous modules des analyseurs
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt warnAnal(message, param)
     TChaine message, param;

/*--------------- Fin identification fonction ----*/
{
  char ligne[256];

  strcpy(ligne, "attention line %3d: ");
  strcat(ligne, message);
  
  if (param!=NULL)
    {
      fprintf(stderr, (char *)strcat(ligne, ": %s\n\0"), monyylineno, param);
    }
  else
    {
      fprintf(stderr, (char *)strcat(ligne, "\n\0"), monyylineno);
    }
return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : erreAutr                 |
| Role                  : gere les messages d'erreur des autres modules
| Parametres d'entree   : message param            |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 15            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : tous modules des analyseurs
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt erreAutr(message, param)
     TChaine message, param;

/*--------------- Fin identification fonction ----*/
{
  char ligne[256];

  strcpy(ligne, "line %3d: ");
  strcat(ligne, message);
  
  if (GModSpecifPsi.erraff==NON)
    {
      if (param!=NULL)
	{
	  fprintf(stderr, (char *)strcat(ligne, ": %s\n\0"), monyylineno, param);
	}
      else
	{
	  fprintf(stderr, (char *)strcat(ligne, "\n\0"), monyylineno);
	}
      GModSpecifPsi.yaerr=OUI;
      GModSpecifPsi.erraff=OUI;
    }
return(VRAI);
}


/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : alloueIde.c               |
| Date                 : 19 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : gere le type de l'identificateur dans PPident
| Reference conception : DCP module 8              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : alloueIde                |
| Role                  : gere le type de l'identificateur dans PPident
| Parametres d'entree   : type liste               |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 8             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt alloueIde(type, liste)
     TShortInt type;
     TVectShort liste;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TPPident * LPPident;

  LPPident=&GModSpecifPsi.PPident;
  for (i=0; i<liste.nbele; i++)
    {
      LPPident->ident[liste.donnees[i]].type=type;
    }
return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : copiConst                |
| Role                  : met a jour GModSpecifPsi.Constantes
| Parametres d'entree   : liste                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 5 et 8        |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt copiConst(liste)
     TVectShort liste;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  GModSpecifPsi.Constantes.nbele=liste.nbele;
  GModSpecifPsi.Constantes.UneCst=(TUneCst *)malloc(liste.nbele*sizeof(TUneCst));
  if (GModSpecifPsi.Constantes.UneCst==NULL)
    {
      erreAnal(EMEM, NULL);
    }
  else
    {
      for (i=0; i<liste.nbele; i++)
	{
	  GModSpecifPsi.Constantes.UneCst[i].ident=liste.donnees[i];
	}
    }
return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : copiAux                 |
| Role                  : met a jour GModSpecifPsi.Auxiliaires
| Parametres d'entree   : liste                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 5 et 8        |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt copiAux(liste)
     TVectShort liste;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  GModSpecifPsi.Auxiliaire.nbele=liste.nbele;
  GModSpecifPsi.Auxiliaire.UnAux=(TUnAux *)calloc(liste.nbele, sizeof(TUnAux));
  if (GModSpecifPsi.Auxiliaire.UnAux==NULL)
    {
      erreAnal(EMEM, NULL);
    }
  else
    {
      
      for (i=0; i<liste.nbele; i++)
	{
	  GModSpecifPsi.Auxiliaire.UnAux[i].ident=liste.donnees[i];
	}
    }
return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : copiPsi                |
| Role                  : met a jour GModSpecifPsi.IdePsi
| Parametres d'entree   : liste                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 5 et 8        |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt copiPsi(liste)
     TVectShort liste;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  GModSpecifPsi.IdePsi.nbele=liste.nbele;
  GModSpecifPsi.IdePsi.UnPsi=(TUnPsi *)calloc(liste.nbele, sizeof(TUnPsi));
  if (GModSpecifPsi.IdePsi.UnPsi==NULL)
    {
      erreAnal(EMEM, NULL);
    }
  else
    {
      for (i=0; i<liste.nbele; i++)
	{
	  GModSpecifPsi.IdePsi.UnPsi[i].ident=liste.donnees[i];
	}
    }
return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : TestUtil                 |
| Role                  : test si une declaration a deja ete faite
| Parametres d'entree   : type                     |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 5 et 8        |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TLogic TestUtil(type)
     TShortInt type;

/*--------------- Fin identification fonction ----*/

{
  if (GModSpecifPsi.typeUsed[type] == NON)
    {
      GModSpecifPsi.typeUsed[type]=OUI;
      return(VRAI);
    }
  else
    {
      switch(type)
	{
	case IDEPSI:
	  erreAnal(EELEM, LPSI);
	  break;
	case IDEZ:
	  erreAnal(EELEM, LVARPSI);
	  break;
	case IDEACT:
	  erreAnal(EELEM, LPARACT);
	  break;
	case IDEGAM:
	  erreAnal(EELEM, LPBISPSI);
	  break;
	case IDEAUX:
	  erreAnal(EELEM, LAUX);
	  break;
	case IDECONST:
	  erreAnal(EELEM, LCONST);
	  break;
	case IDEFICH:
	  erreAnal(EELEM, LNOMFICH);
	  break;
	case IDESUBR:
	  erreAnal(EELEM, LSUBROUTINE);
	  break;
	}
      return(FAUX);
    }
}


/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : constBin.c                |
| Date                 : 26 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : construit un arbre bianire|
| Reference conception : DCP module 12 & 13        |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : constBin                 |
| Role                  : construit un abrbre binaire
| Parametres d'entree   : SsArbG SsArbD fonction   |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 12            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal erreAutr         |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TArbre * constBin(SsArbG, SsArbD, fonction)
     TArbre * SsArbG, *SsArbD;
     TShortInt fonction;

/*--------------- Fin identification fonction ----*/

{
  TArbre * Noeud;

  if (SsArbG==NULL || SsArbD==NULL)
    {
      erreAutr(EEXPR, NULL);
      return(NULL);
    }

  if (fonction<PLUS)
    {
      switch(fonction)
	{
	case NOT:
	  erreAutr(EUNBIN, LNOT);
	  break;
	case TG:
	  erreAutr(EUNBIN, LTG);
	  break;
	case LN:
	  erreAutr(EUNBIN, LLN);
	  break;
	case LOG:
	  erreAutr(EUNBIN, LLOG);
	  break;
	case EXP:
	  erreAutr(EUNBIN, LEXP);
	  break;
	case SIN:
	  erreAutr(EUNBIN, LSIN);
	  break;
	case COS:
	  erreAutr(EUNBIN, LCOS);
	  break;
	}
      return(NULL);
    }

  Noeud=(TArbre *) malloc(sizeof(TArbre));
  if (Noeud==NULL)
    {
      erreAnal(EMEM, NULL);
      return(NULL);
    }
  Noeud->fonction=fonction;
  Noeud->filsG=SsArbG;
  Noeud->filsD=SsArbD;
  return(Noeud);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : constUn                  |
| Role                  : construit un abrbre unaire
| Parametres d'entree   : SsArbG fonction CstVal   |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 13            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal erreAutr         |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TArbre * constUn(SsArbG, fonction, CstVal)
     TArbre * SsArbG;
     TShortInt fonction;
     TDouble CstVal;

/*--------------- Fin identification fonction ----*/

{
  TArbre * Noeud;

  if (fonction>CONSTANTE && SsArbG==NULL)
    {
      erreAutr(EEXPR, NULL);
      return(NULL);
    }

  if (fonction>=PLUS)
    {
      switch(fonction)
	{
	case PLUS:
	  erreAutr(EUNUN, LPLUS);
	  break;
	case MOINS:
	  erreAutr(EUNUN, LMOINS);
	  break;
	case MULT:
	  erreAutr(EUNUN, LMULT);
	  break;
	case DIV:
	  erreAutr(EUNUN, LDIV);
	  break;
	case IF:
	  erreAutr(EUNUN, LIF);
	  break;
	case THENELSE:
	  erreAutr(EUNUN, LTHENELSE);
	  break;
	case PUISSANCE:
	  erreAutr(EUNUN, LPUISSANCE);
	  break;
	case AND:
	  erreAutr(EUNUN, LAND);
	  break;
	case OR:
	  erreAutr(EUNUN, LOR);
	  break;
	case EQ:
	  erreAutr(EUNUN, LIBEQ);
	  break;
	case NEQ:
	  erreAutr(EUNUN, LNEQ);
	  break;
	case LE:
	  erreAutr(EUNUN, LLE);
	  break;
	case LEQ:
	  erreAutr(EUNUN, LLEQ);
	  break;
	case GE:
	  erreAutr(EUNUN, LGE);
	  break;
	case GEQ:
	  erreAutr(EUNUN, LGEQ);
	  break;
	}
      return(NULL);
    }

  Noeud=(TArbre *) malloc(sizeof(TArbre));
  if (Noeud==NULL)
    {
      erreAnal(EMEM, NULL);
      return(NULL);
    }
  Noeud->fonction=fonction;
  Noeud->filsG=SsArbG;
  Noeud->filsD=NULL;

  if (fonction==CONSTANTE)
    {
      Noeud->valeur=CstVal;
    }
  
  return(Noeud);
}


/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : decoCons.c                |
| Date                 : 19 aou. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : Olivier NICOLE            |
| Role                 : calcule la valeur d'une constante
| Reference conception : DCP module 7              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : decoCons                 |
| Role                  : calcule la valeur d'une constante
| Parametres d'entree   : yylength yytext          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 7             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur lexical         |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TDouble decoCons(yylenght, yytext)
     int yylenght;
     TChaine yytext;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TShortInt asc;
  TDouble som;
  TDouble j;
  TShortInt exp;
  TShortInt sig;
  TShortInt mansig;
  TShortInt k;

  i=0;
  som=0.0;
  asc=(int)(yytext[0]);
  mansig=1;
  if (asc==43 || asc==45)
    {
      /* signe en tete de constante */
      if (asc==45)
	mansig=-1;
      i++;
      asc=(int)(yytext[i]);
    }
  while (asc>=48 && asc<=57 && i<yylenght)
    {
      /* partie entiere de la mantisse */
      som=(double)(som*10.0);
      som=som+(double)(asc-48);
      i++;
      if (i<yylenght)
	asc=(int)(yytext[i]);
    }
  if (i==yylenght)
    return(som * (double)mansig);
  if (asc==46)
    {
      /* partie decimale de la mantisse */
      i++;
      if (i==yylenght)
	return(som * (double)mansig);
      j=1;
      asc=(int)(yytext[i]);
      while (asc>=48 && asc<=57 && i<yylenght)
	{
	  j=j/10.0;
	  som=som + ((double)(asc-48) * j);
	  i++;
	  if (i<yylenght)
	    asc=(int)(yytext[i]);
	}
      if (i==yylenght)
	return(som * (double)mansig);
    }
  if (asc==101) /* "e" */
    {
      /* exposant */
      i++;
      asc=(int)(yytext[i]);
      sig=1;
      if (asc==45) /* "-" */
	sig=-1;
      i++;
      exp=0;
      asc=(int)(yytext[i]);
      while (i<yylenght)
	{
	  exp=exp*10;
	  exp=exp+asc-48;
	  i++;
	  if (i<yylenght)
	    asc=(int)(yytext[i]);
	}
      /* elevation a la bonne puissance */
      if (sig==1) /* positive */
	for (k=exp; k>0; k--)
	  som=som * (double)10;
      else        /* ou negative */
	for (k=1; k<=exp; k++)
	  som=som / (double) 10;
      return(som * (double)mansig);
    }
  /* ab */
return((TDouble)0);
}


/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : gereIden.c                |
| Date                 : 14 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : Olivier NICOLE            |
| Role                 : Gere la liste des identificateurs
| Reference conception : DCP module 6              |
| Lecteur              :                           |
--------------------------------------------------*/
/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : gereIden                 |
| Role                  : ajoute un identificateur |
|                         dans la liste si besoin  |
| Parametres d'entree   : yylength, unique, yytext |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 6             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : analyseur lexical         |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt gereIden(yylength, unique, yytext)
     int yylength;
     TShortInt unique;
     TChaine yytext;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TShortInt nbident;
  TPPident* LPPident;

  i=0;
  LPPident=&GModSpecifPsi.PPident;
  nbident=LPPident->nbele;
  while (i<nbident && strcmp(yytext, LPPident->ident[i].libelle))
    i++;  /* Recherche si l'identificateur existe deja dans PPident */
  if (i==nbident)  /* S'il n'existe pas */
    {
      if (unique==NON)
	{
	  /* Erreur l'identificateur aurait du deja exister */
	  erreAnal(EUNDECL, yytext);
          return((TShortInt) -999);
	}
      else
	{
	  LPPident->ident=(Tident *)
	    realloc(LPPident->ident, (nbident+1) * sizeof(Tident));
	  /* Allocation d'une nouvelle entree dans le tableau PPident */
	  if (LPPident->ident == NULL )
	    {
	      /* Probleme de gestion memoire */
	      erreAnal(EMEM, NULL);
	      return((TShortInt) -999);
	    }
	  LPPident->ident[nbident].libelle=(char *)
	    malloc((yylength+1)*sizeof (char));
	  /* Allocation d'une ligne de longueur exactement egale a la
	     longueur de l'identificateur */
	  if (LPPident->ident[nbident].libelle == NULL )
	    {
	      /* Probleme de gestion memoire */
	      erreAnal(EMEM, NULL);
	      return((TShortInt) -999);
	    }
	  strcpy(LPPident->ident[nbident].libelle,yytext);
	  /* Recopie de l'identificateur dans le tableau PPident */
	  LPPident->ident[nbident].type=-1; /* protection */
          LPPident->ident[nbident].nbutil=1;
	  /* initialise le nb d'utilisation */
	  LPPident->nbele++;
	  return(nbident); /* Retour du numero de l'entree  PPident qui 
				continent l'identificateur */
	}
    }
  else
    {
      /* S'il existe deja, retour du numero de l'entree de PPident
	 qui contient l'identificateur */
      if (unique==OUI && LPPident->ident[i].type!=-1)
	{
	  /* Erreur l'identificateur n'aurait pas du exister deja */
	  /* sauf si le type vaut -1, il a ete utilise dans une ligne
	     erronee */
	  erreAnal(EREDECL, yytext);
          return((TShortInt) -999);
	}
      else
	{
	  LPPident->ident[i].nbutil++; /* incremente le nb d'utilisations */
	  return(i);
	}
    }
}

/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : analLex.lex               |
| Date                 : 13 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : Olivier NICOLE            |
| Role                 : Analyseur lexical         |
| Reference conception : DCP module 4              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE ----------------------
|%c%-------------------------------------------------*/
/* dcl des fonctions appelees avant d'etre dfinies */
int monyylookPsi();
int monyybackPsi();
int analSyntPsi();
int psiyywrap() {return(1);}

/*--------------- FIN IDENTIFICATION PRODUIT -----*/
static int analLex(){
int nstr=0; 
while((nstr = monyylookPsi()) >= 0)
yyfussy: switch(nstr){
case 0:
if(psiyywrap()) return(0); break;
case 1:
{;}
break;
case 2:
{return(Tpsi);}
break;
case 3:
{return(Tvarpsi);}
break;
case 4:
{return(Tppsi);}
break;
case 5:
{return(Tconst);}
break;
case 6:
{return(Taux);}
break;
case 7:
{return(Tpbispsi);}
break;
case 8:
{return(Tfilename);}
break;
case 9:
{return(Tsubroutine);}
break;
case 10:
{return(Tif);}
break;
case 11:
{return(Tthen);}
break;
case 12:
{return(Telse);}
break;
case 13:
{return(Tfi);}
break;
case 14:
{return(Texp);}
break;
case 15:
{return(Tlog10);}
break;
case 16:
{return(Tlog);}
break;
case 17:
{return(Tsin);}
break;
case 18:
{return(Tcos);}
break;
case 19:
{return(Ttg);}
break;
case 20:
{return(Tand);}
break;
case 21:
{return(Tor);}
break;
case 22:
{return(Tnot);}
break;
case 23:
{return(Tbegin);}
break;
case 24:
{return(Tend);}
break;
case 25:
{return('@');}
break;
case 26:
{return('+');}
break;
case 27:
{return('$');}
break;
case 28:
{return('-');}
break;
case 29:
{return('/');}
break;
case 30:
{return('*');}
break;
case 31:
{return('^');}
break;
case 32:
{return('(');}
break;
case 33:
{return(')');}
break;
case 34:
{return('=');}
break;
case 35:
{return('!');}
break;
case 36:
{return('#');}
break;
case 37:
{return('>');}
break;
case 38:
{return('<');}
break;
case 39:
{return('%');}
break;
case 40:
{return('&');}
break;
case 41:
{return('[');}
break;
case 42:
{return(']');}
break;
case 43:
{return(',');}
break;
case 44:
{return(';');}
break;
case 45:
{; /*pour un commentaire on ne fait rien */}
break;
case 46:
{
         /* on reconnait un identificateur */
         yylval.court=gereIden(yyleng, GModSpecifPsi.Unique, yytext);
         return(Tidentificateur);}
break;
case 47:
{
         /* on reconnait une constante */
         yylval.dbl=decoCons(yyleng, yytext);
         return(Tconstante);}
break;
case 48:
{/*** gerer les erreurs */
	erreAnal(ELCAR, yytext);
	}
break;
case -1:
break;
default:
fprintf(monyyout,"bad switch monyylookPsi %d",nstr);
} return(0); }
/* end of yylex */

static struct yywork *monyytop = monyycrank+423;

static char monyymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,'+' ,01  ,'+' ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,'_' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,01  ,
0};
static char monyyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif


# define YYU(x) x


int  monyylookPsi(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = monyybgin;
		if (monyyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(monyyout,"state %d\n",yystate-monyysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == monyycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == monyycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(monyyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)monyycrank){
				yyt = yyr + yych;
				if (yyt <= monyytop && yyt->verify+monyysvec == yystate){
					if(yyt->advance+monyysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+monyysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)monyycrank) {		/* r < monyycrank */
				yyt = yyr = monyycrank+(monyycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(monyyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= monyytop && yyt->verify+monyysvec == yystate){
					if(yyt->advance+monyysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+monyysvec;
					goto contin;
					}
				yyt = yyr + YYU(monyymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(monyyout,"try fall back character ");
					allprint(YYU(monyymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= monyytop && yyt->verify+monyysvec == yystate){
					if(yyt->advance+monyysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+monyysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != monyycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(monyyout,"fall back to state %d\n",yystate-monyysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(monyyout,"state %d char ",yystate-monyysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(monyyout,"stopped at %d with ",*(lsp-1)-monyysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(monyyextra[*yyfnd]){		/* must backup */
					while(monyybackPsi((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				monyyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(monyyout,"\nmatch ");
					sprint(yytext);
					fprintf(monyyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(monyyin) */)
			{
			monyysptr=yysbuf;
			return(0);
			}
		monyyprevious = yytext[0] = input();
		if (monyyprevious>0)
			output(monyyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
 int monyybackPsi(int *p, int m)
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
static int monyyinput(){
	return(input());
	}
static void monyyoutput(c)
  int c; {
	output(c);
	}
static void monyyunput(c)
   int c; {
	unput(c);
	}
/* ------------------fin de analLex --------------------------- */


/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : analyse.c                 |
| Date                 : 12 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : prepare et gere l'appel des analyseurs
| Reference conception : DCP modules 2 et 3        |
| Lecteur              :                           |
--------------------------------------------------*/
/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : analSerr                 |
| Role                  : filtre les messages de yacc
| Parametres d'entree   : libelle                  |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 15            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static   void  analSerr(libelle)
     char * libelle;

/*--------------- Fin identification fonction ----*/

{
  if (strcmp(libelle, SYNTERR)==0)
    {
      erreAnal(EYSYNT, yytext);
    }
  else if (strcmp(libelle, OUTMEM)==0)
    {
      erreAnal(EYMEM, yytext);
    }
  else if (strcmp(libelle, STACKOWF)==0)
    {
      erreAnal(EYSTACK, yytext);
    }
  else if (strcmp(libelle, CANTBACK)==0)
    {
      erreAnal(EYBACK, yytext);
    }
  else 
    {
      erreAnal(EYAUTRE, yytext);
    }
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : initOuv                  |
| Role                  : ouvre le fichier de description, initialise
| Parametres d'entree   : NomDescr                 |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 3             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : analyse                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt initOuv(NomDescr)
     TChaine NomDescr;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  if (NomDescr==NULL)
    {
      erreAnal(ENOMFICH, NULL);
      return(FAUX);
    }
  monyyin=fopen(NomDescr, "r");
  if (monyyin==NULL)
    {
      erreAnal(EFICH, NomDescr);
      return(FAUX);
    }
  /* initialisation de ModSpecif */
  GModSpecifPsi.IdeZ.nbele=0;
  GModSpecifPsi.IdePsi.nbele=0;
  GModSpecifPsi.IdeAct.nbele=0;
  GModSpecifPsi.IdeGam.nbele=0;
  GModSpecifPsi.Auxiliaire.nbele=0;
  GModSpecifPsi.Constantes.nbele=0;
  GModSpecifPsi.Unique=OUI;
  for (i=0; i<16; i++)
    {
      GModSpecifPsi.typeUsed[i]=FAUX;
    }
  GModSpecifPsi.yaerr=NON;
  GModSpecifPsi.Subroutine=NON;

  /* stocke NomDescr au debut de la table des identificateurs PPident[0] */
  GModSpecifPsi.NomFich=0;
  GModSpecifPsi.PPident.nbele=1;
  GModSpecifPsi.PPident.ident=(Tident *)malloc(sizeof(Tident));
  if (GModSpecifPsi.PPident.ident==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }
  GModSpecifPsi.PPident.ident[0].libelle=(TChaine)malloc(strlen(NomDescr)
						      *sizeof(TChar));
  if (GModSpecifPsi.PPident.ident[0].libelle==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }
  strcpy(GModSpecifPsi.PPident.ident[0].libelle, NomDescr);
  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : analyse                  |
| Role                  : gere l'appel des analyseurs
| Parametres d'entree   : NomDescr                 |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 2             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : initOuv analyseurs        |
| Fonctions appelantes : analDer                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt analyse(NomDescr)
     TChaine NomDescr;

/*--------------- Fin identification fonction ----*/

{
  if (initOuv(NomDescr)==VRAI)
    {
      analSyntPsi();
      fclose(monyyin);
    }
return(OK);
}


/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : attaArb.c                 |
| Date                 : 26 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : associe une expression a son identificateur
| Reference conception : DCP module 11             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : attaArb                  |
| Role                  : associe une expression a son identificateur
| Parametres d'entree   : classe ordre Noeud       |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 11            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal erre Autr        |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt attaArb(classe, ordre, Noeud)
     TShortInt classe, ordre;
     TArbre * Noeud;

/*--------------- Fin identification fonction ----*/
{
  if (Noeud==NULL)
    {
      erreAutr(EUNEXPR, NULL);
    }
  else
    {
      switch(classe)
	{
	case CLPSI:
	  /* expression codant f */
	  if (GModSpecifPsi.IdePsi.UnPsi[ordre].arbre!=NULL)
	    {
	      erreAnal(EREEXPR,
		       GModSpecifPsi.PPident.
		       ident[GModSpecifPsi.
			     IdePsi.UnPsi[ordre].ident].libelle);
	    }
	  else
	    {
	      GModSpecifPsi.IdePsi.UnPsi[ordre].arbre=Noeud;
	    }
	  break;
	case CLAUX:
	  /* expression auxiliaire */
	  if (GModSpecifPsi.Auxiliaire.UnAux[ordre].arbre!=NULL)
	    {
	      erreAnal(EREEXPR,
		       GModSpecifPsi.PPident.
		       ident[GModSpecifPsi.Auxiliaire.UnAux[ordre].
			     ident].libelle);
	    }
	  else
	    {
	      GModSpecifPsi.Auxiliaire.UnAux[ordre].arbre=Noeud;
	    }
	  break;
	case CLCONS:
	  /* valeur d'une constante */
	  if (Noeud->fonction!=CONSTANTE)
	    {
	      erreAutr(EUNCST, NULL);
	    }
	  else
	    {
	      GModSpecifPsi.Constantes.UneCst[ordre].valeur=Noeud->valeur;
	    }
	  break;
	}
    }
return(VRAI);
}


/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : bouclArb.c                |
| Date                 : 16 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Detecte les bouclages dans les auxiliaires
| Reference conception : DCP module 18             |
| Lecteur              :                           |
--------------------------------------------------*/
/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : lireAux                  |
| Role                  : rempli la table de contingence pour un auxiliaire
| Parametres d'entree   : arbre                    |
| Parametres de sortie  : table                    |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 18            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : bouclArb                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static void lireAux(table, arbre)
     TShortInt * table;
     TArbre * arbre;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  
  if (arbre==NULL)
    {
      return;
    }
  if (arbre->fonction<0)
    {
      /* on est sur un identificateur */
      if (GModSpecifPsi.PPident.ident[-arbre->fonction].type==IDEAUX)
	{
	  /* cet identificateur est un auxiliaire */

	  i=0;
	  /* on localise son rang dans les auxiliaires */
	  while (GModSpecifPsi.Auxiliaire.UnAux[i].ident!=-arbre->fonction)
	    {
	      i++;
	    }
	  /* on rempli la table */
	  table[i]=1;
	}
    }
  else
    {
      /* on parcours l'arbre */
      lireAux(table, arbre->filsG);
      lireAux(table, arbre->filsD);
    }
return;
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : bouclArb                 |
| Role                  : Detecte les bouclages dans les auxiliaires
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 18            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal lireAux          |
| Fonctions appelantes : coheExpr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt bouclArb()

/*--------------- Fin identification fonction ----*/

{
  TShortInt ** table;
  TShortInt indice;
  TShortInt i, j, k;
  TShortInt max;
  TArbre * arbre;
  
  max=GModSpecifPsi.Auxiliaire.nbele;
  indice=0;

  /* creation de la table de contingence */
  table=(TShortInt **)malloc(max*sizeof(TShortInt*));
  if (table==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }
  for (i=0; i<max; i++)
    {
      table[i]=(TShortInt *)malloc((max+2)*sizeof(TShortInt));
      if (table[i]==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
    }

  /* remplissage de la table de contingence */
  for (i=0; i<max; i++)
    {
      /* initialisation de la table */
      for (j=0;j<max+2; j++)
	{
	  table[i][j]=0;
	}
      /* remplissage de la ligne i */

      lireAux(table[i], GModSpecifPsi.Auxiliaire.UnAux[i].arbre);
    }

  /* exploitation de la table de contingence */
  i=0;
  while (i<max)
    {
      /* on calcule les sommes de contingence par ligne (table[j][max+1])*/
      for (j=0; j<max; j++)
	{
	  table[j][max+1]=0;
	  for (k=0; k<max; k++)
	    {
	      table[j][max+1]=table[j][max+1] + table[j][k];
	    }
	}

      /* on cherche une ligne ayant une somme nulle et non encore triee */
      j=0;
      while(j<max && table[j][max]!=table[j][max+1])
	{
	  j++;
	}

      /* on est sur un cas d'erreur */
      if (j==max)
	{
	  erreAnal(EBOUCL, NULL);
	  return(FAUX);
	}

      /* on traite la ligne selectionnee */
      indice++;
      /* on lui affecte un numero d'ordre */
      table[j][max]=indice;
      /* on supprime l'expression de la table de contingence */
      for (k=0; k<max; k++)
	{
	  table[k][j]=0;
	}

      /* on traite une autre ligne de la table */
      i++;
    }

  /* tri des expressions auxiliaires */
  for (i=0; i<max; i++)
    {
      j=i;
      while (table[j][max]!=i+1)
	{
	  j++;
	}
      /* on inverse */
      if (j!=i)
	{
	  table[j][max]=table[i][max];
	  k=GModSpecifPsi.Auxiliaire.UnAux[j].ident;
	  GModSpecifPsi.Auxiliaire.UnAux[j].ident=
	    GModSpecifPsi.Auxiliaire.UnAux[i].ident;
	  GModSpecifPsi.Auxiliaire.UnAux[i].ident=k;
	  arbre=GModSpecifPsi.Auxiliaire.UnAux[j].arbre;
	  GModSpecifPsi.Auxiliaire.UnAux[j].arbre=
	    GModSpecifPsi.Auxiliaire.UnAux[i].arbre;
	  GModSpecifPsi.Auxiliaire.UnAux[i].arbre=arbre;
	}
    }

  return(VRAI);  
}
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : coheDecl.c                |
| Date                 : 20 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Assure la coherence des declarations
| Reference conception : DCP module 9              |
| Lecteur              :                           |
--------------------------------------------------*/


/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : coheDecl                 |
| Role                  : assure la coherence des declarations
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 9             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                 |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt coheDecl()

/*--------------- Fin identification fonction ----*/

{
  TShortInt * util;

  util=GModSpecifPsi.typeUsed;

  /* resp */
  if (util[IDEACT]==NON)
    {
      erreAnal(ECODECL1, NULL);
    }
  if (util[IDEPSI]==NON)
    {
      erreAnal(ECODECL2, NULL);
    }
  /* varind */
  if (util[IDEZ]==OUI && GModSpecifPsi.IdePsi.nbele > 1)
    {
      erreAnal(ECODECL3, NULL);
    }
return(VRAI);
}
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : coheExpr.c                |
| Date                 : 28 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : realise un controle semantique des expressions
| Reference conception : DCP module 14             |
| Lecteur              :                           |
--------------------------------------------------*/
/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : coheExpr                 |
| Role                  : realise un controle semantique des expressions
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 14            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : bouclArb 
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt coheExpr()

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;

  /* controle de l'existance des expressions */
  if (GModSpecifPsi.typeUsed[IDEPSI]==OUI)
    {
      for (i=0; i<GModSpecifPsi.IdePsi.nbele; i++)
	{
	  if (GModSpecifPsi.IdePsi.UnPsi[i].arbre==NULL)
	    {
	      erreAnal(ECOEXPR1,
		       GModSpecifPsi.PPident.
		       ident[GModSpecifPsi.IdePsi.UnPsi[i].ident].libelle);
	    }
	}
    }
  if (GModSpecifPsi.typeUsed[IDEAUX]==OUI)
    {
      for (i=0; i<GModSpecifPsi.Auxiliaire.nbele; i++)
	{
	  if (GModSpecifPsi.PPident.
	      ident[GModSpecifPsi.Auxiliaire.UnAux[i].ident].nbutil==1)
	    {
	      warnAnal(ECOEXPR2,
		       GModSpecifPsi.PPident.
		       ident[GModSpecifPsi.Auxiliaire.UnAux[i].ident].libelle);
	    }
	  else
	    {
	      if (GModSpecifPsi.Auxiliaire.UnAux[i].arbre==NULL)
		{
		  erreAnal(ECOEXPR1,
			   GModSpecifPsi.PPident.
			   ident[GModSpecifPsi.Auxiliaire.
				 UnAux[i].ident].libelle);
		}
	    }
	}
    }
  if (GModSpecifPsi.typeUsed[IDECONST]==OUI)
    {
      for (i=0; i<GModSpecifPsi.Constantes.nbele; i++)
	{
	  if (GModSpecifPsi.PPident.
	      ident[GModSpecifPsi.Constantes.UneCst[i].ident].nbutil==1)
	    {
	      warnAnal(ECOEXPR3,
		       GModSpecifPsi.PPident.
		       ident[GModSpecifPsi.Constantes.UneCst[i].ident].libelle);
	    }
	}
    }
  
  /* controle de l'utilisation des identificateurs declares */
  if (GModSpecifPsi.typeUsed[IDEZ]==OUI)
    {
      for (i=0; i<GModSpecifPsi.IdeZ.nbele; i++)
	{
	  if (GModSpecifPsi.PPident.
	      ident[GModSpecifPsi.IdeZ.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR4,
		       GModSpecifPsi.PPident.
		       ident[GModSpecifPsi.IdeZ.donnees[i]].libelle);
	    }
	}
    }
  if (GModSpecifPsi.typeUsed[IDEACT]==OUI)
    {
      for (i=0; i<GModSpecifPsi.IdeAct.nbele; i++)
	{
	  if (GModSpecifPsi.PPident.
	      ident[GModSpecifPsi.IdeAct.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR5,
		       GModSpecifPsi.PPident.
		       ident[GModSpecifPsi.IdeAct.donnees[i]].libelle);
	    }
	}
    }
  if (GModSpecifPsi.typeUsed[IDEGAM]==OUI)
    {
      for (i=0; i<GModSpecifPsi.IdeGam.nbele; i++)
	{
	  if (GModSpecifPsi.PPident.
	      ident[GModSpecifPsi.IdeGam.donnees[i]].nbutil==1)
	    {
	      warnAnal(ECOEXPR5,
		       GModSpecifPsi.PPident.
		       ident[GModSpecifPsi.IdeGam.donnees[i]].libelle);
	    }
	}
    }
  
  /* verifie l'absence de bouclage dans les expressions auxiliaires */
  bouclArb();
return(VRAI);
}

  

/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : decorArb.c                |
| Date                 : 15 jan. 1992              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : associe a chaque noeud de l'arbre la liste des
identificateurs qui interviennent dans l'arbre
| Reference conception : DCP module 19             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : decorArb                 |
| Role                  : decore un arbre codant une expression
| Parametres d'entree   : liste typeIdent          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    : arbre                    |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : deriv                     |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TLogic decorArb(arbre, liste, typeIdent)
     TArbDe * arbre;
     TVectShort liste;
     TShortInt * typeIdent;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TLogic test;
  
  if (arbre==NULL)
    {
      return(VRAI);
    }
  
  /* on reconnait un identificateur */
  if (arbre->fonction<0)
    {
      /* si cet identificateur est  aux on garde la liste dans
	 sa totalite, on ne sait jamais */
      if (typeIdent[-arbre->fonction]==IDEAUX)
	{
	  arbre->Liste.nbele=liste.nbele;
	  arbre->Liste.donnees=liste.donnees;
	  return(VRAI);
	}

      /* si cet identificateur est dans la liste on l'ajoute a la liste
	 du noeud courant */
      i=0;
      test=FAUX;
      while (i<liste.nbele && test==FAUX)
	{
	  if (liste.donnees[i]==-arbre->fonction)
	    {
	      test=VRAI;
	      arbre->Liste.donnees=(TShortInt *)malloc(sizeof(TShortInt));
	      if (arbre->Liste.donnees==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	      arbre->Liste.donnees[0]= -arbre->fonction;
	      arbre->Liste.nbele=1;
	    }
	  i++;
	}
      return(VRAI);
    }

  /* on traite le fils droit s'il existe */
  if (arbre->filsD!=NULL)
    {
      if (decorArb(arbre->filsD, liste, typeIdent)==FAUX)
	{
	  return(FAUX);
	}
      arbre->Liste.nbele=arbre->filsD->Liste.nbele;
      arbre->Liste.donnees=(TShortInt *)
	malloc(arbre->Liste.nbele*sizeof(TShortInt));
      if (arbre->Liste.donnees==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
      for (i=0; i<arbre->Liste.nbele; i++)
	{
	  arbre->Liste.donnees[i]=arbre->filsD->Liste.donnees[i];
	}
    }
  else
    {
      /* on cree une liste vide pour arbre->Liste.donnees */
      arbre->Liste.donnees=(TShortInt *)malloc(sizeof(TShortInt));
      if (arbre->Liste.donnees==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
    }

  /* on traite le fils gauche ensuite s'il existe */
  if (arbre->filsG!=NULL)
    {
      if (decorArb(arbre->filsG, liste, typeIdent)==FAUX)
	{
	  return(FAUX);
	}
      /* AB: rajout du test suivant pour que ca marche sous linux */
if (arbre->Liste.nbele+arbre->filsG->Liste.nbele != 0) {

      arbre->Liste.donnees=(TShortInt *)realloc
	(arbre->Liste.donnees, (arbre->Liste.nbele+arbre->filsG->Liste.nbele)
		* sizeof(TShortInt));
      if (arbre->Liste.donnees==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
      for (i=0; i<arbre->filsG->Liste.nbele; i++)
	{
	  arbre->Liste.donnees[i+arbre->Liste.nbele]=
	    arbre->filsG->Liste.donnees[i];
	}
      arbre->Liste.nbele=arbre->Liste.nbele+arbre->filsG->Liste.nbele;
 } /* fin  if (arbre->Liste.nbele+arbre->filsG->Liste.nbele != 0) */
    }
        
  return(VRAI);
}
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : deriv.c                   |
| Date                 : 13 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : deriver un ensemble d'expressions
| Reference conception : DCP module 17             |
| Lecteur              :                           |
--------------------------------------------------*/


/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : simplArb                 |
| Role                  : simplifie une expression |
| Parametres d'entree   : arbre                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : deriv                     |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TArbre * simplArb(arbre)
     TArbre * arbre;

/*--------------- Fin identification fonction ----*/

{
  TArbre * gauche, * droit;

  if (arbre==NULL)
    {
      return(NULL);
    }
  gauche=(TArbre *)malloc(sizeof(TArbre));
  if (gauche==NULL)
    {
      erreAnal(EMEM, NULL);
      return(NULL);
    }
  droit=(TArbre *)malloc(sizeof(TArbre));
  if (droit==NULL)
    {
      erreAnal(EMEM, NULL);
      return(NULL);
    }

  /* simplification des sous-arbres */
  gauche=simplArb(arbre->filsG);
  droit=simplArb(arbre->filsD);

  /* simplification du noeud courant */
  switch(arbre->fonction)
    {
    case PLUS:
      if (gauche->fonction==CONSTANTE &&
	  gauche->valeur==(double)0)
	{
	  /* 0+F -> F */
	  return(droit);
	}
      else if (droit->fonction==CONSTANTE &&
	       droit->valeur==(double)0)
	{
	  /* F+0 -> F */
	  return(gauche);
	}
      break;
    case MOINS:
      if (gauche->fonction==CONSTANTE &&
	  gauche->valeur==(double)0)
	{
	  /* 0-F -> -1 * F */
	  return(constBin(constUn(NULL, CONSTANTE, (double)-1),
			 droit,
			 MULT));
	}
      else if (droit->fonction==CONSTANTE &&
	       droit->valeur==(double)0)
	{
	  /* F-0 -> F */
	  return(gauche);
	}
      break;
    case MULT:
      if ((gauche->fonction==CONSTANTE &&
	  gauche->valeur==(double)0) ||
	  (droit->fonction==CONSTANTE &&
	   droit->valeur==(double)0))
	{
	  /* 0*F = F * 0 -> 0 */
	  return(constUn(NULL, CONSTANTE, (double)0));
	}
      else if (gauche->fonction==CONSTANTE &&
	       gauche->valeur==(double)1)
	{
	  /* 1*F -> F */
	  return(droit);
	}
      else if (droit->fonction==CONSTANTE &&
	       droit->valeur==(double)1)
	{
	  /* F*1 -> F */
	  return(gauche);
	}
      break;
    case DIV:
      if (gauche->fonction==CONSTANTE &&
	  gauche->valeur==(double)0)
	{
	  /* 0/F -> 0 */
	  return(constUn(NULL, CONSTANTE, (double)0));
	}
      else if (droit->fonction==CONSTANTE &&
	       droit->valeur==(double)1)
	{
	  /* F/1 -> F */
	  return(gauche);
	}
      break;
    case LOG:
    case LN:
      if (gauche->fonction==CONSTANTE &&
	  gauche->valeur==(double)1)
	{
	  /* log(1) -> 0 */
	  /* ln(1) -> 0 */
	  return(constUn(NULL, CONSTANTE, (double)0));
	}
      break;
    case SIN:
    case TG:
      if (gauche->fonction==CONSTANTE &&
	  gauche->valeur==(double)0)
	{
	  /* sin(0) -> 0 */
	  /* tg(0) -> 0 */
	  return(constUn(NULL, CONSTANTE, (double)0));
	}
      break;
    case COS:
    case EXP:
      if (gauche->fonction==CONSTANTE &&
	  gauche->valeur==(double)0)
	{
	  /* cos(0) -> 1 */
	  /* exp(0) -> 1 */
	  return(constUn(NULL, CONSTANTE, (double)1));
	}
      break;
    case PUISSANCE:
      if (droit->fonction==CONSTANTE)
	{
	  if (droit->valeur==(double)0)
	    {
	      /* F^0 -> 1 */
	      return(constUn(NULL, CONSTANTE, (double)1));
	    }
	  else if (droit->valeur==(double)1)
	    {
	      /* F^1 -> F */
	      return(gauche);
	    }
	}
      break;
    default:
      break;
    }

  /* dans les autres cas, ou quand les conditions de simplification ne sont
     pas satisfaites, on retourne l'arbre initial */
  arbre->filsG=gauche;
  arbre->filsD=droit;
  return(arbre);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : dedecArb                 |
| Role                  : copie un arbre decore dans un arbre simple
| Parametres d'entree   : arbre                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : derivArb                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TArbre * dedecArb(arbre)
     TArbDe * arbre;

/*--------------- Fin identification fonction ----*/

{
  TArbre * Noeud;
  
  if (arbre==NULL)
    {
      return(NULL);
    }
  Noeud=(TArbre *)malloc(sizeof(TArbre));
  if (Noeud==NULL)
    {
      erreAnal(EMEM, NULL);
      return(NULL);
    }
  Noeud->fonction=arbre->fonction;
  Noeud->valeur=arbre->valeur;
  Noeud->filsG=dedecArb(arbre->filsG);
  Noeud->filsD=dedecArb(arbre->filsD);
  return(Noeud);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : derivArb                 |
| Role                  : calcule la derivee d'un arbre
| Parametres d'entree   : arbre variable type |
| Parametres de sortie  : error                    |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 17            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal constUn constBin |
| Fonctions appelantes : deriv                     |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TArbre * derivArb(arbre, variable, error, type)
     TArbDe * arbre;
     TShortInt * variable;
     TShortInt * error;
     TVectShort type;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TLogic test;
  TArbre *gauche, *droit, *der;

  if (arbre==NULL || *error==OUI)
    {
      return(NULL);
    }

  /* teste si la variable de derivation est dans la liste du noeud courant */
  i=0;
  test=FAUX;
  while (i<arbre->Liste.nbele && test==FAUX)
    {
      if (arbre->Liste.donnees[i]==*variable)
	{
	  test=VRAI;
	}
      i++;
    }

  if (test==FAUX)
    {
      /* ca ne sert a rien de deriver cette branche */
      gauche=constUn(NULL, CONSTANTE, (double)0);
      if (gauche==NULL)
	{
	  *error=OUI;
	  return(NULL);
	}
      return(gauche);
    }

  /* on calcule les derivees des sous arbres gauches et droits */
  if (arbre->fonction>NOT && arbre->fonction<IF)
    {
      /* fonction unaire */
      gauche=derivArb(arbre->filsG, variable, error, type);
      if (gauche==NULL || *error==OUI)
	{
	  return(NULL);
	}
      /* fonction binaire */
      if (arbre->fonction>=PLUS)
	{
	  droit=derivArb(arbre->filsD, variable, error, type);
	  if (droit==NULL || *error==OUI)
	    {
	      return(NULL);
	    }
	}
    }

  /* on construit la derivee */
  switch(arbre->fonction)
    {
    case PLUS:
      der=constBin(gauche, droit, PLUS);
      break;
    case MOINS:
      der=constBin(gauche, droit, MOINS);
      break;
    case MULT:
      der=constBin(constBin(dedecArb(arbre->filsG), droit, MULT),
		   constBin(gauche, dedecArb(arbre->filsD), MULT), PLUS);
      break;
    case DIV:
      der=constBin(constBin(constBin(gauche, dedecArb(arbre->filsD), MULT),
			    constBin(dedecArb(arbre->filsG), droit, MULT),
			    MOINS),
		   constBin(dedecArb(arbre->filsD),
			    constUn(NULL, CONSTANTE, (double)2),
			    PUISSANCE),
		   DIV);
      break;
    case NOT:
    case AND:
    case OR:
    case EQ:
    case NEQ:
    case LE:
    case LEQ:
    case GE:
    case GEQ:
    case THENELSE:
      /* on ne devrait jamais passer par cette branche */
      der=NULL;
      break;
    case IF:
      gauche=derivArb(arbre->filsD->filsG, variable, error, type);
      if (gauche==NULL || *error==OUI)
	{
	  return(NULL);
	}
      droit=derivArb(arbre->filsD->filsD, variable, error, type);
      if (droit==NULL || *error==OUI)
	{
	  return(NULL);
	}
      der=constBin(dedecArb(arbre->filsG),
		   constBin(gauche,
			    droit,
			    THENELSE),
		   IF);
      break;
    case PUISSANCE:
      der=constBin(constBin(dedecArb(arbre->filsD),
			    constBin(constBin(dedecArb(arbre->filsG),
					      constBin(dedecArb(arbre->filsD),
						      constUn(NULL, CONSTANTE, (double)1),
						      MOINS),
					      PUISSANCE),
				     gauche,
				     MULT),
			    MULT),
		   constBin(dedecArb(arbre),
			    constBin(constUn(dedecArb(arbre->filsG), LN, 0),
				     droit,
				     MULT),
			    MULT),
		   PLUS);
      break;
    case COS:
      der=constBin(constUn(NULL, CONSTANTE, (double)-1),
		   constBin(gauche,
			    constUn(dedecArb(arbre->filsG), SIN, 0),
			    MULT),
		   MULT);
      break;
    case SIN:
      der=constBin(gauche,
		   constUn(dedecArb(arbre->filsG), COS, 0),
		   MULT);
      break;
    case EXP:
      der=constBin(gauche,
		   constUn(dedecArb(arbre->filsG), EXP, 0),
		   MULT);
      break;
    case TG:
      der=constBin(gauche,
		   constBin(constUn(dedecArb(arbre->filsG), COS, 0),
			    constUn(NULL, CONSTANTE, (double)2),
			    PUISSANCE),
		   DIV);
      break;
    case LN:
      der=constBin(gauche,
		   dedecArb(arbre->filsG),
		   DIV);
      break;
    case LOG:
      der=constBin(gauche,
		   constBin(dedecArb(arbre->filsG),
			    constUn(constUn(NULL, CONSTANTE, (double)10),
				    LN, 0),
			    MULT),
		   DIV);
      break;
    case CONSTANTE:
      der=dedecArb(arbre);
      break;
    default:
      if(type.donnees[-arbre->fonction]==IDEAUX)
	{
	  der=constUn(NULL, arbre->fonction - type.nbele, 0);
	}
      else if (-arbre->fonction==*variable)
	{
	  der=constUn(NULL, CONSTANTE, (double)1);
	}
      else
	{
	  der=constUn(NULL, CONSTANTE, (double)0);
	}
      break;
    }
  if (der==NULL)
    {
      *error=OUI;
      return(NULL);
    }
  return(der);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : deriv                    |
| Role                  : deriver un ensemble d'expressions
| Parametres d'entree   : ModStandard borne        |
| Parametres de sortie  : Deriv                    |
| Parametres d'e./s.    : DerivAux                 |
| Reference conception  : DCP module 17            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal decorArb derivArb|
| Fonctions appelantes : prepDer                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt deriv(ModStandard, Deriv, DerivAux, borne)
     TModStandard ModStandard;
     TDeriv * Deriv;
     TDerivAux * DerivAux;
     TShortInt borne;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i, j, nbaux, nbderaux, nbparam, first, error;
  TVectShort listp;

  nbaux=ModStandard.Auxiliaire.nbele;
  nbparam=ModStandard.IdentDeriv.nbele;
  nbderaux=nbaux*nbparam;
  if (DerivAux->nbele<nbderaux)
    {
      first=DerivAux->nbele/nbaux;
      /* les expressions auxiliaires sont deja derivees par rapport aux
       derivateurs 0 ,..., first-1 */
      listp.donnees=(TShortInt *)malloc((nbparam-first)*sizeof(TShortInt));
      if (listp.donnees==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
      listp.nbele=nbparam-first;

      /* il suffit de decorer/deriver les arbres par rapport aux variables
	 non encore derivees */
      for (i=first; i<nbparam; i++)
	{
	  listp.donnees[i-first]=ModStandard.IdentDeriv.donnees[i];
	}

      /* on decore les aux */
      for (i=0; i<nbaux; i++)
	{
	  if (decorArb(ModStandard.Auxiliaire.UnAux[i].arbre, listp,
		       ModStandard.TypeIdent.donnees)==FAUX)
	    {
	      return(FAUX);
	    }
	  /* on cree DerivAux */
	  if (DerivAux->nbele==0)
	    {
	      DerivAux->arbre=(TArbre **)malloc(nbderaux*sizeof(TArbre *));
	      if (DerivAux->arbre==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	    }
	  else
	    {
	      DerivAux->arbre=(TArbre **)realloc(DerivAux->arbre,
						nbderaux*sizeof(TArbre *));
	      if (DerivAux->arbre==NULL)
		{
		  erreAnal(EMEM, NULL);
		  return(FAUX);
		}
	    }
	  DerivAux->nbele=nbderaux;

	  /* on derive l'aux[i] par rapport au param[j] */
	  error=NON;
	  for (j=0; j<listp.nbele; j++)
	    {
	      DerivAux->arbre[(first+j)*nbaux+i]=
		simplArb(derivArb(ModStandard.Auxiliaire.UnAux[i].arbre,
				  &listp.donnees[j], &error,
				  ModStandard.TypeIdent));
	      if (error==OUI)
		{
		  return(FAUX);
		}
	    }
	}
    }

  /* on derive les expressions principales */
  Deriv->nbele=nbparam*ModStandard.Expressions.nbele;
  Deriv->arbre=(TArbre **)malloc(Deriv->nbele*sizeof(TArbre *));
  if (Deriv->arbre==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }
  
  for (i=0; i<ModStandard.Expressions.nbele; i++)
    {
      /* on decore les expressions */
      if (decorArb(ModStandard.Expressions.arbre[i], ModStandard.IdentDeriv,
		   ModStandard.TypeIdent.donnees)==FAUX)
	{
	  return(FAUX);
	}
      
      /* on derive */
      error=NON;
      for (j=0; j<nbparam; j++)
	{
	  Deriv->arbre[j*ModStandard.Expressions.nbele+i]=
	    simplArb(derivArb(ModStandard.Expressions.arbre[i],
			      &ModStandard.IdentDeriv.donnees[j], &error,
			      ModStandard.TypeIdent));
	  if (error==OUI)
	    {
	      return(FAUX);
	    }
	}
    }
  return(VRAI);
}

/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : geneSubr.c                |
| Date                 : 13 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : stocke les arbres dans des subroutines C
| Reference conception : DCP module 22             |
| Lecteur              :                           |
--------------------------------------------------*/
/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : ecrArb                   |
| Role                  : stocke un arbre dans le fichier de subroutine
| Parametres d'entree   : arbre fout decl modSpecif theta
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 22            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : ecrTest                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TLogic ecrArb(arbre, fout, decl, modSpecif, theta)
     TArbre * arbre;
     FILE * fout;
     TShortInt *decl, theta;
     TModSpecifPsi modSpecif;

/*--------------- Fin identification fonction ----*/

{
  TShortInt ident, j;
  TLogic indicder;

  if (arbre==NULL)
    {
      return(VRAI);
    }
  if (*decl>60)
    {
      fprintf(fout, "\n      ");
      *decl=7;
    }
  switch (arbre->fonction)
    {
    case PLUS:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") + (");
      *decl=*decl+5;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout,")");
      *decl=*decl+1;
      break;
    case MOINS:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") - (");
      *decl=*decl+5;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout,")");
      *decl=*decl+1;
      break;
    case MULT:
      if (arbre->filsG->fonction==CONSTANTE &&
	  arbre->filsG->valeur==(double)-1)
	{
	  fprintf(fout, "-(");
	  *decl=*decl+2;
	  ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
	  fprintf(fout, ")");
	  *decl=*decl+1;
	}
      else if (arbre->filsD->fonction==CONSTANTE &&
	  arbre->filsD->valeur==(double)-1)
	{
	  fprintf(fout, "-(");
	  *decl=*decl+2;
	  ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
	  fprintf(fout, ")");
	  *decl=*decl+1;
	}
      else
	{
	  fprintf(fout, "(");
	  *decl=*decl+1;
	  ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
	  fprintf(fout, ") * (");
	  *decl=*decl+5;
	  ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
	  fprintf(fout,")");
	  *decl=*decl+1;
	}
      break;
    case DIV:
      fprintf(fout, "mydiv(");
      *decl=*decl+5;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ", ");
      *decl=*decl+2;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout,")");
      *decl=*decl+1;
      break;
    case LOG:
      fprintf(fout, "mylog(");
      *decl=*decl+6;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case TG:
      fprintf(fout, "(double)tan(");
      *decl=*decl+11;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case LN:
      fprintf(fout, "myln(");
      *decl=*decl+7;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case EXP:
      fprintf(fout, "(double)myexp(");
      *decl=*decl+14;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case SIN:
      fprintf(fout, "(double)sin(");
      *decl=*decl+12;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case COS:
      fprintf(fout, "(double)cos(");
      *decl=*decl+12;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case IF:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") ? (");
      *decl=*decl+5;
      ecrArb(arbre->filsD->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") : (");
      *decl=*decl+5;
      ecrArb(arbre->filsD->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case OR:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") || (");
      *decl=*decl+6;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case AND:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") && (");
      *decl=*decl+6;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case EQ:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") == (");
      *decl=*decl+6;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case NEQ:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") != (");
      *decl=*decl+6;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case LE:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") < (");
      *decl=*decl+5;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case LEQ:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") <= (");
      *decl=*decl+6;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case GE:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") > (");
      *decl=*decl+5;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case GEQ:
      fprintf(fout, "(");
      *decl=*decl+1;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ") >= (");
      *decl=*decl+6;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case NOT:
      fprintf(fout, "!(");
      *decl=*decl+2;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case PUISSANCE:
      fprintf(fout, "mypow(");
      *decl=*decl+8;
      ecrArb(arbre->filsG, fout, decl, modSpecif, theta);
      fprintf(fout, ", ");
      *decl=*decl+2;
      ecrArb(arbre->filsD, fout, decl, modSpecif, theta);
      fprintf(fout, ")");
      *decl=*decl+1;
      break;
    case CONSTANTE:
      if (*decl>40)
	{
	  fprintf(fout, "\n      ");
	  *decl=7;
	}
      fprintf(fout, "(double)");
      *decl=*decl+20;
      if (arbre->valeur==(double)((long)arbre->valeur))
	{
	  fprintf(fout, "%ld", (long)arbre->valeur);
	}
      else
	{
	  fprintf(fout, "%.8e", arbre->valeur);
	}
      break;
    default:
      /* cas d'un identificateur */
      indicder=FAUX;
      ident=-arbre->fonction;
      if (ident >= modSpecif.PPident.nbele)
	{
	  ident=ident-modSpecif.PPident.nbele;
	  indicder=VRAI;
	}
      /* selon le type de l'identificateur */
      switch (modSpecif.PPident.ident[ident].type)
	{
	case IDECONST:
	  /* on remplace la contante par sa valeur */
	  j=0;
	  while (modSpecif.Constantes.UneCst[j].ident!=ident)
	    {
	      j++;
	    }
	  if (*decl>40)
	    {
	      fprintf(fout, "\n      ");
	      *decl=7;
	    }
	  fprintf(fout, "(double)");
	  *decl=*decl+20;
	  if (modSpecif.Constantes.UneCst[j].valeur==
	      (double)((long)modSpecif.Constantes.UneCst[j].valeur))
	    {
	      fprintf(fout, "%ld",
		      (long)modSpecif.Constantes.UneCst[j].valeur);
	    }
	  else
	    {
	      fprintf(fout, "%.8e", modSpecif.Constantes.UneCst[j].valeur);
	    }
	  break;
	case IDEAUX:
	  /* on met l'appel a l'aux correspondant */
	  j=0;
	  while (modSpecif.Auxiliaire.UnAux[j].ident!=ident)
	    {
	      j++;
	    }
	  if (indicder==VRAI)
	    {
	      /* on appel la derivee de l'aux par rapport a theta*/
	      fprintf(fout, "da[%d][%d]", j, theta);
	      *decl=*decl+9;
	    }
	  else
	    {
	      /* on appel l'aux */
	      fprintf(fout, "a[%d]", j);
	      *decl=*decl+5;
	    }
	  break;
	case IDEZ:
	  /* on remplace par l'appel de la variable correspondante */
	  j=0;
	  while (modSpecif.IdeZ.donnees[j]!=ident)
	    {
	      j++;
	    }
	  fprintf(fout, "z[i][%d]", j);
	  *decl=*decl+8;
	  break;
	case IDEACT:
	  j=0;
	  while (modSpecif.IdeAct.donnees[j]!=ident)
	    {
	      j++;
	    }
	  fprintf(fout, "p[%d]", j);
	  *decl=*decl+5;
	  break;
	case IDEGAM:
	  j=0;
	  while (modSpecif.IdeGam.donnees[j]!=ident)
	    {
	      j++;
	    }
	  fprintf(fout, "g[%d]", j);
	  *decl=*decl+5;
	  break;
	}
      break;
    }
  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : ecrTest                  |
| Role                  : ecrit le test systematique de la valeur de la
                          fonction
| Parametres d'entree   : arbre fout lieuerr modSpecif
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 22            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : ecrArb                    |
| Fonctions appelantes :  stokPsi |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TLogic ecrTest(arbre, fout, lieuerr, modSpecif, theta, nbpsi)
     TArbre * arbre;
     FILE * fout;
     TChaine lieuerr;
     TModSpecifPsi modSpecif;
     TShortInt theta;
     TShortInt nbpsi;
     
/*--------------- Fin identification fonction ----*/
     
{
  TShortInt posit;
  
  fprintf(fout, "    res= ");
  posit=10;
  if (ecrArb(arbre, fout, &posit, modSpecif, theta)==FAUX)
    {
      return(FAUX);
    }
  fprintf(fout, ";\n");
  if (arbre!=NULL)
    {
      if (arbre->fonction>CONSTANTE)
	{
	  /* pour un identificateur ou une constante, pas la peine de
	     tester la valeur de calcul */
	  fprintf(fout, "    if (finite(res)!=1)\n      {\n");
	  if (modSpecif.IdeZ.nbele==0)
	    {
	      fprintf(fout, "        *ie=%d;\n", nbpsi);
	    }
	  else
	    {
	      fprintf(fout, "        *ie=i+1;\n");
	    }
	 fprintf(fout, "        *le=%s;\n        return(ERRMATH);\n      }\n",
		  lieuerr);
	}
    }
  else
    {
      return(FAUX);
    }
return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : stokPsi                 |
| Role                  : stocke la fonction calcf |
| Parametres d'entree   : fout modSpecif derivees  |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 22            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal ecrTest          |
| Fonctions appelantes : geneSubr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TLogic stokPsi(fout, modSpecif, DeriveesPsi)
     FILE * fout;
     TModSpecifPsi modSpecif;
     TDeriveesPsi DeriveesPsi;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i, j;
  TChaine lieuerr;
  
  /* cree l'entete de la fonction calcpsi */
  fprintf(fout, "\nshort int calcpsi_(nbp, nbg, nbl, nbc, \n");
  fprintf(fout, "                   p, g, z, psi, dpsi, le, ie)\n");
  fprintf(fout, "      short int nbp, nbg, nbl, nbc;\n");
  fprintf(fout, "      double *p, *g, **z, *psi, **dpsi;\n");
  fprintf(fout, "      short int *le, *ie;\n");
  fprintf(fout, "{\nshort int i;\ndouble res;\n");
  if (modSpecif.Auxiliaire.nbele>0)
    {
      fprintf(fout, "double a[%d], da[%d][%d];\n", modSpecif.Auxiliaire.nbele,
	      modSpecif.Auxiliaire.nbele, modSpecif.IdeAct.nbele);
    }

  fprintf(fout, "ECRTRACE(\"calcpsi\");\n");

  
  if (modSpecif.IdeZ.nbele!=0)
    {
      fprintf(fout, "for (i=0; i<nbl; i++)\n  {\n");
    }
  
  /* stocke les auxiliaires */
  lieuerr=LA;
  for (i=0; i<modSpecif.Auxiliaire.nbele; i++)
    {
      if (ecrTest(modSpecif.Auxiliaire.UnAux[i].arbre, fout,
		  lieuerr, modSpecif, -1, -1)==FAUX)
	{
	  return(FAUX);
	}
      fprintf(fout, "    a[%d]= res;\n", i);
    }

  /* stocke Psi */
  lieuerr=LF;
  for (i=0; i<modSpecif.IdePsi.nbele; i++)
    {
      if (ecrTest(modSpecif.IdePsi.UnPsi[i].arbre, fout,
		  lieuerr, modSpecif, -1, i+1)==FAUX)
	{
	  return(FAUX);
	}
      if (modSpecif.IdeZ.nbele==0)
	{
	  fprintf(fout, "    psi[%d]= res;\n", i);
	}
      else
	{
	  fprintf(fout, "    psi[i]= res;\n");
	}
    }

  /* stocke les derivees des auxiliaires */
  lieuerr=LDADT;
  for (i=0; i<modSpecif.Auxiliaire.nbele; i++)
    {
      for (j=0; j<modSpecif.IdeAct.nbele; j++)
	{
	  if (ecrTest(DeriveesPsi.DerivAux.arbre[j*modSpecif.Auxiliaire.
					      nbele+i],
		      fout, lieuerr, modSpecif, j, -1)==FAUX)
	    {
	      return(FAUX);
	    }
	  fprintf(fout, "    da[%d][%d]= res;\n", i, j);
	}
    }

  lieuerr=LDFDT;
  for (i=0; i<modSpecif.IdeAct.nbele; i++)
    {
      for (j=0; j<modSpecif.IdePsi.nbele; j++)
	{
	  /* stocke la derivee de Psi pour ParAct[i] */
	  if (ecrTest(DeriveesPsi.DerivPsi.arbre[i*modSpecif.IdePsi.nbele+j],
		      fout, lieuerr, modSpecif, i, j+1)
	      ==FAUX)
	    {
	      return(FAUX);
	    }
	  if (modSpecif.IdeZ.nbele==0)
	    {
	      fprintf(fout, "    dpsi[%d][%d]= res;\n", j, i);
	    }
	  else
	    {
	      fprintf(fout, "    dpsi[i][%d]= res;\n", i);
	    }
	}
    }

  if (modSpecif.IdeZ.nbele!=0)
    {
      fprintf(fout, "    }\n");
    }

  fprintf(fout, "return(OK);\n}\n");
  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : copiDescr                |
| Role                  : copie le fichier de description en tete de la
                          subroutine               |
| Parametres d'entree   : fin fout NomDescr       |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 22            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : erreAnal                  |
| Fonctions appelantes : geneSubr                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TLogic copiDescr(fin, fout, NomDescr)
     FILE *fout, *fin;
     TChaine NomDescr;

/*--------------- Fin identification fonction ----*/

{
  int c;

  fprintf(fout, "/*----------------------------------------\n");
  fprintf(fout, "description file: %s\n\n", NomDescr);
  while((c=getc(fin))!=EOF)
    {
      putc(c, fout);
    }
  fprintf(fout, "----------------------------------------*/\n");
/*  fclose(fin); */
return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : geneSubr                 |
| Role                  : stocke les arbres dans des subroutines C
| Parametres d'entree   : GModSpecifPsi DeriveesPsi NomDescr
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 22            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : stokPsi
| Fonctions appelantes : analDer                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt geneSubr(GModSpecifPsi, DeriveesPsi, NomDescr)
     TModSpecifPsi GModSpecifPsi;
     TDeriveesPsi DeriveesPsi;
     TChaine NomDescr;

/*--------------- Fin identification fonction ----*/

{
  FILE * fout, *fin;
  int c;

  /* AB: Pour que ca marche sous linux, - et aussi pour que le fichier
en sortie de analder ne soit pas automatiquement pathname-du-fichier-en-entree.c
ce qui oblige  avoir les droits w sur le directory de celui-ci,
on fait la gnration du programme c sur la sortie standard  via un fichier dans /tmp
  TChaine nom;

  nom=(TChaine)
    malloc((strlen(GModSpecifPsi.PPident.ident[GModSpecifPsi.NomFich].libelle)
	    +2) * sizeof(TChar));
  if (nom==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }
  strcpy(nom, GModSpecifPsi.PPident.ident[GModSpecifPsi.NomFich].libelle);
  strcat(nom, ".c");

  fout=fopen(nom, "w");
  */

  fout=tmpfile();

  if (fout==NULL)
    {
      erreAnal(EFOUT, "/tmp/...");
      return(FAUX);
    }
  fin=fopen(NomDescr, "r");
  if (fin==NULL)
    {
      erreAnal(EFIN, NomDescr);
      return(FAUX);
    }


  /* recopie du fichier de description en tete du fichier */
  if (copiDescr(fin, fout, NomDescr)==FAUX)
    {
      return(FAUX);
    }

  /* entete general a toutes les fonctions calc */
  fprintf(fout, "#include <stdio.h>\n#include <math.h>\n");
  fprintf(fout, "#include \"nltypes.h\"\n#include \"nlcodes.h\"\n");
  fprintf(fout, "#include \"nlmacros.h\"\n#include \"nlfonc.h\"\n");
  
  if (stokPsi(fout, GModSpecifPsi, DeriveesPsi)==FAUX)
    {
      return(FAUX);
    }

  fclose(fin);

  /* AB: */
  rewind(fout);

  while ((c = getc(fout)) != EOF) {
       putc(c, stdout);
  }

  return(VRAI);
}
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : prepDer.c                 |
| Date                 : 13 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : prepare et lance les appels au derivateur
| Reference conception : DCP module 16             |
| Lecteur              :                           |
--------------------------------------------------*/
/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : copieArb                 |
| Role                  : cree un arbre decore a partir d'un arbre simple
| Parametres d'entree   : arbre                    |
| Parametres de sortie  : error                    |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 16            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : prepDer                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TArbDe * copieArb(arbre, error)
     TArbre * arbre;
     TLogic * error;

/*--------------- Fin identification fonction ----*/

{
  TArbDe * Noeud;

  if (arbre==NULL || *error==OUI)
    {
      return(NULL);
    }
  Noeud=(TArbDe *)malloc(sizeof(TArbDe));
  if (Noeud==NULL)
    {
      fprintf(stderr, EMEM2);
      *error=OUI;
      return(NULL);
    }
  Noeud->fonction=arbre->fonction;
  Noeud->valeur=arbre->valeur;
  Noeud->Liste.nbele=0;
  Noeud->Liste.donnees=NULL;
  Noeud->filsG=copieArb(arbre->filsG, error);
  Noeud->filsD=copieArb(arbre->filsD, error);
  return(Noeud);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : prepDer                  |
| Role                  : prepare et lance les appels au derivateur
| Parametres d'entree   : GModSpecifPsi               |
| Parametres de sortie  : DeriveesPsi                 |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 16            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : deriv copieArb            |
| Fonctions appelantes : analDer                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt prepDer(GModSpecifPsi, DeriveesPsi)
     TModSpecifPsi GModSpecifPsi;
     TDeriveesPsi * DeriveesPsi;

/*--------------- Fin identification fonction ----*/

{
  TModStandard ModStandard;
  TDeriv Deriv;
  TDerivAux DerivAux;
  TShortInt i, j;
  TLogic error;

  /* definition des types des indentificateurs utilises */
  ModStandard.TypeIdent.nbele=GModSpecifPsi.PPident.nbele;
  ModStandard.TypeIdent.donnees=(TShortInt *)
    malloc(ModStandard.TypeIdent.nbele*sizeof(TShortInt));
  if (ModStandard.TypeIdent.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<ModStandard.TypeIdent.nbele; i++)
    {
      ModStandard.TypeIdent.donnees[i]=GModSpecifPsi.PPident.ident[i].type;
    }

  /* recopie des expressions auxiliaires */
  ModStandard.Auxiliaire.nbele=0;
  if (GModSpecifPsi.Auxiliaire.nbele>0)
    {
      ModStandard.Auxiliaire.nbele=GModSpecifPsi.Auxiliaire.nbele;
      ModStandard.Auxiliaire.UnAux=(TUnAuxDe *)
	malloc(ModStandard.Auxiliaire.nbele*sizeof(TUnAuxDe));
      /* copie des arbres des aux */
      error=NON; /* cette affectation est valable pour tout le temps */
      for (i=0; i<ModStandard.Auxiliaire.nbele; i++)
	{
	  ModStandard.Auxiliaire.UnAux[i].arbre=
	    copieArb(GModSpecifPsi.Auxiliaire.UnAux[i].arbre, &error);
	  if (ModStandard.Auxiliaire.UnAux[i].arbre==NULL || error==OUI)
	    {
	      return(FAUX);
	    }
	  ModStandard.Auxiliaire.UnAux[i].ident=
	    GModSpecifPsi.Auxiliaire.UnAux[i].ident;
	}
    }
  
  /* recopie des constantes */
  ModStandard.Constantes.nbele=GModSpecifPsi.Constantes.nbele;
  ModStandard.Constantes.UneCst=GModSpecifPsi.Constantes.UneCst;
  
  /* il n'y a pas encore de derivee pour les aux */
  DerivAux.nbele=0;

  /* Cas simple ou on n'a defini que la reponse du modele */
  ModStandard.Expressions.nbele=GModSpecifPsi.IdePsi.nbele;
  ModStandard.Expressions.arbre=(TArbDe **)malloc(sizeof(TArbDe *) *
						  GModSpecifPsi.IdePsi.nbele);
  if (ModStandard.Expressions.arbre==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  /* copie de l'arbre de f */
  for (i=0; i<GModSpecifPsi.IdePsi.nbele; i++)
    {
      ModStandard.Expressions.arbre[i]=
	copieArb(GModSpecifPsi.IdePsi.UnPsi[i].arbre, &error);
      if (ModStandard.Expressions.arbre[i]==NULL || error==OUI)
	{
	  return(FAUX);
	}
    }
  
  /* on derive par rapport a parAct */
  ModStandard.IdentDeriv.nbele=GModSpecifPsi.IdeAct.nbele;
  ModStandard.IdentDeriv.donnees=GModSpecifPsi.IdeAct.donnees;
  
  /* les variables fixes sont Z et Gamma */
  ModStandard.IdentFixe.nbele=GModSpecifPsi.IdeZ.nbele +
    GModSpecifPsi.IdeGam.nbele;
  ModStandard.IdentFixe.donnees=(TShortInt *)
    malloc(ModStandard.IdentFixe.nbele*sizeof(TShortInt));
  if (ModStandard.IdentFixe.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  j=0;
  for (i=0; i<GModSpecifPsi.IdeZ.nbele; i++)
    {
      ModStandard.IdentFixe.donnees[j]=GModSpecifPsi.IdeZ.donnees[i];
      j++;
    }
  for (i=0; i<GModSpecifPsi.IdeGam.nbele; i++)
    {
      ModStandard.IdentFixe.donnees[j]=GModSpecifPsi.IdeGam.donnees[i];
      j++;
    }
  
  /* appel du derivateur */
  if (deriv(ModStandard, &Deriv, &DerivAux, -1)
      ==FAUX)
    {
      return(FAUX);
    }
  
  /* sauvegarde des resultats */
  DeriveesPsi->DerivPsi.nbele=Deriv.nbele;
  DeriveesPsi->DerivPsi.arbre=Deriv.arbre;

  /* sauvegarde des derivees des expressions auxiliaires */
  DeriveesPsi->DerivAux.nbele=DerivAux.nbele;
  DeriveesPsi->DerivAux.arbre=DerivAux.arbre;
  
  return(VRAI);
}
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : prepEval.c                |
| Date                 : 15 decembre 1992          |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : remplace dans les arbres tous les appels a des
                         identificateurs par un lien sur l'arbre d'expression
                         dans le cas des aux, f ou derivees, sur un arbre
                         constante dans le cas des X, theta, beta, gamma...
| Reference conception : DCP module 31             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : bclCop                   |
| Role                  : fonction recursive de copie d'un arbre
| Parametres d'entree   : arbre                    |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 31            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : copieAux                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TArbre * bclCop(arbre)
     TArbre * arbre;

/*--------------- Fin identification fonction ----*/

{


/*  TArbre * noeud;
  if (arbre==NULL)
    {
      return(NULL);
    }
  noeud=(TArbre*) malloc(sizeof(TArbre));
  if (noeud==NULL)
    {
      erreAnal(EMEM, NULL);
      return(NULL);
    }
  noeud->fonction=arbre->fonction;
  noeud->valeur=arbre->valeur;
  noeud->filsG=bclCop(arbre->filsG);
  noeud->filsD=bclCop(arbre->filsD);
  return(noeud);
  */
  return(arbre);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : copieAux                 |
| Role                  : fait une copie des expressions auxiliaires et
                          de leurs derivees        |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
|    - copie : tableau contenant les copies des expressions auxiliaires
|              et de leurs derivees
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 31            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : bclCop                    |
| Fonctions appelantes : prepEval                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt copieAux(copie)
     TArbre ** copie;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  for (i=0; i<GModSpecifPsi.Auxiliaire.nbele; i++)
    {
      if ((copie[i]=bclCop(GModSpecifPsi.Auxiliaire.UnAux[i].arbre)) == NULL)
	{
	  return(FAUX);
	}
    }
  for (i=0; i<DeriveesPsi.DerivAux.nbele; i++)
    {
      if ((copie[i+GModSpecifPsi.Auxiliaire.nbele]=
	  bclCop(DeriveesPsi.DerivAux.arbre[i])) == NULL)
	{
	  return(FAUX);
	}
    }
  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : FchoixArb                |
| Role                  : retourne un pointeur sur un arbre correspondant
                          a l'identificateur pour le modele simple
| Parametres d'entree   :                          |
|    - ident : numero de l'identificateur a remplacer, ce numero est
|              negatif. Si PPident.nbele<ident<=0 c'est un identificateur
|              "simple", si ident<=PPident.nbele c'est la derivee d'un
|              identificateur
|    - aux   : tableau contenant une copie des expressions auxiliaires et
|              de leurs derivees (on est oblige de faire une copie car
|              tout n'est pas traite pareil dans tous les cas)
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 31            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : FremplIde prepEval        |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TArbre * FchoixArb(ident, aux, param)
     TShortInt ident;
     TArbre ** aux;
     TShortInt param;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TArbre * Noeud;
  TLogic indicder;

  /* on prend un numero positif */
  ident=-ident;
  indicder=FAUX;
  if (ident >= GModSpecifPsi.PPident.nbele)
    {
      ident=ident-GModSpecifPsi.PPident.nbele;
      indicder=VRAI;
    }
  switch(GModSpecifPsi.PPident.ident[ident].type)
    {
    case IDECONST:
      /* on construit un bout d'arbre ne contenant que la valeur de la
	 constante */
      Noeud=(TArbre *) malloc(sizeof(TArbre));
      if (Noeud==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(NULL);
	}
      Noeud->fonction=CONSTANTE;
      Noeud->filsG=NULL;
      Noeud->filsD=NULL;
      i=0;
      while (GModSpecifPsi.Constantes.UneCst[i].ident!=ident)
	{
	  i++;
	}
      Noeud->valeur=GModSpecifPsi.Constantes.UneCst[i].valeur;
      return(Noeud);
      break;
    case IDEAUX:
      i=0;
      while (GModSpecifPsi.Auxiliaire.UnAux[i].ident!=ident)
	{
	  i++;
	}
      if (indicder==VRAI)
	{
	  return(aux[(param+1) * GModSpecifPsi.Auxiliaire.nbele+i]);
	}
      else
	{
	  return(aux[i]);
	}
      break;
    case IDEZ:
      i=0;
      while (GModSpecifPsi.IdeZ.donnees[i]!=ident)
	{
	  i++;
	}
      return(GModSpecifPsi.ParamEntre[i]);
      break;
    case IDEACT:
      i=0;
      while (GModSpecifPsi.IdeAct.donnees[i]!=ident)
	{
	  i++;
	}
      return(GModSpecifPsi.ParamEntre[i+GModSpecifPsi.IdeZ.nbele]);
      break;
    case IDEGAM:
      i=0;
      while (GModSpecifPsi.IdeGam.donnees[i]!=ident)
	{
	  i++;
	}
      return(GModSpecifPsi.ParamEntre[i + GModSpecifPsi.IdeZ.nbele +
				       GModSpecifPsi.IdeAct.nbele]);
      break;
    }
  return(NULL);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : FremplIde                |
| Role                  : remplace un identificateur par un lien vers 
                          l'arbre correspondant pour un modele simple
| Parametres d'entree   :                          |
|    - arbre : arbre sur lequel est fait le remplacement des identificateurs
|    - param : numero du parametre par rapport auquel on derive si l'arbre
|              traite est un arbre de derivee
|    - aux   : tableau contenant une copue des auxiliaires et de 
|              leurs derivees
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 31            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : FchoixArb                 |
| Fonctions appelantes : prepPsi preAux erreAnal
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TArbre * FremplIde(arbre, aux, param)
     TArbre * arbre;
     TShortInt param;
     TArbre ** aux;

/*--------------- Fin identification fonction ----*/

{
  
  if (arbre!=NULL)
    {
      if (arbre->fonction <=0)
	{
	  /* cas ou l'expression est reduite a un identificateur, par exemple:
	     f=aux1;
	     aux1=aux2;... */
	  return(FchoixArb(arbre->fonction, aux, param));
	}
      else
	{
	  arbre->filsG=FremplIde(arbre->filsG, aux, param);
	  arbre->filsD=FremplIde(arbre->filsD, aux, param);
	  return(arbre);
	}
    }
  /* AB */
return(NULL);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : prepAux                  |
| Role                  : fait le rattachement des arbres sur une copie des
|                         auxiliaires
| Parametres d'entree   :                          |
|    - liste : liste des auxiliaires a traiter effectivement
|    - type : type de l'expression traitee (CLF, CLV...)
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
|    - aux : copie des auxiliaires a traiter       |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : FremplIde                 |
| Fonctions appelantes : prepPsi
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt prepAux(aux)
     TArbre **aux;

/*--------------- Fin identification fonction ----*/

{
  TShortInt i, j, ii, k;
  
  for (i=0; i<GModSpecifPsi.Auxiliaire.nbele; i++)
    {
      if (aux[i] == NULL)
	{
	  erreAnal(EARBRE, NULL);
	  return(FAUX);
	}
      k=0;
      aux[i]=FremplIde(aux[i], aux, 0);
    }
  /* derivees des auxiliaires */
  for (i=0; i<GModSpecifPsi.Auxiliaire.nbele; i++)
    {
      for (j=0; j<GModSpecifPsi.IdeAct.nbele; j++)
	{
	  ii=(j+1)*GModSpecifPsi.Auxiliaire.nbele+i;
	  /* (j+1) car les NbAux premieres equations sont les
	     expressions auxiliaires simples */
	  if (aux[ii]==NULL)
	    {
	      erreAnal(EARBRE, NULL);
	      return(FAUX);
	    }
	  aux[ii]=FremplIde(aux[ii], aux, j);
	}
      }
  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : prepPsi                    |
| Role                  : prepare le modele simple |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : FremplIde prepAux         |
| Fonctions appelantes : prepEval                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt prepPsi()

/*--------------- Fin identification fonction ----*/

{
  TArbre ** aux;
  TShortInt i, j, ii;
  
  /* cas des auxiliaires */
  if (GModSpecifPsi.Auxiliaire.nbele > 0)
    {
      /* on cree et copie les expressions auxiliaires */
      aux=(TArbre**)malloc((GModSpecifPsi.Auxiliaire.nbele +
			    DeriveesPsi.DerivAux.nbele) *
			   sizeof(TArbre*));
      if (aux==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
      if(copieAux(aux)==FAUX)
	{
	  return(FAUX);
	}
      
      /* on prepare les expressions auxiliaires */
      if (prepAux(aux) == FAUX)
	{
	  return(FAUX);
	}
    }

  /* F */
  for (i=0; i<GModSpecifPsi.IdePsi.nbele; i++)
    {
      if (GModSpecifPsi.IdePsi.UnPsi[i].arbre==NULL)
	{
	  erreAnal(EARBRE, NULL);
	  return(FAUX);
	}
      GModSpecifPsi.IdePsi.UnPsi[i].arbre=
	FremplIde(GModSpecifPsi.IdePsi.UnPsi[i].arbre, aux, 0);
    }
  
  /* derivees de F */
  for (i=0; i<GModSpecifPsi.IdeAct.nbele; i++)
    {
      for (j=0; j<GModSpecifPsi.IdePsi.nbele; j++)
	{
	  ii=i*GModSpecifPsi.IdePsi.nbele+j;
	  if (DeriveesPsi.DerivPsi.arbre[ii]==NULL)
	    {
	      erreAnal(EARBRE, NULL);
	      return(FAUX);
	    }
	  DeriveesPsi.DerivPsi.arbre[ii]=
	    FremplIde(DeriveesPsi.DerivPsi.arbre[ii], aux, i);
	}
    }
  return(VRAI);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : prepEval                 |
| Role                  : supprime des arbres tous les appels a des
                          identificateurs          |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 31            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : prepF                     |
| Fonctions appelantes : analDer                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt prepEval()

/*--------------- Fin identification fonction ----*/

{
  TShortInt i, longueur, nbTheta, nbGf, nbX;

  /* cree un tableau d'arbres reduits a une feuille ou seront stockees
     les valeurs des differents parametres du modele a chaque appel
     aux fonctions calcf, calcv... passant par l'evaluation d'un arbre */
  nbTheta=GModSpecifPsi.IdeAct.nbele;
  nbX=GModSpecifPsi.IdeZ.nbele;
  nbGf=GModSpecifPsi.IdeGam.nbele;
  longueur=nbX + nbTheta + nbGf ;

  GModSpecifPsi.ParamEntre=(TArbre **) malloc(longueur*sizeof(TArbre *));
  if (GModSpecifPsi.ParamEntre==NULL)
    {
      erreAnal(EMEM, NULL);
      return(FAUX);
    }
  for (i=0; i<longueur; i++)
    {
      /* on initialise les arbres comme etant des feuilles */
      GModSpecifPsi.ParamEntre[i]=(TArbre *) malloc(sizeof(TArbre));
      if (GModSpecifPsi.ParamEntre[i]==NULL)
	{
	  erreAnal(EMEM, NULL);
	  return(FAUX);
	}
      GModSpecifPsi.ParamEntre[i]->filsG=NULL;
      GModSpecifPsi.ParamEntre[i]->filsD=NULL;
      GModSpecifPsi.ParamEntre[i]->fonction=CONSTANTE;
    }
  
  /* cas du modele simple */
  if (prepPsi() == FAUX)
    {
      return(FAUX);
    }

  return(VRAI);
}


/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : veriType.c                |
| Date                 : 25 nov. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : Verifie que l'identificateur est de type autorise
| Reference conception : DCP module 10             |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : veriType                 |
| Role                  : Verifie que l'identificateur est de type autorise
| Parametres d'entree   : IdRef classein           |
| Parametres de sortie  : ordre classeout          |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 10            |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : analyseur syntaxique      |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

static TShortInt veriType(IdRef, classein, classeout, ordre)
     TShortInt IdRef, classein;
     TShortInt * ordre, * classeout;

/*--------------- Fin identification fonction ----*/
{
  TShortInt type;
  TShortInt i;

  type=GModSpecifPsi.PPident.ident[IdRef].type;
  *classeout=-999;
  *ordre=-999;

  switch(classein)
    {
    case CLDTE:
      /* identificateur en partie droite */
      switch(type)
	{
	case IDEZ:
	case IDEACT:
	case IDEGAM:
	case IDEAUX:
	case IDECONST:
	  break;
	default:
	  erreAutr(ETYPE, GModSpecifPsi.PPident.ident[IdRef].libelle);
	  break;
	}
      break;
    case CLGCH:
      switch(type)
	{
	  /* identificateur en partie gauche */
	case IDEPSI:
	  *classeout=CLPSI;
	  for (i=0; i<GModSpecifPsi.IdePsi.nbele; i++)
	    {
	      if (GModSpecifPsi.IdePsi.UnPsi[i].ident==IdRef)
		{
		  *ordre=i;
		}
	    }
	  break;
	case IDEAUX:
	  *classeout=CLAUX;
	  for (i=0; i<GModSpecifPsi.Auxiliaire.nbele; i++)
	    {
	      if (GModSpecifPsi.Auxiliaire.UnAux[i].ident==IdRef)
		{
		  *ordre=i;
		}
	    }
	  break;
	case IDECONST:
	  *classeout=CLCONS;
	  for (i=0; i<GModSpecifPsi.Constantes.nbele; i++)
	    {
	      if (GModSpecifPsi.Constantes.UneCst[i].ident==IdRef)
		{
		  *ordre=i;
		}
	    }
	  break;
	default:
	  erreAutr(ETYPE, GModSpecifPsi.PPident.ident[IdRef].libelle);
	  break;
	}
      break;
    }
return(VRAI);
}

/* ---------------analSyntPsi------------------------------------- */


 int analSyntPsi()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		analSerr( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				analSerr( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = monyypact[ yy_state ] ) <= YYFLAG )
			goto monyydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = analLex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto monyydefault;
		if ( monyychk[ yy_n = monyyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	monyydefault:
		if ( ( yy_n = monyydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = analLex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = monyyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				analSerr( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = monyypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						monyychk[monyyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = monyyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If monyyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = monyyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = monyypgo[ yy_n = monyyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					monyychk[ yy_state =
					monyyact[ yy_state ] ] != -yy_n )
				{
					yy_state = monyyact[ monyypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = monyypgo[ yy_n = monyyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				monyychk[ yy_state = monyyact[ yy_state ] ] != -yy_n )
			{
				yy_state = monyyact[ monyypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 3:
# line 45 "analSynt.yacc"
{
		coheDecl();
		GModSpecifPsi.Unique=NON;
		} break;
case 4:
# line 50 "analSynt.yacc"
{
		coheDecl();
		GModSpecifPsi.Unique=NON;
		} break;
case 13:
# line 66 "analSynt.yacc"
{
		GModSpecifPsi.yaerr=OUI;
		} break;
case 14:
# line 73 "analSynt.yacc"
{
		if (TestUtil(IDEPSI)==VRAI)
                  {
		    copiPsi(yypvt[-0].vecsht);
		    alloueIde(IDEPSI, yypvt[-0].vecsht);
		  }
		} break;
case 15:
# line 84 "analSynt.yacc"
{
		if (TestUtil(IDEZ)==VRAI)
		  {
		    GModSpecifPsi.IdeZ.nbele=yypvt[-0].vecsht.nbele;
		    GModSpecifPsi.IdeZ.donnees=yypvt[-0].vecsht.donnees;
		    alloueIde(IDEZ, yypvt[-0].vecsht);
		  }
		} break;
case 16:
# line 96 "analSynt.yacc"
{
		yyval.vecsht.nbele=yypvt[-2].vecsht.nbele+1;
		yyval.vecsht.donnees=(TShortInt *)realloc(yypvt[-2].vecsht.donnees,
			yyval.vecsht.nbele*sizeof(TShortInt));
		if (yyval.vecsht.donnees==NULL)
			{
			erreAnal(EMEM, NULL);
			}
		else
			{
			yyval.vecsht.donnees[yypvt[-2].vecsht.nbele]=yypvt[-0].court;
			}
		} break;
case 17:
# line 110 "analSynt.yacc"
{
		yyval.vecsht.nbele=1;
		yyval.vecsht.donnees=(TShortInt *)malloc(sizeof(TShortInt));
		if (yyval.vecsht.donnees==NULL)
			{
			erreAnal(EMEM, NULL);
			}
		else
			{
			yyval.vecsht.donnees[0]=yypvt[-0].court;
			}
		} break;
case 18:
# line 126 "analSynt.yacc"
{
		if (TestUtil(IDEACT)==VRAI)
		  {
		    GModSpecifPsi.IdeAct.nbele=yypvt[-0].vecsht.nbele;
		    GModSpecifPsi.IdeAct.donnees=yypvt[-0].vecsht.donnees;
		    alloueIde(IDEACT, yypvt[-0].vecsht);
		  }
		} break;
case 19:
# line 138 "analSynt.yacc"
{
		if (TestUtil(IDECONST)==VRAI)
		  {
		    copiConst(yypvt[-0].vecsht);
		    alloueIde(IDECONST, yypvt[-0].vecsht);
		  }
		} break;
case 20:
# line 149 "analSynt.yacc"
{
		if (TestUtil(IDEAUX)==VRAI)
		  {
		    copiAux(yypvt[-0].vecsht);
		    alloueIde(IDEAUX, yypvt[-0].vecsht);
		  }
		} break;
case 21:
# line 160 "analSynt.yacc"
{
		if (TestUtil(IDEGAM)==VRAI)
		  {
		    GModSpecifPsi.IdeGam.nbele=yypvt[-0].vecsht.nbele;
		    GModSpecifPsi.IdeGam.donnees=yypvt[-0].vecsht.donnees;
		    alloueIde(IDEGAM, yypvt[-0].vecsht);
		  }
		} break;
case 22:
# line 172 "analSynt.yacc"
{
		if (TestUtil(IDEFICH)==VRAI)
		  {
		    GModSpecifPsi.NomFich=yypvt[-0].court;
		    GModSpecifPsi.PPident.ident[yypvt[-0].court].type=IDEFICH;
		  }
		} break;
case 23:
# line 183 "analSynt.yacc"
{
		if (TestUtil(IDESUBR)==VRAI)
		  {
		    GModSpecifPsi.Subroutine=OUI;
		  }
		} break;
case 25:
# line 194 "analSynt.yacc"
{
		coheExpr();
		} break;
case 26:
# line 198 "analSynt.yacc"
{
		coheExpr();
		} break;
case 27:
# line 205 "analSynt.yacc"
{
		TShortInt classein, classeout, ordre;

		classein=CLGCH;
		veriType(yypvt[-2].court, classein, &classeout, &ordre);
		attaArb(classeout, ordre, yypvt[-0].arb);
		GModSpecifPsi.erraff=NON;
		} break;
case 28:
# line 214 "analSynt.yacc"
{
		GModSpecifPsi.yaerr=OUI;
		} break;
case 29:
# line 221 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, PLUS);
		} break;
case 30:
# line 225 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, MOINS);
		} break;
case 31:
# line 229 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, PLUS);
		} break;
case 32:
# line 233 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, MOINS);
		} break;
case 33:
# line 237 "analSynt.yacc"
{
		yyval.arb=yypvt[-0].arb;
		} break;
case 34:
# line 244 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, MULT);
		} break;
case 35:
# line 248 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, DIV);
		} break;
case 36:
# line 252 "analSynt.yacc"
{
		yyval.arb=yypvt[-0].arb;
		} break;
case 37:
# line 259 "analSynt.yacc"
{
		yyval.arb=yypvt[-0].arb;
		} break;
case 38:
# line 263 "analSynt.yacc"
{
		yyval.arb=yypvt[-0].arb;
		} break;
case 39:
# line 267 "analSynt.yacc"
{
		yyval.arb=constBin(constUn(NULL, CONSTANTE, (double)-1), yypvt[-0].arb, MULT);
		} break;
case 40:
# line 274 "analSynt.yacc"
{
		yyval.arb=yypvt[-0].arb;
		} break;
case 41:
# line 278 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-5].arb, constBin(yypvt[-3].arb, yypvt[-1].arb, THENELSE), IF);
		} break;
case 42:
# line 282 "analSynt.yacc"
{
		yyval.arb=constUn(yypvt[-1].arb, SIN, 0);
		} break;
case 43:
# line 286 "analSynt.yacc"
{
		yyval.arb=constUn(yypvt[-1].arb, COS, 0);
		} break;
case 44:
# line 290 "analSynt.yacc"
{
		yyval.arb=constUn(yypvt[-1].arb, EXP, 0);
		} break;
case 45:
# line 294 "analSynt.yacc"
{
		yyval.arb=constUn(yypvt[-1].arb, LOG, 0);
		} break;
case 46:
# line 298 "analSynt.yacc"
{
		yyval.arb=constUn(yypvt[-1].arb, LN, 0);
		} break;
case 47:
# line 302 "analSynt.yacc"
{
		yyval.arb=constUn(yypvt[-1].arb, TG, 0);
		} break;
case 48:
# line 306 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, PUISSANCE);
		} break;
case 49:
# line 313 "analSynt.yacc"
{
		yyval.arb=yypvt[-1].arb;
		} break;
case 50:
# line 317 "analSynt.yacc"
{
		TShortInt classein, classeout, ordre;

		classein=CLDTE;
		veriType(yypvt[-0].court, classein, &classeout, &ordre);
		yyval.arb=constUn(NULL, -yypvt[-0].court, 0);		
		} break;
case 51:
# line 325 "analSynt.yacc"
{
		yyval.arb=constUn(NULL, CONSTANTE, yypvt[-0].dbl);
		} break;
case 52:
# line 329 "analSynt.yacc"
{
		yyval.arb=constUn(NULL, CONSTANTE, yypvt[-0].dbl);
		} break;
case 53:
# line 333 "analSynt.yacc"
{
		yyval.arb=constUn(NULL, CONSTANTE, -yypvt[-0].dbl);
		} break;
case 54:
# line 340 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, AND);
		} break;
case 55:
# line 344 "analSynt.yacc"
{
		yyval.arb=yypvt[-0].arb;
		} break;
case 56:
# line 351 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, OR);
		} break;
case 57:
# line 355 "analSynt.yacc"
{
		yyval.arb=yypvt[-0].arb;
		} break;
case 58:
# line 362 "analSynt.yacc"
{
		yyval.arb=constUn(yypvt[-0].arb, NOT, 0);
		} break;
case 59:
# line 366 "analSynt.yacc"
{
		yyval.arb=yypvt[-0].arb;
		} break;
case 60:
# line 373 "analSynt.yacc"
{
		yyval.arb=yypvt[-1].arb;
		} break;
case 61:
# line 377 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, EQ);
		} break;
case 62:
# line 381 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, NEQ);
		} break;
case 63:
# line 385 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, GE);
		} break;
case 64:
# line 389 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, LE);
		} break;
case 65:
# line 393 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, GEQ);
		} break;
case 66:
# line 397 "analSynt.yacc"
{
		yyval.arb=constBin(yypvt[-2].arb, yypvt[-0].arb, LEQ);
		} break;
	}
	goto yystack;		/* reset registers in driver code */
}

/* -------------fin de analSynt  --------------------------- */


/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : analDerFunc.c                 |
| Date                 : 12 dec. 1991              |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : O. Nicole                 |
| Role                 : point d'entre de l'analyseur derivateur
| Reference conception : DCP module 1              |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : analDerFunc                  |
| Role                  : point d'entree de l'analyseur derivateur
| Parametres d'entree   : NomDescr                 |
| Parametres de sortie  : RetModelePsi RetInteg       |
| Parametres d'e./s.    :                          |
| Reference conception  : DCP module 1             |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : analyse prepDer geneSubr  |
| Fonctions appelantes :                           |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt analDerFunc(TChaine NomDescr, int gfile, TRetModelePsi * RetModelePsi)

/*--------------- Fin identification fonction ----*/
{
  TShortInt i;
  
  /* appel de l'analyseur */
  analyse(NomDescr);
  if (GModSpecifPsi.yaerr==OUI)
    {
      fprintf(stderr, EFATAL);
      return(FAUX);
    }
  /* appel du derivateur */
  if (prepDer(GModSpecifPsi, &DeriveesPsi)==FAUX)
    {
      fprintf(stderr, EFATAL);
      return(FAUX);
    }

  /* appel au stockage des subroutines en C */
  if (GModSpecifPsi.Subroutine==OUI)
    {
      if (gfile == 1)
          geneSubr(GModSpecifPsi, DeriveesPsi, NomDescr);
      if (GModSpecifPsi.yaerr==OUI)
	{
	  fprintf(stderr, EFATAL);
	  return(FAUX);
	}
    }
  else
     fprintf(stderr, WSUBR);


  /* appel a la preparation en vue de l'evaluation des arbres */
  if (prepEval(GModSpecifPsi, DeriveesPsi) == FAUX)
    {
      fprintf(stderr, EFATAL);
      return(FAUX);
    }

  RetModelePsi->NomZ.nbele=GModSpecifPsi.IdeZ.nbele;
  RetModelePsi->NomZ.donnees=(TChaine *)malloc(GModSpecifPsi.IdeZ.nbele*
					   sizeof(TChaine));
  if (RetModelePsi->NomZ.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModelePsi->NomZ.nbele; i++)
    {
      RetModelePsi->NomZ.donnees[i]=GModSpecifPsi.PPident.
	ident[GModSpecifPsi.IdeZ.donnees[i]].libelle;
    }

  RetModelePsi->NomAct.nbele=GModSpecifPsi.IdeAct.nbele;
  RetModelePsi->NomAct.donnees=(TChaine *)malloc(GModSpecifPsi.IdeAct.nbele*
					   sizeof(TChaine));
  if (RetModelePsi->NomAct.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModelePsi->NomAct.nbele; i++)
    {
      RetModelePsi->NomAct.donnees[i]=GModSpecifPsi.PPident.
	ident[GModSpecifPsi.IdeAct.donnees[i]].libelle;
    }

  RetModelePsi->NomPsi.nbele=GModSpecifPsi.IdePsi.nbele;
  RetModelePsi->NomPsi.donnees=(TChaine *)malloc(GModSpecifPsi.IdePsi.nbele*
					   sizeof(TChaine));
  if (RetModelePsi->NomPsi.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModelePsi->NomPsi.nbele; i++)
    {
      RetModelePsi->NomPsi.donnees[i]=GModSpecifPsi.PPident.
	ident[GModSpecifPsi.IdePsi.UnPsi[i].ident].libelle;
    }

  RetModelePsi->NomGam.nbele=GModSpecifPsi.IdeGam.nbele;
  RetModelePsi->NomGam.donnees=(TChaine *)malloc(GModSpecifPsi.IdeGam.nbele*
					   sizeof(TChaine));
  if (RetModelePsi->NomGam.donnees==NULL)
    {
      fprintf(stderr, EMEM2);
      return(FAUX);
    }
  for (i=0; i<RetModelePsi->NomGam.nbele; i++)
    {
      RetModelePsi->NomGam.donnees[i]=GModSpecifPsi.PPident.
	ident[GModSpecifPsi.IdeGam.donnees[i]].libelle;
    }

  RetModelePsi->NomFich=GModSpecifPsi.PPident.ident[GModSpecifPsi.NomFich].libelle;

  return(VRAI);
}

/* -------------- initglobpsi -----------------------
  Role: initialisation des variables globales de analDer
 --------------------------------------------------- */

void initglobpsi()
{
int i;

DeriveesPsi.DerivPsi.nbele=0;
DeriveesPsi.DerivAux.nbele=0;

GModSpecifPsi.PPident.nbele=0;
GModSpecifPsi.IdePsi.nbele=0;
GModSpecifPsi.IdeZ.nbele=0;
GModSpecifPsi.IdeAct.nbele=0;
GModSpecifPsi.IdeGam.nbele=0;
GModSpecifPsi.Resp=0;
GModSpecifPsi.Auxiliaire.nbele=0;
GModSpecifPsi.Constantes.nbele=0;
GModSpecifPsi.Subroutine=0;
for (i=0;i<17;i++)
  {GModSpecifPsi.typeUsed[i]=0;}
GModSpecifPsi.Unique=0;
GModSpecifPsi.yaerr=0;
GModSpecifPsi.erraff=0;
monyylineno=1;

}
/*--------------- end of initglobpsi -------------- */


/* -----------------crPsinls2 ------------------------------
 Role: appeler le generateur formel pour creer un arbre et un programme
-------------------------------------------------------- */
void crPsinls2(ficmod,Code)
/* arguments d'entree */
char **ficmod;
/* arguments de sortie */
long *Code;
{

int gfile=0; /* on veut pas generer un fichier */

/* char NomModele[255]; strcpy(NomModele, *ficmod); */

/* Appel de analDer */
/* ----------------- */
  if (analDerFunc(*ficmod, gfile, &RetModelePsi ) == FAUX)
    {
     fprintf(stderr,
"\n Error in the execution of the symbolic generator \n");
     *Code=ERR;
     return;
    }
*Code=OK;

return;
}
/* ---------------- end of  crPsinls2 ----------------- */
