/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : CalcInteg                 |
| Date                 : 1992                      |
| Derniere mise a jour :                           |
| Concepteur           : P. Neveu                  |
| Role                 : le programme d'appel a    |
|   l'integrateur                                  |
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nlchoix.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlglobal.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
TShortInt GerMessage( );

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : CalcInteg                |
| Role                  : gere l'appel a lsoda     |
|                                                  |
| Les parties de code liees a LSODA sont regroupees|
| dans cette fonction                              |
|                                                  |
| Parametres d'entree   : nbt nbg nbl nbc theta    |
  gamf xobs indc                                   |
| Parametres de sortie  : le ie                    |
| Parametres d'e./s.    : FSedo, DFSedo            |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  lsosa calcodes_ calcjac_ |
| Fonctions appelantes :  ModSedo                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/


/* declaration des fonctions appelees par LSODA pour le calcul des */
/* SEDO et du jacobien                                             */

extern void calcodes_(); 
extern void calcjac_();


/* Ce module ne fait pas parti de la bibliotheque NL */
/* car il peut etre remplacer par un programme utilisateur */


TShortInt CalcInteg(nbt,nbg,nbl,nbc,theta, gamf, xobs, 
		    indc, FSedo, DFSedo, le ,ie) 
     TShortInt nbt;      /* nombre de parametres theta */
     TShortInt nbg;      /* nombre de parametres gamf  */
     TShortInt nbl;      /* nombre de lignes de xobs */
     TShortInt nbc;      /* nombre de colonnes de xobs */
     TDouble *theta;     /* vecteur des parametres a estimer */
     TDouble *gamf;      /* vecteurs des parametres de second niveau */
     TDouble  **xobs;    /* matrice des variables explicatives */
     TShortInt indc;     /* identificateur de la courbe courante */
     TDouble ***FSedo;   /* table tridimensionnelle contiendra les valeurs */
                         /* du systeme pour les differents temps           */
                         /* et eventuellement pour les differents XObs     */
     TDouble ***DFSedo;  /* table tridimensionnelle contiendra les valeurs */
                         /* des derives du systeme */
     TShortInt *le;      /* non utilise pour l'instant. prevu pour la */
			 /* localisation de l'erreur  */
     TShortInt *ie;      /* iteration de l'erreur */
{
  TVect y;               /* vecteur pour l'integration */
                         /* mais aussi pour le passage des Theta GamF et XObs */
                         /* dans la routine qui calcule les equations du systeme */ 
  int neq[7];            /* descripteur du vecteur y */
                         /* mais aussi pour l'indice courant quand */
                         /* XObs intervient dans les equations */
  TShortInt decala,dd;   /* pour le stockage des decalages dans y */
  int istate;            /* parametre de lsoda -- voir notice */
  int itask=1;           /* parametres lsoda -- voir notice */
  TShortInt i,j,k,l;     /* indices */
  TDouble *condinit;     /* pour le stockage des conditions initiales */
  TDouble lt0;           /* pour passer t0 a lsoda */

  void lsoda_();
  /*-----------------------------------------------------------*/
  /*                   allocations memoire                     */

  /* remarque : certaines instructions sont redondantes avec   */
  /* les appels precedents, aussi elles sont a ce niveau car   */
  /* ces instructions sont specifiques a LSODA.                */

  ECRTRACE("CalcInteg");
  /* Initialisation du vecteur neq */

  neq[0] = (int) GNLCtxInteg.LongSys ;
  neq[1]=(int) nbt;
  neq[2]=(int) nbg;
  
  if ( GNLCtxInteg.IndicX == FAUX )
    {
      /* XObs n'intervient pas -> on n'a pas besoin de neq[3 a 5] */
      neq[4]=0;
      neq[5]=0;
    }
  else
    { 
      /* XObs intervient nbre d'observations dans neq[4]  */
      /* nbre de variables explicatives dans neq[5]       */
      neq[4]=(int) nbl;
      neq[5]=(int) nbc;
    }
  neq[6]=0; /* pour recuperer les erreurs dans calcodes_ */


  /* allocation de condinit */
  CREER_T1(condinit,neq[0],TDouble);
  
  /* allocation de y                                     */
  /* longueur de y  neq[0]+neq[1]+neq[2]+(neq[4]*neq[5]) */

  y.nbele =  neq[0] + neq[1] + neq[2]
    + ( neq[4]*neq[5] );
  CREER_T1( y.donnees , y.nbele, TDouble); 
  
  
  /* on remplit le vecteur y en fonction de la nature */
  /* des conditions initiales */
  
  if ( GNLCtxInteg.IndicCi == FAUX)
    {
      /* Les Conditions initiales ne sont pas des parametres a estimer */
      for (i=0; i < GNLCtxInteg.NbEq; i++)
	{
	  y.donnees[i]=GNLCtxInteg.VectCi[indc].donnees[i];
	  condinit[i]=y.donnees[i];
	}
      for (i=GNLCtxInteg.NbEq; i<neq[0]; i++)
	{
	  y.donnees[i]=0.0;
	  condinit[i]=y.donnees[i];
	}
    }
  else
    {
      /* les condition initiales sont des parametres a estimer */
      for (i=0; i < GNLCtxInteg.NbEq; i++)
	/* les NbEq parametres sont les valeurs initiales */
	{
	  y.donnees[i] = theta[i];
	  condinit[i]=y.donnees[i];
	}
      for (i=GNLCtxInteg.NbEq; i < neq[0] ; i++)
	/* on met toutes les autres valeurs initiales a 0 */
	{
	  y.donnees[i]=0.0;
	  condinit[i]=y.donnees[i];
	}
      /* on met les NbEq valeurs initales "de la diagonale" a 1 */
      for (i= 0; i < GNLCtxInteg.NbEq ; i++)
	{
	  j=GNLCtxInteg.NbEq+i*(GNLCtxInteg.NbThetaSedo+GNLCtxInteg.NbEq+1);
	  y.donnees[j]=1.0;
	  condinit[j]=y.donnees[j];
	}
    }
  
  /* on entre les valeurs de Theta dans y */
  
  for ( i = 0; i < nbt; i++)
    {
      y.donnees[neq[0]+i]=theta[i];
    }
  /* on entre les valeurs de GamF dans y */
  
  decala=neq[0]+neq[1]; /* on fait ce calcul avant pour eviter de le faire */
  /* a chaque iteration */
  for ( i = 0; i < nbg; i++)
    {
      y.donnees[decala+i]=gamf[i];
    }
  decala=decala+neq[2];
  
  /* si les X interviennent on les entre dans y, sinon  */
  /* neq[4] et neq[5] sont egaux a 0 et on ne passe pas */
  /* dans les boucles                                   */

/* AB: 28/05/98 JE MODIFIE
ce qui suit car il faut que les variables explicatives soient
ranges ainsi: toutes les valeurs de la 1iere va, toutes les valeurs de la 
2ieme variable, etc ...
Ce qui suit provoquait des mauvais resultats quand une varind
qui n'est pas valint intervient dans le sedo.
Ca ne faisait pas d'erreur si toutes les varind n'interviennent que pour
le calcul de la reponse 

  for ( i =0; i < neq[4]; i++)
    {
      for (k =0; k < neq[5] ; k++)
	{
 	  y.donnees[(decala+k)]=xobs[i][k]; 
	}
      decala++;
    }
 FIN MODIF */

  dd=decala;
  for (k =0; k < neq[5] ; k++)
    {
     for ( i =0; i < neq[4]; i++)
	{
 	  y.donnees[dd]=xobs[i][k]; 
         dd++;
	}
    }

  
  /*----------------------------------------------------------*/
  /*                 l'integration                            */
  
  
  /* boucle d'integration */
  
  if ( GNLCtxInteg.Tj[indc].nblig > 1 && GNLCtxInteg.IndicX == FAUX )
    {
      Tcoo *ccoo; /* pointeur pour recuperer les coordonnees  */
      
      /* X n'intervient pas dans les equations du systeme et  */
      /* la matrice des temps Tj a NbObs lignes est mise      */
      /* dans le vecteur TjBis.                               */
      
      istate=1;
      lt0=GNLCtxInteg.T0Bis.donnees[indc];
      for (j=0; j< GNLCtxInteg.TjBis[indc].nbele ; j++ )
	{
	  

	  lsoda_(calcodes_, &neq[0], y.donnees, 
		 &lt0,
		 &(GNLCtxInteg.TjBis[indc].donnees[j]),
		 &(GNLCtxInteg.itol), GNLCtxInteg.rtol.donnees,
		 GNLCtxInteg.atol.donnees,  &itask,
		 &istate, &(GNLCtxInteg.iopt),
		 GNLCtxInteg.rwork.donnees, &(GNLCtxInteg.lrw),
		 GNLCtxInteg.iwork.donnees, &(GNLCtxInteg.liw),
		 calcjac_, &(GNLCtxInteg.jt)); 
	  


	  if ( GNLCtxInteg.ImpInteg == VRAI )
	    {
	      fprintf( GNLControle.SortImp,"t = %g   ",GNLCtxInteg.TjBis[indc].donnees[j]);
	      for ( k=0 ; k < GNLCtxInteg.NbEq ; k++)
		{
		  fprintf( GNLControle.SortImp,"%g ",y.donnees[k]);
		}
	      fprintf( GNLControle.SortImp,"\n");
	    }




	  if ( neq[6] != 0 ) 
	    {
	      /* il y a une erreur de calcul dans calcodes_ */ 
	      *le=SEDO;
	      *ie=j+1;
	      return(ERRMATH);
	    }
	  /* on regarde si l'integration s'est bien deroulee */
	  if (istate  < 1 ) 
	    {
	      char scode[3];
	      *ie=j+1;
	      *le=SEDO;
	      sprintf(scode,"%d",istate);
	     /* return(istate); */
	      NLERREUR((ERLSODA,2,"CalcInteg",scode,ERR));
	    }
	  
	  /* on remplit FSedo et DFSedo */
	  
	  /* on pointe sur structure contenant les coordonnees */
	  /* associees a la jieme valeur */
	  ccoo = &(GNLCtxInteg.TjDes[indc][j]);
	  
	  
	  /* On recupere les TjBisNb.donnees[j] coordonnees */
	  
          /* on boucle sur le nbre d'ex-aequos de la jieme valeur */   
	  for ( i=0; i<GNLCtxInteg.TjBisNb[indc].donnees[j]; i++)
	    
	    {
              /* On place les valeurs aux coordonnees stockees */
              /* pour l'element ccoo courant                   */ 
	      for (l=0; l < GNLCtxInteg.NbEq; l++)
		FSedo[(*ccoo).ligne][(*ccoo).col][l]=y.donnees[l]; 
	      
	      for (l= GNLCtxInteg.NbEq; l < neq[0]; l++)
		DFSedo[(*ccoo).ligne][(*ccoo).col][l-GNLCtxInteg.NbEq]=y.donnees[l];
	      
	      /* on passe a l'element suivant dans la liste */
	      ccoo=ccoo->suivant; 
	    }
	  
	}
    }
  
  else
    { 
      /* Cas : X intervient dans les equations ou Tj a une    */
      /* seule  ligne ou une seule colonne                    */       
      
      
      istate=1; 
      
      for ( i = 0 ; i < GNLCtxInteg.Tj[indc].nblig ; i++ )  
	{
          /*------------------------------------------*/
	  /* pour reamorcer lsoda  quand X intervient */

	  lt0=GNLCtxInteg.T0[indc].donnees[i];
	  
	  istate=1; 
	  for (j=0;j < GNLCtxInteg.LongSys ; j++)
	    {
	      y.donnees[j]=condinit[j];
	    }
	  
	  
	  /* Remarques sur les lignes precedentes :             */
          /* Quand les conditions initiales sont connues        */
	  /* il faut mettre les conditions initiales            */
          /* associees a l'observation i                        */
          /* ici on ne traite que le cas : les conditions       */ 
	  /* initiales sont toujours les memes                  */
	  
	  /* En modifiant la ligne : y.donnees[j]=condinit[j]   */
          /* on peut traiter les cas du type les conditions     */
          /* initiales sont differentes pour chaque observation */
          
	  
	  /* Quand les conditions initales sont des parametres  */
          /* a estimer elles ne peuvent pas etre fonction de i  */
          /*----------------------------------------------------*/
	  
	  /* place l'indice courant dans neq pour qu'il puisse etre */
	  /* connu dans calcodes_ */     
	  neq[3]=i;
	  
	  
	  for (j=0; j< GNLCtxInteg.Tj[indc].nbcol ; j++ )
	    {
	      
	      
       	      /* on integre en T[j] */ 
	      
	      
	      lsoda_(calcodes_, &neq[0], y.donnees, 
		     &lt0,
		     &(GNLCtxInteg.Tj[indc].donnees[i][j]),
		     &(GNLCtxInteg.itol), GNLCtxInteg.rtol.donnees,
		     GNLCtxInteg.atol.donnees,  &itask,
		     &istate, &(GNLCtxInteg.iopt),
		     GNLCtxInteg.rwork.donnees, &(GNLCtxInteg.lrw),
		     GNLCtxInteg.iwork.donnees, &(GNLCtxInteg.liw),
		     calcjac_, &(GNLCtxInteg.jt));  

	      	      
	      if ( GNLCtxInteg.ImpInteg == VRAI )
		{
		  fprintf( GNLControle.SortImp,"t = %f   ",GNLCtxInteg.Tj[indc].donnees[i][j]);
		  for ( k=0 ; k < GNLCtxInteg.NbEq ; k++)
		    {
		      fprintf( GNLControle.SortImp,"%f ",y.donnees[k]);
		    }
		  fprintf( GNLControle.SortImp,"\n");
		}
	      
	     

	      if ( neq[6] != 0 ) 
		{
		  /* il y a une erreur de calcul dans calcodes_ */ 
		  *ie=j+1;
		  *le=SEDO;
		  return(ERRMATH);
		} 

	      /* on regarde si l'integration s'est bien deroulee */

	      if (istate < 1) 
		{
		  *ie=j+1;
		  *le=SEDO;
		  return(ERRMATH);
		}
	      
	      /* on remplit FSedo et DFSedo */ 
	      for (l=0; l < GNLCtxInteg.NbEq; l++)
		FSedo[i][j][l]=y.donnees[l]; 
	      for (l= GNLCtxInteg.NbEq; l < neq[0]; l++)
		DFSedo[i][j][l-GNLCtxInteg.NbEq]=y.donnees[l];
	    }
	}
      
    }
  free((char *)y.donnees);
  free((char *)condinit);
  return(OK);
}


