
/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : Message                   |
| Date                 :  7Nov91 / 10:47:31        |
| Derniere mise a jour :                           |
| Concepteur           : PN                        |
| Role                 : Gestion des messages et   |
|   erreurs                                        |
| Le fichier des messages a la structure suivante: |
| - un code numerique sur 4 chiffres max,          |
| - un message court d'au maxi MAXLGBRUT caracteres|
| les endroits ou il faut inserer une valeur etant |
| reperes entre 2 %                                |
| - un $                                           |
| - un message long, eventuellement, d'au maxi     |
| MAXLGBRUT caracteres sans valeurs a remplacer    |
| - un @                                           |
| - des commentaires qui ne commencent pas par du  |
| numerique, aussi longs que l'on veut             |
| Ces commentaires ralentissent la recherche       |
| Les terminer par un @                            |
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* #include <varargs.h>*/
#include <stdarg.h>
#include <ctype.h>

#include "nltypes.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlchoix.h"
#include "nlmacros.h"
#include "nlglobal.h"



/*--------------- VARIABLES EXTERNES -------------*/

extern TCtrole GNLControle;
extern TTrace **GNLTrace;
extern TLongInt GNLNbAppel;
extern TTrace *GNLCourant;

/*--------------- FONCTIONS EXTERNES -------------*/

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/


/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : AffMess                  |
| Role                  : Affichage des messages   |
| Parametres d'entree   :                          |
|   Message: message a imprimer                    |
|   TypeMess: type du message                      |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  aucune                   |
| Fonctions appelantes :                           |
|                        CompMess,                 |
|                        GerErreur,                |
|                        GerWarning                |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

  

TShortInt AffMess(Message, TypeMess)
     TChar Message[]; /* chaine a afficher */
     TShortInt TypeMess; /* type du message */
     
/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  
  switch ( TypeMess ) /* On se branche en fonction du type de message */
    {
    case ERR : /* c'est un message d'erreur fatale */
      /* les tests sur GNLControle.SortWE, sont faits en amont */
      fprintf( GNLControle.SortWE,"%s\n",Message);
      break;
      
    case TRACE : /* demande d'impression de la trace */
     /* elle peut etre demandee par l'utilisateur */
     /* mais pas forcemement en cas d'erreur -> faire le test */
     /* de validite de l'unite de sortie */
      if(GNLControle.SortTrace == NULL)
	{
	  /* Unite de sortie est non valide on sort sur l'unite standard */
	  GNLControle.SortTrace=stdout;
	}
      
      /* on imprime le nombre d'appels effectues */
      fprintf(GNLControle.SortTrace,"Number of calls: %ld\n",GNLNbAppel);
      
      /* on imprime la longueur de trace demandee */
      fprintf(GNLControle.SortTrace,
	      "Requested length of trace: %d\n",GNLControle.LgTrace);
      
      /* on imprime les noms des modules contenu dans la trace */ 
      for(i=0;i< GNLControle.LgTrace; i++)
	{
	  fprintf(GNLControle.SortTrace,"%s ",GNLCourant->Nom);
	  GNLCourant=GNLCourant->Suivant;
	}
      fprintf(GNLControle.SortTrace,"\n");
      break;
      
      /* C'est un warning */
    case WANALY : 
    case WMETHO :
    case WINTEG :
    case WNUMER :
      /* les tests sur GNLControle.SortWE, sont faits en amont */
      fprintf( GNLControle.SortWE,"%s\n",Message);
      break;
      
    case IMP : /* C'est une impression intermediaire */
	  fprintf( GNLControle.SortImp,"%s\n",Message);
      break;
      
    default:
      /* type inconnu on sort le message sur SortWE */
      fprintf( GNLControle.SortWE,"%s\n",Message);
    }
  return(OK);
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : CompMess                 |
| Role                  : Compose les messages     |
| Parametres d'entree   : Code : code du message   |
|                         NbChaines : nombre de    |
|                         chaines                  |
|                         ppchaines : pointeur sur |
|                         les chaines parametres   |
|                         du message               |
|                         TypeMess: Type du message|
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : AffMess, LecMess          |
| Fonctions appelantes : GerMessage                |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/
  
  TShortInt CompMess(Code, NbChaines, ppchaine, TypeMess)
TShortInt Code;
TShortInt NbChaines;
TChar **ppchaine;
TShortInt TypeMess;
/*--------------- Fin identification fonction ----*/

{
  TShortInt i;
  TChar MessBrut[MAXLGMESS];
  TChar Message[MAXLGMESS];
  TChar *buffer;

  /* pointeur sur les fonctions suivantes du module appelees */
  TShortInt LecMess();

  /* on met a blanc MessBrut et Message  */
    strncpy(MessBrut, " ", MAXLGMESS);
    strncpy(Message, " ", MAXLGMESS);

  /* appel pour recuperer le message dans le fichier */
  if ( LecMess(Code, MessBrut) != 0 )
    {
      /* Le message n'a pas ete trouve, seul le nom du module pourra
	 figurer dans le message, donc NbChaines = 1 */
      NbChaines=1;
    }
  
  /* composition du message */
  switch (TypeMess) 
    /* debut du message en fonction du type */
    {
    case ERR :
      sprintf(Message,"\nError %d\n ",Code);
      break;
    case WMETHO :
      sprintf(Message,"\nWarning (methodologic) %d\n ",Code);
      break;
    case WANALY :
      sprintf(Message,"\nWarning (formal analysor) %d\n ",Code);
      break;
    case WNUMER :
      sprintf(Message,"\nWarning (numeric) %d\n ",Code);
      break;
    case WINTEG :
      sprintf(Message,"\nWarning (integration) %d\n ",Code);
      break;
    case IMP :
      sprintf(Message," ");
      break;
    default:
      break;
    }

  /* le % est separateur on met la partie a gauche du premier parametre
     dans le message */
  strcat(Message,strtok(MessBrut,"%"));


  /* Pour les NbChaines parametres on fait la substitution */
  for (i=0; i < NbChaines ; i++)
    {
    if ((int)(strlen(Message) + strlen( *(ppchaine+i))) < (int)MAXLGMESS) 
      {
      strcat(Message, *(ppchaine+i)); 
      }
    else
      {
      fprintf(stdout, 
"CompMess: error NL: message too long \n Message = %s\n ppchaine = %s\n",
            Message, *(ppchaine+i));
      }

    buffer = strtok(NULL,"%");
    buffer = strtok(NULL,"%");
    if ( buffer != NULL )
      {
      if ((int)(strlen(Message) + strlen(buffer)) < MAXLGMESS)
        {
         strcat(Message, buffer);
        }
      else
        {
        fprintf(stdout,
"CompMess: error NL: message too long \n Message = %s\n buffer = %s\n",
            Message, buffer);
        }
      } /* fin  buffer != NULL */
    } /* fin boucle sur i */
  AffMess(Message,TypeMess);
  return(OK);
}
  

/*--------------- Identification fonction ----------
| Nom de la fonction    : GerErreur                |
| Role                  :  Stopper le traitement en|
|                         cas d'erreur fatale      |
| Parametres d'entree   : Code: code d'erreur      |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : AffMess                   |
| Fonctions appelantes : GerWarning, GerMessage    |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/


void GerErreur(Code)
     TShortInt Code;
/*--------------- Fin identification fonction ----*/

{
  /* pointeur sur les fonctions suivantes du module appelees */

  /* Il y a eu une erreur fatale le traitement doit etre stoppe */
  
  if ( GNLControle.SortTrace != NULL ) /* la trace est demandee ? */
    {
      /* on affiche la trace avant de stopper le traitement */
      AffMess("", TRACE);
    }
  /* Quelle est la fin de traitement demandee ? */
  if ( GNLControle.FinTrait == RETURN ) return; /* fin return */
  
  /* fin exit */
  exit(Code);
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : GerMessage               |
| Role                  :  Gerer l'impression des  |
|  messages et l'incrementation des compteurs de   |
|  warnings                                        |
| Parametres d'entree   :                          |
|  La liste d'arguments va_alist de longueur       |
|  variable a la structure suivante:               |
|                         Code : code du message   |
|                         NbChaines : nombre de    |
|                             chaines composant le |
|                             message. NbChaines>0 |
|                         Un nombre variable de    |
|                         chaines de caracteres    |
|                         TypeMess : Type du       |
|                                    message       |
| Retour de la fonction :                          |
|                         OK si impression interme-|
|                         -diaire                  |
|                         OK si compteur de        |
|  warnings non depasse                            |
|                         Code#OK si erreur        |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : CompMess                  |
|                        GerErreur                 |
|                        GerWarning                |
| Fonctions appelantes : les programmes de Nl via  |
|  les macros NLWARNING et NLERREUR                |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt GerMessage(int Code, ...)

/*--------------- Fin identification fonction ----*/

{
  va_list ap;         /* descripteur de la liste variable d'arguments */
  /*  TShortInt Code;            code du message */
  TShortInt NbChaines;      /* nombre de chaines parametres du message */
  TChar **chainerecup; /*  Pour accueillir et stocker les chaines */
  TShortInt TypeMess;       /* type de message */
  TShortInt i;              /* indice */

  /* pointeur sur les fonctions suivantes du module appelees */
  TShortInt GerWarning();

  va_start(ap, Code); /* Pour pointer sur le premier argument */
  
  /* on recupere le premier entier : code du message */
  /*  Code= va_arg(ap, TShortInt);  */

  /* on recupere le second entier : nombre de chaines */

  NbChaines= va_arg(ap, int); 

  /* provisoire pour mise au point du code */
  if (NbChaines < 1 ) 
    {
      printf("error NL, program Messagenls2, NbChaines < 1 \n");
      exit(1);
    }

  
  /* on alloue NbChaines pointeurs de chaines */
  CREER_T2(chainerecup, NbChaines, TChar);  

  /* on fait pointer ces pointeurs sur le pointeur de chaines recus */
  for (i=0 ; i < NbChaines; i++) 
    {
    CREER_T1(chainerecup[i], MAXLGCHP, TChar);

  /* modif AB : 15 juin 93 : a la place de:
    *(chainerecup+i) = va_arg(ap, char *);
     faire ceci pour pouvoir desallouer ensuite: */
    sprintf(*(chainerecup+i),"%s",va_arg(ap, char *));
    }
  
  /* on recupere le dernier entier : type du message  */
  /*  TypeMess = va_arg(ap, TShortInt ); */
  TypeMess = va_arg(ap, int );
  
  /* On gere les actions en fonction du type de message */
  /* Les messages de type TRACE ne passent pas par ce module */

  switch ( TypeMess ) {
    
  case ERR :   /* cas : c'est une erreur */
    /* Appel du module de composition si l'affichage du message est demande */
    if ( GNLControle.SortWE != NULL)
      CompMess(Code,NbChaines,chainerecup, TypeMess);
    
    /* on libere les pointeurs sur les chaines recues */
    for (i=0 ; i < NbChaines; i++)
      {
      DETRU_T1(chainerecup[i], MAXLGCHP, TChar);
      }
    DETRU_T2( chainerecup, NbChaines, TChar);

    GerErreur(Code);                   /* on gere l'erreur */
    va_end(ap);
    return(Code);
    break;
  case WANALY :   /* cas : c'est un warning */
  case WINTEG : 
  case WNUMER:
  case WMETHO :
    /* Appel du module de composition si l'affichage du message est demande */
    if ( GNLControle.SortWE != NULL)
      CompMess(Code, NbChaines,chainerecup, TypeMess);
    
    /* on libere les pointeurs sur les chaines recues */
    for (i=0 ; i < NbChaines; i++)
      {
      DETRU_T1(chainerecup[i], MAXLGCHP, TChar);
      }
    DETRU_T2( chainerecup, NbChaines, TChar);
    va_end(ap);

    return(GerWarning(TypeMess)); /* on gere le warning */
    break;
    
  case IMP :
    /* Appel du module de composition si l'affichage du message est demande */
    if (GNLControle.SortImp != NULL)
      CompMess(Code, NbChaines,chainerecup, TypeMess); 
    
    /* on libere les pointeurs sur les chaines recues */
    for (i=0 ; i < NbChaines; i++)
      {
      DETRU_T1(chainerecup[i], MAXLGCHP, TChar);
      }
    DETRU_T2( chainerecup, NbChaines, TChar);
    va_end(ap);

    return(OK); /* on retourne au module appelant */
    break;
  default: 
    /* pb : type de message inconnu, l'erreur vient du code NL */
    printf("ERROR NL : type of message notknown (TypeMess)\n");
    va_end(ap);
    return(Code);
  }
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : GerWarning               |
| Role                  :  Gerer les messages de   |
|  warnings                                        |
| Parametres d'entree   :                          |
|  TypeMess: type du warning                       |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : AffMess, GerErreur        |
| Fonctions appelantes : GerMessage                |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt GerWarning(TypeMess)
     TShortInt TypeMess;
/*--------------- Fin identification fonction ----*/

     
{
  TChar WarMess[100];
  TShortInt RCode;
  
  switch (TypeMess)
    {
    case WMETHO :
      GNLControle.CWarMet++;
      if ( GNLControle.CWarMet > GNLControle.NbWMethe )
	{
	  /* on depasse le nombre autorise */
	  RCode = ERWM;
	  if (GNLControle.SortWE != NULL) 
	    {
	      /* on affiche un message */
	      sprintf(WarMess,
 "GerWarning %d : The allowed maximum number of methodologic warnings is reached (%d)",
		      ERWM, GNLControle.NbWMethe);
	      AffMess(WarMess,ERR); 
	    }
	  GerErreur(RCode);
	  return(RCode);
	}
      
      break;
    case WANALY :
      GNLControle.CWarAna++;
      if ( GNLControle.CWarAna > GNLControle.NbWAnaly )
	{
	  /* on depasse le nombre autorise */
	  RCode = ERWA;
	  if (GNLControle.SortWE != NULL) 
	    {
	      /* on affiche un message */
	      sprintf(WarMess,
 "GerWarning %d : The allowed maximum number of analysor warnings is reached (%d)",
		      ERWA, GNLControle.NbWAnaly);
	      AffMess(WarMess,ERR); 
	    }
	  GerErreur(RCode);
	  return(RCode);
	}
      break;
    case WNUMER :
      GNLControle.CWarNum++;
      if ( GNLControle.CWarNum > GNLControle.NbWNumer )
	{
	  /* on depasse le nombre autorise */
	  RCode = ERWN;
	  if (GNLControle.SortWE != NULL) 
	    {
	      /* on affiche un message */
	      sprintf(WarMess,
 "GerWarning %d : The allowed maximum number of numerical warnings is reached (%d)",
		      ERWN, GNLControle.NbWNumer);
	      AffMess(WarMess,ERR); 
	    }
	  GerErreur(RCode); /* on gere l'erreur */
	  return(RCode); /* on assure le retour si fin de traitement = RETURN */
	}
      break;
    case WINTEG :
      GNLControle.CWarInt++;
      if ( GNLControle.CWarInt > GNLControle.NbWInteg )
	{
	  /* on depasse le nombre autorise */
	  RCode = ERWI;
	  if (GNLControle.SortWE != NULL) 
	    {
	      /* on affiche un message */
	      sprintf(WarMess,
 "GerWarning %d : The allowed maximum number of integrator warnings is reached (%d)",
		      ERWI, GNLControle.NbWInteg);
	      AffMess(WarMess,ERR); 
	    }
	  GerErreur(RCode); /* on gere l'erreur */
	  return(RCode); /* on assure le retour si fin de traitement = RETURN */
	}
      break; 
    }

  /* on compte le nombre total de warnings */
  GNLControle.CWarTot++;
  if ( GNLControle.CWarTot > GNLControle.NbWTotal ) 
    {
      /* on depasse le nombre total autorise */
      RCode = ERWT; 
      if (GNLControle.SortWE != NULL) 
	{
	  /* on affiche un message */
	  sprintf(WarMess,
 "GerWarning %d : The maximum number allowed for all the warnings is reached (%d)",
	   ERWT,  GNLControle.NbWTotal);
	  AffMess(WarMess,ERR); 
	}
      GerErreur(RCode); /* on gere l'erreur */
      return(RCode); /* on assure le retour si fin de traitement = RETURN */
    }
  /* On ne depasse pas les nombres autorises on peut continuer */
  return(OK);
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : LecMess                  |
| Role                  : rechercher les messages  |
| Parametres d'entree   : Code : code du message   |
| Parametres de sortie  : MessBrut : message non   |
|                         compose                  |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : aucune                    |
| Fonctions appelantes : CompMess                  |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/




TShortInt LecMess(Code, MessBrut)
     TShortInt Code; /* code du message a rechercher */
     TChar MessBrut[]; /* pointeur sur le texte du message */
/*--------------- Fin identification fonction ----*/

{
  FILE *FichMess;     /* declaration du pointeur du fichier de messages */
  TChar c=' ';         /* pour stocher le caractere courant, initialise
			 pour etre different de NULL */
  TChar fin='$';       /* caractere de fin de message */
  /* TChaine tcode="    ";  pour stocker les codes lus dans le fichier 
                        le fait de mettre ="    " alloue la zone
                        mais ne l'initialise pas.
  Modification pour portage linux, le 14 sept 1999: */
  TChaine tcode=(TChar *)calloc(5,sizeof(TChar));
  TShortInt i=0;            /* indice */
  TChar NomFic[MAXLGFIC];

  /* Determiner l'endroit ou est le fichier des messages */
  strcpy(NomFic, "/home/abouvier/MONNLS2/nls2.Rcheck/nls2");
  strcat(NomFic,"/FILEMESS");

  /* Ouverture du fichier contenant les messages */
  FichMess = fopen(NomFic ,"r");
  
  /* Controle si il y a erreur a l'ouverture du fichier */
  if ( FichMess == NULL )
    {
      /* Le message brut est reduit au nom du module et on indique
	 le probleme a l'ouverture de FichMess */
      strcpy(MessBrut,
	     " %MODULE% -- error in the opening of the message file ");
      strcat(MessBrut, NomFic);
      
      return(1); /* 1 indique un anomalie au module CompMess */
    }


  while ( c != EOF )
    {
      
     /* on nettoie la zone qui va contenir les codes lus, */
      strcpy(tcode,"    "); /* ne pas mettre tcode="    "
                         car ceci ne fait rien ! */

      i=0;
      /* recherche du code de message dans le fichier */
      c=getc(FichMess);
      while (isdigit((int)c)) /* tant que les caracteres sont des chiffres 
			    alors c'est un code */
	{
	  tcode[i]=c;
	  i++;
	  c=getc(FichMess);
	}
      if ( Code == atoi(tcode)) /* le code lu est il celui que l'on 
				   cherche ? */
	{
	  /* c'est le code cherche */
	  
	  /* Lecture du message */
	  i=0;
	  while ( (isascii(c)) && (c != fin) )
	    { 
            if (i<MAXLGBRUT)
              { 
              MessBrut[i]=c; /* on recupere la partie courte du message */
              }
	      c=getc(FichMess);
	      i++;
	    }
	  if ( GNLControle.TypeLgMess == LONG ) 
	    {
	      fin ='@'; /* caractere de fin de message long */
	      c=getc(FichMess); /* pour sauter le $ */
	      while ( (isascii(c)) && (c != fin) )
		{ 
                if (i<MAXLGBRUT)
                  {
                  MessBrut[i]=c; /* on recupere le message */
                  }
		  c=getc(FichMess);
		  i++;
		}
	    }
	  fclose(FichMess); /* on ferme le fichier */
	  free ((char *) tcode);

	  return(OK); 
	} /* fin du if CODE */
      
      /* CE N"EST PAS LE CODE CHERCHE */
      
      /* on se place en fin de message */
      while ( (c != '@') && (c != EOF))  c=getc(FichMess); 
      c=getc(FichMess); 
    } /* fin  du while */
  
  /* on passe ici si le message est non trouve */
  sprintf(MessBrut," Messagenls2 -- Message code %d not found in the file %s",Code, NomFic);
  fclose(FichMess); 
  return(1); /* 1 indique un anomalie au module CompMess */
}








