/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : ModSedo                   |
| Date                 : 1992                      |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : P. Neveu                  |
| Role                 : le programme d'appel aux  |
|  fonctions de calcul du modele dans le cas sedo  |
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/

#include "nlchoix.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlglobal.h"
/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
short int calcphi_(short int nbt, short int nbg, short int nbl, short int nbc,
		   double *t, double *g, double **x, double ***Fsedo, 
		   double ***dFsedo, double *f, double **df, 
		   short int *le, short int *ie);
TShortInt CalcInteg(TShortInt nbt,TShortInt nbg,TShortInt nbl,TShortInt nbc,
		    TDouble *theta, TDouble *gamf, TDouble **xobs, 
		    TShortInt indc, TDouble ***FSedo, TDouble ***DFSedo,
		    TShortInt *le ,TShortInt *ie) ;

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

/*--------------- Identification fonction ----------
| Nom de la fonction    : ModSedo                  |
| Role                  : Assure les appels au     |
 programme d'integration et au programme de calcul |
 de f et df.                                       |
| Parametres d'entree   : nbt nbg nbl nbc theta    |
 gamf xobs indc                                    |
| Parametres de sortie  : FSedo DFSedo             |
| Parametres d'e./s.    : le ie                    |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : CalcInteg calcphi_        |
| Fonctions appelantes :                           |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/



TShortInt ModSedo(TShortInt nbt,TShortInt nbg,TShortInt nbl,TShortInt nbc,
		  TDouble *theta, TDouble *gamf,TDouble **xobs,
		  TDouble ***FSedo,TDouble ***DFSedo,
		  TDouble *f, TDouble **df,
		  TShortInt *le,TShortInt *ie,
		  TShortInt indc)
{
TShortInt icoder;

ECRTRACE("ModSedo");

/* on appelle le programme d'integration */
icoder=CalcInteg(nbt,nbg,nbl,nbc,theta,gamf, xobs,indc,FSedo,DFSedo,le,ie);
if ( icoder != OK)  return(icoder);

/* l'integration s'est bien terminee */


/* on appelle calcphi_ programme genere */
/* pour calculer les valeurs de f et df */


APPEL(calcphi_(nbt,nbg,nbl,nbc,theta, gamf, xobs,FSedo, DFSedo, f, df,le,ie));

/* le calcul de f et df s'est bien passe on retourne */

return(OK); 

}
