/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : NLDebut                   |
| Date                 : 30 dec 91                 |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : A. Bouvier                |
| Role                 : Initialiser les entrees   |
|  aux valeurs par defaut, afin que l'utilisateur  |
|  n'ait plus, ensuite,  qu'a changer celles qu'il |
|  veut modifier                                   |
| PAR RAPPORT A LA VERSION NON INTERFACEE AVEC SPLUS
|   identique mais non inclus dans la library      |
|   car au 1ier niveau d'appel des fonctions S     |
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>

#include "nlchoix.h"
#include "nlcodes.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "errcodes.h"
#include "nlglobal.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
/* fonctions des autres modules */
TShortInt CreerMat(),  CreerVect(), 
CreerVectStr(), CreerVectShort();
 
/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

  

/*--------------- Identification fonction ----------
| Nom de la fonction    : NLDebut                  |
| Role                  : Initialiser aux valeurs  |
|  par defaut les entrees                          |
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
|  Donnees: la structure des donnees               |
|  Modele: la structure du modele                  |
|  CtxPuss: le contexte du processus statistique   |
|  CtxNum: le contexte numerique                   |
| Globales en e./s.     :                          |
|  GNLControle: la structure de controle           |
|  GNLCtxInteg: le contexte d'integration          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| CreerMat, CreerVect, CreerVectShort, CreerVectStr|
| Fonctions appelantes : l'utilisateur             |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt NLDebut(TDonnees *Donnees, TModele *Modele, 
		  TCtxPuss *CtxPuss, TCtxNum CtxNum[])

/* ............... Arguments d'entree ............................ 
TDonnees *Donnees;
TModele *Modele;
TCtxPuss *CtxPuss;
TCtxNum CtxNum[];
*/

/*--------------- Fin identification fonction ----*/
{
/* locals */
TShortInt i;

/* initialisation de CtxPuss */
  CtxPuss->Algo = DEFALGO;
  CtxPuss->DirecC = DEFDIRECC;
  CtxPuss->Lambda0 = DEFLAMBDA0;
  CtxPuss->LambdaC1 = DEFLAMBDAC1;
  CtxPuss->LambdaC2 = DEFLAMBDAC2 / DEFLAMBDAC1;
  CtxPuss->MaxCritArret = DEFCRITA;
  CtxPuss->MaxErr = DEFMAXERR;
  CtxPuss->MaxDeb = DEFMAXDEB;
  CtxPuss->MaxLambda = DEFMAXLAMBDA;
  CtxPuss->NbEtapes = DEFNBETAP;
  CtxPuss->OmegaPas = DEFOMEGA;
  CtxPuss->TypeMu = DEFAUT;
  CtxPuss->Famille = DEFFAMILLE;

/* le programme NLVCtxPuss  modifiera TypeSigma selon la valeur de Vari 
   mais pour cela, il faut l'initialiser par une valeur qui ne soit pas
   un code reconnu */
  CtxPuss->TypeSigma = DEFAUT; 
  CtxPuss->Sigma = 1.;
/* le programme NLVCtxPuss mettra MaxIter a la valeur DEFMAXITER* NbParam
  si celle-ci est erronee; donc , on  met une valeur erronee */
  CtxPuss->MaxIter = -1;

  APPEL(CreerVect((TShortInt)0, &(CtxPuss->Beta0)));
  APPEL(CreerVect((TShortInt)0, &(CtxPuss->Theta0)));


/* initialisation de CtxNum */
/* on initialise les MAXETAP premiers elements  */

for (i=0; i<MAXETAP; i++)
  {
  CtxNum[i].Estim= DEFAUT;
  CtxNum[i].TypeCritStat=DEFAUT;
/* on laisse NLVCtxNum determiner la valeur */
  }

/* initialisation de GNLControle */
GNLControle.AVerif.VCrole = VRAI;
GNLControle.AVerif.VCtxInteg = VRAI;
GNLControle.AVerif.VCtxNum = VRAI;
GNLControle.AVerif.VCtxPuss = VRAI;
GNLControle.AVerif.VDon = VRAI;
GNLControle.AVerif.VMod = VRAI;

GNLControle.FinTrait = DEFFINTRAIT;
GNLControle.FreqIp = DEFFREQIP;

GNLControle.LgTrace = DEFLGTRACE;
GNLControle.NbWAnaly = DEFWANALY;
GNLControle.NbWInteg = DEFWINTEG;
GNLControle.NbWMethe = DEFWMETHO;
GNLControle.NbWNumer = DEFWNUMER;
GNLControle.NbWTotal = DEFWTOTAL;

GNLControle.SortImp = DEFSORTIMP;
GNLControle.SortTrace = DEFSORTTRACE;
GNLControle.SortWE = DEFSORTWE;
GNLControle.SortSv = (FILE *)NULL;

GNLControle.TypeLgMess = DEFLGMESS;

GNLControle.Voulu.Ajustes = VRAI;
GNLControle.Voulu.AsVar = FAUX;
GNLControle.Voulu.BVarZBP  = FAUX;
GNLControle.Voulu.Corr  = FAUX;
GNLControle.Voulu.Data  = VRAI;
GNLControle.Voulu.EquN  = VRAI;
GNLControle.Voulu.Estim = VRAI;
GNLControle.Voulu.FctSensib = VRAI;
GNLControle.Voulu.Mu  = FAUX;
GNLControle.Voulu.Residus  = FAUX;
GNLControle.Voulu.ResNum  = VRAI;
GNLControle.Voulu.Sedo  = VRAI;
GNLControle.Voulu.ValW  = FAUX;
GNLControle.Voulu.Z = VRAI;

GNLControle.VouluIp.Ajustes = VRAI;
GNLControle.VouluIp.Sedo = VRAI;
GNLControle.VouluIp.EquN  = FAUX;
GNLControle.VouluIp.Estim  = VRAI;
GNLControle.VouluIp.FctSensib  = FAUX;
GNLControle.VouluIp.NbIter  = VRAI;
GNLControle.VouluIp.ResNum  = VRAI;

/* les sauvegardes des resultats par iterations */
for (i=0; i<MAXETAP; i++)
  GNLControle.EtapeIt[i]=FAUX;
GNLControle.VouluIt.Ajustes = FAUX;
GNLControle.VouluIt.Sedo = FAUX;
GNLControle.VouluIt.EquN  = FAUX;
GNLControle.VouluIt.Estim  = FAUX;
GNLControle.VouluIt.FctSensib  = FAUX;
GNLControle.VouluIt.NbIter  = FAUX;
GNLControle.VouluIt.ResNum  = FAUX;


/* initialisation du contexte d'integration  */
APPEL(CreerVect((TShortInt)1, &(GNLCtxInteg.atol))); /* tolerance absolue */
GNLCtxInteg.atol.donnees[0]=DEFATOL;
APPEL(CreerVect((TShortInt)1, &(GNLCtxInteg.rtol))); /* tolerance relative */
GNLCtxInteg.rtol.donnees[0]=DEFRTOL;
APPEL(CreerVect((TShortInt)0, &(GNLCtxInteg.T0Bis))); /* tableau de travail */
APPEL(CreerVectShort((TShortInt)0, &(GNLCtxInteg.IndicTj))); /* tableau de travail */
GNLCtxInteg.NbThetaSedo=0;
GNLCtxInteg.ImpInteg=FAUX; /* pas d'impression (non disponible) */
GNLCtxInteg.IndicCi=VRAI;  /* Valeurs initiales sont des parametres */
GNLCtxInteg.IndicX=FAUX;   /* Xobs n'intervient pas dans les equations */
GNLCtxInteg.iopt=FAUX;      /* pas d'options de lsoda */
GNLCtxInteg.itol=DEFITOL; /* type de tolerance */
GNLCtxInteg.jt=DEFJT;
GNLCtxInteg.LongSys=0;
GNLCtxInteg.liw=0;
GNLCtxInteg.lrw=0;


/* initialisation des donnees */
APPEL(CreerMat((TShortInt)0, (TShortInt)0, &(Donnees->XObsT)));
APPEL(CreerVect((TShortInt)0, &(Donnees->ValY)));
APPEL(CreerVect((TShortInt)0, &(Donnees->PoidsT)));
APPEL(CreerVectStr((TShortInt)0, &(Donnees->NomCT)));
APPEL(CreerVectStr((TShortInt)0, &(Donnees->NomObsT)));
APPEL(CreerVectStr((TShortInt)0, &(Donnees->NomX)));
Donnees->NomY=DEFY;
Donnees->NbX = 1;
Donnees->NbCourbe = 1;
 Donnees->IndiceN =0;

/* initialisation du modele */
APPEL(CreerVect((TShortInt)0, &(Modele->CTheta0.BInf)));
APPEL(CreerVect((TShortInt)0, &(Modele->CTheta0.BSup)));
APPEL(CreerVect((TShortInt)0, &(Modele->CTheta0.EgalN)));
APPEL(CreerVectShort((TShortInt)0, &(Modele->CTheta0.EgalP)));
Modele->CTheta0.Ctr = FAUX;


APPEL(CreerVect((TShortInt)0, &(Modele->CBeta0.BInf)));
APPEL(CreerVect((TShortInt)0, &(Modele->CBeta0.BSup)));
APPEL(CreerVect((TShortInt)0, &(Modele->CBeta0.EgalN)));
APPEL(CreerVectShort((TShortInt)0, &(Modele->CBeta0.EgalP)));
Modele->CBeta0.Ctr = FAUX;
 
APPEL(CreerVect((TShortInt)0, &(Modele->GamF)));
APPEL(CreerVect((TShortInt)0, &(Modele->GamV)));

APPEL(CreerVectStr((TShortInt)0, &(Modele->NomTheta)));
APPEL(CreerVectStr((TShortInt)0, &(Modele->NomBeta)));
APPEL(CreerVectStr((TShortInt)0, &(Modele->NomGamF)));
APPEL(CreerVectStr((TShortInt)0, &(Modele->NomGamV)));

Modele->Vari = DEFAUT;
Modele->CasSedo =0;

  return(OK);

}
