/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : NLVCtxInteg               |
| Date                 : 1992                      |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : P. Neveu                  |
| Role                 : Module d'initialisation et|
|  de verification du contexte d'integration       |
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
|%c%--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include "nlchoix.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "nlcodes.h"
#include "errcodes.h"
#include "nlglobal.h"

/*--------------- VARIABLES EXTERNES -------------*/


  extern TCtxInteg GNLCtxInteg; 

/*--------------- FONCTIONS EXTERNES -------------*/
TShortInt CreerVect( TShortInt nbele, TVect *pvect);
TShortInt CreerVectLong(TShortInt nbele, TVectLong *pvect);
TShortInt GerMessage( );

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/



/*--------------- Identification fonction ----------
| Nom de la fonction    : RempT0                   |
| Role                  : Remplir GNLCtxInteg.T0   |
| a partir des valeurs de GNLCtxInteg.T0T: T0T est |
| un vecteur de dimension NbObsT; on le transforme |
| en NbCourbe vecteurs de dimension NbObsC         |
| (elimination des valeurs correspondant a des     |
| poids nuls)                                      |
| fonction appelee quand IndicX=1 et T0Egal=0      |
| Parametres d'entree   : T0T, NbRepet, PoidsT     |
| Parametres de sortie  : T0 (alloue avant l'appel)|
| Parametres d'e./s.    :                          |
| Concepteur            : A. Bouvier               |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :  NLVCtxInteg              |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/


TShortInt RempT0(T0T, NbRepet, PoidsT, T0)
  TVect *T0T;
  TVectLong *NbRepet; 
  TVect *PoidsT;
  TVect **T0;

{
  TShortInt i,j, irepet, iobs, icourbe; /* indices */
  TShortInt  NbObsT;
  TDouble Zero;

  ECRTRACE("RempT0");

  Zero= (TDouble)0;
  NbObsT = T0T->nbele;
  icourbe=iobs=i=irepet=0;
  while ( i<NbObsT)
    {
    if (PoidsT->donnees[i] != Zero)
      {
      T0[icourbe]->donnees[iobs] = T0T->donnees[i];
      iobs= iobs+1;
      if (iobs == T0[icourbe]->nbele)
      /* passer a la courbe suivante */
        {
        icourbe = icourbe +1;
        iobs = 0;
        }
      /* sauter les repetitions */
      for (j=0; j<NbRepet->donnees[irepet]; j++)
        {
         i=i+1;
        }
      irepet=irepet+1;
      }
    }
  return(OK);
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : TriTj                    |
| Role                  : Cette fonction est       |
|                         utilisee quand :         |
|             indicX = Faux et Tj.ligne = NbOb     |
| elle trie les valeurs de temps pour integrer la  |
| matrice comme un vecteur.                        |
| Cela  evite de repartir en T0 NbObs fois         |
|                                                  |
| Parametres d'entree   : NbCourbes                |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
|     Pas d'arguments les donnees dont on a        |
|     besoin sont globales                         |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes :  NLVCtxInteg              |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/
void TriTj(NbCourbes) 
     TShortInt NbCourbes;

/*--------------- Fin identification fonction ----*/

{
  TShortInt **Ran; /* entier pour stocker le rang des valeurs */
  TDouble **Val; /* Pour le stockage des valeurs distinctes */
  TShortInt **Nb; /*  Pour le stockage de l'effectif sur chaque valeur */
  Tcoo **coo; /* structure pour stocker les coordonnees et la liste */
  Tcoo *rcoo; /* pointeur pour parcourir les liste de coordonnees */
  TShortInt i,j,k,l,g,h; /* indices */
  TShortInt non; /* Indique si la valeur est nouvelle */
  
  ECRTRACE("TriTj");
  CREER_T2(coo, NbCourbes,Tcoo);
  CREER_T2(Val, NbCourbes,TDouble);
  CREER_T2(Nb, NbCourbes, TShortInt);
  CREER_T2(Ran, NbCourbes, TShortInt);
  
  for (h=0; h < NbCourbes ; h++)
    {
      k=0; /* initialisation de k */
      
      /* allocations de taille 1, ces vecteurs seront realloues en fonction */
      /* du nombre de valeurs distinctes trouvees */
      
      CREER_T1(coo[h],1,Tcoo); 
      
      CREER_T1(Val[h], 1, TDouble);
      
      CREER_T1(Nb[h],1,TShortInt);
      Nb[h][0]=1;
      
      CREER_T1(Ran[h],1,TShortInt);
      
      for (i=0; i<GNLCtxInteg.Tj[h].nblig; i++)
	{
	  for(j=0; j<GNLCtxInteg.Tj[h].nbcol; j++)
	    {
	      /* on stocke chaque valeur */
	      /* comme etant a priori nouvelle */
	      Val[h][k]=GNLCtxInteg.Tj[h].donnees[i][j]; 
	      non=0;                             

	      for (l=0;l <k; l++)
		{
		  if (Val[h][l] == Val[h][k]) /* on regarde si la derniere valeur */ 
		    /* a deja ete rencontree */
		    {             
		      /* cas : elle a ete deja rencontree */
		      
		      Nb[h][l]++; /* incremente le compteur correspondant a */
		      /* cette valeur */
		      
		      non=1; /* indique que la valeur n'est pas nouvelle */
		      
		      rcoo = &coo[h][l]; /* on pointe sur la liste associee */
		      
                /* on va sur le dernier element de la liste */
		      for (g=0; g <Nb[h][l]-2; g++) rcoo=rcoo->suivant;
		      
		      /* on alloue pour stocker le nouvel element */
		      /* de la liste */
		      CREER_T1((*rcoo).suivant ,1,Tcoo);
		      /*		(*rcoo).suivant = (Tcoo *) calloc(1,sizeof(Tcoo)); */
		      
		      /* on pointe sur le nouvel element */
		      rcoo=rcoo->suivant;
		      (*rcoo).ligne=i; /* on ecrit le No de ligne et de colonne */
		      (*rcoo).col=j;
		    }
		}
	      
	      if (non == 0)
	  {
	    /* cas : La valeur est nouvelle */
	    for (l=0;l <k; l++)
	      {
		if (Val[h][l] > Val[h][k]) Ran[h][l]++; /* quand les autres valeurs */
		/* on incremente leur rang  */
		else Ran[h][k]=MAX(Ran[h][k],Ran[h][l]+1); /* quand elles sont plus */
		/* petites on ajuste la     */
		/* valeur du rang  */
	      }
	    /* on stocke les coordonnees de la nouvelle valeur */
	    RECREER_T1(coo[h], (k+1), Tcoo);
	    
	    coo[h][k].ligne=i;
	    coo[h][k].col=j;
	    k++;
	    /* on alloue pour l'element suivant */
	    RECREER_T1(Val[h], (k+1), TDouble);
            
            RECREER_T1(Nb[h], (k+1), TShortInt);
	    Nb[h][k]=1;
	    
	    RECREER_T1(Ran[h], (k+1), TShortInt);
	    Ran[h][k]=0;
	  }
	    }
	}
      
      /* On passe les valeurs dans les structures globales */
      
      GNLCtxInteg.TjBis[h].nbele=k;
      CREER_T1(GNLCtxInteg.TjBis[h].donnees,k,TDouble);
      for (i=0;i<k;i++) GNLCtxInteg.TjBis[h].donnees[Ran[h][i]]=Val[h][i];
      
      /* alloc sur GNLCtxInteg.TjDes */
      CREER_T1(GNLCtxInteg.TjDes[h],k,Tcoo);
      for (i=0;i<k;i++) GNLCtxInteg.TjDes[h][Ran[h][i]]=coo[h][i];
      
      /* alloc sur GNLCtxInteg.TjBisNb[h].donnees */
      GNLCtxInteg.TjBisNb[h].nbele=k;
      CREER_T1(GNLCtxInteg.TjBisNb[h].donnees,k,TShortInt);
      for (i=0;i<k;i++) GNLCtxInteg.TjBisNb[h].donnees[Ran[h][i]]=Nb[h][i];
      
         DETRU_T1(Nb[h],k+1, TShortInt);
	 DETRU_T1(Val[h],k+1,TDouble);
      /*	 DETRU_T1(Ran[h], k+1,TShortInt); */
      /* on ne detruit pas coo, car il contient les elements des listes */
      /* dont on recopie le pointeur  dans TjDes                          */
    }
}

/*--------------- Identification fonction ----------
| Nom de la fonction    : NLVCtxInteg              |
| Role                  : Operer les verifications |
|                         et des initialisations   |
|                         des donnees relatives au |
|                         contexte d'integration   |
|                                                  |
|          Les donnees sont globales dans          |
|          GNLCtxInteg                             |
| Parametres d'entree   : NbCourbe, NbObsC, NbRepet|
|                         XObs, PoidsT             |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   : TriTj, RempT0             |
| Fonctions appelantes : NLVInit                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/

TShortInt NLVCtxInteg(TShortInt NbCourbe, 
		      TVectLong *NbObsC, 
		      TVectLong *NbRepet, 
		      TMat *XObs, TVect *PoidsT)
{
  TShortInt   i,j,k;              /* indices */
  TShortInt   longatol, longrtol; /* longueur des vecteurs des tolerances */
  TShortInt   anclong;            /* pour le stockage du cumul des nb obs */
                                  /* des courbes precedentes */
  TChar Mess[5];

  ECRTRACE("NLVCtxInteg");

  anclong=0;
  /* on verifie le nombre d'equations donne par l'utilisateur */
  /* on se donne une limite superieure fictive */

  if (GNLCtxInteg.NbEq < 1 || GNLCtxInteg.NbEq > BSUPFICT )
    NLERREUR((ERNBEQUA,1,"NLVCtxInteg",ERR));

  /* On cree T0 a partir de T0T */
      /* allocation de T0 */
  GNLCtxInteg.T0= ( TVect *) calloc( NbCourbe, sizeof( TVect));
  for (i=0; i < NbCourbe; i++)
    {
      if ( GNLCtxInteg.IndicX == 1)
	{
	  GNLCtxInteg.T0[i].donnees=(TDouble *) calloc( NbObsC->donnees[i], sizeof( TDouble));
	  GNLCtxInteg.T0[i].nbele=NbObsC->donnees[i];
	}
      else
	{
	  GNLCtxInteg.T0[i].donnees=(TDouble *) calloc( 1, sizeof(TDouble)); 
	  GNLCtxInteg.T0[i].nbele=1;
	  
	}
    }
       /* remplissage de T0 */
  if (GNLCtxInteg.T0Egal == 1)
    {
    for (i=0; i<NbCourbe; i++)
      {
      for (j=0; j<GNLCtxInteg.T0[i].nbele; j++)
        {
        GNLCtxInteg.T0[i].donnees[j]=GNLCtxInteg.T0T.donnees[0];
        }
      }
    }
  else
    { /* cas ou T0Egal =0 */
    if (GNLCtxInteg.IndicX == 0)
      {
      /* on recopie les valeurs de T0T */
      for (i=0; i<NbCourbe; i++)
        {
        GNLCtxInteg.T0[i].donnees[0]= GNLCtxInteg.T0T.donnees[i];
        }
      }
    else
      {
      /* cas ou T0Egal =0 et IndicX=1 */
      /* mettre les NbObsT valeurs de T0T dans T0 en eliminant les poids nuls */
      RempT0(&(GNLCtxInteg.T0T), NbRepet, PoidsT,&(GNLCtxInteg.T0));
      }
    }


  /* on verifie si la matrice Tj est cree a partir de XObs et si les */
  /* valeurs fournies sont coherentes */
  
  /* si  GNLCtxInteg.IndicTj.nbele > 0 alors Tj doit etre */
  /* rempli a partir de XObs */
 

  if ( GNLCtxInteg.IndicTj.nbele > 0 )
    {
      /* on alloue Tj */
      /* GNLCtxInteg.Tj a 3 dimensions */
      /* la premiere dimension correspond au nombre de courbes */
      /* on a une matrice de temps par courbe */
      CREER_T1(GNLCtxInteg.Tj, NbObsC->nbele,TMat);

      /* controle des valeurs de IndicTj */
      for (i=0; i< GNLCtxInteg.IndicTj.nbele;i++)
	{
          /* les valeurs de IndicTj doivent etre superieures a 0 */
          /* et inferieure ou egale au nombre de colonnes de XObs */
	  
	  if ((GNLCtxInteg.IndicTj.donnees[i] < 1) ||
	      (GNLCtxInteg.IndicTj.donnees[i] >  XObs->nbcol))
	    NLERREUR((ERINITJ,1,"NLVCtxInteg",ERR));
	}  
      
    
      for ( i=0;i <  NbObsC->nbele; i++)
	{
	  /*         creation des matrices de temps.             */
	  /* GNLCtxInteg.IndicTj.nbele est le nombre de vecteurs */ 
          /* participant a la matrice des temps                  */
	  GNLCtxInteg.Tj[i].nbcol=GNLCtxInteg.IndicTj.nbele;
	  
          /*  le nombre de lignes de chaque matrice est le nombre d'observations */
          /* par courbe */
	  GNLCtxInteg.Tj[i].nblig= NbObsC->donnees[i];
	  
	  CREER_T2(GNLCtxInteg.Tj[i].donnees,
		   GNLCtxInteg.Tj[i].nblig,
		   TDouble);
	
	  for (j=0;j <  GNLCtxInteg.Tj[i].nblig; j++)
	    {
	      CREER_T1(GNLCtxInteg.Tj[i].donnees[j],
		       GNLCtxInteg.Tj[i].nbcol,
		       TDouble);
	      for (k=0; k <   GNLCtxInteg.Tj[i].nbcol ; k++)
		{
		  /* pour chacune des matrices de temps associee aux differentes courbes */
		  /* on entre les valeurs issues des vecteurs XObs */
		  GNLCtxInteg.Tj[i].donnees[j][k]=
		   XObs->donnees[(j+anclong)][(GNLCtxInteg.IndicTj.donnees[k]-1)];
		}
	    }
	  anclong=NbObsC->donnees[i]+anclong;
	}
    }
  

  /* Verifications des indicateurs logiques */
  
  if (GNLCtxInteg.IndicX != VRAI && GNLCtxInteg.IndicX != FAUX )
    NLERREUR((ERINDLO,1,"NLVCtxInteg",ERR));
  if (GNLCtxInteg.ImpInteg != VRAI && GNLCtxInteg.ImpInteg != FAUX )
    {
      GNLCtxInteg.ImpInteg=FAUX;
      strcpy(Mess,"FAUX");
      NLWARNING((WAINDLO,2,"NLVCtxInteg",Mess, WMETHO));
    }
  
  /* Nature des conditions initiales : parametres ou pas */
  /* on calcule la longueur du systeme complet */
  switch (  GNLCtxInteg.IndicCi )
    {
    case FAUX :
      GNLCtxInteg.LongSys=GNLCtxInteg.NbEq*(GNLCtxInteg.NbThetaSedo+1);
      /* Le vecteur de conditions initiales VectCi doit etre de longueur */
      /*  GNLCtxInteg.NbEq pour toutes les courbes */
      for (i=0 ; i < NbObsC->nbele ; i++)
	{
	  if (GNLCtxInteg.VectCi[i].nbele != GNLCtxInteg.NbEq)
	    NLERREUR((ERLCI,1,"NLVCtxInteg",ERR));
	}
      break;
    case VRAI :
      GNLCtxInteg.LongSys= GNLCtxInteg.NbEq*(1+GNLCtxInteg.NbThetaSedo+GNLCtxInteg.NbEq); 
      break;
    default:
      NLERREUR((ERINDLO,1,"NLVCtxInteg",ERR));
    }
  
  
  /* le nombre de parametres dans le systeme doit etre positif ou nul */
  if (GNLCtxInteg.NbThetaSedo < 0 ) 
    NLERREUR((ERNBTHET,1,"NLVCtxInteg",ERR));
  if (GNLCtxInteg.NbThetaSedo == 0 ) 
    {
      /* si le nombre de parametres dans le systeme est nul alors */
      /* les conditions initiales doivent etre des parametres */
      if (GNLCtxInteg.IndicCi != VRAI )
	NLERREUR((ERTYPCI,1,"NLVCtxInteg",ERR)); 
      /* bien preciser NbthetaSedo=0 dans le message d'erreur */
    }
  
  
  /* verification des tolerances */
  /* Suivant la valeur de itol = {1,2,3,4} les longueurs de atol et rtol */
  /* sont soit egales 1 ou au nombre d'equations du systeme complet */
  
  switch (GNLCtxInteg.itol)
    { 
    case 1 :
      longatol=1;
      longrtol=1;
      break;
    case 2 :
      longatol=GNLCtxInteg.LongSys; 
      longrtol=1; 
      break;
    case 3:
      longatol=1;
      longrtol=GNLCtxInteg.LongSys;
      break;
    case 4 :
      longatol=GNLCtxInteg.LongSys;
      longrtol=GNLCtxInteg.LongSys;
      break;
    default:
      /* NLWARNING */
      GNLCtxInteg.itol =1;
      strcpy(Mess,"1");
      NLWARNING((WARITOL,2,"NLVCtxInteg",Mess,WMETHO));
      longatol=1;
      longrtol=1;
    }
  /* verification de la tolerance absolue atol est un vecteur */
  for ( i=0; i < longatol; i++)
    {
      if (GNLCtxInteg.atol.donnees[i] <= 0.0)
	{
	  GNLCtxInteg.atol.donnees[i]=DEFATOL;
	  /* NLWARNING(WMETHO) */
          sprintf(Mess, "%f", GNLCtxInteg.atol.donnees[i]);
	  NLWARNING((WARATOL,2, "NLVCtxInteg",Mess,WMETHO));
	}
    }
  /* verification de la tolerance relative rtol est un vecteur */
  for ( i=0; i < longrtol; i++)
    {
      if (GNLCtxInteg.rtol.donnees[i] <= 0.0)
	{
	  GNLCtxInteg.rtol.donnees[i]=DEFRTOL;
	  /* NLWARNING(WMETHO) */
          sprintf(Mess, "%f", GNLCtxInteg.rtol.donnees[i]);
	  NLWARNING((WARRTOL,2,"NLVCtxInteg",Mess, WMETHO));
	}
    }
  
  
  /* calcul des longueurs lrw et liw des tableaux de travail rwork et iwork */
  /* le contenu de iwork et rwork peut etre utilise pour des entrees        */
  /* sorties avec lsoda                                                     */

  GNLCtxInteg.liw=(int)(20 + GNLCtxInteg.LongSys);
  GNLCtxInteg.lrw=(int)(22 + GNLCtxInteg.LongSys * MAX(16, (GNLCtxInteg.LongSys+9)));
  
  /* Allocations des tableaux de travail rwork et iwork */
  APPEL(CreerVectLong((TShortInt)GNLCtxInteg.liw, &(GNLCtxInteg.iwork)));
  APPEL(CreerVect((TShortInt)GNLCtxInteg.lrw, &(GNLCtxInteg.rwork)));
  /*
  CREER_T1( GNLCtxInteg.iwork.donnees,GNLCtxInteg.liw, TLongInt );
  CREER_T1(GNLCtxInteg.rwork.donnees, GNLCtxInteg.lrw,TDouble );
  */
  
  if ( GNLCtxInteg.jt < 0 || GNLCtxInteg.jt> 6 )
    {
      /*  NLWARNING() */
      GNLCtxInteg.jt=1; /* ou defJT */
      sprintf(Mess,"%d", GNLCtxInteg.jt);
      NLWARNING((WARJT,2,"NLVCtxInteg",Mess, WMETHO));
    }
  
  if ( GNLCtxInteg.iopt <0 || GNLCtxInteg.iopt > 1 )
    {
      /* NLWARNING() */
      GNLCtxInteg.iopt=0; 
      sprintf(Mess,"%d", GNLCtxInteg.iopt);
      NLWARNING((WARIOPT,2,"NLVCtxInteg",Mess,WMETHO));
      /* DEFIOPT */
    }

  /* si les XObs n'interviennent pas il n'est pas neccessaire d'integrer une matrice */
  /* on fait le controle sur GNLCtxInteg.Tj[0].nbcol puisque cette valeur est */
  /* constante quelque soit la courbe */

  if ( GNLCtxInteg.IndicX == FAUX &&  GNLCtxInteg.Tj[0].nblig >1)
    {
      /* on alloue les vecteurs TjBis associes a chaque courbe */
      CREER_T1(GNLCtxInteg.TjBis,NbObsC->nbele,TVect);

      /* on alloue les vecteurs TjBisNb associes a chaque courbe */
      CREER_T1(GNLCtxInteg.TjBisNb, NbObsC->nbele ,TVectShort);

      /* on alloue les vecteurs de structure Tcoo  TjDes associes a chaque courbe */
      CREER_T2(GNLCtxInteg.TjDes, NbObsC->nbele,Tcoo);

      /* on apelle TriTj */
      TriTj(NbObsC->nbele);


      /* on alloue T0Bis et TjBisNb!!!*/

      GNLCtxInteg.T0Bis.nbele=NbObsC->nbele;
      
 

      CREER_T1( GNLCtxInteg.T0Bis.donnees,GNLCtxInteg.T0Bis.nbele,TDouble);
   
      

      /* Attention a faire pour chaque indice de courbe !!!! */

      for (j=0; j < NbObsC->nbele; j++)
	{
	  GNLCtxInteg.T0Bis.donnees[j]=GNLCtxInteg.T0[j].donnees[0];
	  
     	  /* X n'intervient pas -> un seul T0 par courbe */ 
	}
    }

  /* Remplissage de iwork et rwork si il y a des options: */

  if ( GNLCtxInteg.iopt == 1)
    {
      for (i=0; i < 9 ; i++ )
        GNLCtxInteg.iwork.donnees[i]=GNLCtxInteg.proiwork[i];
      for (i=0; i < 7 ; i++ )
        GNLCtxInteg.rwork.donnees[i]=GNLCtxInteg.prorwork[i];
    }

  return(OK);
}
