/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : NLVInit                   |
| Date                 : 1991                      |
| Derniere mise a jour : %e%     / %u%             |
| Concepteur           : A. Bouvier                |
| Role                 : Verifier et initialiser   |
|  les entrees                                     |
| Reference conception :                           |
| Lecteur              :  A. Bouvier               |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>
#include <float.h>

#include "nlchoix.h"
#include "nlcodes.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "errcodes.h"
#include "nlglobal.h"

/*--------------- VARIABLES EXTERNES -------------*/

/*--------------- FONCTIONS EXTERNES -------------*/
/* fonctions des autres modules */
TShortInt NLVCrole(), NLVCtxInteg(),
 NLVCtxNum(), NLVCtxPuss(),
NLVDon(), NLVDonM(), NLVMod(), 
GerMessage();



/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/

  

/*--------------- Identification fonction ----------
| Nom de la fonction    : VerifContBeta            |
| Role                  : Verifier que si Vari     |
|  depend des Theta et Beta (dans ce cas, on a deja|
|  verifie qu'il y a des Beta), avec un estimateur |
|  qui ne depend que des Theta, il y a des         |
|  contraintes d'egalite numerique sur tous les    |
|  Beta si NbEtapes =1                             |
| Parametres d'entree   :                          |
|  Vari: mode de la variance                       |
|  NbEtapes: nombre d'etapes                       |
|  Estim: l'estimateur                             |
|  EgalN: vecteur des contraintes d'egalite        |
|    numerique sur les parametres Beta             |
| Parametres de sortie  :                          |
|  Code : OK ou code de warning                    | 
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
| Fonctions appelantes : NLVInit                   |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt VerifContBeta(Vari, NbEtapes, Estim, EgalN,  Code)
/* ............... Arguments d'entree ............................ */
TShortInt Vari, NbEtapes, Estim;
TVect *EgalN;

/* argu de sortie */
TShortInt *Code;

/*--------------- Fin identification fonction ----*/

{
/* locals */
TShortInt i, nbele;

/* Ecriture de la trace */
ECRTRACE("VerifContBeta");

*Code = OK;

if ( (NbEtapes == 1) && 
     ( (Vari == VTB) || (Vari == VSTB)) &&
     ( (Estim == MVT) || 
       (Estim == MCPT) ||
       (Estim == MCOT) || 
       (Estim == MCMT) ||
       (Estim == QVT) ||
       (Estim == MCPVIT))
   )
  {
  nbele = EgalN->nbele;

  if (nbele == 0)
     {
     *Code = WARCONTB;
     }
  else
    {
    i=0;
    while ( (i< nbele) && (!myisnan(EgalN->donnees[i])))
      {
      i=i+1;
      }
    if ( i != nbele)
      {
      *Code = WARCONTB;
      }
    } /* fin du else */
  } /* fin du cas ou il faut verifier */

if (*Code != OK)
  {
  /* Actions effectuees par la macro NLWARNING :
   fprintf(stderr,
" Quand la variance depend des Theta et des Beta et que l'estimateur n'est fonction que\
des Theta, il faut fixer tous les Beta ou proceder par etapes\n");
  fprintf(stderr," On continue les verifications possibles, puis on s'arretera en erreur\n");
    */
  NLWARNING((WARCONTB, 1,"VerifContBeta", WMETHO)) ;
  }

return(OK);
}


/*--------------- Identification fonction ----------
| Nom de la fonction    : NLVInit                  |
| Role                  : Initialiser et verifier  |
|  les entrees                                     |
| Parametres d'entree   :                          |
| Parametres d'e./s.    :                          |
|  Donnees: la structure des donnees               |
|  Modele: la structure du modele                  |
|  CtxPuss: le contexte du processus statistique   |
|  CtxNum: le contexte numerique                   |
| Globales en e./s.     :                          |
|  GNLControle: la structure de controle           |
|  GNLCtxInteg: le contexte d'integration          |
| Parametres de sortie  :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :                           |
|  NLVCrole                                        |
|  NLVCtxInteg                                     |
|  NLVCtxNum                                       |
|  NLVCtxPuss                                      |
|  NLVDon                                          |
|  NLVDonM                                         |
|  NLVMod                                          |
|  VerifContBeta                                   |
| Fonctions appelantes : NL                        |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

TShortInt NLVInit(TDonnees *Donnees, TModele *Modele, 
		  TCtxPuss *CtxPuss, TCtxNum CtxNum[])

/* ............... Arguments d'entree-sortie...................... 
TDonnees *Donnees;
TModele *Modele;
TCtxPuss *CtxPuss;
TCtxNum CtxNum[];
*/

/*--------------- Fin identification fonction ----*/
{

/* locals */
TShortInt NbTheta, NbBeta,  NbThetaEs, NbBetaEs;
TShortInt CodeDon, CodeMod, CodeCrole, CodeVDonM, CodeVPuss, CodeNum, CodeContBeta;


/* Ecriture de la trace */
ECRTRACE("NLVInit");

/* initialisation des codes arguments d sortie des fonctions appelees */
CodeCrole =OK;
CodeMod =OK;
CodeDon =OK;
CodeVDonM = OK;
CodeVPuss = OK;
CodeNum = OK;
CodeContBeta = OK;

/* initialisation des nombre de parametres */
NbTheta = Modele->NomTheta.nbele;
NbBeta = Modele->NomBeta.nbele;


/* appel des programmes de verification-initialisation */

if(GNLControle.AVerif.VCrole == VRAI)
  {
  /* LE CONTROLE */
  APPEL(NLVCrole(Modele->CasSedo, &CodeCrole));
    /* une erreur dans NLVCrole ne gene pas la suite des verifications:
    on ne provoque pas une erreur */
  }
  
if(GNLControle.AVerif.VDon == VRAI)
  {
  /* LES DONNEES */
  APPEL(NLVDon(Donnees, &CodeDon));
    /* une erreur dans NLVDon ne gene pas la suite des verifications:
    on ne provoque pas une erreur */
  }

NbThetaEs = NbTheta * Donnees->NbCourbe;
NbBetaEs = NbBeta * Donnees->NbCourbe;

if(GNLControle.AVerif.VMod == VRAI)
  {
  /* LE MODELE */
  APPEL(NLVMod(Donnees->NbCourbe, &(Donnees->Poids), &(CtxPuss->Theta0),  &(CtxPuss->Beta0),
               Modele, &CodeMod));
  }

if ((CodeDon ==OK) && (CodeMod == OK))
  {
  if ((GNLControle.AVerif.VDon  == VRAI) || (GNLControle.AVerif.VMod == VRAI))
    {
    /* LA CONCORDANCE ENTRE DONNEES ET MODELE */
    APPEL(NLVDonM(NbTheta, NbBeta, &(Donnees->NbObsC), &CodeVDonM));
    }
  }

if ((GNLControle.AVerif.VCtxPuss == VRAI) &&
    (CodeDon == OK) && (CodeMod== OK) )
  {
  /* CTXPUSS */
  APPEL(NLVCtxPuss(Modele->Vari, NbThetaEs, NbBetaEs, &(Donnees->NbRepet), &(Donnees->StatDon.S2),
                       CtxPuss, &CodeVPuss));
  }


/* LA CONCORDANCE ENTRE DONNEES ET FAMILLE */
 if ((CodeDon == OK) && ( CodeVPuss==OK)) {
   if  ( (CtxPuss->Famille != GAUSS) &&
	 (CtxPuss->Famille != BERNOULLI) &&
	 (CtxPuss->Famille != POISSON)) {
/* Il faut son indice parmi les var. explicatives */
     if (Donnees->IndiceN <=0) {
         NLWARNING((WARVPUSS19, 1,"NLVInit", WMETHO)) ;
	 CodeVPuss=WARVPUSS19;
     } /* fin (Donnees->IndiceN <=0) */
   } /* fin strcmp(CtxPuss->Famille) */
 } /* fin CONCORDANCE ENTRE DONNEES ET FAMILLE */

   
if ((GNLControle.AVerif.VCtxNum  == VRAI) &&
    (CodeMod == OK) && (CodeDon == OK) && (CodeVPuss == OK))
  {
  /* CTXNUM */
  APPEL(NLVCtxNum(CtxPuss->Algo, CtxPuss->TypeSigma, CtxPuss->TypeMu, Modele->Vari,&(Donnees->NbRepet),
                      &(CtxPuss->NbEtapes), CtxNum, &CodeNum));
  }


if((GNLControle.AVerif.VCtxInteg  == VRAI) && (Modele->CasSedo == VRAI))
  {
  /* CTXINTEG */
  APPEL(NLVCtxInteg(Donnees->NbCourbe,  &(Donnees->NbObsC),
                    &(Donnees->NbRepet),  &(Donnees->XObs),
                    &(Donnees->PoidsT)));
  }

/* Verifier qu'il y a des contraintes sur Beta quand NbEtapes=1 et que Estim ne depend que
   des Theta, et que Vari depend des Theta et des Beta */
   APPEL(VerifContBeta(Modele->Vari, CtxPuss->NbEtapes, CtxNum[0].Estim,
                      &(Modele->CBeta0.EgalN), &CodeContBeta));

/* provoquer une erreur si les programmes appeles en ont detecte */
if ( (CodeDon != OK) || (CodeMod != OK) || (CodeCrole != OK) || 
     (CodeVDonM != OK) || (CodeVPuss != OK) || (CodeNum !=OK) || (CodeContBeta != OK))
  {
  /* actions effectuees par la macro:
  printf("Arret du programme : NLVInit a detecte des erreurs dans les entrees\n");
  return(ERRVINIT);
  */
  NLERREUR((ERRVINIT,1,"NLVInit", ERR));  
  }
else
  {
  return(OK);
  }
}
