/*--------------- COPYRIGHT ------------------------
| INRA - Laboratoire de Biometrie de Jouy en Josas |
--------------------------------------------------*/

/*--------------- IDENTIFICATION PRODUIT -----------
| Produit              : NLVTrace                  |
| Date                 : 1991                      |
| Derniere mise a jour :                           |
| Concepteur           : Pascal Neveu              |
| Role                 : Verification et           |
|                        initialisation de la trace|
| Reference conception :                           |
| Lecteur              :                           |
--------------------------------------------------*/

/*--------------- HISTORIQUE -----------------------
--------------------------------------------------*/

/*--------------- INCLUDES -----------------------*/
#include <stdio.h>

#include "nlchoix.h"
#include "nltypes.h"
#include "nlmacros.h"
#include "nlcodes.h"
#include "errcodes.h"

/*--------------- VARIABLES EXTERNES -------------*/

extern TCtrole GNLControle;

extern TTrace **GNLTrace; /* Contient les pointeurs */
/*                      du systeme de chainage    */
/*                                                */
extern TTrace *GNLCourant; /* composant dans      */
/*                          lequel on ecrit       */
extern TLongInt GNLNbAppel; /* compte le          */
/*                             nombre d'appels    */





/*--------------- FONCTIONS EXTERNES -------------*/
TShortInt GerMessage( );
/* NLERREUR, NLWARNING                            */

/*--------------- CONSTANTES ---------------------*/

/*--------------- MACROS -------------------------*/

/*--------------- VARIABLES STATIQUES ------------*/

/*--------------- TYPES --------------------------*/

/*--------------- FIN IDENTIFICATION PRODUIT -----*/


/*--------------- Identification fonction ----------
| Nom de la fonction    : NLVTrace                 |
| Role                  :                          |
| Parametres d'entree   :                          |
| Parametres de sortie  :                          |
| Parametres d'e./s.    :                          |
| Reference conception  :                          |
--------------------------------------------------*/

/*--------------- Appels croises -------------------
| Fonctions appelees   :  NLWARNING, NLERREUR      |
| Fonctions appelantes :                           |
--------------------------------------------------*/

/*--------------- Definition fonction ------------*/

/*--------------- Fin identification fonction ----*/


TShortInt NLVTrace()

{
  TShortInt i; /* indice */

  GNLNbAppel=0; /* initialisation du compteur d'appels */

  /* verification de la longueur de  trace demandee */

  if ((GNLControle.LgTrace < 2) || (GNLControle.LgTrace > MAXLGTRACE )) 
    {
      /* on previent l'utilisateur que la longueur
	 de la trace demandee est incorrecte       */
      NLWARNING((WALGTRACE,1,"NLVTrace",WMETHO));
      /* on force la longueur a la longueur definie
	 par defaut                                */
      GNLControle.LgTrace=DEFLGTRACE;
    }

  /* allocation de la memoire pour les pointeurs de la liste */
  
  CREER_T2(GNLTrace , GNLControle.LgTrace, TTrace);

  /* verification de l'allocation */

  if ( GNLTrace == NULL) NLERREUR((EPBALLOC,1,"NLVTrace",ERR));
						 
  /*  allocation de la memoire pour chaque element de la liste */

  for (i=0; i< GNLControle.LgTrace ; i++)
    {
      CREER_T1(GNLTrace[i], 1, TTrace);
      /* verification de l'allocation */
      if ( GNLTrace[i] == NULL) NLERREUR((EPBALLOC,1,"NLVTrace",ERR));
    }
  /* mise en place du chainage */

  for (i=0; i< (GNLControle.LgTrace - 1) ; i++)
    {
      GNLTrace[i]->Suivant = GNLTrace[i+1];
    }
  /* mise en place de la boucle : le dernier pointe sur le premier */

  GNLTrace[GNLControle.LgTrace -1]->Suivant = GNLTrace[0];

  /* initialisation de l'element courant sur le premier */

  GNLCourant = GNLTrace[0];

  return(OK);
}
