/* ------------------------------------------------------- */
/* Programme d'interface entre C et un programme de calcul 
   du modele ecrit en Fortran:
   Conversion des arguments de type TShortInt en type int
 -------------------------------------------------------- */

#include "nlcodes.h"
#include "nltypes.h"
#include "errcodes.h"

/*----------------FONCTIONS EXTERNES ------------*/
/* declaration des sp fortran */
int mycalcf_(int *nbt, int *nbg, int *nbl, 
		 int *nbc, 
		 double *t, double *g, double *x, 
		 double *f, double *df, 
		 int *le, int *ie);


int mycalcv_(int *nbt, int *nbb, int *nbg, int *nbl, 
		 int *nbc, 
		 double *t, double *b, double *g,
		 double *f, double *df, double *x, double *v, 
		 double *dtv, double *dbv, int *le, int *ie);

int mycalcphi_(int *nbt, int *nbg, int *nbl, int *nbc,
		   double *t, double *g, double *x, double *Fsedo, 
		   double *dFsedo, double *f, double *df, 
		   int *le, int *ie);

int mycalcodes_(int *neq, double *t, double *y, double *ydot);

/* ----------------------------------------------------------------------
             Fonction calcf_
 ----------------------------------------------------------------------- */
      TShortInt calcf_ (nbtheta,nbgamma,nbobs,nbvar,
                        theta,gamma,x,fmod,dfmod,le,ie)
/* ................. Arguments d'entree ................................... */
 TShortInt nbtheta, nbgamma, nbobs, nbvar;
 TDouble *theta, *gamma, **x;
/* ................. Arguments de sortie ................................. */
 TDouble *fmod, **dfmod;
 TShortInt *le, *ie;

{
TShortInt Code;
int nbthetaf, nbgammaf, nbobsf, nbvarf, lef, ief;
int Codee;
  /* Conversion des arguments d'entree */
  nbthetaf = (int)nbtheta;
  nbgammaf = (int)nbgamma;
  nbobsf = (int)nbobs;
  nbvarf = (int)nbvar;

  /* Appel du programme Fortran */
  Codee = mycalcf_( &nbthetaf, &nbgammaf, &nbobsf, &nbvarf,
                     theta ,gamma, &(x[0][0]),fmod,
                     &(dfmod[0][0]),&lef,&ief); 
  /* Conversion des arguments de sortie et du retour de la 
     fonction */
  *le =(TShortInt)lef;
  *ie = (TShortInt)ief;
  Code = (TShortInt)Codee;
  return(Code);
}

/* ----------------------------------------------------------------------
             Fonction calcv_
 ----------------------------------------------------------------------- */
      TShortInt calcv_ (nbtheta,nbbeta,nbgamma,nbobs,nbvar,
                        theta,beta,gamma,fmod,dfmod,x,
                        vmod, dvmodt, dvmodb,le,ie)
/* ................. Arguments d'entree ................................... */
 TShortInt nbtheta, nbbeta, nbgamma, nbobs, nbvar;
 TDouble *theta, *beta, *gamma, *fmod, **dfmod, **x;
/* ................. Arguments de sortie ................................. */
 TDouble *vmod, **dvmodt, **dvmodb;
 TShortInt *le, *ie;

{
TShortInt Code;
int nbthetaf, nbbetaf, nbgammaf, nbobsf, nbvarf, lef, ief;
int Codee;
  /* Conversion des arguments d'entree */
  nbthetaf = (int)nbtheta;
  nbbetaf = (int)nbbeta;
  nbgammaf = (int)nbgamma;
  nbobsf = (int)nbobs;
  nbvarf = (int)nbvar;
  /* Appel du programme Fortran */
  Codee = mycalcv_( &nbthetaf, &nbbetaf, &nbgammaf, &nbobsf, &nbvarf,
                     theta , beta, gamma,fmod, &(dfmod[0][0]), &(x[0][0]),
                     vmod, &(dvmodt[0][0]), &(dvmodb[0][0]),&lef,&ief);
  /* Conversion des arguments de sortie et du retour de la 
     fonction */
  *le =(TShortInt)lef;
  *ie = (TShortInt)ief;
  Code = (TShortInt)Codee;
  return(Code);
}


/* ----------------------------------------------------------------------
             Fonction calcphi_
 ----------------------------------------------------------------------- */

      TShortInt calcphi_ (nbtheta,nbgamma,nbobs,nbvar,
                        theta,gamma,x,fsedo,dfsedo,fmod,dfmod,le,ie)
/* ................. Arguments d'entree ................................... */
 TShortInt nbtheta, nbgamma, nbobs, nbvar;
 TDouble *theta, *gamma, **x, ***fsedo, ***dfsedo;
/* ................. Arguments de sortie ................................. */
 TDouble *fmod, **dfmod;
 TShortInt *le, *ie;

{
TShortInt Code;
int nbthetaf, nbgammaf, nbobsf, nbvarf, lef, ief;
int Codee;
  /* Conversion des arguments d'entree */
  nbthetaf = (int)nbtheta;
  nbgammaf = (int)nbgamma;
  nbobsf = (int)nbobs;
  nbvarf = (int)nbvar;

  /* Appel du programme Fortran */
  Codee = mycalcphi_( &nbthetaf, &nbgammaf, &nbobsf, &nbvarf,
                     theta ,gamma, &(x[0][0]),
                     &(fsedo[0][0][0]), &(dfsedo[0][0][0]),
                     fmod, &(dfmod[0][0]),
                     &lef,&ief); 
  /* Conversion des arguments de sortie et du retour de la 
     fonction */
  *le =(TShortInt)lef;
  *ie = (TShortInt)ief;
  Code = (TShortInt)Codee;
  return(Code);
}




/* ----------------------------------------------------------------------
             Fonction calcodes_
 ----------------------------------------------------------------------- */

      TShortInt calcodes_ (neq,t,y,ydot)
/* ................. Arguments d'entree ................................... */
 int *neq;
 TDouble *t;

/* ................. Arguments de sortie ................................. */
 TDouble *y, *ydot;

{
TShortInt Code;
int Codee;

  /* Appel du programme Fortran */
  Codee = mycalcodes_( neq, t, y, ydot);

  /* Conversion  du retour de la 
     fonction */
  Code = (TShortInt)Codee;
  return(Code);
}



/* ----------------------------------------------
   Les fonctions inutilisees
 ---------------------------------------------- */
short int calcjac_()
{
return(0);
}

