/* -------------------------------------------------------*/
/* Programme d'interface entre C et un programme de calcul 
   du modele ecrit en Fortran:
   Conversion des arguments de type TShortInt en type int
 -------------------------------------------------------- */

#include "nlcodes.h"
#include "nltypes.h"
#include "errcodes.h"

/*----------------FONCTIONS EXTERNES ------------*/
/* declaration des sp fortran */
int mycalcpsi_ (int *nbtheta,int *nbgamma,int *nbobs,int *nbvar,
	      double *theta,double *gamma,double *z,
	      double *psi, double *dpsi,
	      int *le, int *ie);

/* ----------------------------------------------------------------------
             Fonction calcpsi_
 ----------------------------------------------------------------------- */
      TShortInt calcpsi_ (nbtheta,nbgamma,nbobs,nbvar,
                        theta,gamma,z,psi,dpsi,le,ie)
/* ................. Arguments d'entree ................................... */
 TShortInt nbtheta, nbgamma, nbobs, nbvar;
 TDouble *theta, *gamma, **z;
/* ................. Arguments de sortie ................................. */
 TDouble *psi, **dpsi;
 TShortInt *le, *ie;

{
TShortInt Code;
int nbthetaf, nbgammaf, nbobsf, nbvarf, lef, ief;
int Codee;
  /* Conversion des arguments d'entree */
  nbthetaf = (int)nbtheta;
  nbgammaf = (int)nbgamma;
  nbobsf = (int)nbobs;
  nbvarf = (int)nbvar;

  /* Appel du programme Fortran */
  Codee = mycalcpsi_( &nbthetaf, &nbgammaf, &nbobsf, &nbvarf,
                     theta ,gamma, &(z[0][0]),psi,
                     &(dpsi[0][0]),&lef,&ief); 
  /* Conversion des arguments de sortie et du retour de la 
     fonction */
  *le =(TShortInt)lef;
  *ie = (TShortInt)ief;
  Code = (TShortInt)Codee;
  return(Code);
}
